/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.DottyPredef$;
import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.File;
import dotty.tools.io.Path$;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public class Path {
    private final java.io.File jfile;
    private final char separator;
    private final String separatorStr;

    public static String randomPrefix() {
        return Path$.MODULE$.randomPrefix();
    }

    public static Path apply(java.io.File file) {
        return Path$.MODULE$.apply(file);
    }

    public static Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static Iterator onlyFiles(Iterator iterator) {
        return Path$.MODULE$.onlyFiles(iterator);
    }

    public static List roots() {
        return Path$.MODULE$.roots();
    }

    public static Path string2path(String string) {
        return Path$.MODULE$.string2path(string);
    }

    public static List onlyDirs(List list) {
        return Path$.MODULE$.onlyDirs(list);
    }

    public static Iterator onlyDirs(Iterator iterator) {
        return Path$.MODULE$.onlyDirs(iterator);
    }

    public static Path jfile2path(java.io.File file) {
        return Path$.MODULE$.jfile2path(file);
    }

    public static boolean isExtensionJarOrZip(String string) {
        return Path$.MODULE$.isExtensionJarOrZip(string);
    }

    public static boolean isExtensionJarOrZip(java.io.File file) {
        return Path$.MODULE$.isExtensionJarOrZip(file);
    }

    public static Nothing$ fail(String string) {
        return Path$.MODULE$.fail(string);
    }

    public Path(java.io.File jfile) {
        this.jfile = jfile;
        this.separator = java.io.File.separatorChar;
        this.separatorStr = java.io.File.separator;
    }

    public java.io.File jfile() {
        return this.jfile;
    }

    public char separator() {
        return this.separator;
    }

    public String separatorStr() {
        return this.separatorStr;
    }

    public File toFile() {
        return new File(this.jfile(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public Directory toDirectory() {
        return new Directory(this.jfile());
    }

    public Path toAbsolute() {
        return this.isAbsolute() ? this : Path$.MODULE$.apply(this.jfile().getAbsolutePath());
    }

    public Path toCanonical() {
        return Path$.MODULE$.apply(this.jfile().getCanonicalPath());
    }

    public URI toURI() {
        return this.jfile().toURI();
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    public Path toAbsoluteWithRoot(Path root) {
        return this.isAbsolute() ? this : root.toAbsolute().$div(this);
    }

    public Path $div(Path child) {
        return this.isEmpty() ? child : new Path(new java.io.File(this.jfile(), child.path()));
    }

    public Directory $div(Directory child) {
        return this.$div((Path)child).toDirectory();
    }

    public File $div(File child) {
        return this.$div((Path)child).toFile();
    }

    public Iterator walkFilter(Function1 cond) {
        return this.isFile() ? this.toFile().walkFilter(cond) : (this.isDirectory() ? this.toDirectory().walkFilter(cond) : package$.MODULE$.Iterator().empty());
    }

    public Iterator walk() {
        return this.walkFilter((Function1)((JFunction1)Path::walk$$anonfun$1));
    }

    public String name() {
        return this.jfile().getName();
    }

    public String path() {
        return this.jfile().getPath();
    }

    public Path normalize() {
        return Path$.MODULE$.apply(this.jfile().getAbsolutePath());
    }

    public Path resolve(Path other) {
        return other.isAbsolute() || this.isEmpty() ? other : this.$div(other);
    }

    public Path relativize(Path other) {
        block0: {
            boolean assertion;
            boolean bl = assertion = this.isAbsolute() == other.isAbsolute();
            if (assertion) break block0;
            DottyPredef$.MODULE$.assertFail(() -> this.relativize$$anonfun$1(other));
        }
        return Path$.MODULE$.apply(this.createRelativePath$1(this.segments(), other.segments()));
    }

    public List segments() {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.path())).split(this.separator()))).toList().filterNot((Function1)((JFunction1)Path::segments$$anonfun$1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Directory parent() {
        String string;
        Directory directory;
        String string2 = this.path();
        if ("".equals(string2) || ".".equals(string2)) {
            directory = Directory$.MODULE$.apply(Path$.MODULE$.string2path(".."));
            return directory;
        }
        if (this.segments().nonEmpty()) {
            Object object = this.segments().last();
            String string3 = "..";
            if (!(object != null ? !object.equals(string3) : string3 != null)) {
                directory = Path$.MODULE$.string2path(this.path()).$div(Path$.MODULE$.string2path("..")).toDirectory();
                return directory;
            }
        }
        if ((string = this.jfile().getParent()) != null) {
            String x = string;
            directory = Directory$.MODULE$.apply(Path$.MODULE$.string2path(x));
            return directory;
        }
        if (this.isAbsolute()) {
            directory = this.toDirectory();
            return directory;
        }
        directory = Directory$.MODULE$.apply(Path$.MODULE$.string2path("."));
        return directory;
    }

    public List parents() {
        Nil$ nil$;
        Directory p = this.parent();
        if (p.isSame(this)) {
            nil$ = package$.MODULE$.Nil();
        } else {
            Directory directory = p;
            nil$ = p.parents().$colon$colon((Object)directory);
        }
        return nil$;
    }

    public String extension() {
        int i;
        for (i = this.name().length() - 1; i >= 0 && this.name().charAt(i) != '.'; --i) {
        }
        return i < 0 ? "" : this.name().substring(i + 1);
    }

    public boolean hasExtension(String ext, Seq exts) {
        String lower = this.extension().toLowerCase();
        String string = ext.toLowerCase();
        String string2 = lower;
        return !(string == null ? string2 != null : !string.equals(string2)) || exts.exists((Function1)((JFunction1)arg_0 -> Path.hasExtension$$anonfun$1(lower, arg_0)));
    }

    public String stripExtension() {
        return new StringOps(Predef$.MODULE$.augmentString(this.name())).stripSuffix(new StringBuilder().append((Object)".").append((Object)this.extension()).toString());
    }

    public Path addExtension(String ext) {
        return Path$.MODULE$.apply(new StringBuilder().append((Object)this.path()).append((Object)".").append((Object)ext).toString());
    }

    public Path changeExtension(String ext) {
        String string = this.extension();
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.addExtension(ext) : Path$.MODULE$.apply(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(this.path())).stripSuffix(this.extension())).append((Object)ext).toString());
    }

    public Option ifFile(Function1 f) {
        return this.isFile() ? Some$.MODULE$.apply(f.apply((Object)this.toFile())) : None$.MODULE$;
    }

    public Option ifDirectory(Function1 f) {
        return this.isDirectory() ? Some$.MODULE$.apply(f.apply((Object)this.toDirectory())) : None$.MODULE$;
    }

    public boolean canRead() {
        return this.jfile().canRead();
    }

    public boolean canWrite() {
        return this.jfile().canWrite();
    }

    public boolean exists() {
        boolean bl;
        try {
            bl = this.jfile().exists();
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isFile() {
        boolean bl;
        try {
            bl = this.jfile().isFile();
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl;
        block3: {
            try {
                bl = this.jfile().isDirectory();
            }
            catch (SecurityException ex) {
                String string = this.jfile().getPath();
                String string2 = ".";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAbsolute() {
        return this.jfile().isAbsolute();
    }

    public boolean isEmpty() {
        return this.path().length() == 0;
    }

    public long lastModified() {
        return this.jfile().lastModified();
    }

    public long length() {
        return this.jfile().length();
    }

    public boolean endsWith(Path other) {
        return this.segments().endsWith((GenSeq)other.segments());
    }

    public boolean isSame(Path other) {
        Path path = this.toCanonical();
        Path path2 = other.toCanonical();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public boolean isFresher(Path other) {
        return this.lastModified() > other.lastModified();
    }

    public Directory createDirectory(boolean force, boolean failIfExists) {
        boolean res;
        boolean bl = res = force ? this.jfile().mkdirs() : this.jfile().mkdir();
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("Directory '%s' already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        return this.isDirectory() ? this.toDirectory() : new Directory(this.jfile());
    }

    public boolean createDirectory$default$1() {
        return true;
    }

    public boolean createDirectory$default$2() {
        return false;
    }

    public File createFile(boolean failIfExists) {
        boolean res = this.jfile().createNewFile();
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("File '%s' already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        return this.isFile() ? this.toFile() : new File(this.jfile(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public boolean createFile$default$1() {
        return false;
    }

    public boolean delete() {
        return this.jfile().delete();
    }

    public boolean deleteRecursively() {
        return this.deleteRecursively(this.jfile());
    }

    private boolean deleteRecursively(java.io.File f) {
        block0: {
            Object[] objectArray;
            if (!f.isDirectory() || (objectArray = f.listFiles()) == null) break block0;
            Object[] xs = objectArray;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(xs)).foreach((Function1)((JFunction1)this::deleteRecursively$$anonfun$1));
        }
        return f.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean truncate() {
        if (!this.isFile()) return false;
        RandomAccessFile raf = new RandomAccessFile(this.jfile(), "rw");
        raf.setLength(0L);
        raf.close();
        if (this.length() != 0L) return false;
        return true;
    }

    public String toString() {
        return this.path();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Path) {
            Path path;
            Path x = path = (Path)object;
            String string = this.path();
            String string2 = x.path();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    private static boolean walk$$anonfun$1(Path _$1009) {
        return true;
    }

    private String message$1(Path other$40) {
        return new StringBuilder().append((Object)"Paths not of same type: ").append((Object)this).append((Object)", ").append((Object)other$40).toString();
    }

    private String relativize$$anonfun$1(Path other$41) {
        return this.message$1(other$41);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String createRelativePath$1(List baseSegs, List otherSegs) {
        List list;
        Tuple2 tuple2;
        block5: {
            List list2;
            block2: {
                block3: {
                    block4: {
                        List list3 = otherSegs;
                        List list4 = baseSegs;
                        while ((tuple2 = Tuple2$.MODULE$.apply((Object)list4, (Object)list3)) != null) {
                            List list5;
                            List list6;
                            list2 = (List)tuple2._1();
                            if (!(list2 instanceof .colon.colon)) break block2;
                            .colon.colon colon2 = (.colon.colon)list2;
                            String b = (String)colon2.head();
                            List bs = list6 = colon2.tl$access$1();
                            List list7 = (List)tuple2._2();
                            if (!(list7 instanceof .colon.colon)) break block3;
                            .colon.colon colon3 = (.colon.colon)list7;
                            String o = (String)colon3.head();
                            List os = list5 = colon3.tl$access$1();
                            String string = b;
                            String string2 = o;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                list3 = os;
                                list4 = bs;
                                continue;
                            }
                            break block4;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    list = list2;
                    break block5;
                }
                list = list2;
                break block5;
            }
            list = list2;
        }
        List bs = list;
        List os = (List)tuple2._2();
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"..").append((Object)BoxesRunTime.boxToCharacter((char)this.separator())).toString())).$times(bs.length())).append((Object)os.mkString(this.separatorStr())).toString();
    }

    private static boolean segments$$anonfun$1(String _$1010) {
        return _$1010.length() == 0;
    }

    private static boolean hasExtension$$anonfun$1(String lower$1, String _$1011) {
        String string = _$1011.toLowerCase();
        String string2 = lower$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean deleteRecursively$$anonfun$1(java.io.File f) {
        return this.deleteRecursively(f);
    }
}

