/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.tools.dotc.core.Types;
import scala.collection.immutable.List;
import scala.util.hashing.MurmurHash3$;

public interface Hashable {
    default public void $init$() {
    }

    default public int hashSeed() {
        return this.getClass().hashCode();
    }

    default public int finishHash(int hashCode, int arity) {
        return this.avoidSpecialHashes(MurmurHash3$.MODULE$.finalizeHash(hashCode, arity));
    }

    default public int identityHash() {
        return this.avoidSpecialHashes(System.identityHashCode(this));
    }

    default public int finishHash(int seed, int arity, Types.Type tp) {
        int elemHash = tp.hash();
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1);
    }

    default public int finishHash(int seed, int arity, Types.Type tp1, Types.Type tp2) {
        int elemHash = tp1.hash();
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1, tp2);
    }

    default public int finishHash(int seed, int arity, List<Types.Type> tps) {
        int h = seed;
        List xs = tps;
        int len = arity;
        while (xs.nonEmpty()) {
            int elemHash = ((Types.Type)xs.head()).hash();
            if (elemHash == 0) {
                return 0;
            }
            h = MurmurHash3$.MODULE$.mix(h, elemHash);
            xs = xs.tail();
            ++len;
        }
        return this.finishHash(h, len);
    }

    default public int finishHash(int seed, int arity, Types.Type tp, List<Types.Type> tps) {
        int elemHash = tp.hash();
        if (elemHash == 0) {
            return 0;
        }
        return this.finishHash(MurmurHash3$.MODULE$.mix(seed, elemHash), arity + 1, tps);
    }

    default public int doHash(Object x) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(this.hashSeed(), x.hashCode()), 1);
    }

    default public int doHash(Types.Type tp) {
        return this.finishHash(this.hashSeed(), 0, tp);
    }

    default public int doHash(Object x1, Types.Type tp2) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2);
    }

    default public int doHash(Types.Type tp1, Types.Type tp2) {
        return this.finishHash(this.hashSeed(), 0, tp1, tp2);
    }

    default public int doHash(Object x1, Types.Type tp2, Types.Type tp3) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2, tp3);
    }

    default public int doHash(Types.Type tp1, List<Types.Type> tps2) {
        return this.finishHash(this.hashSeed(), 0, tp1, tps2);
    }

    default public int doHash(Object x1, Types.Type tp2, List<Types.Type> tps3) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(this.hashSeed(), x1.hashCode()), 1, tp2, tps3);
    }

    default public int doHash(int x1, int x2) {
        return this.finishHash(MurmurHash3$.MODULE$.mix(MurmurHash3$.MODULE$.mix(this.hashSeed(), x1), x2), 1);
    }

    default public int addDelta(int elemHash, int delta) {
        return elemHash == 0 ? 0 : this.avoidSpecialHashes(elemHash + delta);
    }

    private int avoidSpecialHashes(int h) {
        return h == 0 ? Integer.MIN_VALUE : (h == 1234 ? 4321 : h);
    }
}

