/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.ast.Positioned;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.tasty.TastyBuffer;
import dotty.tools.dotc.core.tasty.TastyPickler;
import dotty.tools.dotc.util.Positions$;
import dotty.tools.dotc.util.Positions$Position$;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public class PositionPickler {
    private final Function1<Trees.Tree<Types.Type>, Option<TastyBuffer.Addr>> addrOfTree;
    private final TastyBuffer buf;
    private final IdentityHashMap remainingAddrs;

    public PositionPickler(TastyPickler pickler, Function1<Trees.Tree<Types.Type>, Option<TastyBuffer.Addr>> addrOfTree) {
        this.addrOfTree = addrOfTree;
        this.buf = new TastyBuffer(5000);
        pickler.newSection("Positions", this.buf());
        this.remainingAddrs = new IdentityHashMap();
    }

    public TastyBuffer buf() {
        return this.buf;
    }

    private IdentityHashMap<Trees.Tree<Types.Type>, Iterator<TastyBuffer.Addr>> remainingAddrs() {
        return this.remainingAddrs;
    }

    public int header(int addrDelta, boolean hasStartDelta, boolean hasEndDelta, boolean hasPoint) {
        return addrDelta << 3 | PositionPickler.toInt$1(hasStartDelta) << 2 | PositionPickler.toInt$1(hasEndDelta) << 1 | PositionPickler.toInt$1(hasPoint);
    }

    public void picklePositions(List<Trees.Tree<Types.Type>> roots, Contexts.Context ctx) {
        IntRef lastIndex = IntRef.create((int)0);
        LongRef lastPos = LongRef.create((long)Positions$.MODULE$.Position(0, 0));
        this.traverse$1(ctx, lastIndex, lastPos, roots);
    }

    private static int toInt$1(boolean b) {
        return b ? 1 : 0;
    }

    private void pickleDeltas$1(IntRef lastIndex$1, LongRef lastPos$5, int index, long pos) {
        long l;
        int n;
        int addrDelta = index - lastIndex$1.elem;
        int startDelta = Positions$Position$.MODULE$.start$extension(pos) - Positions$Position$.MODULE$.start$extension(lastPos$5.elem);
        int endDelta = Positions$Position$.MODULE$.end$extension(pos) - Positions$Position$.MODULE$.end$extension(lastPos$5.elem);
        this.buf().writeInt(this.header(addrDelta, startDelta != 0, endDelta != 0, !Positions$Position$.MODULE$.isSynthetic$extension(pos)));
        if (startDelta != 0) {
            this.buf().writeInt(startDelta);
        }
        if (endDelta != 0) {
            this.buf().writeInt(endDelta);
        }
        if (!Positions$Position$.MODULE$.isSynthetic$extension(pos)) {
            this.buf().writeInt(Positions$Position$.MODULE$.pointDelta$extension(pos));
        }
        lastIndex$1.elem = n = index;
        lastPos$5.elem = l = pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean alwaysNeedsPos$1(Positioned x) {
        Positioned positioned = x;
        if (positioned instanceof Trees.WithLazyField) {
            Trees.WithLazyField withLazyField = (Trees.WithLazyField)((Object)positioned);
            return true;
        }
        if (!(positioned instanceof Trees.PackageDef)) return false;
        Trees.PackageDef packageDef = (Trees.PackageDef)positioned;
        return true;
    }

    private void $anonfun$1(Contexts.Context ctx$646, IntRef lastIndex$3, LongRef lastPos$7, Annotations.Annotation ann) {
        this.traverse$1(ctx$646, lastIndex$3, lastPos$7, ann.tree(ctx$646));
    }

    private void $anonfun$2(Contexts.Context ctx$647, IntRef lastIndex$4, LongRef lastPos$8, Object x) {
        this.traverse$1(ctx$647, lastIndex$4, lastPos$8, x);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void traverse$1(Contexts.Context ctx$645, IntRef lastIndex$2, LongRef lastPos$6, Object x) {
        Object object = x;
        while (true) {
            Annotations.Annotation annotation;
            Iterator<Object> iterator;
            if ((iterator = object) instanceof Trees.Tree) {
                Trees.Tree tree;
                Option option;
                long pos;
                Trees.Tree tree2 = (Trees.Tree)iterator;
                Trees.Tree x2 = tree2;
                long l = pos = x2 instanceof Trees.MemberDef ? x2.pos() : Positions$Position$.MODULE$.toSynthetic$extension(x2.pos());
                if (Positions$Position$.MODULE$.exists$extension(pos) && (pos != Positions$Position$.MODULE$.toSynthetic$extension(x2.initialPos()) || PositionPickler.alwaysNeedsPos$1(x2)) && (option = (Option)this.addrOfTree.apply((Object)x2)) instanceof Some) {
                    Some some = (Some)option;
                    int addr = some.value() == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)some.value()).index();
                    this.pickleDeltas$1(lastIndex$2, lastPos$6, addr, pos);
                }
                if ((tree = x2) instanceof Trees.MemberDef) {
                    Trees.MemberDef memberDef;
                    Trees.MemberDef x3 = memberDef = (Trees.MemberDef)tree;
                    Symbols$.MODULE$.toDenot(x3.symbol(ctx$645), ctx$645).annotations(ctx$645).foreach((Function1)((JProcedure1)arg_0 -> this.$anonfun$1(ctx$645, lastIndex$2, lastPos$6, arg_0)));
                }
                object = x2.productIterator();
                continue;
            }
            if (iterator instanceof TraversableOnce) {
                TraversableOnce traversableOnce;
                TraversableOnce xs = traversableOnce = (TraversableOnce)iterator;
                xs.foreach((Function1)((JProcedure1)arg_0 -> this.$anonfun$2(ctx$645, lastIndex$2, lastPos$6, arg_0)));
                return;
            }
            if (!(iterator instanceof Annotations.Annotation)) return;
            Annotations.Annotation x4 = annotation = (Annotations.Annotation)iterator;
            object = x4.tree(ctx$645);
        }
    }
}

