/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.runtime.LazyRef;
import dotty.tools.io.Path$;
import dotty.tools.io.Streamable$;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Streamable {
    public static <T extends Closeable, U> U closing(T t, Function1<T, U> function1) {
        return Streamable$.MODULE$.closing(t, function1);
    }

    public static byte[] bytes(Function0<InputStream> function0) {
        return Streamable$.MODULE$.bytes(function0);
    }

    public static String slurp(URL uRL, Codec codec) {
        return Streamable$.MODULE$.slurp(uRL, codec);
    }

    public static String slurp(Function0 function0, Codec codec) {
        return Streamable$.MODULE$.slurp(function0, codec);
    }

    public static interface Bytes {
        default public void $init$() {
        }

        public InputStream inputStream();

        default public long length() {
            return -1L;
        }

        default public BufferedInputStream bufferedInput() {
            return new BufferedInputStream(this.inputStream());
        }

        default public Iterator<Object> bytes() {
            return this.bytesAsInts().map((Function1)((JFunction1)this::bytes$$anonfun$adapted$1));
        }

        default public Iterator<Object> bytesAsInts() {
            BufferedInputStream in = this.bufferedInput();
            return package$.MODULE$.Iterator().continually((Function0)((JFunction0.mcI.sp)() -> this.bytesAsInts$$anonfun$1(in))).takeWhile((Function1)((JFunction1.mcZI.sp)this::bytesAsInts$$anonfun$2));
        }

        default public byte[] toByteArray() {
            LazyRef lazyRef = new LazyRef();
            if (this.length() == -1L) {
                return (byte[])new ArrayBuffer().$plus$plus$eq(this.bytes()).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
            }
            byte[] arr = new byte[(int)this.length()];
            int len = arr.length;
            IntRef offset = IntRef.create((int)0);
            try {
                this.loop$1(arr, len, offset, lazyRef);
            }
            finally {
                this.in$1(lazyRef).close();
            }
            if (offset.elem != arr.length) {
                throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("Could not read entire source (%d of %d bytes)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset.elem), BoxesRunTime.boxToInteger((int)len)})));
            }
            return arr;
        }

        private byte bytes$$anonfun$1(int _$1024) {
            return (byte)_$1024;
        }

        private byte bytes$$anonfun$adapted$1(Object _$1024) {
            return this.bytes$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1024));
        }

        private int bytesAsInts$$anonfun$1(BufferedInputStream in$3) {
            return in$3.read();
        }

        private boolean bytesAsInts$$anonfun$2(int _$1025) {
            return _$1025 != -1;
        }

        private BufferedInputStream in$lzyINIT1$1(LazyRef in$lzy1$1) {
            Object object;
            LazyRef lazyRef = in$lzy1$1;
            synchronized (lazyRef) {
                Object object2;
                if (in$lzy1$1.initialized()) {
                    object2 = in$lzy1$1.value();
                } else {
                    in$lzy1$1.initialized_$eq(true);
                    in$lzy1$1.value_$eq((Object)this.bufferedInput());
                    object2 = in$lzy1$1.value();
                }
                object = object2;
            }
            return (BufferedInputStream)object;
        }

        private BufferedInputStream in$1(LazyRef in$lzy1$2) {
            return (BufferedInputStream)(in$lzy1$2.initialized() ? in$lzy1$2.value() : this.in$lzyINIT1$1(in$lzy1$2));
        }

        private void loop$1(byte[] arr$5, int len$4, IntRef offset$4, LazyRef in$lzy1$3) {
            int read;
            while (offset$4.elem < len$4 && (read = this.in$1(in$lzy1$3).read(arr$5, offset$4.elem, len$4 - offset$4.elem)) >= 0) {
                int n;
                offset$4.elem = n = offset$4.elem + read;
            }
        }
    }

    public static interface Chars
    extends Bytes {
        @Override
        default public void $init$() {
        }

        default public Codec creationCodec() {
            return Codec$.MODULE$.fallbackSystemCodec();
        }

        default public BufferedSource chars(Codec codec) {
            return Source$.MODULE$.fromInputStream(this.inputStream(), codec);
        }

        default public Iterator<String> lines() {
            return this.lines(this.creationCodec());
        }

        default public Iterator<String> lines(Codec codec) {
            return this.chars(codec).getLines();
        }

        default public InputStreamReader reader(Codec codec) {
            return new InputStreamReader(this.inputStream(), codec.charSet());
        }

        default public BufferedReader bufferedReader() {
            return this.bufferedReader(this.creationCodec());
        }

        default public BufferedReader bufferedReader(Codec codec) {
            return new BufferedReader(this.reader(codec));
        }

        default public <T> T applyReader(Function1<BufferedReader, T> f) {
            Object object;
            try (BufferedReader in = this.bufferedReader();){
                object = f.apply((Object)in);
            }
            return (T)object;
        }

        default public String slurp() {
            return this.slurp(this.creationCodec());
        }

        default public String slurp(Codec codec) {
            String string;
            try (BufferedSource src = this.chars(codec);){
                string = src.mkString();
            }
            return string;
        }
    }
}

