/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.config.CommandLineParser$;
import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.util.DotClass;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class CompilerCommand$
extends DotClass {
    public static final CompilerCommand$ MODULE$;

    static {
        new CompilerCommand$();
    }

    public CompilerCommand$() {
        MODULE$ = this;
    }

    public String cmdName() {
        return "dotc";
    }

    private String explainAdvanced() {
        return "\n    |-- Notes on option parsing --\n    |Boolean settings are always false unless set.\n    |Where multiple values are accepted, they should be comma-separated.\n    |  example: -Xplugin:plugin1,plugin2\n    |<phases> means one or a comma-separated list of:\n    |  - (partial) phase names with an optional \"+\" suffix to include the next phase\n    |  - the string \"all\"\n    |  example: -Xprint:all prints all phases.\n    |  example: -Xprint:front,mixin prints the frontend and mixin phases.\n    |  example: -Ylog:erasure+ logs the erasure phase and the phase after the erasure phase.\n    |           This is useful because during the tree transform of phase X, we often\n    |           already are in phase X + 1.\n  ";
    }

    public String shortUsage() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Usage: ", " <options> <source files>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmdName()}));
    }

    public String versionMsg() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dotty compiler ", " -- ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Properties$.MODULE$.versionString(), Properties$.MODULE$.copyrightString()}));
    }

    public Settings.ArgsSummary distill(String[] args, Contexts.Context ctx) {
        return Contexts$Context$.MODULE$.toBase(ctx).settings().processArguments((List<String>)this.expandedArguments$1(args), true, ctx);
    }

    public List<String> checkUsage(Settings.ArgsSummary summary, boolean sourcesRequired, Contexts.Context ctx) {
        Nil$ nil$;
        ScalaSettings settings = Contexts$Context$.MODULE$.toBase(ctx).settings();
        summary.warnings().foreach((Function1)((JProcedure1)arg_0 -> this.checkUsage$$anonfun$1(ctx, arg_0)));
        if (summary.errors().nonEmpty()) {
            summary.errors().foreach((Function1)((JProcedure1)arg_0 -> this.checkUsage$$anonfun$2(ctx, arg_0)));
            ctx.echo(this::checkUsage$$anonfun$3, ctx.echo$default$2());
            nil$ = package$.MODULE$.Nil();
        } else {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(settings.version());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))) {
                ctx.echo(this::checkUsage$$anonfun$4, ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (!Properties$.MODULE$.isJavaAtLeast("1.8")) {
                ctx.error(this::checkUsage$$anonfun$5, ctx.error$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (this.shouldStopWithInfo$1(ctx, settings)) {
                ctx.echo(() -> this.checkUsage$$anonfun$6(ctx, settings), ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else {
                if (sourcesRequired && summary.arguments().isEmpty()) {
                    ctx.echo(() -> this.checkUsage$$anonfun$7(ctx), ctx.echo$default$2());
                }
                nil$ = summary.arguments();
            }
        }
        return nil$;
    }

    private boolean stripComment$1$$anonfun$1(char _$141) {
        return _$141 != '#';
    }

    private boolean stripComment$2$$anonfun$adapted$1(Object _$141) {
        return this.stripComment$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$141));
    }

    private String stripComment$3(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(s)).takeWhile((Function1)((JFunction1)this::stripComment$2$$anonfun$adapted$1));
    }

    private String $anonfun$1(String s) {
        return this.stripComment$3(s);
    }

    private List<String> expandArg$1(String arg) {
        Path path = Paths.get(new StringOps(Predef$.MODULE$.augmentString(arg)).stripPrefix("@"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(new StringOps(Predef$.MODULE$.augmentString("argument file %s could not be found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getFileName()})));
        }
        java.util.List<String> lines = Files.readAllLines(path);
        String params = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(lines).asScala()).map((Function1)((JFunction1)this::$anonfun$1), Buffer$.MODULE$.canBuildFrom())).mkString(" ");
        return CommandLineParser$.MODULE$.tokenize(params);
    }

    private GenTraversableOnce<String> expandedArguments$2$$anonfun$1(String x$1) {
        List list;
        String string = x$1;
        String x = string;
        if (x.startsWith("@")) {
            list = this.expandArg$1(x);
        } else {
            String x2 = string;
            list = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x2}));
        }
        return list;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private List expandedArguments$1(String[] args$4) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$4)).toList().flatMap((Function1)((JFunction1)this::expandedArguments$2$$anonfun$1), List$.MODULE$.canBuildFrom());
    }

    private String $anonfun$2(Settings.Setting<?> _$142) {
        return _$142.name();
    }

    private int $anonfun$3(Settings.Setting<?> _$143) {
        return _$143.name().length();
    }

    private String format$1(int width$1, String s) {
        return new StringOps(Predef$.MODULE$.augmentString("%-" + width$1 + "s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private String helpStr$1(int width$2, Settings.Setting s) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format$1(width$2, s.name()), s.description()}));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private String availableOptionsMsg$1$$anonfun$1(int width$3, Settings.Setting s) {
        return this.helpStr$1(width$3, s);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private String availableOptionsMsg$2(Contexts.Context ctx$217, Function1 cond) {
        List ss = (List)((TraversableOnce)Contexts$Context$.MODULE$.toBase(ctx$217).settings().allSettings().filter(cond)).toList().sortBy((Function1)((JFunction1)this::$anonfun$2), (Ordering)Ordering.String$.MODULE$);
        int width = BoxesRunTime.unboxToInt((Object)((TraversableOnce)ss.map((Function1)((JFunction1)this::$anonfun$3), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        return ((TraversableOnce)ss.map((Function1)((JFunction1)arg_0 -> this.availableOptionsMsg$1$$anonfun$1(width, arg_0)), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private boolean $anonfun$4(boolean shouldExplain$1, String _$144) {
        return shouldExplain$1;
    }

    private GenTraversableOnce<String> $anonfun$5(Option<String> xo) {
        return Option$.MODULE$.option2Iterable(xo);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private String createUsageMsg$1(Contexts.Context ctx$223, String label, boolean shouldExplain, Function1 cond) {
        String prefix = ((TraversableOnce)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)this.shortUsage()), Some$.MODULE$.apply((Object)this.explainAdvanced()).filter((Function1)((JFunction1)arg_0 -> this.$anonfun$4(shouldExplain, arg_0))), Some$.MODULE$.apply((Object)(label + " options include:"))})).flatten((Function1)((JFunction1)this::$anonfun$5))).mkString("\n");
        return prefix + "\n" + this.availableOptionsMsg$2(ctx$223, cond);
    }

    private boolean isStandard$1(Settings.Setting<?> s) {
        return !this.isAdvanced$1(s) && !this.isPrivate$1(s);
    }

    private boolean isAdvanced$1(Settings.Setting<?> s) {
        return s.name().startsWith("-X");
    }

    private boolean isPrivate$1(Settings.Setting<?> s) {
        return s.name().startsWith("-Y");
    }

    private boolean usageMessage$1$$anonfun$1(Settings.Setting<?> s) {
        return this.isStandard$1(s);
    }

    private String usageMessage$2(Contexts.Context ctx$224) {
        return this.createUsageMsg$1(ctx$224, "where possible standard", false, (Function1)((JFunction1)this::usageMessage$1$$anonfun$1));
    }

    private boolean xusageMessage$1$$anonfun$1(Settings.Setting<?> s) {
        return this.isAdvanced$1(s);
    }

    private String xusageMessage$2(Contexts.Context ctx$225) {
        return this.createUsageMsg$1(ctx$225, "Possible advanced", true, (Function1)((JFunction1)this::xusageMessage$1$$anonfun$1));
    }

    private boolean yusageMessage$1$$anonfun$1(Settings.Setting<?> s) {
        return this.isPrivate$1(s);
    }

    private String yusageMessage$2(Contexts.Context ctx$226) {
        return this.createUsageMsg$1(ctx$226, "Possible private", true, (Function1)((JFunction1)this::yusageMessage$1$$anonfun$1));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private boolean shouldStopWithInfo$2$$anonfun$1(Contexts.Context ctx$219, Settings.Setting _$145) {
        Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(_$145);
        return BoxesRunTime.unboxToBoolean(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx$219));
    }

    private boolean shouldStopWithInfo$1(Contexts.Context ctx$218, ScalaSettings settings$1) {
        return ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Settings.Setting[]{settings$1.help(), settings$1.Xhelp(), settings$1.Yhelp()}))).exists((Function1)((JFunction1)arg_0 -> this.shouldStopWithInfo$2$$anonfun$1(ctx$218, arg_0)));
    }

    private String infoMessage$1(Contexts.Context ctx$220, ScalaSettings settings$2) {
        Settings.Setting<Object> setting;
        Settings.Setting<Object> setting2;
        Settings.Setting<Object> setting3 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.help());
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting3, ctx$220)) ? this.usageMessage$2(ctx$220) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Xhelp()), ctx$220)) ? this.xusageMessage$2(ctx$220) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Yhelp()), ctx$220)) ? this.yusageMessage$2(ctx$220) : ""));
    }

    private Message checkUsage$$anonfun$8$$anonfun$1(String _$146$1) {
        return Message$.MODULE$.toNoExplanation(_$146$1);
    }

    private void checkUsage$$anonfun$1(Contexts.Context ctx$221, String _$146) {
        ctx$221.warning(() -> this.checkUsage$$anonfun$8$$anonfun$1(_$146), ctx$221.warning$default$2());
    }

    private Message checkUsage$$anonfun$9$$anonfun$1(String _$147$1) {
        return Message$.MODULE$.toNoExplanation(_$147$1);
    }

    private void checkUsage$$anonfun$2(Contexts.Context ctx$222, String _$147) {
        ctx$222.error(() -> this.checkUsage$$anonfun$9$$anonfun$1(_$147), ctx$222.error$default$2());
    }

    private String checkUsage$$anonfun$3() {
        return "  dotc -help  gives more information";
    }

    private String checkUsage$$anonfun$4() {
        return this.versionMsg();
    }

    private Message checkUsage$$anonfun$5() {
        return Message$.MODULE$.toNoExplanation("Dotty requires Java 8 to run");
    }

    private String checkUsage$$anonfun$6(Contexts.Context ctx$227, ScalaSettings settings$3) {
        return this.infoMessage$1(ctx$227, settings$3);
    }

    private String checkUsage$$anonfun$7(Contexts.Context ctx$228) {
        return this.usageMessage$2(ctx$228);
    }
}

