/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.DottyPredef$;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.core.tasty.TastyBuffer;
import dotty.tools.dotc.core.tasty.TastyBuffer$;
import dotty.tools.dotc.core.tasty.TastyBuffer$Addr$;
import dotty.tools.dotc.util.Util$;
import java.util.IdentityHashMap;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.collection.Seq;
import scala.compat.java8.JFunction1;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null;
import scala.runtime.RichInt$;

public class TreeBuffer
extends TastyBuffer {
    private final int initialOffsetSize = this.bytes().length / 8;
    private int[] offsets = new int[this.initialOffsetSize()];
    private boolean[] isRelative = new boolean[this.initialOffsetSize()];
    private int[] delta;
    private int numOffsets = 0;
    private final IdentityHashMap treeAddrs = new IdentityHashMap();

    public TreeBuffer() {
        super(50000);
    }

    private final int ItemsOverOffsets() {
        return 2;
    }

    private int initialOffsetSize() {
        return this.initialOffsetSize;
    }

    private IdentityHashMap<Trees.Tree<Null>, Object> treeAddrs() {
        return this.treeAddrs;
    }

    public int registerTreeAddr(Trees.Tree tree) {
        int n;
        Object object = this.treeAddrs().get(tree);
        if (object == null) {
            this.treeAddrs().put(tree, new TastyBuffer.Addr(this.currentAddr()));
            n = this.currentAddr();
        } else if (object instanceof TastyBuffer.Addr) {
            int n2;
            int addr;
            n = addr = (n2 = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index());
        } else {
            throw new MatchError(object);
        }
        return n;
    }

    public Option<TastyBuffer.Addr> addrOfTree(Trees.Tree<Null> tree) {
        None$ none$;
        Object object = this.treeAddrs().get(tree);
        if (object == null) {
            none$ = None$.MODULE$;
        } else if (object instanceof TastyBuffer.Addr) {
            int n;
            int addr = n = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index();
            none$ = Some$.MODULE$.apply((Object)new TastyBuffer.Addr(addr));
        } else {
            throw new MatchError(object);
        }
        return none$;
    }

    private int offset(int i) {
        return TastyBuffer$Addr$.MODULE$.apply(this.offsets[i]);
    }

    private void keepOffset(boolean relative) {
        if (this.numOffsets == this.offsets.length) {
            this.offsets = (int[])Util$.MODULE$.dble(this.offsets, ClassTag$.MODULE$.apply(Integer.TYPE));
            this.isRelative = (boolean[])Util$.MODULE$.dble(this.isRelative, ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        this.offsets[this.numOffsets] = this.length();
        this.isRelative[this.numOffsets] = relative;
        ++this.numOffsets;
    }

    /*
     * WARNING - void declaration
     */
    public int reserveRef(boolean relative) {
        void var2_2;
        int addr = this.currentAddr();
        this.keepOffset(relative);
        this.reserveAddr();
        return (int)var2_2;
    }

    public void writeRef(int target) {
        this.keepOffset(false);
        this.fillAddr(this.reserveAddr(), target);
    }

    public void fillRef(int at, int target, boolean relative) {
        int addr = relative ? TastyBuffer$Addr$.MODULE$.relativeTo$extension(target, at) : target;
        this.fillAddr(at, addr);
    }

    public int deltaAt(int at) {
        int idx = Util$.MODULE$.bestFit(this.offsets, this.numOffsets, at - 1, Util$.MODULE$.bestFit$default$4());
        return idx < 0 ? 0 : this.delta[idx];
    }

    public int adjusted(int x) {
        return TastyBuffer$Addr$.MODULE$.$minus$extension(x, this.deltaAt(x));
    }

    private void computeDeltas() {
        this.delta = new int[this.numOffsets];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            boolean assertion;
            int off = this.offset(i);
            int skippedOff = this.skipZeroes(off);
            int skippedCount = skippedOff - off;
            boolean bl = assertion = skippedCount < 4;
            if (!assertion) {
                DottyPredef$.MODULE$.assertFail(() -> TreeBuffer.$anonfun$1(off));
            }
            this.delta[i] = lastDelta += skippedCount;
        }
    }

    private int adjustedOffset(int i) {
        int n;
        int at = this.offset(i);
        int original = this.getAddr(at);
        if (this.isRelative[i]) {
            int len2;
            boolean assertion;
            int start = this.skipNat(at);
            int len1 = TastyBuffer$Addr$.MODULE$.$minus$extension(TastyBuffer$Addr$.MODULE$.$plus$extension(original, this.delta[i]), this.deltaAt(TastyBuffer$Addr$.MODULE$.$plus$extension(original, start)));
            boolean bl = assertion = len1 == (len2 = TastyBuffer$Addr$.MODULE$.$minus$extension(this.adjusted(TastyBuffer$Addr$.MODULE$.$plus$extension(original, start)), this.adjusted(start)));
            if (!assertion) {
                DottyPredef$.MODULE$.assertFail(() -> TreeBuffer.adjustedOffset$$anonfun$1(i, at, original, len1, len2));
            }
            n = len1;
        } else {
            n = this.adjusted(original);
        }
        return n;
    }

    private void adjustOffsets() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numOffsets).foreach((Function1)((JFunction1.mcVI.sp)this::adjustOffsets$$anonfun$1));
    }

    private int adjustDeltas() {
        int[] delta1 = new int[this.delta.length];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int corrected = this.adjustedOffset(i);
            delta1[i] = lastDelta += 4 - TastyBuffer$.MODULE$.natSize(corrected);
        }
        int saved = this.numOffsets == 0 ? 0 : delta1[this.numOffsets - 1] - this.delta[this.numOffsets - 1];
        this.delta = delta1;
        return saved;
    }

    private int compress() {
        IntRef lastDelta = IntRef.create((int)0);
        IntRef start = IntRef.create((int)0);
        int wasted = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int n;
            boolean assertion;
            int n2;
            int next = this.offsets[i];
            this.shift$1(lastDelta, start, next);
            start.elem = n2 = next + this.delta[i] - lastDelta.elem;
            int pastZeroes = this.skipZeroes(TastyBuffer$Addr$.MODULE$.apply(next));
            boolean bl = assertion = pastZeroes >= start.elem;
            if (!assertion) {
                DottyPredef$.MODULE$.assertFail(TreeBuffer::$anonfun$2);
            }
            wasted += pastZeroes - start.elem;
            lastDelta.elem = n = this.delta[i];
        }
        this.shift$1(lastDelta, start, this.length());
        this.length_$eq(this.length() - lastDelta.elem);
        return wasted;
    }

    public void adjustTreeAddrs() {
        for (Trees.Tree<Null> tree : this.treeAddrs().keySet()) {
            Object object = this.treeAddrs().get(tree);
            if (object instanceof TastyBuffer.Addr) {
                int n;
                int addr = n = object == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.Addr)object).index();
                this.treeAddrs().put(tree, new TastyBuffer.Addr(this.adjusted(addr)));
                continue;
            }
            throw new MatchError(object);
        }
    }

    public void compactify() {
        int origLength = this.length();
        this.computeDeltas();
        IntRef saved = IntRef.create((int)0);
        do {
            int n;
            saved.elem = n = this.adjustDeltas();
            Printers$.MODULE$.pickling().println(() -> TreeBuffer.$anonfun$3(saved));
        } while (saved.elem > 0 && this.length() / saved.elem < 100);
        this.adjustOffsets();
        this.adjustTreeAddrs();
        int wasted = this.compress();
        Printers$.MODULE$.pickling().println(() -> this.compactify$$anonfun$1(origLength, wasted));
    }

    private static String $anonfun$1(int off$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unset field at position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new TastyBuffer.Addr(off$1)}));
    }

    private static String adjustedOffset$$anonfun$1(int i$6, int at$1, int original$7, int len1$1, int len2$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"adjusting offset #", ": ", ", original = ", ", len1 = ", ", len2 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$6), new TastyBuffer.Addr(at$1), new TastyBuffer.Addr(original$7), new TastyBuffer.Addr(len1$1), new TastyBuffer.Addr(len2$1)}));
    }

    private void adjustOffsets$$anonfun$1(int i) {
        int corrected = this.adjustedOffset(i);
        this.fillAddr(this.offset(i), corrected);
    }

    private void shift$1(IntRef lastDelta$1, IntRef start$4, int end) {
        Array$.MODULE$.copy((Object)this.bytes(), start$4.elem, (Object)this.bytes(), start$4.elem - lastDelta$1.elem, end - start$4.elem);
    }

    private static String $anonfun$2() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"something's wrong: eliminated non-zero"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static String $anonfun$3(IntRef saved$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"adjusting deltas, saved = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)saved$1.elem)}));
    }

    private String compactify$$anonfun$1(int origLength$1, int wasted$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"original length: ", ", compressed to: ", ", wasted: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)origLength$1), BoxesRunTime.boxToInteger((int)this.length()), BoxesRunTime.boxToInteger((int)wasted$1)}));
    }
}

