/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.interpreter;

import dotty.runtime.Arrays$;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$Apply$;
import dotty.tools.dotc.ast.Trees$Block$;
import dotty.tools.dotc.ast.Trees$Inlined$;
import dotty.tools.dotc.ast.Trees$Literal$;
import dotty.tools.dotc.ast.Trees$Typed$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Constants;
import dotty.tools.dotc.core.Constants$Constant$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.quoted.Quoted$;
import dotty.tools.dotc.interpreter.RawQuoted$;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JFunction2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class Interpreter {
    private final Contexts.Context ctx;
    private final URLClassLoader classLoader;

    public Interpreter(Contexts.Context ctx) {
        this.ctx = ctx;
        Settings.Setting<String> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().classpath());
        URL[] urls = (URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))).split(':'))).map((Function1)((JFunction1)Interpreter::$anonfun$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
        this.classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    public <T> Option<T> interpretTree(Trees.Tree<Types.Type> tree, ClassTag<T> ct) {
        None$ none$;
        block3: {
            try {
                Option option;
                Object object = this.interpretTreeImpl(tree, Predef$.MODULE$.Map().empty());
                if (object != null && !(option = ct.unapply(object)).isEmpty()) {
                    Object object2;
                    Object obj = object2 = option.get();
                    none$ = Some$.MODULE$.apply(obj);
                    break block3;
                }
                Object obj = object;
                this.ctx.error(() -> Interpreter.interpretTree$$anonfun$1(ct, obj), Decorators$.MODULE$.sourcePos(tree.pos(), this.ctx));
                none$ = None$.MODULE$;
            }
            catch (StopInterpretation ex) {
                this.ctx.error(() -> Interpreter.interpretTree$$anonfun$2(ex), Decorators$.MODULE$.sourcePos(ex.pos(), this.ctx));
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object interpretTreeImpl(Trees.Tree tree, Map env) {
        Map map = env;
        Trees.Tree<Types.Type> tree2 = tree;
        Interpreter interpreter = this;
        while (true) {
            Trees.Ident ident;
            Trees.Ident tree3;
            Object object;
            Trees.Tree<Types.Type> tree4;
            block16: {
                long pos;
                block15: {
                    block14: {
                        Trees.Literal literal;
                        Trees.Literal literal2;
                        Constants.Constant constant;
                        Option<Trees.Tree<Types.Type>> option;
                        interpreter.ctx.debuglog(() -> Interpreter.$anonfun$2(interpreter, tree2, map));
                        pos = tree2.pos();
                        tree4 = tree2;
                        if (tree4 != null && !(option = Quoted$.MODULE$.unapply(tree4, interpreter.ctx)).isEmpty()) {
                            Trees.Tree tree5;
                            Trees.Tree quotedTree = tree5 = (Trees.Tree)option.get();
                            object = RawQuoted$.MODULE$.apply(quotedTree);
                            return object;
                        }
                        if (tree4 instanceof Trees.Literal && (constant = (literal2 = Trees$Literal$.MODULE$.unapply(literal = (Trees.Literal)tree4))._1()) != null) {
                            Object object2;
                            Object c;
                            Constants.Constant constant2 = Constants$Constant$.MODULE$.unapply(constant);
                            object = c = (object2 = constant2._1());
                            return object;
                        }
                        if (tree4 instanceof Trees.Apply) {
                            Trees.Apply apply = (Trees.Apply)tree4;
                            Trees.Apply apply2 = Trees$Apply$.MODULE$.unapply(apply);
                            Trees.Tree tree6 = apply2._1();
                            List list = apply2._2();
                            Trees.Tree fn = tree6;
                            List args = list;
                            if (Symbols$.MODULE$.toDenot(fn.symbol(interpreter.ctx), interpreter.ctx).isConstructor()) {
                                Class<?> clazz = interpreter.loadClass(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(fn.symbol(interpreter.ctx), interpreter.ctx).owner(), interpreter.ctx).symbol(), interpreter.ctx).fullName(interpreter.ctx), pos);
                                List<Class<?>> paramClasses = interpreter.paramsSig(fn.symbol(interpreter.ctx));
                                List interpretedArgs = (List)args.map((Function1)((JFunction1)arg_0 -> Interpreter.$anonfun$6(interpreter, map, arg_0)), List$.MODULE$.canBuildFrom());
                                Constructor<Object> constructor = interpreter.getConstructor(clazz, paramClasses, pos);
                                object = interpreter.interpreted(() -> Interpreter.$anonfun$7(interpretedArgs, constructor), pos);
                                return object;
                            }
                        }
                        if (!(tree4 instanceof Trees.RefTree)) break block14;
                        Trees.RefTree refTree = (Trees.RefTree)tree4;
                        break block15;
                    }
                    if (!(tree4 instanceof Trees.Apply)) break block16;
                    Trees.Apply apply = (Trees.Apply)tree4;
                }
                if (tree2.symbol(interpreter.ctx).isStatic(interpreter.ctx)) {
                    Class<?> clazz = interpreter.loadClass(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(tree2.symbol(interpreter.ctx), interpreter.ctx).owner(), interpreter.ctx).companionModule(interpreter.ctx), interpreter.ctx).fullName(interpreter.ctx), pos);
                    List<Class<?>> paramClasses = interpreter.paramsSig(tree2.symbol(interpreter.ctx));
                    ArrayBuilder interpretedArgs = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Object.class));
                    Interpreter.interpretArgs$1(interpreter, map, interpretedArgs, tree2);
                    Method method = interpreter.getMethod(clazz, tree2.symbol(interpreter.ctx).name(interpreter.ctx), paramClasses, pos);
                    object = interpreter.interpreted(() -> Interpreter.$anonfun$5(interpretedArgs, method), pos);
                    return object;
                }
            }
            if (tree4 instanceof Trees.Ident && map.contains((Object)(tree3 = (ident = (Trees.Ident)tree4)).symbol(interpreter.ctx))) {
                object = map.apply((Object)tree3.symbol(interpreter.ctx));
                return object;
            }
            if (tree4 instanceof Trees.Block) {
                Map env2;
                Trees.Block block = (Trees.Block)tree4;
                Trees.Block block2 = Trees$Block$.MODULE$.unapply(block);
                List list = block2._1();
                Trees.Tree tree7 = block2._2();
                List stats = list;
                Trees.Tree expr = tree7;
                map = env2 = (Map)stats.foldLeft((Object)map, (Function2)((JFunction2)(arg_0, arg_1) -> Interpreter.$anonfun$3(interpreter, arg_0, arg_1)));
                tree2 = expr;
                continue;
            }
            if (tree4 instanceof Trees.NamedArg) {
                Trees.NamedArg namedArg;
                Trees.NamedArg tree8 = namedArg = (Trees.NamedArg)tree4;
                tree2 = tree8.arg();
                continue;
            }
            if (tree4 instanceof Trees.Inlined) {
                Map env2;
                Trees.Inlined inlined = (Trees.Inlined)tree4;
                Trees.Inlined inlined2 = Trees$Inlined$.MODULE$.unapply(inlined);
                Trees.Tree tree9 = inlined2._1();
                List list = inlined2._2();
                Trees.Tree tree10 = inlined2._3();
                List bindings = list;
                Trees.Tree expansion = tree10;
                map = env2 = (Map)bindings.foldLeft((Object)map, (Function2)((JFunction2)(arg_0, arg_1) -> Interpreter.$anonfun$4(interpreter, arg_0, arg_1)));
                tree2 = expansion;
                continue;
            }
            if (!(tree4 instanceof Trees.Typed)) {
                throw new StopInterpretation(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not interpret ", ". Consider extracting logic into a helper def."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tree2.show(interpreter.ctx)})), tree2.pos());
            }
            Trees.Typed typed = (Trees.Typed)tree4;
            Trees.Typed typed2 = Trees$Typed$.MODULE$.unapply(typed);
            Trees.Tree tree11 = typed2._1();
            Trees.Tree tree12 = typed2._2();
            Trees.Tree expr = tree11;
            tree2 = expr;
        }
    }

    private Map interpretStat(Trees.Tree stat, Map env) {
        Map map;
        Trees.Tree tree = stat;
        if (tree instanceof Trees.ValDef) {
            Trees.ValDef valDef;
            Trees.ValDef tree2 = valDef = (Trees.ValDef)tree;
            Object obj = this.interpretTreeImpl(tree2.rhs(this.ctx), env);
            map = env.updated((Object)tree2.symbol(this.ctx), obj);
        } else {
            this.interpretTreeImpl(stat, env);
            map = env;
        }
        return map;
    }

    private Class<?> loadClass(Names.Name name, long pos) {
        Class<?> clazz;
        try {
            clazz = this.classLoader.loadClass(name.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            String msg = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find interpreted class ", " in classpath"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
            throw new StopInterpretation(msg, pos);
        }
        return clazz;
    }

    private Method getMethod(Class<?> clazz, Names.Name name, List<Class<?>> paramClasses, long pos) {
        Method method;
        try {
            method = clazz.getMethod(name.toString(), (Class[])Arrays$.MODULE$.seqToArray(paramClasses, Class.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String msg = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find interpreted method ", ".", " with parameters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getCanonicalName(), name, paramClasses}));
            throw new StopInterpretation(msg, pos);
        }
        return method;
    }

    private Constructor<Object> getConstructor(Class<?> clazz, List<Class<?>> paramClasses, long pos) {
        Constructor<Object> constructor;
        try {
            constructor = clazz.getConstructor((Class[])Arrays$.MODULE$.seqToArray(paramClasses, Class.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String msg = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find interpreted constructor of ", " with parameters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getCanonicalName(), paramClasses}));
            throw new StopInterpretation(msg, pos);
        }
        return constructor;
    }

    private <T> T interpreted(Function0<T> thunk, long pos) {
        Object object;
        try {
            object = thunk.apply();
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            sw.write("A runtime exception occurred while interpreting\n");
            sw.write(ex.getMessage());
            sw.write("\n");
            ex.printStackTrace(new PrintWriter(sw));
            sw.write("\n");
            throw new StopInterpretation(sw.toString(), pos);
        }
        return (T)object;
    }

    private List<Class<?>> paramsSig(Symbols.Symbol sym) {
        return (List)sym.signature(this.ctx).paramsSig().map((Function1)((JFunction1)this::paramsSig$$anonfun$1), List$.MODULE$.canBuildFrom());
    }

    private static URL $anonfun$1(String cp) {
        return Paths.get(cp, new String[0]).toUri().toURL();
    }

    private static Message interpretTree$$anonfun$1(ClassTag ct$3, Object obj$1) {
        return Message$.MODULE$.toNoExplanation(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Interpreted tree returned a result of an unexpected type. Expected ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ct$3.runtimeClass(), obj$1.getClass()})));
    }

    private static Message interpretTree$$anonfun$2(StopInterpretation ex$7) {
        return Message$.MODULE$.toNoExplanation(ex$7.msg());
    }

    private static String $anonfun$2(Interpreter $this$38, Trees.Tree tree$33, Map env$1) {
        return new StringOps(Predef$.MODULE$.augmentString(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Interpreting:\n        |", "\n        |", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tree$33.show($this$38.ctx), env$1})))).stripMargin();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Map $anonfun$3(Interpreter $this$39, Map acc, Trees.Tree x) {
        return $this$39.interpretStat(x, acc);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Map $anonfun$4(Interpreter $this$40, Map acc, Trees.MemberDef x) {
        return $this$40.interpretStat(x, acc);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static ArrayBuilder interpretArgs$2$$anonfun$1(Interpreter $this$42, Map env$3, ArrayBuilder interpretedArgs$2, Trees.Tree arg) {
        return (ArrayBuilder)interpretedArgs$2.$plus$eq($this$42.interpretTreeImpl(arg, env$3));
    }

    private static void interpretArgs$1(Interpreter $this$41, Map env$2, ArrayBuilder interpretedArgs$1, Trees.Tree tree) {
        block0: {
            Trees.Tree tree2 = tree;
            if (!(tree2 instanceof Trees.Apply)) break block0;
            Trees.Apply apply = (Trees.Apply)tree2;
            Trees.Apply apply2 = Trees$Apply$.MODULE$.unapply(apply);
            Trees.Tree tree3 = apply2._1();
            List list = apply2._2();
            Trees.Tree fn = tree3;
            List args = list;
            Interpreter.interpretArgs$1($this$41, env$2, interpretedArgs$1, fn);
            args.foreach((Function1)((JFunction1)arg_0 -> Interpreter.interpretArgs$2$$anonfun$1($this$41, env$2, interpretedArgs$1, arg_0)));
        }
    }

    private static Object $anonfun$5(ArrayBuilder interpretedArgs$3, Method method$5) {
        return method$5.invoke(null, (Object[])Arrays$.MODULE$.seqToArray((Seq)Predef$.MODULE$.wrapRefArray((Object[])interpretedArgs$3.result()), Object.class));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object $anonfun$6(Interpreter $this$43, Map env$4, Trees.Tree arg) {
        return $this$43.interpretTreeImpl(arg, env$4);
    }

    private static Object $anonfun$7(List interpretedArgs$4, Constructor constructor$1) {
        return constructor$1.newInstance((Object[])Arrays$.MODULE$.seqToArray((Seq)interpretedArgs$4, Object.class));
    }

    private Class<?> paramsSig$$anonfun$1(Names.TypeName param) {
        Class<?> clazz;
        Option<Class<?>> option = Symbols$.MODULE$.defn(this.ctx).valueTypeNameToJavaType(param, this.ctx);
        if (option instanceof Some) {
            Class<?> clazz2;
            Some some = (Some)option;
            clazz = clazz2 = (Class<?>)some.value();
        } else if (None$.MODULE$.equals(option)) {
            clazz = this.classLoader.loadClass(param.toString());
        } else {
            throw new MatchError(option);
        }
        return clazz;
    }

    private static class StopInterpretation
    extends Exception {
        private final String msg;
        private final long pos;

        public StopInterpretation(String msg, long pos) {
            this.msg = msg;
            this.pos = pos;
        }

        public String msg() {
            return this.msg;
        }

        public long pos() {
            return this.pos;
        }
    }
}

