/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$;
import dotty.tools.dotc.core.Contexts$ModeChanges$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.reporting.Reporter$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.reporting.diagnostic.messages;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class Reporter
implements ReporterResult {
    private boolean _truncationOK = true;
    private Function1 incompleteHandler = this::$init$$$anonfun$1;
    private int errorCount = 0;
    private int warningCount = 0;
    private List<messages.Error> errors = package$.MODULE$.Nil();
    private Set<Symbols.Symbol> reportedFeaturesUseSites = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbols.Symbol[0]));
    private final HashMap unreportedWarnings = new HashMap<String, Object>(){

        public int default(String key) {
            return 0;
        }
    };

    public static Reporter fromSimpleReporter(SimpleReporter simpleReporter) {
        return Reporter$.MODULE$.fromSimpleReporter(simpleReporter);
    }

    public abstract void doReport(MessageContainer var1, Contexts.Context var2);

    public boolean truncationOK() {
        return this._truncationOK;
    }

    public <T> T withoutTruncating(Function0<T> body) {
        Object object;
        boolean saved = this._truncationOK;
        this._truncationOK = false;
        try {
            object = body.apply();
        }
        finally {
            this._truncationOK = saved;
        }
        return (T)object;
    }

    public <T> T withIncompleteHandler(Function1<MessageContainer, Function1<Contexts.Context, BoxedUnit>> handler, Function0<T> op) {
        Object object;
        Function1 saved = this.incompleteHandler;
        this.incompleteHandler = handler;
        try {
            object = op.apply();
        }
        finally {
            this.incompleteHandler = saved;
        }
        return (T)object;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void errorCount_$eq(int x$1) {
        this.errorCount = x$1;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void warningCount_$eq(int x$1) {
        this.warningCount = x$1;
    }

    public boolean hasErrors() {
        return this.errorCount() > 0;
    }

    public boolean hasWarnings() {
        return this.warningCount() > 0;
    }

    public List<messages.Error> allErrors() {
        return this.errors;
    }

    public boolean errorsReported() {
        return this.hasErrors();
    }

    public boolean isReportedFeatureUseSite(Symbols.Symbol featureTrait) {
        return this.reportedFeaturesUseSites.contains((Object)featureTrait);
    }

    public void reportNewFeatureUseSite(Symbols.Symbol featureTrait) {
        this.reportedFeaturesUseSites = (Set)this.reportedFeaturesUseSites.$plus((Object)featureTrait);
    }

    public HashMap<String, Object> unreportedWarnings() {
        return this.unreportedWarnings;
    }

    public void report(MessageContainer m, Contexts.Context ctx) {
        if (!this.isHidden(m, ctx)) {
            messages.ConditionalWarning conditionalWarning;
            messages.ConditionalWarning m2;
            Settings.Setting<Object> setting;
            this.doReport(m, Contexts$ModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.ModeChanges(ctx), Mode$.MODULE$.Printing()));
            MessageContainer messageContainer = m;
            if (messageContainer instanceof messages.ConditionalWarning && !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator((m2 = (conditionalWarning = (messages.ConditionalWarning)messageContainer)).enablingOption(ctx)), ctx))) {
                String key$1 = m2.enablingOption(ctx).name();
                this.unreportedWarnings().update((Object)key$1, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.unreportedWarnings().apply((Object)key$1)) + 1)));
            } else if (messageContainer instanceof messages.Warning) {
                messages.Warning warning;
                messages.Warning m3 = warning = (messages.Warning)messageContainer;
                this.warningCount_$eq(this.warningCount() + 1);
            } else if (messageContainer instanceof messages.Error) {
                messages.Error error;
                messages.Error m4;
                messages.Error error2 = m4 = (error = (messages.Error)messageContainer);
                this.errors = this.errors.$colon$colon((Object)error2);
                this.errorCount_$eq(this.errorCount() + 1);
            } else if (messageContainer instanceof messages.Info) {
                messages.Info info;
                messages.Info m5 = info = (messages.Info)messageContainer;
            } else {
                throw new MatchError((Object)messageContainer);
            }
        }
    }

    public void incomplete(MessageContainer m, Contexts.Context ctx) {
        ((Function1)this.incompleteHandler.apply((Object)m)).apply((Object)ctx);
    }

    public String summary() {
        ListBuffer b = new ListBuffer();
        Object object = this.warningCount() > 0 ? b.$plus$eq((Object)(this.countString(this.warningCount(), "warning") + " found")) : BoxedUnit.UNIT;
        Object object2 = this.errorCount() > 0 ? b.$plus$eq((Object)(this.countString(this.errorCount(), "error") + " found")) : BoxedUnit.UNIT;
        this.unreportedWarnings().withFilter((Function1)((JFunction1)Reporter::summary$$anonfun$1)).foreach((Function1)((JFunction1)arg_0 -> Reporter.summary$$anonfun$2(b, arg_0)));
        return b.mkString("\n");
    }

    public void printSummary(Contexts.Context ctx) {
        block0: {
            String s;
            String string = s = this.summary();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            ctx.echo(() -> Reporter.printSummary$$anonfun$1(s), ctx.echo$default$2());
        }
    }

    public String countString(int n, String elements) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "no " + elements + "s";
                break;
            }
            case 1: {
                string = "one " + elements;
                break;
            }
            case 2: {
                string = "two " + elements + "s";
                break;
            }
            case 3: {
                string = "three " + elements + "s";
                break;
            }
            case 4: {
                string = "four " + elements + "s";
                break;
            }
            default: {
                string = n + " " + elements + "s";
                break;
            }
        }
        return string;
    }

    public boolean isHidden(MessageContainer m, Contexts.Context ctx) {
        return Mode$.MODULE$.is$extension(ctx.mode(), Mode$.MODULE$.Printing());
    }

    public boolean hasPending() {
        return false;
    }

    public List<MessageContainer> removeBufferedMessages(Contexts.Context ctx) {
        return package$.MODULE$.Nil();
    }

    public void flush(Contexts.Context ctx) {
        Reporter $672$ = ctx.reporter();
        this.removeBufferedMessages(ctx).foreach((Function1)((JProcedure1)arg_0 -> Reporter.flush$$anonfun$1(ctx, $672$, arg_0)));
    }

    private void $init$$$anonfun$2$$anonfun$1(MessageContainer d$5, Contexts.Context c) {
        this.report(d$5, c);
    }

    private Function1<Contexts.Context, BoxedUnit> $init$$$anonfun$1(MessageContainer d) {
        return arg_0 -> this.$init$$$anonfun$2$$anonfun$1(d, arg_0);
    }

    private static boolean summary$$anonfun$1(Tuple2<String, Object> x$1) {
        boolean bl;
        Tuple2<String, Object> tuple2 = x$1;
        if (tuple2 != null) {
            String settingName = (String)tuple2._1();
            int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static ListBuffer summary$$anonfun$2(ListBuffer b$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String settingName = (String)tuple2._1();
        int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
        return b$2.$plus$eq((Object)StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"there were ", " ", " warning(s); re-run with ", " for details"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count), new StringOps(Predef$.MODULE$.augmentString(settingName)).tail(), settingName})));
    }

    private static String printSummary$$anonfun$1(String s$9) {
        return s$9;
    }

    private static void flush$$anonfun$1(Contexts.Context ctx$907, Reporter $672$$1, MessageContainer m) {
        $672$$1.report(m, ctx$907);
    }
}

