/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.config.CommandLineParser$;
import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.util.DotClass;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class CompilerCommand$
extends DotClass {
    public static final CompilerCommand$ MODULE$;

    static {
        new CompilerCommand$();
    }

    public CompilerCommand$() {
        MODULE$ = this;
    }

    public String cmdName() {
        return "dotc";
    }

    private String explainAdvanced() {
        return "\n    |-- Notes on option parsing --\n    |Boolean settings are always false unless set.\n    |Where multiple values are accepted, they should be comma-separated.\n    |  example: -Xplugin:plugin1,plugin2\n    |<phases> means one or a comma-separated list of:\n    |  - (partial) phase names with an optional \"+\" suffix to include the next phase\n    |  - the string \"all\"\n    |  example: -Xprint:all prints all phases.\n    |  example: -Xprint:front,mixin prints the frontend and mixin phases.\n    |  example: -Ylog:erasure+ logs the erasure phase and the phase after the erasure phase.\n    |           This is useful because during the tree transform of phase X, we often\n    |           already are in phase X + 1.\n  ";
    }

    public String shortUsage() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Usage: ", " <options> <source files>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmdName()}));
    }

    public String versionMsg() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dotty compiler ", " -- ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Properties$.MODULE$.versionString(), Properties$.MODULE$.copyrightString()}));
    }

    public Settings.ArgsSummary distill(String[] args, Contexts.Context ctx) {
        return Contexts$Context$.MODULE$.toBase(ctx).settings().processArguments((List<String>)this.expandedArguments$1(args), true, ctx);
    }

    public List<String> checkUsage(Settings.ArgsSummary summary, boolean sourcesRequired, Contexts.Context ctx) {
        Nil$ nil$;
        ScalaSettings settings = Contexts$Context$.MODULE$.toBase(ctx).settings();
        summary.warnings().foreach((Function1)((JProcedure1)_$150 -> ctx.warning(() -> this.checkUsage$$anonfun$8$$anonfun$1(_$150), ctx.warning$default$2())));
        if (summary.errors().nonEmpty()) {
            summary.errors().foreach((Function1)((JProcedure1)_$151 -> ctx.error(() -> this.checkUsage$$anonfun$9$$anonfun$1(_$151), ctx.error$default$2())));
            ctx.echo(this::checkUsage$$anonfun$3, ctx.echo$default$2());
            nil$ = package$.MODULE$.Nil();
        } else {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(settings.version());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx))) {
                ctx.echo(this::checkUsage$$anonfun$4, ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (!Properties$.MODULE$.isJavaAtLeast("1.8")) {
                ctx.error(this::checkUsage$$anonfun$5, ctx.error$default$2());
                nil$ = package$.MODULE$.Nil();
            } else if (this.shouldStopWithInfo$1(ctx, settings)) {
                ctx.echo(() -> this.checkUsage$$anonfun$6(ctx, settings), ctx.echo$default$2());
                nil$ = package$.MODULE$.Nil();
            } else {
                if (sourcesRequired && summary.arguments().isEmpty()) {
                    ctx.echo(() -> this.checkUsage$$anonfun$7(ctx), ctx.echo$default$2());
                }
                nil$ = summary.arguments();
            }
        }
        return nil$;
    }

    private /* synthetic */ boolean stripComment$1$$anonfun$1(char _$145) {
        return _$145 != '#';
    }

    private boolean stripComment$2$$anonfun$adapted$1(Object _$145) {
        return this.stripComment$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$145));
    }

    private String stripComment$3(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(s)).takeWhile((Function1)((JFunction1)this::stripComment$2$$anonfun$adapted$1));
    }

    private List expandArg$1(String arg) {
        Path path = Paths.get(new StringOps(Predef$.MODULE$.augmentString(arg)).stripPrefix("@"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(new StringOps(Predef$.MODULE$.augmentString("argument file %s could not be found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getFileName()})));
        }
        java.util.List<String> lines = Files.readAllLines(path);
        String params = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(lines).asScala()).map((Function1)((JFunction1)s -> this.stripComment$3((String)s)), Buffer$.MODULE$.canBuildFrom())).mkString(" ");
        return CommandLineParser$.MODULE$.tokenize(params);
    }

    private List expandedArguments$1(String[] args$4) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$4)).toList().flatMap((Function1)((JFunction1)x$1 -> {
            List list;
            String string = x$1;
            String x = string;
            if (x.startsWith("@")) {
                list = this.expandArg$1(x);
            } else {
                String x2 = string;
                list = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x2}));
            }
            return list;
        }), List$.MODULE$.canBuildFrom());
    }

    private String format$1(int width$1, String s) {
        return new StringOps(Predef$.MODULE$.augmentString("%-" + width$1 + "s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String defaultValue$1(Settings.Setting s$6) {
        Object t = s$6.default();
        if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
        } else {
            if (!(t instanceof String)) return "";
            String string = (String)t;
        }
        String string = s$6.default().toString();
        return string;
    }

    private String formatSetting$1(int width$3, String name, String value) {
        return new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty() ? StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " ", ": ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format$1(width$3, ""), name, value})) : "";
    }

    private String helpStr$1(int width$2, Settings.Setting s) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format$1(width$2, s.name()), s.description(), this.formatSetting$1(width$2, "Default", this.defaultValue$1(s)), this.formatSetting$1(width$2, "Choices", s.legalChoices())}));
    }

    private String availableOptionsMsg$2(Contexts.Context ctx$226, Function1 cond) {
        List ss = (List)((TraversableOnce)Contexts$Context$.MODULE$.toBase(ctx$226).settings().allSettings().filter(cond)).toList().sortBy((Function1)((JFunction1)_$146 -> _$146.name()), (Ordering)Ordering.String$.MODULE$);
        int width = BoxesRunTime.unboxToInt((Object)((TraversableOnce)ss.map((Function1)((JFunction1)_$147 -> _$147.name().length()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        return ((TraversableOnce)ss.map((Function1)((JFunction1)s -> this.helpStr$1(width, (Settings.Setting)s)), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String createUsageMsg$1(Contexts.Context ctx$232, String label, boolean shouldExplain, Function1 cond) {
        String prefix = ((TraversableOnce)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)this.shortUsage()), Some$.MODULE$.apply((Object)this.explainAdvanced()).filter((Function1)((JFunction1)_$148 -> shouldExplain)), Some$.MODULE$.apply((Object)(label + " options include:"))})).flatten((Function1)((JFunction1)xo -> Option$.MODULE$.option2Iterable(xo)))).mkString("\n");
        return prefix + "\n" + this.availableOptionsMsg$2(ctx$232, cond);
    }

    private boolean isStandard$1(Settings.Setting s) {
        return !this.isAdvanced$1(s) && !this.isPrivate$1(s);
    }

    private boolean isAdvanced$1(Settings.Setting s) {
        return s.name().startsWith("-X");
    }

    private boolean isPrivate$1(Settings.Setting s) {
        return s.name().startsWith("-Y");
    }

    private String usageMessage$2(Contexts.Context ctx$233) {
        return this.createUsageMsg$1(ctx$233, "where possible standard", false, (Function1)((JFunction1)s -> this.isStandard$1((Settings.Setting)s)));
    }

    private String xusageMessage$2(Contexts.Context ctx$234) {
        return this.createUsageMsg$1(ctx$234, "Possible advanced", true, (Function1)((JFunction1)s -> this.isAdvanced$1((Settings.Setting)s)));
    }

    private String yusageMessage$2(Contexts.Context ctx$235) {
        return this.createUsageMsg$1(ctx$235, "Possible private", true, (Function1)((JFunction1)s -> this.isPrivate$1((Settings.Setting)s)));
    }

    private boolean shouldStopWithInfo$1(Contexts.Context ctx$227, ScalaSettings settings$1) {
        return ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Settings.Setting[]{settings$1.help(), settings$1.Xhelp(), settings$1.Yhelp(), settings$1.showPlugins()}))).exists((Function1)((JFunction1)_$149 -> {
            Settings.Setting setting = Settings$Setting$.MODULE$.SettingDecorator(_$149);
            return BoxesRunTime.unboxToBoolean(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx$227));
        }));
    }

    private String infoMessage$1(Contexts.Context ctx$229, ScalaSettings settings$2) {
        Settings.Setting<Object> setting;
        Settings.Setting<Object> setting2;
        Settings.Setting<Object> setting3;
        Settings.Setting<Object> setting4 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.help());
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting4, ctx$229)) ? this.usageMessage$2(ctx$229) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting3 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Xhelp()), ctx$229)) ? this.xusageMessage$2(ctx$229) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2 = Settings$Setting$.MODULE$.SettingDecorator(settings$2.Yhelp()), ctx$229)) ? this.yusageMessage$2(ctx$229) : (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting = Settings$Setting$.MODULE$.SettingDecorator(settings$2.showPlugins()), ctx$229)) ? ctx$229.pluginDescriptions() : "")));
    }

    private Message checkUsage$$anonfun$8$$anonfun$1(String _$150$1) {
        return Message$.MODULE$.toNoExplanation(_$150$1);
    }

    private Message checkUsage$$anonfun$9$$anonfun$1(String _$151$1) {
        return Message$.MODULE$.toNoExplanation(_$151$1);
    }

    private String checkUsage$$anonfun$3() {
        return "  dotc -help  gives more information";
    }

    private String checkUsage$$anonfun$4() {
        return this.versionMsg();
    }

    private Message checkUsage$$anonfun$5() {
        return Message$.MODULE$.toNoExplanation("Dotty requires Java 8 to run");
    }

    private String checkUsage$$anonfun$6(Contexts.Context ctx$236, ScalaSettings settings$3) {
        return this.infoMessage$1(ctx$236, settings$3);
    }

    private String checkUsage$$anonfun$7(Contexts.Context ctx$237) {
        return this.usageMessage$2(ctx$237);
    }
}

