/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.FatalError;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File$;
import dotty.tools.io.Jar$;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import dotty.tools.io.VirtualDirectory;
import dotty.tools.io.ZipArchive;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JFunction2;
import scala.io.Codec$;
import scala.package$;

public class OutputDirs {
    private List<Tuple2<AbstractFile, AbstractFile>> outputDirs = package$.MODULE$.Nil();
    private Option<AbstractFile> singleOutDir = None$.MODULE$;

    public void add(String srcDir, String outDir) {
        this.add(this.checkDir(AbstractFile$.MODULE$.getDirectory(srcDir), srcDir, this.checkDir$default$3()), this.checkDir(AbstractFile$.MODULE$.getDirectory(outDir), outDir, this.checkDir$default$3()));
    }

    private AbstractFile checkDir(AbstractFile dir, String name, boolean allowJar) {
        AbstractFile abstractFile;
        if (dir != null && dir.isDirectory()) {
            abstractFile = dir;
        } else if (allowJar && dir == null && Jar$.MODULE$.isJarOrZip(File$.MODULE$.apply(name, Codec$.MODULE$.fallbackSystemCodec()), false)) {
            abstractFile = new PlainFile(Path$.MODULE$.apply(name));
        } else {
            throw new FatalError(name + " does not exist or is not a directory");
        }
        return abstractFile;
    }

    public boolean checkDir$default$3() {
        return false;
    }

    public void setSingleOutput(String outDir) {
        AbstractFile dst = AbstractFile$.MODULE$.getDirectory(outDir);
        this.setSingleOutput(this.checkDir(dst, outDir, true));
    }

    public Option<AbstractFile> getSingleOutput() {
        return this.singleOutDir;
    }

    public void setSingleOutput(AbstractFile dir) {
        this.singleOutDir = Some$.MODULE$.apply((Object)dir);
    }

    public void add(AbstractFile src, AbstractFile dst) {
        this.singleOutDir = None$.MODULE$;
        this.outputDirs = this.outputDirs.$colon$colon((Object)Tuple2$.MODULE$.apply((Object)src, (Object)dst));
    }

    public List<Tuple2<AbstractFile, AbstractFile>> outputs() {
        return this.outputDirs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractFile outputDirFor(AbstractFile src) {
        AbstractFile abstractFile;
        Option<AbstractFile> option = this.singleOutDir;
        if (option instanceof Some) {
            AbstractFile d;
            Some some = (Some)option;
            abstractFile = d = (AbstractFile)some.value();
            return abstractFile;
        } else {
            AbstractFile d;
            Some some;
            Tuple2 tuple2;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option option2 = this.outputs().find(((JFunction2)(srcDir, outDir) -> OutputDirs.isBelow$1(src, srcDir, outDir)).tupled());
            if (!(option2 instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option2).value()) == null) throw new FatalError("Could not find an output directory for " + src.path() + " in " + this.outputs());
            abstractFile = d = (AbstractFile)tuple2._2();
        }
        return abstractFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<AbstractFile> srcFilesFor(AbstractFile classFile, String srcPath) {
        Nil$ nil$;
        Option<AbstractFile> option = this.singleOutDir;
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractFile d = (AbstractFile)some.value();
            AbstractFile abstractFile = d;
            if (abstractFile instanceof VirtualDirectory) {
                VirtualDirectory virtualDirectory = (VirtualDirectory)abstractFile;
            } else {
                if (!(abstractFile instanceof ZipArchive)) {
                    nil$ = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractFile[]{d.lookupPathUnchecked(srcPath, false)}));
                    return nil$;
                }
                ZipArchive zipArchive = (ZipArchive)abstractFile;
            }
            nil$ = package$.MODULE$.Nil();
            return nil$;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        List list = (List)this.outputs().filter(((JFunction2)(srcDir, outDir) -> OutputDirs.isBelow$2(classFile, srcDir, outDir)).tupled());
        Nil$ nil$2 = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$2 != null ? !nil$2.equals(list2) : list2 != null)) {
            nil$ = package$.MODULE$.Nil();
            return nil$;
        }
        List matches = list;
        nil$ = (List)matches.map((Function1)((JFunction1)_$153 -> ((AbstractFile)_$153._1()).lookupPathUnchecked(srcPath, false)), List$.MODULE$.canBuildFrom());
        return nil$;
    }

    private static boolean isBelow$1(AbstractFile src$1, AbstractFile srcDir, AbstractFile outDir) {
        return src$1.path().startsWith(srcDir.path());
    }

    private static boolean isBelow$2(AbstractFile classFile$1, AbstractFile srcDir, AbstractFile outDir) {
        return classFile$1.path().startsWith(outDir.path());
    }
}

