/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.package$;

public interface PropertiesTrait {
    default public void $init$() {
    }

    public String propCategory();

    public Class<?> pickJarBasedOn();

    public String propFilename();

    default public String initial$propFilename() {
        return "/" + this.propCategory() + ".properties";
    }

    /*
     * WARNING - void declaration
     */
    default public Properties scalaProps() {
        void var1_1;
        block0: {
            Properties props = new Properties();
            InputStream stream = this.pickJarBasedOn().getResourceAsStream(this.propFilename());
            if (stream == null) break block0;
            this.quietlyDispose((Function0)((JFunction0.mcV.sp)() -> PropertiesTrait.scalaProps$$anonfun$1(props, stream)), (Function0)((JFunction0.mcV.sp)() -> PropertiesTrait.scalaProps$$anonfun$2(stream)));
        }
        return var1_1;
    }

    private void quietlyDispose(Function0 action, Function0 disposal) {
        try {
            action.apply();
        }
        catch (Throwable throwable) {
            try {
                disposal.apply();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            disposal.apply();
        }
        catch (IOException iOException) {}
    }

    default public boolean propIsSet(String name) {
        return System.getProperty(name) != null;
    }

    default public boolean propIsSetTo(String name, String value) {
        String string = this.propOrNull(name);
        String string2 = value;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    default public String propOrElse(String name, String alt) {
        return System.getProperty(name, alt);
    }

    default public String propOrEmpty(String name) {
        return this.propOrElse(name, "");
    }

    default public String propOrNull(String name) {
        return this.propOrElse(name, null);
    }

    default public Option<String> propOrNone(String name) {
        return Option$.MODULE$.apply((Object)this.propOrNull(name));
    }

    default public boolean propOrFalse(String name) {
        return this.propOrNone(name).exists((Function1)((JFunction1)x -> package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yes", "on", "true"})).contains((Object)x.toLowerCase())));
    }

    default public String setProp(String name, String value) {
        return System.setProperty(name, value);
    }

    default public String clearProp(String name) {
        return System.clearProperty(name);
    }

    default public String envOrElse(String name, String alt) {
        return (String)Option$.MODULE$.apply((Object)System.getenv(name)).getOrElse(() -> PropertiesTrait.envOrElse$$anonfun$1(alt));
    }

    default public Option<String> envOrNone(String name) {
        return Option$.MODULE$.apply((Object)System.getenv(name));
    }

    default public String scalaPropOrElse(String name, String alt) {
        return this.scalaProps().getProperty(name, alt);
    }

    default public String scalaPropOrEmpty(String name) {
        return this.scalaPropOrElse(name, "");
    }

    default public Option<String> scalaPropOrNone(String name) {
        return Option$.MODULE$.apply((Object)this.scalaProps().getProperty(name));
    }

    default public String versionNumberString() {
        return this.scalaPropOrEmpty("version.number");
    }

    public String versionString();

    default public String initial$versionString() {
        String v = this.scalaPropOrElse("version.number", "(unknown)");
        return "version " + this.scalaPropOrElse("version.number", "(unknown)") + (v.contains("SNAPSHOT") || v.contains("NIGHTLY") ? "-git-" + this.scalaPropOrElse("git.hash", "(unknown)") : "");
    }

    public boolean experimental();

    default public boolean initial$experimental() {
        return this.versionString().contains("SNAPSHOT") || this.versionString().contains("NIGHTLY");
    }

    public String copyrightString();

    default public String initial$copyrightString() {
        return this.scalaPropOrElse("copyright.string", "(c) 2002-2017 LAMP/EPFL");
    }

    default public String sourceEncoding() {
        return this.scalaPropOrElse("file.encoding", "UTF-8");
    }

    default public String sourceReader() {
        return this.scalaPropOrElse("source.reader", "scala.tools.nsc.io.SourceReader");
    }

    default public String encodingString() {
        return this.propOrElse("file.encoding", "UTF-8");
    }

    default public String lineSeparator() {
        return this.propOrElse("line.separator", "\n");
    }

    default public String javaClassPath() {
        return this.propOrEmpty("java.class.path");
    }

    default public String javaHome() {
        return this.propOrEmpty("java.home");
    }

    default public String javaVendor() {
        return this.propOrEmpty("java.vendor");
    }

    default public String javaVersion() {
        return this.propOrEmpty("java.version");
    }

    default public String javaVmInfo() {
        return this.propOrEmpty("java.vm.info");
    }

    default public String javaVmName() {
        return this.propOrEmpty("java.vm.name");
    }

    default public String javaVmVendor() {
        return this.propOrEmpty("java.vm.vendor");
    }

    default public String javaVmVersion() {
        return this.propOrEmpty("java.vm.version");
    }

    default public String osName() {
        return this.propOrEmpty("os.name");
    }

    default public String scalaHome() {
        return this.propOrEmpty("scala.home");
    }

    default public String tmpDir() {
        return this.propOrEmpty("java.io.tmpdir");
    }

    default public String userDir() {
        return this.propOrEmpty("user.dir");
    }

    default public String userHome() {
        return this.propOrEmpty("user.home");
    }

    default public String userName() {
        return this.propOrEmpty("user.name");
    }

    default public boolean isWin() {
        return this.osName().startsWith("Windows");
    }

    default public boolean isMac() {
        return this.javaVendor().startsWith("Apple");
    }

    default public String jdkHome() {
        return this.envOrElse("JDK_HOME", this.envOrElse("JAVA_HOME", this.javaHome()));
    }

    default public String versionMsg() {
        return new StringOps(Predef$.MODULE$.augmentString("Scala %s %s -- %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.propCategory(), this.versionString(), this.copyrightString()}));
    }

    default public String scalaCmd() {
        return this.isWin() ? "dotr.bat" : "dotr";
    }

    default public String scalacCmd() {
        return this.isWin() ? "dotc.bat" : "dotc";
    }

    default public boolean isJavaAtLeast(String version) {
        String string = version;
        Nil$ okVersions = "1.5".equals(string) ? package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.5", "1.6", "1.7", "1.8"})) : ("1.6".equals(string) ? package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.6", "1.7", "1.8"})) : ("1.7".equals(string) ? package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.7", "1.8"})) : ("1.8".equals(string) ? package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.8"})) : package$.MODULE$.Nil())));
        return okVersions.exists((Function1)((JFunction1)_$158 -> this.javaVersion().startsWith((String)_$158)));
    }

    private static void scalaProps$$anonfun$1(Properties props$1, InputStream stream$1) {
        props$1.load(stream$1);
    }

    private static void scalaProps$$anonfun$2(InputStream stream$2) {
        stream$2.close();
    }

    private static String envOrElse$$anonfun$1(String alt$2) {
        return alt$2;
    }
}

