/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.interactive;

import dotty.tools.FatalError;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$PackageDef$;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.ast.tpd$TreeOps$;
import dotty.tools.dotc.classpath.AggregateClassPath;
import dotty.tools.dotc.classpath.AggregateClassPath$;
import dotty.tools.dotc.classpath.ClassPathEntries;
import dotty.tools.dotc.classpath.ClassPathEntries$;
import dotty.tools.dotc.classpath.JFileDirectoryLookup;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.ZipArchiveFileLookup;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Contexts$FreshModeChanges$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$PreNamedString$;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.NameOps$NameDecorator$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$UnspecifiedErrorType$;
import dotty.tools.dotc.interactive.InteractiveCompiler;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.HideNonSensicalMessages;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.reporting.UniqueMessagePositions;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.PlainFile;
import dotty.tools.io.VirtualFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public class InteractiveDriver
extends Driver {
    private final List settings;
    private final Contexts.Context myInitCtx;
    private Contexts.Context myCtx;
    private final LinkedHashMap myOpenedFiles;
    private final LinkedHashMap myOpenedTrees;
    private final LinkedHashMap myCompilationUnits;
    private final List tastySuffixes;
    private final Seq zipClassPaths;
    private final Seq dirClassPaths;
    private final Seq zipClassPathClasses;
    private final Compiler compiler;

    public static URI toUri(SourceFile sourceFile) {
        return InteractiveDriver$.MODULE$.toUri(sourceFile);
    }

    /*
     * WARNING - void declaration
     */
    public InteractiveDriver(List<String> settings) {
        Tuple2 tuple2;
        void var3_3;
        this.settings = settings;
        Contexts.FreshContext rootCtx = Contexts$FreshModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.FreshModeChanges(Contexts$FreshModeChanges$.MODULE$.addMode$extension(Contexts$.MODULE$.FreshModeChanges(this.initCtx().fresh()), Mode$.MODULE$.ReadPositions())), Mode$.MODULE$.Interactive());
        rootCtx.setSetting(Contexts$Context$.MODULE$.toBase(rootCtx).settings().YretainTrees(), BoxesRunTime.boxToBoolean((boolean)true));
        Contexts.Context ctx = (Contexts.Context)this.setup((String[])settings.toArray(ClassTag$.MODULE$.apply(String.class)), rootCtx)._2();
        Contexts$Context$.MODULE$.toBase(ctx).initialize(ctx);
        this.myInitCtx = var3_3;
        this.myCtx = this.myInitCtx();
        this.myOpenedFiles = new LinkedHashMap(){

            public SourceFile default(URI key) {
                return NoSource$.MODULE$;
            }
        };
        this.myOpenedTrees = new LinkedHashMap(){

            public List default(URI key) {
                return package$.MODULE$.Nil();
            }
        };
        this.myCompilationUnits = new LinkedHashMap();
        this.tastySuffixes = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".hasTasty", ".tasty"}));
        ClassPath classPath = Contexts$Context$.MODULE$.toBase(this.currentCtx()).platform().classPath(this.currentCtx());
        if (classPath instanceof AggregateClassPath) {
            AggregateClassPath aggregateClassPath = (AggregateClassPath)classPath;
            AggregateClassPath aggregateClassPath2 = AggregateClassPath$.MODULE$.unapply(aggregateClassPath);
            Seq<ClassPath> seq = aggregateClassPath2._1();
            Seq<ClassPath> cps = seq;
            Tuple2 tuple22 = cps.partition((Function1)((JFunction1)_$472 -> _$472 instanceof ZipArchiveFileLookup));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Seq zipCps = (Seq)tuple22._1();
            Seq dirCps = (Seq)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)zipCps, (Object)dirCps);
            Seq zipCps2 = (Seq)tuple23._1();
            Seq dirCps2 = (Seq)tuple23._2();
            tuple2 = Tuple2$.MODULE$.apply((Object)zipCps2, (Object)dirCps2);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        }
        Tuple2 tuple24 = tuple2;
        this.zipClassPaths = (Seq)tuple24._1();
        this.dirClassPaths = (Seq)tuple24._2();
        this.zipClassPathClasses = (Seq)this.zipClassPaths().flatMap((Function1)((JFunction1)zipCp -> {
            ZipFile zipFile = new ZipFile(zipCp.zipFile());
            return this.liftedTree8$6(zipFile);
        }), Seq$.MODULE$.canBuildFrom());
        this.compiler = new InteractiveCompiler();
    }

    public List<String> settings() {
        return this.settings;
    }

    @Override
    public boolean sourcesRequired() {
        return false;
    }

    private Contexts.Context myInitCtx() {
        return this.myInitCtx;
    }

    public Contexts.Context currentCtx() {
        return this.myCtx;
    }

    private LinkedHashMap<URI, SourceFile> myOpenedFiles() {
        return this.myOpenedFiles;
    }

    private LinkedHashMap<URI, List<SourceTree>> myOpenedTrees() {
        return this.myOpenedTrees;
    }

    private LinkedHashMap<URI, CompilationUnit> myCompilationUnits() {
        return this.myCompilationUnits;
    }

    public Map<URI, SourceFile> openedFiles() {
        return this.myOpenedFiles();
    }

    public Map<URI, List<SourceTree>> openedTrees() {
        return this.myOpenedTrees();
    }

    public Map<URI, CompilationUnit> compilationUnits() {
        return this.myCompilationUnits();
    }

    public List<SourceTree> allTrees(Contexts.Context ctx) {
        return this.allTreesContaining("", ctx);
    }

    public List<SourceTree> allTreesContaining(String id, Contexts.Context ctx) {
        List fromSource = ((TraversableOnce)this.openedTrees().values().flatten((Function1)Predef$.MODULE$.$conforms())).toList();
        Seq fromClassPath = (Seq)((TraversableLike)this.dirClassPathClasses().$plus$plus(this.zipClassPathClasses(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1)((JFunction1)cls -> {
            Names.TypeName className = Decorators$PreNamedString$.MODULE$.toTypeName$extension(Decorators$.MODULE$.PreNamedString((String)cls));
            Object[] objectArray = new Option[2];
            objectArray[0] = this.tree(className, id, ctx);
            Names.TypeName typeName = NameOps$.MODULE$.NameDecorator(className);
            objectArray[1] = this.tree(NameOps$NameDecorator$.MODULE$.moduleClassName$extension(typeName), id, ctx);
            return package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray)).flatten((Function1)((JFunction1)xo -> Option$.MODULE$.option2Iterable(xo)));
        }), Seq$.MODULE$.canBuildFrom());
        return (List)((SeqLike)fromSource.$plus$plus((GenTraversableOnce)fromClassPath, List$.MODULE$.canBuildFrom())).distinct();
    }

    private Option<SourceTree> tree(Names.TypeName className, String id, Contexts.Context ctx) {
        Option<SourceTree> option;
        Denotations.Denotation clsd = ctx.base().staticRef(className, ctx.base().staticRef$default$2(), ctx.base().staticRef$default$3(), ctx);
        Denotations.Denotation denotation = clsd;
        if (denotation instanceof SymDenotations.ClassDenotation) {
            SymDenotations.ClassDenotation classDenotation;
            SymDenotations.ClassDenotation clsd2 = classDenotation = (SymDenotations.ClassDenotation)denotation;
            clsd2.ensureCompleted(ctx);
            option = SourceTree$.MODULE$.fromSymbol(clsd2.symbol().asClass(), id, ctx);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public List<String> dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes() {
        return this.tastySuffixes;
    }

    private List<String> classNames(ClassPath cp, String packageName) {
        ClassPathEntries classPathEntries = cp.list(packageName);
        if (classPathEntries == null) {
            throw new MatchError((Object)classPathEntries);
        }
        ClassPathEntries classPathEntries2 = ClassPathEntries$.MODULE$.unapply(classPathEntries);
        Seq<PackageEntry> seq = classPathEntries2._1();
        Seq<ClassRepresentation> seq2 = classPathEntries2._2();
        Seq<PackageEntry> pkgs = seq;
        Seq<ClassRepresentation> classReps = seq2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(pkgs, classReps);
        Seq pkgs2 = (Seq)tuple2._1();
        Seq classReps2 = (Seq)tuple2._2();
        return (List)((TraversableOnce)((TraversableLike)classReps2.filter((Function1)((JFunction1)classRep -> {
            PlainFile plainFile;
            Option<AbstractFile> option = classRep.binary();
            if (None$.MODULE$.equals(option)) {
                return true;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            AbstractFile binFile = (AbstractFile)some.value();
            if (!binFile.name().endsWith(".class")) return false;
            String string = new StringOps(Predef$.MODULE$.augmentString(binFile.name())).stripSuffix(".class");
            String prefix = string;
            if (prefix == null) return false;
            AbstractFile abstractFile = binFile;
            if (!(abstractFile instanceof PlainFile)) {
                throw scala.sys.package$.MODULE$.error(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled file type: ", " [getClass = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binFile, binFile.getClass()})));
            }
            PlainFile pf = plainFile = (PlainFile)abstractFile;
            if (!((LinearSeqOptimized)this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes().map((Function1)((JFunction1)suffix -> pf.givenPath().parent().$div(prefix + suffix)), List$.MODULE$.canBuildFrom())).exists((Function1)((JFunction1)_$471 -> _$471.exists()))) return false;
            return true;
        }))).map((Function1)((JFunction1)classRep -> {
            String string = packageName;
            String string2 = "";
            return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(packageName)).$plus$plus((GenTraversableOnce)((string == null ? string2 != null : !string.equals(string2)) ? new StringOps(Predef$.MODULE$.augmentString(".")) : new StringOps(Predef$.MODULE$.augmentString(""))), Predef$.MODULE$.StringCanBuildFrom()))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(classRep.name())), Predef$.MODULE$.StringCanBuildFrom());
        }), Seq$.MODULE$.canBuildFrom())).toList().$plus$plus((GenTraversableOnce)pkgs2.flatMap((Function1)((JFunction1)pkg -> this.classNames(cp, pkg.name())), Seq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
    }

    private Seq<ZipArchiveFileLookup<?>> zipClassPaths() {
        return this.zipClassPaths;
    }

    private Seq<JFileDirectoryLookup<?>> dirClassPaths() {
        return this.dirClassPaths;
    }

    private Seq<String> zipClassPathClasses() {
        return this.zipClassPathClasses;
    }

    private Seq<String> dirClassPathClasses() {
        ListBuffer names = new ListBuffer();
        this.dirClassPaths().foreach((Function1)((JFunction1)dirCp -> {
            Path root = ((File)dirCp.dir()).toPath();
            return this.liftedTree9$1(names, root);
        }));
        return names.toList();
    }

    private List<SourceTree> topLevelClassTrees(Trees.Tree<Types.Type> topTree, SourceFile source) {
        ListBuffer trees = new ListBuffer();
        InteractiveDriver.addTrees$1(source, trees, topTree);
        return trees.toList();
    }

    private Compiler compiler() {
        return this.compiler;
    }

    private void cleanup(Trees.Tree tree, Contexts.Context ctx) {
        Set seen = Set$.MODULE$.empty();
        InteractiveDriver.cleanupTree$1(ctx, seen, tree);
    }

    private SourceFile toSource(URI uri, String sourceCode) {
        VirtualFile virtualFile = new VirtualFile(uri.toString(), Paths.get(uri).toString());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(virtualFile.output(), "UTF-8"));
        writer.write(sourceCode);
        writer.close();
        return new SourceFile((AbstractFile)virtualFile, Codec$.MODULE$.UTF8());
    }

    public List<MessageContainer> run(URI uri, String sourceCode) {
        return this.run(uri, this.toSource(uri, sourceCode));
    }

    public List<MessageContainer> run(URI uri, SourceFile source) {
        List<MessageContainer> list;
        Contexts.Context previousCtx = this.myCtx;
        try {
            UniqueMessagePositions reporter = new UniqueMessagePositions(){
                private final HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                {
                    this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions = UniqueMessagePositions.super.dotty$tools$dotc$reporting$UniqueMessagePositions$$initial$positions();
                    UniqueMessagePositions.super.$init$();
                }

                public HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
                    return this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$UniqueMessagePositions$$super$isHidden(MessageContainer m, Contexts.Context ctx) {
                    return super.isHidden(m, ctx);
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$HideNonSensicalMessages$$super$isHidden(MessageContainer m, Contexts.Context ctx) {
                    return UniqueMessagePositions.super.isHidden(m, ctx);
                }

                public boolean isHidden(MessageContainer m, Contexts.Context ctx) {
                    return HideNonSensicalMessages.super.isHidden(m, ctx);
                }
            };
            Run run = this.compiler().newRun(this.myInitCtx().fresh().setReporter((Reporter)((Object)reporter)));
            Contexts.Context ctx = this.myCtx = run.runContext();
            this.myOpenedFiles().update((Object)uri, (Object)source);
            run.compileSources((List<SourceFile>)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SourceFile[]{source})));
            run.printSummary();
            CompilationUnit unit = (CompilationUnit)ctx.run().units().head();
            Trees.Tree t = unit.tpdTree();
            this.cleanup(t, ctx);
            this.myOpenedTrees().update((Object)uri, this.topLevelClassTrees(t, source));
            this.myCompilationUnits().update((Object)uri, (Object)unit);
            list = ((StoreReporter)((Object)reporter)).removeBufferedMessages(ctx);
        }
        catch (FatalError ex) {
            this.myCtx = previousCtx;
            this.close(uri);
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public void close(URI uri) {
        this.myOpenedFiles().remove((Object)uri);
        this.myOpenedTrees().remove((Object)uri);
        this.myCompilationUnits().remove((Object)uri);
    }

    private ArraySeq liftedTree8$6(ZipFile zipFile$2) {
        ArraySeq arraySeq;
        try {
            arraySeq = (ArraySeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zipFile$2.stream().toArray(ZipEntry[]::new))).map((Function1)((JFunction1)entry -> {
                String name = entry.getName();
                return Tuple2$.MODULE$.apply(entry, (Object)name);
            }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1)((JFunction1)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ZipEntry entry = (ZipEntry)tuple2._1();
                String name = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes().find((Function1)((JFunction1)x$0 -> name.endsWith((String)x$0))).map((Function1)((JFunction1)tastySuffix -> new StringOps(Predef$.MODULE$.augmentString(name.replace("/", "."))).stripSuffix(tastySuffix))));
            }), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        finally {
            zipFile$2.close();
        }
        return arraySeq;
    }

    private static String className$1(List classSegments) {
        return new StringOps(Predef$.MODULE$.augmentString(classSegments.mkString("."))).stripSuffix(".class");
    }

    public static /* synthetic */ boolean dotty$tools$dotc$interactive$InteractiveDriver$$anon$4$$_$visitFile$$anonfun$1(String name$123, String tastySuffix) {
        return name$123.endsWith(tastySuffix);
    }

    private Object liftedTree9$1(ListBuffer names$6, Path root$13) {
        Object object;
        try {
            object = Files.walkFileTree(root$13, new SimpleFileVisitor(names$6, root$13, this){
                private final ListBuffer names$1;
                private final Path root$1;
                private final InteractiveDriver $outer;
                {
                    this.names$1 = names$9;
                    this.root$1 = root$15;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    block0: {
                        if (attrs.isDirectory()) break block0;
                        String name = path.getFileName().toString();
                        this.dotty$tools$dotc$interactive$InteractiveDriver$_$_$_$$anon$$$outer().dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffixes().withFilter((Function1)((JFunction1)arg_0 -> InteractiveDriver.dotty$tools$dotc$interactive$InteractiveDriver$$anon$4$$_$visitFile$$anonfun$1(name, arg_0))).foreach((Function1)((JFunction1)tastySuffix -> this.names$1.$plus$eq((Object)new StringOps(Predef$.MODULE$.augmentString(this.root$1.relativize(path).toString().replace("/", "."))).stripSuffix(tastySuffix))));
                    }
                    return FileVisitResult.CONTINUE;
                }

                private InteractiveDriver $outer() {
                    return this.$outer;
                }

                public final InteractiveDriver dotty$tools$dotc$interactive$InteractiveDriver$_$_$_$$anon$$$outer() {
                    return this.$outer();
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private static void addTrees$1(SourceFile source$4, ListBuffer trees$2, Trees.Tree tree2) {
        block1: {
            Trees.TypeDef typeDef;
            Trees.Tree tree3;
            block0: {
                List list;
                tree3 = tree2;
                if (!(tree3 instanceof Trees.PackageDef)) break block0;
                Trees.PackageDef packageDef = (Trees.PackageDef)tree3;
                Trees.PackageDef packageDef2 = Trees$PackageDef$.MODULE$.unapply(packageDef);
                Trees.RefTree refTree = packageDef2._1();
                List stats = list = packageDef2._2();
                stats.foreach((Function1)((JProcedure1)tree -> InteractiveDriver.addTrees$1(source$4, trees$2, tree)));
                break block1;
            }
            if (!(tree3 instanceof Trees.TypeDef)) break block1;
            Trees.TypeDef tree4 = typeDef = (Trees.TypeDef)tree3;
            trees$2.$plus$eq((Object)SourceTree$.MODULE$.apply(tree4, source$4));
        }
    }

    private static void cleanupTree$1(Contexts.Context ctx$937, Set seen$1, Trees.Tree tree) {
        seen$1.$plus$eq((Object)tree);
        Trees.Tree tree2 = tpd$.MODULE$.TreeOps(tree);
        tpd$TreeOps$.MODULE$.foreachSubTree$extension(tree2, (Function1<Trees.Tree<Types.Type>, BoxedUnit>)((JProcedure1)t -> {
            if (Symbols$.MODULE$.toDenot(t.symbol(ctx$937), ctx$937).exists() && t.hasType()) {
                if (!Symbols$.MODULE$.toDenot(t.symbol(ctx$937), ctx$937).isCompleted()) {
                    Symbols$.MODULE$.toDenot(t.symbol(ctx$937), ctx$937).info_$eq(Types$UnspecifiedErrorType$.MODULE$);
                }
                Symbols$.MODULE$.toDenot(t.symbol(ctx$937), ctx$937).annotations(ctx$937).foreach((Function1)((JProcedure1)annot -> {
                    block0: {
                        if (!annot.isEvaluated() || seen$1.apply((Object)annot.tree(ctx$937))) break block0;
                        InteractiveDriver.cleanupTree$1(ctx$937, seen$1, annot.tree(ctx$937));
                    }
                }));
            }
            t.removeAllAttachments();
        }), ctx$937);
    }
}

