/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.EventType;
import dotty.tools.dotc.profile.EventType$;
import dotty.tools.dotc.profile.GcEventData;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileReporter;
import dotty.tools.dotc.profile.RealProfiler;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public class StreamProfileReporter
implements ProfileReporter {
    private final PrintWriter out;

    public StreamProfileReporter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void header(RealProfiler profiler) {
        this.out.println(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"info, ", ", version, 2, output, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profiler.id()), profiler.outDir()})));
        this.out.println(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"header(main/background),startNs,endNs,runId,phaseId,phaseName,purpose,task-count,threadId,threadName,runNs,idleNs,cpuTimeNs,userTimeNs,allocatedByte,heapSize"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])));
        this.out.println(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"header(GC),startNs,endNs,startMs,endMs,name,action,cause,threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    @Override
    public void reportBackground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.BACKGROUND(), profiler, threadRange);
    }

    @Override
    public void reportForeground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.MAIN(), profiler, threadRange);
    }

    private void reportCommon(EventType tpe, RealProfiler profiler, ProfileRange threadRange) {
        this.out.println(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", ",", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe, BoxesRunTime.boxToLong((long)threadRange.start().snapTimeNanos()), BoxesRunTime.boxToLong((long)threadRange.end().snapTimeNanos()), BoxesRunTime.boxToInteger((int)profiler.id()), BoxesRunTime.boxToInteger((int)threadRange.phase().id()), threadRange.phase().phaseName().replace(',', ' '), threadRange.purpose(), BoxesRunTime.boxToInteger((int)threadRange.taskCount()), BoxesRunTime.boxToLong((long)threadRange.thread().getId()), threadRange.thread().getName(), BoxesRunTime.boxToLong((long)threadRange.runNs()), BoxesRunTime.boxToLong((long)threadRange.idleNs()), BoxesRunTime.boxToLong((long)threadRange.cpuNs()), BoxesRunTime.boxToLong((long)threadRange.userNs()), BoxesRunTime.boxToLong((long)threadRange.allocatedBytes()), BoxesRunTime.boxToLong((long)threadRange.end().heapBytes())})));
    }

    @Override
    public void reportGc(GcEventData data) {
        long duration = TimeUnit.MILLISECONDS.toNanos(data.gcEndMillis() - data.gcStartMillis() + 1L);
        long start = data.reportTimeNs() - duration;
        this.out.println(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ",", ", ", ",", ",", ",", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventType$.MODULE$.GC(), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)data.reportTimeNs()), BoxesRunTime.boxToLong((long)data.gcStartMillis()), BoxesRunTime.boxToLong((long)data.gcEndMillis()), data.name(), data.action(), data.cause(), BoxesRunTime.boxToLong((long)data.threads())})));
    }

    @Override
    public void close(RealProfiler profiler) {
        this.out.flush();
        this.out.close();
    }
}

