/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$PhaseListDecorator$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.reporting.diagnostic.ExtendMessage;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.Message$;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourcePosition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;

public interface Reporting {
    default public void inform(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().verbose());
            if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block0;
            this.echo(msg, pos);
        }
    }

    default public NoSourcePosition$ inform$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void echo(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new messages.Info(() -> Reporting.echo$$anonfun$1(msg), pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ echo$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void reportWarning(messages.Warning warning) {
        block2: {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().silentWarnings());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block2;
            Settings.Setting<Object> setting2 = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().XfatalWarnings());
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting2, ((Contexts.Context)this).ctx()))) {
                ((Contexts.Context)this).reporter().report(warning.toError(), ((Contexts.Context)this).ctx());
            } else {
                ((Contexts.Context)this).reporter().report(warning, ((Contexts.Context)this).ctx());
            }
        }
    }

    default public void deprecationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.DeprecationWarning(msg, pos));
    }

    default public NoSourcePosition$ deprecationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void migrationWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.MigrationWarning(msg, pos));
    }

    default public NoSourcePosition$ migrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void uncheckedWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.UncheckedWarning(msg, pos));
    }

    default public NoSourcePosition$ uncheckedWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.FeatureWarning(msg, pos));
    }

    default public NoSourcePosition$ featureWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void featureWarning(String feature, String featureDescription, boolean isScala2Feature, Symbols.Symbol featureUseSite, boolean required, SourcePosition pos) {
        String string;
        String req = required ? "needs to" : "should";
        String prefix = isScala2Feature ? "scala." : "dotty.";
        String fqname = prefix + "language." + feature;
        if (((Contexts.Context)this).reporter().isReportedFeatureUseSite(featureUseSite)) {
            string = "";
        } else {
            ((Contexts.Context)this).reporter().reportNewFeatureUseSite(featureUseSite);
            string = new StringOps(Predef$.MODULE$.augmentString(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |This can be achieved by adding the import clause 'import ", "'\n           |or by setting the compiler option -language:", ".\n           |See the Scala docs for value ", " for a discussion\n           |why the feature ", " be explicitly enabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fqname, feature, fqname, req})))).stripMargin();
        }
        String explain = string;
        String msg = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " be enabled\\nby making the implicit value ", " visible.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureDescription, req, fqname, explain}));
        if (required) {
            this.error(() -> Reporting.featureWarning$$anonfun$1(msg), pos);
        } else {
            this.reportWarning(new messages.FeatureWarning(() -> Reporting.featureWarning$$anonfun$2(msg), pos));
        }
    }

    default public void warning(Function0 msg, SourcePosition pos) {
        this.reportWarning(new messages.Warning(msg, pos));
    }

    default public NoSourcePosition$ warning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void strictWarning(Function0 msg, SourcePosition pos) {
        Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().strict());
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) {
            this.error(msg, pos);
        } else {
            this.reportWarning(new ExtendMessage((Function0<Message>)((Function0)() -> (Message)msg.apply()), (Function1<String, String>)((JFunction1)_$571 -> _$571 + "\n(This would be an error under strict mode)")).warning(pos));
        }
    }

    default public NoSourcePosition$ strictWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void error(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new messages.Error(msg, pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ error$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void errorOrMigrationWarning(Function0 msg, SourcePosition pos) {
        if (((Contexts.Context)this).ctx().scala2Mode()) {
            this.migrationWarning(msg, pos);
        } else {
            this.error(msg, pos);
        }
    }

    default public NoSourcePosition$ errorOrMigrationWarning$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void restrictionError(Function0 msg, SourcePosition pos) {
        ((Contexts.Context)this).reporter().report(new ExtendMessage((Function0<Message>)((Function0)() -> (Message)msg.apply()), (Function1<String, String>)((JFunction1)m -> StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Implementation restriction: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m})))).error(pos), ((Contexts.Context)this).ctx());
    }

    default public NoSourcePosition$ restrictionError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void incompleteInputError(Function0 msg, SourcePosition pos, Contexts.Context ctx) {
        ((Contexts.Context)this).reporter().incomplete(new messages.Error(msg, pos), ctx);
    }

    default public NoSourcePosition$ incompleteInputError$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void log(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting<List<String>> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().Ylog());
            if (!Decorators$PhaseListDecorator$.MODULE$.containsPhase$extension(Decorators$.MODULE$.PhaseListDecorator(Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx())), ((Contexts.Context)this).phase())) break block0;
            this.echo(() -> this.log$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ log$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    default public void debuglog(Function0 msg) {
        block0: {
            if (!((Contexts.Context)this).ctx().debug()) break block0;
            this.log(msg, this.log$default$2());
        }
    }

    default public void informTime(Function0 msg, long start) {
        this.informProgress(() -> Reporting.informTime$$anonfun$1(msg, start));
    }

    default public void informProgress(Function0 msg) {
        this.inform(() -> Reporting.informProgress$$anonfun$1(msg), this.inform$default$2());
    }

    default public <T> T logWith(Function0<String> msg, T value) {
        this.log(() -> Reporting.logWith$$anonfun$1(msg, value), this.log$default$2());
        return value;
    }

    default public void debugwarn(Function0 msg, SourcePosition pos) {
        block0: {
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase((Contexts.Context)this).settings().Ydebug());
            if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ((Contexts.Context)this).ctx()))) break block0;
            this.warning(() -> Reporting.debugwarn$$anonfun$1(msg), pos);
        }
    }

    default public NoSourcePosition$ debugwarn$default$2() {
        return NoSourcePosition$.MODULE$;
    }

    private static Message echo$$anonfun$1(Function0 msg$21) {
        return Message$.MODULE$.toNoExplanation((String)msg$21.apply());
    }

    private static Message featureWarning$$anonfun$1(String msg$22) {
        return Message$.MODULE$.toNoExplanation(msg$22);
    }

    private static Message featureWarning$$anonfun$2(String msg$23) {
        return Message$.MODULE$.toNoExplanation(msg$23);
    }

    private String log$$anonfun$1(Function0 msg$26) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[log ", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Contexts.Context)this).ctx().phasesStack().reverse().mkString(" -> "), msg$26.apply()}));
    }

    private static String elapsed$1(long start$45) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" in ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start$45))}));
    }

    private static String informTime$$anonfun$1(Function0 msg$27, long start$46) {
        return (String)msg$27.apply() + Reporting.elapsed$1(start$46);
    }

    private static String informProgress$$anonfun$1(Function0 msg$28) {
        return "[" + msg$28.apply() + "]";
    }

    private static String logWith$$anonfun$1(Function0 msg$29, Object value$2) {
        return (String)msg$29.apply() + " " + value$2;
    }

    private static Message debugwarn$$anonfun$1(Function0 msg$30) {
        return Message$.MODULE$.toNoExplanation((String)msg$30.apply());
    }
}

