/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.printing.Highlighting;
import dotty.tools.dotc.printing.Highlighting$Blue$;
import dotty.tools.dotc.printing.Highlighting$Red$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.diagnostic.ErrorMessageID;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.SourcePosition;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.StringBuilder$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JFunction2;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public interface MessageRendering {
    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    default public List<String> outer(SourcePosition pos, String prefix, Contexts.Context ctx) {
        Nil$ nil$;
        if (pos.outer().exists()) {
            String x$136 = "" + prefix + "| This location is in code that was inlined at " + pos.outer();
            nil$ = this.outer(pos.outer(), prefix, ctx).$colon$colon((Object)x$136);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    default public Tuple3<List<String>, List<String>, Object> sourceLines(SourcePosition pos, Contexts.Context ctx) {
        IntRef maxLen = IntRef.create((int)Integer.MIN_VALUE);
        Settings.Setting<String> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().color());
        String string = Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx);
        String string2 = "never";
        char[] syntax = (string == null ? string2 != null : !string.equals(string2)) ? (char[])SyntaxHighlighting$.MODULE$.apply((Iterable<Object>)Predef$.MODULE$.wrapCharArray(pos.linesSlice())).toArray(ClassTag$.MODULE$.apply(Character.TYPE)) : pos.linesSlice();
        List lines = MessageRendering.linesFrom$1(syntax);
        Tuple2<List<Object>, List<Object>> tuple2 = pos.beforeAndAfterPoint();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List before = (List)tuple2._1();
        List after = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)before, (Object)after);
        List before2 = (List)tuple22._1();
        List after2 = (List)tuple22._2();
        return Tuple3$.MODULE$.apply(((List)before2.zip((GenIterable)lines, List$.MODULE$.canBuildFrom())).map((Function1)((JFunction1)offsetAndLine -> MessageRendering.render$1(pos, ctx, maxLen, offsetAndLine)), List$.MODULE$.canBuildFrom()), ((List)after2.zip((GenIterable)lines.drop(before2.length()), List$.MODULE$.canBuildFrom())).map((Function1)((JFunction1)offsetAndLine -> MessageRendering.render$1(pos, ctx, maxLen, offsetAndLine)), List$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)maxLen.elem));
    }

    default public String columnMarker(SourcePosition pos, int offset, Contexts.Context ctx) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset - 1);
        String padding = pos.startColumnPadding();
        Highlighting.Red carets = Highlighting$Red$.MODULE$.apply(pos.startLine() == pos.endLine() ? new StringOps(Predef$.MODULE$.augmentString("^")).$times(scala.math.package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^");
        return "" + prefix + "|" + padding + carets.show(ctx);
    }

    default public String errorMsg(SourcePosition pos, String msg, int offset, Contexts.Context ctx) {
        String padding = (String)new StringOps(Predef$.MODULE$.augmentString(msg)).lines().foldLeft((Object)pos.startColumnPadding(), (Function2)((JFunction2)(pad, line) -> {
            int lineLength = this.stripColor((String)line).length();
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().pageWidth());
            int maxPad = scala.math.package$.MODULE$.max(0, BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx)) - offset - lineLength) - offset;
            return maxPad < pad.length() ? new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxPad) : pad;
        }));
        return new StringOps(Predef$.MODULE$.augmentString(msg)).lines().map((Function1)((JFunction1)line -> new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset - 1) + "|" + padding + line)).mkString((String)scala.sys.package$.MODULE$.props().apply((Object)"line.separator"));
    }

    default public String posStr(SourcePosition pos, String diagnosticLevel, Message message, Contexts.Context ctx) {
        String string;
        if (pos.exists()) {
            String string2;
            String file = "" + pos.source().file().toString() + ":" + (pos.line() + 1) + ":" + pos.column();
            if (message.errorId() != ErrorMessageID.NoExplanationID) {
                int errorNumber = message.errorId().errorNumber();
                string2 = "[E" + (new StringOps(Predef$.MODULE$.augmentString("0")).$times(3 - ((Object)BoxesRunTime.boxToInteger((int)errorNumber)).toString().length()) + errorNumber) + "] ";
            } else {
                string2 = "";
            }
            String errId = string2;
            String string3 = message.kind();
            String string4 = "";
            String kind = !(string3 != null ? !string3.equals(string4) : string4 != null) ? diagnosticLevel : "" + message.kind() + " " + diagnosticLevel;
            String prefix = "-- " + errId + kind + ": " + file + " ";
            Settings.Setting<Object> setting = Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().pageWidth());
            string = Highlighting$Blue$.MODULE$.apply(prefix + new StringOps(Predef$.MODULE$.augmentString("-")).$times(scala.math.package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(setting, ctx)) - this.stripColor(prefix).length(), 0))).show(ctx);
        } else {
            string = "";
        }
        return string;
    }

    default public String explanation(Message m, Contexts.Context ctx) {
        StringBuilder sb = new StringBuilder(Decorators$StringInterpolators$.MODULE$.hl$extension(Decorators$.MODULE$.StringInterpolators(StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n           |", "\n           |", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Highlighting$Blue$.MODULE$.apply("Explanation"), Highlighting$Blue$.MODULE$.apply("===========")}), ctx));
        sb.append('\n').append(m.explanation());
        Option option = new StringOps(Predef$.MODULE$.augmentString(m.explanation())).lastOption();
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        Object object = (option == null ? some != null : !option.equals(some)) ? sb.append('\n') : BoxedUnit.UNIT;
        return sb.toString();
    }

    default public String messageAndPos(Message msg, SourcePosition pos, String diagnosticLevel, Contexts.Context ctx) {
        StringBuilder stringBuilder;
        StringBuilder sb = StringBuilder$.MODULE$.newBuilder();
        String posString = this.posStr(pos, diagnosticLevel, msg, ctx);
        Object object = new StringOps(Predef$.MODULE$.augmentString(posString)).nonEmpty() ? sb.append(posString).append('\n') : BoxedUnit.UNIT;
        if (pos.exists()) {
            Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines(pos, ctx);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            List srcBefore = (List)tuple3._1();
            List srcAfter = (List)tuple3._2();
            int offset = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
            List srcBefore2 = (List)tuple32._1();
            List srcAfter2 = (List)tuple32._2();
            int offset2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            String marker = this.columnMarker(pos, offset2, ctx);
            String err = this.errorMsg(pos, msg.msg(), offset2, ctx);
            List<String> prefix$29 = this.outer(pos, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset2 - 1), ctx);
            stringBuilder = sb.append(srcAfter2.$colon$colon$colon(prefix$29).$colon$colon((Object)err).$colon$colon((Object)marker).$colon$colon$colon(srcBefore2).mkString("\n"));
        } else {
            stringBuilder = sb.append(msg.msg());
        }
        return sb.toString();
    }

    default public String diagnosticLevel(MessageContainer cont) {
        String string;
        MessageContainer messageContainer = cont;
        if (messageContainer instanceof messages.Error) {
            messages.Error error;
            messages.Error m = error = (messages.Error)messageContainer;
            string = "Error";
        } else if (messageContainer instanceof messages.FeatureWarning) {
            messages.FeatureWarning featureWarning;
            messages.FeatureWarning m = featureWarning = (messages.FeatureWarning)messageContainer;
            string = "Feature Warning";
        } else if (messageContainer instanceof messages.DeprecationWarning) {
            messages.DeprecationWarning deprecationWarning;
            messages.DeprecationWarning m = deprecationWarning = (messages.DeprecationWarning)messageContainer;
            string = "Deprecation Warning";
        } else if (messageContainer instanceof messages.UncheckedWarning) {
            messages.UncheckedWarning uncheckedWarning;
            messages.UncheckedWarning m = uncheckedWarning = (messages.UncheckedWarning)messageContainer;
            string = "Unchecked Warning";
        } else if (messageContainer instanceof messages.MigrationWarning) {
            messages.MigrationWarning migrationWarning;
            messages.MigrationWarning m = migrationWarning = (messages.MigrationWarning)messageContainer;
            string = "Migration Warning";
        } else if (messageContainer instanceof messages.Warning) {
            messages.Warning warning;
            messages.Warning m = warning = (messages.Warning)messageContainer;
            string = "Warning";
        } else if (messageContainer instanceof messages.Info) {
            messages.Info info;
            messages.Info m = info = (messages.Info)messageContainer;
            string = "Info";
        } else {
            throw new MatchError((Object)messageContainer);
        }
        return string;
    }

    private static String render$1(SourcePosition pos$22, Contexts.Context ctx$977, IntRef maxLen$2, Tuple2 offsetAndLine) {
        int n;
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int offset = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String line = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset), (Object)line);
        int offset2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String line2 = (String)tuple22._2();
        int lineNbr = pos$22.source().offsetToLine(offset2);
        String prefix = "" + (lineNbr + 1) + " |";
        maxLen$2.elem = n = scala.math.package$.MODULE$.max(maxLen$2.elem, prefix.length());
        String lnum = Highlighting$Red$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(scala.math.package$.MODULE$.max(0, maxLen$2.elem - prefix.length())) + prefix).show(ctx$977);
        return lnum + new StringOps(Predef$.MODULE$.augmentString(line2)).stripLineEnd();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean pred$1(char c) {
        char c2 = c;
        switch (c2) {
            case '\n': {
                return true;
            }
            case '\r': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\u001a': {
                return true;
            }
            default: {
                return false;
            }
        }
    }

    private static /* synthetic */ boolean $anonfun$2(char _$587) {
        return !MessageRendering.pred$1(_$587);
    }

    private static boolean $anonfun$adapted$1(Object _$587) {
        return MessageRendering.$anonfun$2(BoxesRunTime.unboxToChar((Object)_$587));
    }

    private static boolean $anonfun$adapted$2(Object c) {
        return MessageRendering.pred$1(BoxesRunTime.unboxToChar((Object)c));
    }

    private static List linesFrom$1(char[] arr) {
        Tuple2 tuple2 = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(arr)).span((Function1)((JFunction1)MessageRendering::$anonfun$adapted$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char[] line = (char[])tuple2._1();
        char[] rest0 = (char[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)line, (Object)rest0);
        char[] line2 = (char[])tuple22._1();
        char[] rest02 = (char[])tuple22._2();
        Tuple2 tuple23 = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(rest02)).span((Function1)((JFunction1)MessageRendering::$anonfun$adapted$2));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        char[] rest = (char[])tuple23._2();
        char[] rest2 = rest;
        String x$137 = new String(line2);
        return (new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(rest2)).isEmpty() ? package$.MODULE$.Nil() : MessageRendering.linesFrom$1(rest2)).$colon$colon((Object)x$137);
    }
}

