/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.DottyPredef$;
import dotty.tools.dotc.util.HashSet$;
import dotty.tools.dotc.util.Set;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JProcedure1;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public class HashSet<T>
extends Set<T> {
    private final int powerOfTwoInitialCapacity;
    private final float loadFactor;
    private int used;
    private int limit;
    public Object[] dotty$tools$dotc$util$HashSet$$table;
    private int accesses;
    private int misses;
    private int rover;

    public static float $lessinit$greater$default$2() {
        return HashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public <T> HashSet(int powerOfTwoInitialCapacity, float loadFactor) {
        boolean assertion;
        this.powerOfTwoInitialCapacity = powerOfTwoInitialCapacity;
        this.loadFactor = loadFactor;
        boolean bl = assertion = Integer.bitCount(powerOfTwoInitialCapacity) == 1;
        if (!assertion) {
            DottyPredef$.MODULE$.assertFail();
        }
        this.accesses = 0;
        this.misses = 0;
        this.clear();
        this.rover = -1;
    }

    public boolean isEqual(T x, T y) {
        return x.equals(y);
    }

    public int accesses() {
        return this.accesses;
    }

    public void accesses_$eq(int x$1) {
        this.accesses = x$1;
    }

    public int misses() {
        return this.misses;
    }

    public void misses_$eq(int x$1) {
        this.misses = x$1;
    }

    public int size() {
        return this.used;
    }

    private void allocate(int size) {
        this.dotty$tools$dotc$util$HashSet$$table = new Object[size];
        this.limit = (int)((float)size * this.loadFactor);
    }

    @Override
    public void clear() {
        this.used = 0;
        this.allocate(this.powerOfTwoInitialCapacity);
    }

    private int index(int x) {
        return x & this.dotty$tools$dotc$util$HashSet$$table.length - 1;
    }

    public int hash(T x) {
        return x.hashCode();
    }

    private T entryAt(int idx) {
        return (T)this.dotty$tools$dotc$util$HashSet$$table[idx];
    }

    public T findEntryOrUpdate(T x) {
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null) {
            if (this.isEqual(x, entry)) {
                return entry;
            }
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        return this.addEntryAt(h, x);
    }

    private T addEntryAt(int idx, T x) {
        block0: {
            this.dotty$tools$dotc$util$HashSet$$table[idx] = x;
            ++this.used;
            if (this.used <= this.limit) break block0;
            this.growTable();
        }
        return x;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T findEntry(T x) {
        void var3_3;
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null && !this.isEqual(x, entry)) {
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        return var3_3;
    }

    @Override
    public void addEntry(T x) {
        block2: {
            int h = this.index(this.hash(x));
            T entry = this.entryAt(h);
            while (entry != null) {
                if (this.isEqual(x, entry)) {
                    return;
                }
                h = this.index(h + 1);
                entry = this.entryAt(h);
            }
            this.dotty$tools$dotc$util$HashSet$$table[h] = x;
            ++this.used;
            if (this.used <= this.dotty$tools$dotc$util$HashSet$$table.length >> 2) break block2;
            this.growTable();
        }
    }

    public void addEntries(TraversableOnce<T> xs) {
        xs.foreach((Function1)((JProcedure1)x -> this.addEntry(x)));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator(this){
            private int i;
            private final HashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public List reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1 p) {
                return TraversableOnce.count$((TraversableOnce)this, (Function1)p);
            }

            public Option collectFirst(PartialFunction pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, (PartialFunction)pf);
            }

            public Object $div$colon(Object z, Function2 op) {
                return TraversableOnce.$div$colon$((TraversableOnce)this, (Object)z, (Function2)op);
            }

            public Object $colon$bslash(Object z, Function2 op) {
                return TraversableOnce.$colon$bslash$((TraversableOnce)this, (Object)z, (Function2)op);
            }

            public Object foldLeft(Object z, Function2 op) {
                return TraversableOnce.foldLeft$((TraversableOnce)this, (Object)z, (Function2)op);
            }

            public Object foldRight(Object z, Function2 op) {
                return TraversableOnce.foldRight$((TraversableOnce)this, (Object)z, (Function2)op);
            }

            public Object reduceLeft(Function2 op) {
                return TraversableOnce.reduceLeft$((TraversableOnce)this, (Function2)op);
            }

            public Object reduceRight(Function2 op) {
                return TraversableOnce.reduceRight$((TraversableOnce)this, (Function2)op);
            }

            public Option reduceLeftOption(Function2 op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, (Function2)op);
            }

            public Option reduceRightOption(Function2 op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, (Function2)op);
            }

            public Object reduce(Function2 op) {
                return TraversableOnce.reduce$((TraversableOnce)this, (Function2)op);
            }

            public Option reduceOption(Function2 op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, (Function2)op);
            }

            public Object fold(Object z, Function2 op) {
                return TraversableOnce.fold$((TraversableOnce)this, (Object)z, (Function2)op);
            }

            public Object aggregate(Function0 z, Function2 seqop, Function2 combop) {
                return TraversableOnce.aggregate$((TraversableOnce)this, (Function0)z, (Function2)seqop, (Function2)combop);
            }

            public Object sum(Numeric num) {
                return TraversableOnce.sum$((TraversableOnce)this, (Numeric)num);
            }

            public Object product(Numeric num) {
                return TraversableOnce.product$((TraversableOnce)this, (Numeric)num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public void copyToBuffer(Buffer dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, (Buffer)dest);
            }

            public void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public Object toArray(ClassTag evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, (ClassTag)evidence$1);
            }

            public List toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public Buffer toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public scala.collection.immutable.Set toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public Object to(CanBuildFrom cbf) {
                return TraversableOnce.to$((TraversableOnce)this, (CanBuildFrom)cbf);
            }

            public Map toMap(Predef.$less$colon$less ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, (Predef.$less$colon$less)ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public Iterator seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public Iterator map(Function1 f) {
                return Iterator.map$((Iterator)this, (Function1)f);
            }

            public Iterator $plus$plus(Function0 that) {
                return Iterator.$plus$plus$((Iterator)this, (Function0)that);
            }

            public Iterator flatMap(Function1 f) {
                return Iterator.flatMap$((Iterator)this, (Function1)f);
            }

            public Iterator filter(Function1 p) {
                return Iterator.filter$((Iterator)this, (Function1)p);
            }

            public boolean corresponds(GenTraversableOnce that, Function2 p) {
                return Iterator.corresponds$((Iterator)this, (GenTraversableOnce)that, (Function2)p);
            }

            public Iterator withFilter(Function1 p) {
                return Iterator.withFilter$((Iterator)this, (Function1)p);
            }

            public Iterator filterNot(Function1 p) {
                return Iterator.filterNot$((Iterator)this, (Function1)p);
            }

            public Iterator collect(PartialFunction pf) {
                return Iterator.collect$((Iterator)this, (PartialFunction)pf);
            }

            public Iterator scanLeft(Object z, Function2 op) {
                return Iterator.scanLeft$((Iterator)this, (Object)z, (Function2)op);
            }

            public Iterator scanRight(Object z, Function2 op) {
                return Iterator.scanRight$((Iterator)this, (Object)z, (Function2)op);
            }

            public Iterator takeWhile(Function1 p) {
                return Iterator.takeWhile$((Iterator)this, (Function1)p);
            }

            public Tuple2 partition(Function1 p) {
                return Iterator.partition$((Iterator)this, (Function1)p);
            }

            public Tuple2 span(Function1 p) {
                return Iterator.span$((Iterator)this, (Function1)p);
            }

            public Iterator dropWhile(Function1 p) {
                return Iterator.dropWhile$((Iterator)this, (Function1)p);
            }

            public Iterator zip(Iterator that) {
                return Iterator.zip$((Iterator)this, (Iterator)that);
            }

            public Iterator padTo(int len, Object elem) {
                return Iterator.padTo$((Iterator)this, (int)len, (Object)elem);
            }

            public Iterator zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public Iterator zipAll(Iterator that, Object thisElem, Object thatElem) {
                return Iterator.zipAll$((Iterator)this, (Iterator)that, (Object)thisElem, (Object)thatElem);
            }

            public void foreach(Function1 f) {
                Iterator.foreach$((Iterator)this, (Function1)f);
            }

            public boolean forall(Function1 p) {
                return Iterator.forall$((Iterator)this, (Function1)p);
            }

            public boolean exists(Function1 p) {
                return Iterator.exists$((Iterator)this, (Function1)p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option find(Function1 p) {
                return Iterator.find$((Iterator)this, (Function1)p);
            }

            public int indexWhere(Function1 p) {
                return Iterator.indexWhere$((Iterator)this, (Function1)p);
            }

            public int indexWhere(Function1 p, int from) {
                return Iterator.indexWhere$((Iterator)this, (Function1)p, (int)from);
            }

            public int indexOf(Object elem) {
                return Iterator.indexOf$((Iterator)this, (Object)elem);
            }

            public int indexOf(Object elem, int from) {
                return Iterator.indexOf$((Iterator)this, (Object)elem, (int)from);
            }

            public BufferedIterator buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public Iterator.GroupedIterator grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public Iterator.GroupedIterator sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2 duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public Iterator patch(int from, Iterator patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, (Iterator)patchElems, (int)replaced);
            }

            public void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator that) {
                return Iterator.sameElements$((Iterator)this, (Iterator)that);
            }

            public Traversable toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public boolean hasNext() {
                while (this.i < this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table.length && this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table[this.i] == null) {
                    ++this.i;
                }
                return this.i < this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table.length;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    ++this.i;
                    object = this.dotty$tools$dotc$util$HashSet$_$$anon$$$outer().dotty$tools$dotc$util$HashSet$$table[this.i - 1];
                } else {
                    object = null;
                }
                return object;
            }

            private HashSet $outer() {
                return this.$outer;
            }

            public final HashSet dotty$tools$dotc$util$HashSet$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    public T findEntryByHash(int hashCode) {
        this.rover = this.index(hashCode);
        return this.nextEntryByHash(hashCode);
    }

    public T nextEntryByHash(int hashCode) {
        Object entry = this.dotty$tools$dotc$util$HashSet$$table[this.rover];
        while (entry != null) {
            this.rover = this.index(this.rover + 1);
            if (this.hash(entry) == hashCode) {
                return (T)entry;
            }
            entry = this.dotty$tools$dotc$util$HashSet$$table[this.rover];
        }
        return null;
    }

    public T addEntryAfterScan(T x) {
        return this.addEntryAt(this.rover, x);
    }

    private void addOldEntry(T x) {
        int h = this.index(this.hash(x));
        T entry = this.entryAt(h);
        while (entry != null) {
            h = this.index(h + 1);
            entry = this.entryAt(h);
        }
        this.dotty$tools$dotc$util$HashSet$$table[h] = x;
    }

    private void growTable() {
        Object[] oldtable = this.dotty$tools$dotc$util$HashSet$$table;
        this.allocate(this.dotty$tools$dotc$util$HashSet$$table.length * 2);
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            this.addOldEntry(entry);
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("HashSet(%d / %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.used), BoxesRunTime.boxToInteger((int)this.dotty$tools$dotc$util$HashSet$$table.length)}));
    }
}

