/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dottydoc.model.comment;

import com.vladsch.flexmark.ast.Node;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dottydoc.model.Entity;
import dotty.tools.dottydoc.model.Members;
import dotty.tools.dottydoc.model.comment.Body;
import dotty.tools.dottydoc.model.comment.Bold;
import dotty.tools.dottydoc.model.comment.Bold$;
import dotty.tools.dottydoc.model.comment.Chain;
import dotty.tools.dottydoc.model.comment.Chain$;
import dotty.tools.dottydoc.model.comment.EntityLink;
import dotty.tools.dottydoc.model.comment.EntityLink$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$BodyToHtml$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$InlineToHtml$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$MarkdownToHtml$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$StringToMarkdown$;
import dotty.tools.dottydoc.model.comment.HtmlParsers$StringToWiki$;
import dotty.tools.dottydoc.model.comment.HtmlTag;
import dotty.tools.dottydoc.model.comment.HtmlTag$;
import dotty.tools.dottydoc.model.comment.Inline;
import dotty.tools.dottydoc.model.comment.Italic;
import dotty.tools.dottydoc.model.comment.Italic$;
import dotty.tools.dottydoc.model.comment.Link;
import dotty.tools.dottydoc.model.comment.Link$;
import dotty.tools.dottydoc.model.comment.LinkTo;
import dotty.tools.dottydoc.model.comment.LinkToEntity;
import dotty.tools.dottydoc.model.comment.LinkToEntity$;
import dotty.tools.dottydoc.model.comment.LinkToExternal;
import dotty.tools.dottydoc.model.comment.LinkToExternal$;
import dotty.tools.dottydoc.model.comment.Monospace;
import dotty.tools.dottydoc.model.comment.Monospace$;
import dotty.tools.dottydoc.model.comment.Subscript;
import dotty.tools.dottydoc.model.comment.Subscript$;
import dotty.tools.dottydoc.model.comment.Summary;
import dotty.tools.dottydoc.model.comment.Summary$;
import dotty.tools.dottydoc.model.comment.Superscript;
import dotty.tools.dottydoc.model.comment.Superscript$;
import dotty.tools.dottydoc.model.comment.Text;
import dotty.tools.dottydoc.model.comment.Text$;
import dotty.tools.dottydoc.model.comment.Tooltip;
import dotty.tools.dottydoc.model.comment.Tooltip$;
import dotty.tools.dottydoc.model.comment.Underline;
import dotty.tools.dottydoc.model.comment.Underline$;
import dotty.tools.dottydoc.util.traversing$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class HtmlParsers {
    public static Node MarkdownToHtml(Node node) {
        return HtmlParsers$.MODULE$.MarkdownToHtml(node);
    }

    public static Body BodyToHtml(Body body) {
        return HtmlParsers$.MODULE$.BodyToHtml(body);
    }

    public static String StringToMarkdown(String string) {
        return HtmlParsers$.MODULE$.StringToMarkdown(string);
    }

    public static String StringToWiki(String string) {
        return HtmlParsers$.MODULE$.StringToWiki(string);
    }

    public static final class BodyToHtml {
        private final Body body;

        public static String show$extension(Body body, Entity entity) {
            return HtmlParsers$BodyToHtml$.MODULE$.show$extension(body, entity);
        }

        public static boolean equals$extension(Body body, Object object) {
            return HtmlParsers$BodyToHtml$.MODULE$.equals$extension(body, object);
        }

        public static int hashCode$extension(Body body) {
            return HtmlParsers$BodyToHtml$.MODULE$.hashCode$extension(body);
        }

        public BodyToHtml(Body body) {
            this.body = body;
        }

        public Body body() {
            return this.body;
        }

        public String show(Entity origin) {
            return HtmlParsers$BodyToHtml$.MODULE$.show$extension(this.body(), origin);
        }

        public int hashCode() {
            return HtmlParsers$BodyToHtml$.MODULE$.hashCode$extension(this.body());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$BodyToHtml$.MODULE$.equals$extension(this.body(), x$0);
        }
    }

    public static class InlineToHtml
    implements Product {
        private final Entity origin;

        public static InlineToHtml unapply(InlineToHtml inlineToHtml) {
            return HtmlParsers$InlineToHtml$.MODULE$.unapply(inlineToHtml);
        }

        public static Function1 andThen(Function1 function1) {
            return HtmlParsers$InlineToHtml$.MODULE$.andThen(function1);
        }

        public static Function1 compose(Function1 function1) {
            return HtmlParsers$InlineToHtml$.MODULE$.compose(function1);
        }

        public InlineToHtml(Entity origin) {
            this.origin = origin;
            Product.class.$init$((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Entity origin() {
            return this.origin;
        }

        public String apply(Inline inl) {
            return this.toHtml(inl);
        }

        public String relativePath(Entity target) {
            return traversing$.MODULE$.relativePath(this.origin(), target);
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toHtml(Inline inl) {
            String string;
            Inline inline = inl;
            if (inline instanceof Chain) {
                Chain chain = (Chain)inline;
                if (Chain$.MODULE$.unapply((Chain)inline) != null) {
                    Chain chain2 = Chain$.MODULE$.unapply((Chain)inline);
                    Seq items = chain2._1();
                    string = ((TraversableOnce)items.map((Function1)((JFunction1)this::toHtml$$anonfun$1), Seq$.MODULE$.canBuildFrom())).mkString();
                    return string;
                }
            }
            if (inline instanceof Italic) {
                Italic italic = (Italic)inline;
                if (Italic$.MODULE$.unapply((Italic)inline) != null) {
                    Italic italic2 = Italic$.MODULE$.unapply((Italic)inline);
                    Inline in = italic2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<i>", "</i>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Bold) {
                Bold bold = (Bold)inline;
                if (Bold$.MODULE$.unapply((Bold)inline) != null) {
                    Bold bold2 = Bold$.MODULE$.unapply((Bold)inline);
                    Inline in = bold2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<b>", "</b>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Underline) {
                Underline underline = (Underline)inline;
                if (Underline$.MODULE$.unapply((Underline)inline) != null) {
                    Underline underline2 = Underline$.MODULE$.unapply((Underline)inline);
                    Inline in = underline2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<u>", "</u>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Superscript) {
                Superscript superscript = (Superscript)inline;
                if (Superscript$.MODULE$.unapply((Superscript)inline) != null) {
                    Superscript superscript2 = Superscript$.MODULE$.unapply((Superscript)inline);
                    Inline in = superscript2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<sup>", "</sup>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Subscript) {
                Subscript subscript = (Subscript)inline;
                if (Subscript$.MODULE$.unapply((Subscript)inline) != null) {
                    Subscript subscript2 = Subscript$.MODULE$.unapply((Subscript)inline);
                    Inline in = subscript2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<sub>", "</sub>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Link) {
                Link link = (Link)inline;
                if (Link$.MODULE$.unapply((Link)inline) != null) {
                    Link link2 = Link$.MODULE$.unapply((Link)inline);
                    String raw = link2._1();
                    Inline title = link2._2();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=", " target=\"_blank\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{raw, this.toHtml(title)}));
                    return string;
                }
            }
            if (inline instanceof Monospace) {
                Monospace monospace = (Monospace)inline;
                if (Monospace$.MODULE$.unapply((Monospace)inline) != null) {
                    Monospace monospace2 = Monospace$.MODULE$.unapply((Monospace)inline);
                    Inline in = monospace2._1();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<code>", "</code>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toHtml(in)}));
                    return string;
                }
            }
            if (inline instanceof Text) {
                Text text = (Text)inline;
                if (Text$.MODULE$.unapply((Text)inline) != null) {
                    String text2;
                    Text text3 = Text$.MODULE$.unapply((Text)inline);
                    string = text2 = text3._1();
                    return string;
                }
            }
            if (inline instanceof Summary) {
                Summary summary = (Summary)inline;
                if (Summary$.MODULE$.unapply((Summary)inline) != null) {
                    Summary summary2 = Summary$.MODULE$.unapply((Summary)inline);
                    Inline in = summary2._1();
                    string = this.toHtml(in);
                    return string;
                }
            }
            if (inline instanceof HtmlTag) {
                HtmlTag htmlTag = (HtmlTag)inline;
                if (HtmlTag$.MODULE$.unapply((HtmlTag)inline) != null) {
                    String tag;
                    HtmlTag htmlTag2 = HtmlTag$.MODULE$.unapply((HtmlTag)inline);
                    string = tag = htmlTag2._1();
                    return string;
                }
            }
            if (!(inline instanceof EntityLink)) {
                throw new MatchError((Object)inline);
            }
            EntityLink entityLink = (EntityLink)inline;
            Some some = EntityLink$.MODULE$.unapply((EntityLink)inline);
            if (some.isEmpty()) throw new MatchError((Object)inline);
            Tuple2 tuple2 = (Tuple2)some.get();
            Inline target = (Inline)tuple2._1();
            LinkTo link = (LinkTo)tuple2._2();
            string = this.enityLinkToHtml(target, link);
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String enityLinkToHtml(Inline target, LinkTo link) {
            String string;
            LinkTo linkTo = link;
            if (linkTo instanceof Tooltip) {
                Tooltip tooltip = (Tooltip)linkTo;
                if (Tooltip$.MODULE$.unapply((Tooltip)linkTo) != null) {
                    Tooltip tooltip2 = Tooltip$.MODULE$.unapply((Tooltip)linkTo);
                    String string2 = tooltip2._1();
                    string = this.toHtml(target);
                    return string;
                }
            }
            if (linkTo instanceof LinkToExternal) {
                LinkToExternal linkToExternal = (LinkToExternal)linkTo;
                if (LinkToExternal$.MODULE$.unapply((LinkToExternal)linkTo) != null) {
                    LinkToExternal linkToExternal2 = LinkToExternal$.MODULE$.unapply((LinkToExternal)linkTo);
                    String n = linkToExternal2._1();
                    String url = linkToExternal2._2();
                    string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, n}));
                    return string;
                }
            }
            if (!(linkTo instanceof LinkToEntity)) {
                throw new MatchError((Object)linkTo);
            }
            LinkToEntity linkToEntity = (LinkToEntity)linkTo;
            if (LinkToEntity$.MODULE$.unapply((LinkToEntity)linkTo) == null) {
                throw new MatchError((Object)linkTo);
            }
            LinkToEntity linkToEntity2 = LinkToEntity$.MODULE$.unapply((LinkToEntity)linkTo);
            Entity entity = linkToEntity2._1();
            if (entity == null) {
                throw new MatchError((Object)linkTo);
            }
            Entity t = entity;
            Entity entity2 = t;
            if (!(entity2 instanceof Members)) {
                Entity x = entity2;
                string = (String)x.parent().fold(this.toHtml(target), (Function1)((JFunction1)arg_0 -> this.enityLinkToHtml$$anonfun$1(target, x, arg_0)));
                return string;
            }
            Entity e = entity2;
            string = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relativePath(t), this.toHtml(target)}));
            return string;
        }

        public InlineToHtml copy(Entity origin) {
            return new InlineToHtml(origin);
        }

        public Entity copy$default$1() {
            return this.origin();
        }

        public Entity _1() {
            return this.origin();
        }

        public int hashCode() {
            int n = 1350500173;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.origin()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof InlineToHtml) {
                InlineToHtml inlineToHtml = (InlineToHtml)object;
                Entity entity = this.origin();
                Entity entity2 = inlineToHtml.origin();
                if (entity == null) {
                    if (entity2 == null) return true;
                    return false;
                } else if (entity.equals(entity2)) return true;
                return false;
            }
            if (object instanceof Object) return false;
            throw new MatchError(object);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InlineToHtml;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InlineToHtml";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
            }
            return this._1();
        }

        private String toHtml$$anonfun$1(Inline inl) {
            return this.toHtml(inl);
        }

        private String enityLinkToHtml$$anonfun$1(Inline target$1, Entity x$1, Entity xpar) {
            return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "#", "\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relativePath(xpar), x$1.name(), this.toHtml(target$1)}));
        }
    }

    public static final class MarkdownToHtml {
        private final Node markdown;

        public static String show$extension(Node node, Contexts.Context context) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.show$extension(node, context);
        }

        public static boolean equals$extension(Node node, Object object) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.equals$extension(node, object);
        }

        public static int hashCode$extension(Node node) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.hashCode$extension(node);
        }

        public static String shortenAndShow$extension(Node node, Contexts.Context context) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.shortenAndShow$extension(node, context);
        }

        public MarkdownToHtml(Node markdown) {
            this.markdown = markdown;
        }

        public Node markdown() {
            return this.markdown;
        }

        public String show(Contexts.Context ctx) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.show$extension(this.markdown(), ctx);
        }

        public String shortenAndShow(Contexts.Context ctx) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.shortenAndShow$extension(this.markdown(), ctx);
        }

        public int hashCode() {
            return HtmlParsers$MarkdownToHtml$.MODULE$.hashCode$extension(this.markdown());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.equals$extension(this.markdown(), x$0);
        }
    }

    public static final class StringToMarkdown {
        private final String text;

        public static Node toMarkdown$extension(String string, Entity entity, Contexts.Context context) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdown$extension(string, entity, context);
        }

        public static boolean equals$extension(String string, Object object) {
            return HtmlParsers$StringToMarkdown$.MODULE$.equals$extension(string, object);
        }

        public static String toMarkdownString$extension(String string, Entity entity, Contexts.Context context) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdownString$extension(string, entity, context);
        }

        public static int hashCode$extension(String string) {
            return HtmlParsers$StringToMarkdown$.MODULE$.hashCode$extension(string);
        }

        public StringToMarkdown(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }

        public Node toMarkdown(Entity origin, Contexts.Context ctx) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdown$extension(this.text(), origin, ctx);
        }

        public String toMarkdownString(Entity origin, Contexts.Context ctx) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdownString$extension(this.text(), origin, ctx);
        }

        public int hashCode() {
            return HtmlParsers$StringToMarkdown$.MODULE$.hashCode$extension(this.text());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$StringToMarkdown$.MODULE$.equals$extension(this.text(), x$0);
        }
    }

    public static final class StringToWiki {
        private final String text;

        public static boolean equals$extension(String string, Object object) {
            return HtmlParsers$StringToWiki$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return HtmlParsers$StringToWiki$.MODULE$.hashCode$extension(string);
        }

        public static Body toWiki$extension(String string, Entity entity, Map map, long l) {
            return HtmlParsers$StringToWiki$.MODULE$.toWiki$extension(string, entity, map, l);
        }

        public StringToWiki(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }

        public Body toWiki(Entity origin, Map packages, long pos) {
            return HtmlParsers$StringToWiki$.MODULE$.toWiki$extension(this.text(), origin, packages, pos);
        }

        public int hashCode() {
            return HtmlParsers$StringToWiki$.MODULE$.hashCode$extension(this.text());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$StringToWiki$.MODULE$.equals$extension(this.text(), x$0);
        }
    }
}

