/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dottydoc.model.comment;

import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.util.Positions;
import dotty.tools.dottydoc.model.Entity;
import dotty.tools.dottydoc.model.comment.Block;
import dotty.tools.dottydoc.model.comment.Body;
import dotty.tools.dottydoc.model.comment.Body$;
import dotty.tools.dottydoc.model.comment.Bold$;
import dotty.tools.dottydoc.model.comment.Chain$;
import dotty.tools.dottydoc.model.comment.CharReader;
import dotty.tools.dottydoc.model.comment.Code$;
import dotty.tools.dottydoc.model.comment.HorizontalRule$;
import dotty.tools.dottydoc.model.comment.HtmlTag;
import dotty.tools.dottydoc.model.comment.HtmlTag$;
import dotty.tools.dottydoc.model.comment.Inline;
import dotty.tools.dottydoc.model.comment.Italic$;
import dotty.tools.dottydoc.model.comment.Link$;
import dotty.tools.dottydoc.model.comment.Monospace$;
import dotty.tools.dottydoc.model.comment.OrderedList$;
import dotty.tools.dottydoc.model.comment.Paragraph;
import dotty.tools.dottydoc.model.comment.Paragraph$;
import dotty.tools.dottydoc.model.comment.Regexes$;
import dotty.tools.dottydoc.model.comment.Subscript$;
import dotty.tools.dottydoc.model.comment.Summary$;
import dotty.tools.dottydoc.model.comment.Superscript$;
import dotty.tools.dottydoc.model.comment.Text;
import dotty.tools.dottydoc.model.comment.Text$;
import dotty.tools.dottydoc.model.comment.Title$;
import dotty.tools.dottydoc.model.comment.Underline$;
import dotty.tools.dottydoc.model.comment.UnorderedList$;
import dotty.tools.dottydoc.util.MemberLookup;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class WikiParser
extends CharReader
implements MemberLookup {
    private final Entity entity;
    private final Map packages;
    private final String buffer;
    private final long pos;
    private boolean summaryParsed;
    private final Map listStyles;
    private final Regex OPEN_TAG;
    private final Regex CLOSE_TAG;

    public WikiParser(Entity entity, Map packages, String buffer, long pos, Symbols.Symbol site) {
        this.entity = entity;
        this.packages = packages;
        this.buffer = buffer;
        this.pos = pos;
        super(buffer);
        this.summaryParsed = false;
        Object[] objectArray = new Tuple2[6];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"- ");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, WikiParser::$init$$$anonfun$3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"1. ");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, WikiParser::$init$$$anonfun$6);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"I. ");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object3, WikiParser::$init$$$anonfun$2);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"i. ");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object4, WikiParser::$init$$$anonfun$4);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)"A. ");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object5, WikiParser::$init$$$anonfun$5);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"a. ");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object6, WikiParser::$init$$$anonfun$1);
        this.listStyles = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray));
        this.OPEN_TAG = new StringOps(Predef$.MODULE$.augmentString("^<([A-Za-z]+)( [^>]*)?(/?)>$")).r();
        this.CLOSE_TAG = new StringOps(Predef$.MODULE$.augmentString("^</([A-Za-z]+)>$")).r();
    }

    public String buffer() {
        return this.buffer;
    }

    public boolean summaryParsed() {
        return this.summaryParsed;
    }

    public void summaryParsed_$eq(boolean x$1) {
        this.summaryParsed = x$1;
    }

    public Body document() {
        ListBuffer blocks = new ListBuffer();
        while (this.char() != Regexes$.MODULE$.endOfText()) {
            blocks.$plus$eq((Object)this.block());
        }
        return Body$.MODULE$.apply((Seq)blocks.toList());
    }

    public Block block() {
        return this.checkSkipInitWhitespace("{{{") ? this.code() : (this.checkSkipInitWhitespace('=') ? this.title() : (this.checkSkipInitWhitespace("----") ? this.hrule() : (this.checkList() ? this.listBlock() : this.para())));
    }

    public Map listStyles() {
        return this.listStyles;
    }

    public boolean checkList() {
        return this.countWhitespace() > 0 && this.listStyles().keys().exists((Function1)((JFunction1)this::checkList$$anonfun$1));
    }

    public Block listBlock() {
        int indent = this.countWhitespace();
        String style = (String)this.listStyles().keys().find((Function1)((JFunction1)this::$anonfun$106)).getOrElse(this::$anonfun$97);
        return this.listLevel$1(indent, style);
    }

    public Block code() {
        Boolean bl;
        this.jumpWhitespace();
        this.jump("{{{");
        String str = this.readUntil("}}}");
        if (this.char() == Regexes$.MODULE$.endOfText()) {
            this.reportError(this.pos, "unclosed code block");
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)this.jump("}}}"));
        }
        this.blockEnded("code block");
        return Code$.MODULE$.apply(this.normalizeIndentation(str));
    }

    public Block title() {
        this.jumpWhitespace();
        int inLevel = this.repeatJump('=', this.repeatJump$default$2());
        Inline text = this.getInline((Function0)((JFunction0.mcZ.sp)() -> this.$anonfun$113(inLevel)));
        int outLevel = this.repeatJump('=', inLevel);
        if (inLevel != outLevel) {
            this.reportError(this.pos, "unbalanced or unclosed heading");
        }
        this.blockEnded("heading");
        return Title$.MODULE$.apply(text, inLevel);
    }

    public Block hrule() {
        this.jumpWhitespace();
        this.repeatJump('-', this.repeatJump$default$2());
        this.blockEnded("horizontal rule");
        return HorizontalRule$.MODULE$.apply();
    }

    /*
     * WARNING - void declaration
     */
    public Block para() {
        void var1_3;
        Paragraph paragraph;
        if (this.summaryParsed()) {
            paragraph = Paragraph$.MODULE$.apply(this.getInline((Function0)((JFunction0.mcZ.sp)WikiParser::$anonfun$115)));
        } else {
            Inline s = this.summary();
            List r = this.checkParaEnded() ? package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Inline[]{s})) : package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Inline[]{s, this.getInline((Function0)((JFunction0.mcZ.sp)WikiParser::$anonfun$109))}));
            this.summaryParsed_$eq(true);
            paragraph = Paragraph$.MODULE$.apply(Chain$.MODULE$.apply((Seq)r));
        }
        Paragraph p = paragraph;
        while (this.char() == Regexes$.MODULE$.endOfLine() && this.char() != Regexes$.MODULE$.endOfText()) {
            this.nextChar();
        }
        return var1_3;
    }

    public Regex OPEN_TAG() {
        return this.OPEN_TAG;
    }

    public Regex CLOSE_TAG() {
        return this.CLOSE_TAG;
    }

    private String readHTMLFrom(HtmlTag begin) {
        List list;
        ListBuffer stack;
        ListBuffer list2;
        block9: {
            block8: {
                HtmlTag htmlTag;
                HtmlTag htmlTag2;
                list2 = (ListBuffer)ListBuffer$.MODULE$.empty();
                stack = (ListBuffer)ListBuffer$.MODULE$.empty();
                Option option = begin.close();
                if (!(option instanceof Some)) break block8;
                Some some = (Some)option;
                Option option2 = Some$.MODULE$.unapply((Some)option);
                if (option2.isEmpty() || HtmlTag$.MODULE$.unapply(htmlTag2 = (htmlTag = (HtmlTag)option2.get())) == null) break block8;
                HtmlTag htmlTag3 = HtmlTag$.MODULE$.unapply(htmlTag2);
                String string = htmlTag3._1();
                Option option3 = this.CLOSE_TAG().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && (list = (List)option3.get()) != null && list.lengthCompare(1) == 0) break block9;
            }
            return "";
        }
        String s = (String)list.head();
        stack.$plus$eq((Object)s);
        do {
            List list3;
            Object object;
            List list4;
            String str = this.readUntil((Function0)((JFunction0.mcZ.sp)this::$anonfun$96));
            this.nextChar();
            list2.$plus$eq((Object)str);
            String string = str;
            Option option = this.OPEN_TAG().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list4 = (List)option.get()) != null && list4.lengthCompare(3) == 0) {
                String s2 = (String)list4.head();
                String standalone = (String)list4.apply(2);
                String string2 = (String)list4.apply(1);
                String string3 = standalone;
                String string4 = "/";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    object = stack.$plus$eq((Object)s2);
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            Option option4 = this.CLOSE_TAG().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && (list3 = (List)option4.get()) != null && list3.lengthCompare(1) == 0) {
                String s3;
                String string5 = s3 = (String)list3.head();
                Object object2 = stack.last();
                if (!(string5 == null ? object2 != null : !string5.equals(object2))) {
                    object = (Serializable)stack.remove(stack.length() - 1);
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        } while (stack.length() > 0 && this.char() != Regexes$.MODULE$.endOfText());
        return list2.mkString("");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Inline getInline(Function0 isInlineEnd) {
        Inline inline;
        List inlines;
        ListBuffer iss = (ListBuffer)ListBuffer$.MODULE$.empty();
        iss.$plus$eq((Object)this.inline0$1(isInlineEnd));
        while (!BoxesRunTime.unboxToBoolean((Object)isInlineEnd.apply()) && !this.checkParaEnded()) {
            ListBuffer listBuffer;
            boolean bl;
            if (this.char() != Regexes$.MODULE$.endOfLine()) {
                bl = false;
            } else {
                this.nextChar();
                bl = true;
            }
            boolean skipEndOfLine = bl;
            Inline current = this.inline0$1(isInlineEnd);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(iss.last(), (Object)current);
            Option option = Tuple2$.MODULE$.unapply(tuple2);
            if (!option.isEmpty()) {
                Tuple2 tuple22 = (Tuple2)option.get();
                Inline inline2 = (Inline)tuple22._1();
                Inline inline3 = (Inline)tuple22._2();
                if (inline2 instanceof Text) {
                    Text text = (Text)inline2;
                    if (Text$.MODULE$.unapply((Text)inline2) != null) {
                        Text text2 = Text$.MODULE$.unapply((Text)inline2);
                        String t1 = text2._1();
                        if (inline3 instanceof Text) {
                            Text text3 = (Text)inline3;
                            if (Text$.MODULE$.unapply((Text)inline3) != null) {
                                Text text4 = Text$.MODULE$.unapply((Text)inline3);
                                String t2 = text4._1();
                                if (skipEndOfLine) {
                                    iss.update(iss.length() - 1, (Object)Text$.MODULE$.apply(new StringBuilder().append((Object)t1).append((Object)BoxesRunTime.boxToCharacter((char)Regexes$.MODULE$.endOfLine())).append((Object)t2).toString()));
                                    listBuffer = BoxedUnit.UNIT;
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            Option option2 = Tuple2$.MODULE$.unapply(tuple2);
            if (!option2.isEmpty()) {
                Tuple2 tuple23 = (Tuple2)option2.get();
                Inline i2 = (Inline)tuple23._2();
                if (skipEndOfLine) {
                    listBuffer = iss.$plus$plus$eq((TraversableOnce)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Inline[]{Text$.MODULE$.apply(((Object)BoxesRunTime.boxToCharacter((char)Regexes$.MODULE$.endOfLine())).toString()), i2})));
                    continue;
                }
            }
            listBuffer = iss.$plus$eq((Object)current);
        }
        List list = inlines = iss.toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            Nil$ nil$2 = (Nil$)list;
            inline = Text$.MODULE$.apply("");
            return inline;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Option option = package$.MODULE$.$colon$colon().unapply((.colon.colon)list);
            if (!option.isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                Inline i = (Inline)tuple2._1();
                List list3 = (List)tuple2._2();
                Nil$ nil$3 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$3 != null ? !nil$3.equals(list4) : list4 != null)) {
                    Nil$ nil$4 = (Nil$)list3;
                    inline = i;
                    return inline;
                }
            }
        }
        List is = list;
        inline = Chain$.MODULE$.apply((Seq)is);
        return inline;
    }

    public HtmlTag htmlTag() {
        this.jump(Regexes$.MODULE$.safeTagMarker());
        String read = this.readUntil(Regexes$.MODULE$.safeTagMarker());
        Object object = this.char() != Regexes$.MODULE$.endOfText() ? BoxesRunTime.boxToBoolean((boolean)this.jump(Regexes$.MODULE$.safeTagMarker())) : BoxedUnit.UNIT;
        return HtmlTag$.MODULE$.apply(read);
    }

    public Inline bold() {
        this.jump("'''");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$114));
        this.jump("'''");
        return Bold$.MODULE$.apply(i);
    }

    public Inline italic() {
        this.jump("''");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$105));
        this.jump("''");
        return Italic$.MODULE$.apply(i);
    }

    public Inline monospace() {
        this.jump("`");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$110));
        this.jump("`");
        return Monospace$.MODULE$.apply(i);
    }

    public Inline underline() {
        this.jump("__");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$112));
        this.jump("__");
        return Underline$.MODULE$.apply(i);
    }

    public Inline superscript() {
        this.jump("^");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$104));
        return this.jump("^") ? Superscript$.MODULE$.apply(i) : Chain$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Inline[]{Text$.MODULE$.apply("^"), i})));
    }

    public Inline subscript() {
        this.jump(",,");
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$107));
        this.jump(",,");
        return Subscript$.MODULE$.apply(i);
    }

    public Inline summary() {
        Inline i = this.getInline((Function0)((JFunction0.mcZ.sp)this::$anonfun$98));
        return Summary$.MODULE$.apply(this.jump(".") ? Chain$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Inline[]{i, Text$.MODULE$.apply(".")}))) : i);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Inline link() {
        Option option;
        Inline inline;
        None$ none$;
        Regex SchemeUri = new StringOps(Predef$.MODULE$.augmentString("([a-z]+:.*)")).r();
        this.jump("[[");
        int parens = 2 + this.repeatJump('[', this.repeatJump$default$2());
        String stop = new StringOps(Predef$.MODULE$.augmentString("]")).$times(parens);
        String target = this.readUntil((Function0)((JFunction0.mcZ.sp)() -> this.$anonfun$102(stop)));
        if (!this.check(stop)) {
            this.jumpWhitespaceOrNewLine();
            none$ = Some$.MODULE$.apply((Object)this.getInline((Function0)((JFunction0.mcZ.sp)() -> this.$anonfun$111(stop))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ title = none$;
        this.jump(stop);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)target, (Object)title);
        Option option2 = Tuple2$.MODULE$.unapply(tuple2);
        if (!option2.isEmpty()) {
            List list;
            Tuple2 tuple22 = (Tuple2)option2.get();
            String string = (String)tuple22._1();
            Option optTitle = (Option)tuple22._2();
            Option option3 = SchemeUri.unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && (list = (List)option3.get()) != null && list.lengthCompare(1) == 0) {
                String uri = (String)list.head();
                inline = Link$.MODULE$.apply(uri, (Inline)optTitle.getOrElse(() -> this.link$$anonfun$2(uri)));
                return inline;
            }
        }
        if ((option = Tuple2$.MODULE$.unapply(tuple2)).isEmpty()) throw new MatchError((Object)tuple2);
        Tuple2 tuple23 = (Tuple2)option.get();
        Option optTitle = (Option)tuple23._2();
        inline = this.makeEntityLink(this.entity, this.packages, (Inline)optTitle.getOrElse(() -> this.link$$anonfun$1(target)), target);
        return inline;
    }

    public void blockEnded(String blockType) {
        Object object;
        if (this.char() != Regexes$.MODULE$.endOfLine() && this.char() != Regexes$.MODULE$.endOfText()) {
            this.reportError(this.pos, new StringBuilder().append((Object)"no additional content on same line after ").append((Object)blockType).toString());
            object = BoxesRunTime.boxToInteger((int)this.jumpUntil(Regexes$.MODULE$.endOfLine()));
        } else {
            object = BoxedUnit.UNIT;
        }
        while (this.char() == Regexes$.MODULE$.endOfLine()) {
            this.nextChar();
        }
    }

    public String normalizeIndentation(String _code) {
        String code = (String)new StringOps(Predef$.MODULE$.augmentString(_code.replaceAll("\\s+$", ""))).dropWhile((Function1)((JFunction1)WikiParser::$anonfun$100));
        Object[] lines = code.split("\n");
        Object[] nonEmptyLines = (String[])Predef$.MODULE$.refArrayOps(lines).filter((Function1)((JFunction1)WikiParser::$anonfun$108));
        int maxSkip = Predef$.MODULE$.refArrayOps(nonEmptyLines).isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps(nonEmptyLines).map((Function1)((JFunction1)WikiParser::$anonfun$99), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.TYPE)))).min((Ordering)Ordering.Int$.MODULE$));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(lines).map((Function1)((JFunction1)arg_0 -> this.normalizeIndentation$$anonfun$1(maxSkip, arg_0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkParaEnded() {
        void var2_2;
        if (this.char() == Regexes$.MODULE$.endOfText()) return true;
        if (this.char() != Regexes$.MODULE$.endOfLine()) return false;
        int poff = this.offset();
        this.nextChar();
        boolean ok = this.checkSkipInitWhitespace(Regexes$.MODULE$.endOfLine()) || this.checkSkipInitWhitespace('=') || this.checkSkipInitWhitespace("{{{") || this.checkList() || this.checkSkipInitWhitespace('=');
        this.offset_$eq(poff);
        if (var2_2 != false) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkSentenceEnded() {
        void var2_2;
        if (this.char() != '.') return false;
        int poff = this.offset();
        this.nextChar();
        boolean ok = this.char() == Regexes$.MODULE$.endOfText() || this.char() == Regexes$.MODULE$.endOfLine() || this.isWhitespace(this.char());
        this.offset_$eq(poff);
        if (var2_2 != false) return true;
        return false;
    }

    public void reportError(long pos, String message) {
        Printers$.MODULE$.dottydoc().println(() -> this.reportError$$anonfun$1(pos, message));
    }

    private static Block $init$$$anonfun$3(Seq _$80) {
        return UnorderedList$.MODULE$.apply(_$80);
    }

    private static Block $init$$$anonfun$6(Seq _$81) {
        return OrderedList$.MODULE$.apply(_$81, "decimal");
    }

    private static Block $init$$$anonfun$2(Seq _$82) {
        return OrderedList$.MODULE$.apply(_$82, "upperRoman");
    }

    private static Block $init$$$anonfun$4(Seq _$83) {
        return OrderedList$.MODULE$.apply(_$83, "lowerRoman");
    }

    private static Block $init$$$anonfun$5(Seq _$84) {
        return OrderedList$.MODULE$.apply(_$84, "upperAlpha");
    }

    private static Block $init$$$anonfun$1(Seq _$85) {
        return OrderedList$.MODULE$.apply(_$85, "lowerAlpha");
    }

    private boolean checkList$$anonfun$1(String _$86) {
        return this.checkSkipInitWhitespace(_$86);
    }

    private static boolean $anonfun$103() {
        return false;
    }

    private Option listLine$1(int indent, String style) {
        None$ none$;
        if (this.countWhitespace() > indent && this.checkList()) {
            none$ = Some$.MODULE$.apply((Object)this.listBlock());
        } else if (this.countWhitespace() != indent || !this.checkSkipInitWhitespace(style)) {
            none$ = None$.MODULE$;
        } else {
            this.jumpWhitespace();
            this.jump(style);
            Paragraph p = Paragraph$.MODULE$.apply(this.getInline((Function0)((JFunction0.mcZ.sp)WikiParser::$anonfun$103)));
            this.blockEnded("end of list line ");
            none$ = Some$.MODULE$.apply((Object)p);
        }
        return none$;
    }

    private Block listLevel$1(int indent, String style) {
        ListBuffer lines = (ListBuffer)ListBuffer$.MODULE$.empty();
        Option line = this.listLine$1(indent, style);
        while (line.isDefined()) {
            lines.$plus$eq(line.get());
            line = this.listLine$1(indent, style);
        }
        Function1 constructor = (Function1)this.listStyles().apply((Object)style);
        return (Block)constructor.apply((Object)lines);
    }

    private boolean $anonfun$106(String _$87) {
        return this.checkSkipInitWhitespace(_$87);
    }

    private String $anonfun$97() {
        return (String)this.listStyles().keys().head();
    }

    private boolean $anonfun$113(int inLevel$1) {
        return this.check(new StringOps(Predef$.MODULE$.augmentString("=")).$times(inLevel$1));
    }

    private static boolean $anonfun$115() {
        return false;
    }

    private static boolean $anonfun$109() {
        return false;
    }

    private boolean $anonfun$96() {
        return this.char() == Regexes$.MODULE$.safeTagMarker() || this.char() == Regexes$.MODULE$.endOfText();
    }

    private boolean $anonfun$101(Function0 isInlineEnd$2) {
        return this.char() == Regexes$.MODULE$.safeTagMarker() || this.check("''") || this.char() == '`' || this.check("__") || this.char() == '^' || this.check(",,") || this.check("[[") || BoxesRunTime.unboxToBoolean((Object)isInlineEnd$2.apply()) || this.checkParaEnded() || this.char() == Regexes$.MODULE$.endOfLine();
    }

    private Inline inline0$1(Function0 isInlineEnd$1) {
        Inline inline;
        if (this.char() == Regexes$.MODULE$.safeTagMarker()) {
            HtmlTag tag = this.htmlTag();
            inline = HtmlTag$.MODULE$.apply(new StringBuilder().append((Object)tag.data()).append((Object)this.readHTMLFrom(tag)).toString());
        } else if (this.check("'''")) {
            inline = this.bold();
        } else if (this.check("''")) {
            inline = this.italic();
        } else if (this.check("`")) {
            inline = this.monospace();
        } else if (this.check("__")) {
            inline = this.underline();
        } else if (this.check("^")) {
            inline = this.superscript();
        } else if (this.check(",,")) {
            inline = this.subscript();
        } else if (this.check("[[")) {
            inline = this.link();
        } else {
            String str = this.readUntil((Function0)((JFunction0.mcZ.sp)() -> this.$anonfun$101(isInlineEnd$1)));
            inline = Text$.MODULE$.apply(str);
        }
        return inline;
    }

    private boolean $anonfun$114() {
        return this.check("'''");
    }

    private boolean $anonfun$105() {
        return this.check("''");
    }

    private boolean $anonfun$110() {
        return this.check("`");
    }

    private boolean $anonfun$112() {
        return this.check("__");
    }

    private boolean $anonfun$104() {
        return this.check("^");
    }

    private boolean $anonfun$107() {
        return this.check(",,");
    }

    private boolean $anonfun$98() {
        return this.checkSentenceEnded();
    }

    private boolean $anonfun$102(String stop$1) {
        return this.check(stop$1) || this.isWhitespaceOrNewLine(this.char());
    }

    private boolean $anonfun$111(String stop$2) {
        return this.check(stop$2);
    }

    private Text link$$anonfun$1(String target$2) {
        return Text$.MODULE$.apply(target$2);
    }

    private Text link$$anonfun$2(String uri$1) {
        return Text$.MODULE$.apply(uri$1);
    }

    private static boolean $anonfun$100(char _$88) {
        return _$88 == '\n';
    }

    private static boolean $anonfun$108(String _$89) {
        return new StringOps(Predef$.MODULE$.augmentString(_$89.trim())).nonEmpty();
    }

    public static boolean dotty$tools$dottydoc$model$comment$WikiParser$$anonfun$99$$$anonfun$99$$anonfun$1$1(char _$90) {
        return _$90 == ' ';
    }

    private static int $anonfun$99(String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line)).prefixLength((Function1)((JFunction1)WikiParser::dotty$tools$dottydoc$model$comment$WikiParser$$anonfun$99$$$anonfun$99$$anonfun$1$1));
    }

    private String normalizeIndentation$$anonfun$1(int maxSkip$1, String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() ? line.substring(maxSkip$1) : line;
    }

    private String reportError$$anonfun$1(long pos$8, String message$1) {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Positions.Position(pos$8), message$1}));
    }
}

