/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dottydoc.model.comment;

import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.util.matching.Regex;

public final class Regexes$ {
    public static final Regexes$ MODULE$;
    private final Regex TrailingWhitespace;
    private final Regex CleanCommentLine;
    private final Regex DangerousTags;
    private final Regex JavadocTags;
    private final Regex SafeTags;
    private final char safeTagMarker;
    private final char endOfLine;
    private final char endOfText;
    private final Regex SingleTagRegex;
    private final Regex SimpleTagRegex;
    private final Regex SymbolTagRegex;
    private final Regex CodeBlockStartRegex;
    private final Regex CodeBlockEndRegex;

    static {
        new Regexes$();
    }

    public Regexes$() {
        MODULE$ = this;
        this.TrailingWhitespace = new StringOps(Predef$.MODULE$.augmentString("\\s+$")).r();
        this.CleanCommentLine = new Regex("(?:\\s*\\*\\s?\\s?)?(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.DangerousTags = new Regex("<(/?(div|ol|ul|li|h[1-6]|p))( [^>]*)?/?>|<!--.*-->", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.JavadocTags = new Regex("\\{\\@(code|docRoot|linkplain|link|literal|value)\\p{Zs}*([^}]*)\\}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.SafeTags = new Regex("((&\\w+;)|(&#\\d+;)|(</?(abbr|acronym|address|area|a|bdo|big|blockquote|br|button|b|caption|cite|code|col|colgroup|dd|del|dfn|em|fieldset|form|hr|img|input|ins|i|kbd|label|legend|link|map|object|optgroup|option|param|pre|q|samp|select|small|span|strong|sub|sup|table|tbody|td|textarea|tfoot|th|thead|tr|tt|var)( [^>]*)?/?>))", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.safeTagMarker = (char)14;
        this.endOfLine = (char)10;
        this.endOfText = (char)3;
        this.SingleTagRegex = new Regex("\\s*@(\\S+)\\s*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.SimpleTagRegex = new Regex("\\s*@(\\S+)\\s+(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.SymbolTagRegex = new Regex("\\s*@(param|tparam|throws|groupdesc|groupname|groupprio)\\s+(\\S*)\\s*(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.CodeBlockStartRegex = new Regex("(.*?)((?:\\{\\{\\{)|(?:\u000e<pre(?: [^>]*)?>\u000e))(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.CodeBlockEndRegex = new Regex("(.*?)((?:\\}\\}\\})|(?:\u000e</pre>\u000e))(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public Regex TrailingWhitespace() {
        return this.TrailingWhitespace;
    }

    public Regex CleanCommentLine() {
        return this.CleanCommentLine;
    }

    public Regex DangerousTags() {
        return this.DangerousTags;
    }

    public Regex JavadocTags() {
        return this.JavadocTags;
    }

    public String javadocReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        return "code".equals(string) ? new StringBuilder().append((Object)"<code>").append((Object)mtch.group(2)).append((Object)"</code>").toString() : ("docRoot".equals(string) ? "" : ("link".equals(string) ? new StringBuilder().append((Object)"`[[").append((Object)mtch.group(2)).append((Object)"]]`").toString() : ("linkplain".equals(string) ? new StringBuilder().append((Object)"[[").append((Object)mtch.group(2)).append((Object)"]]").toString() : ("literal".equals(string) ? new StringBuilder().append((Object)"`").append((Object)mtch.group(2)).append((Object)"`").toString() : ("value".equals(string) ? new StringBuilder().append((Object)"`").append((Object)mtch.group(2)).append((Object)"`").toString() : "")))));
    }

    /*
     * Enabled aggressive block sorting
     */
    public String htmlReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        if ("p".equals(string) || "div".equals(string)) {
            return "\n\n";
        }
        if ("h1".equals(string)) {
            return "\n= ";
        }
        if ("/h1".equals(string)) {
            return " =\n";
        }
        if ("h2".equals(string)) {
            return "\n== ";
        }
        if ("/h2".equals(string)) {
            return " ==\n";
        }
        if ("h3".equals(string)) {
            return "\n=== ";
        }
        if ("/h3".equals(string)) {
            return " ===\n";
        }
        if ("h4".equals(string) || "h5".equals(string) || "h6".equals(string)) {
            return "\n==== ";
        }
        if ("/h4".equals(string) || "/h5".equals(string) || "/h6".equals(string)) {
            return " ====\n";
        }
        if (!"li".equals(string)) return "";
        return "\n *  - ";
    }

    public Regex SafeTags() {
        return this.SafeTags;
    }

    public char safeTagMarker() {
        return this.safeTagMarker;
    }

    public char endOfLine() {
        return this.endOfLine;
    }

    public char endOfText() {
        return this.endOfText;
    }

    public Regex SingleTagRegex() {
        return this.SingleTagRegex;
    }

    public Regex SimpleTagRegex() {
        return this.SimpleTagRegex;
    }

    public Regex SymbolTagRegex() {
        return this.SymbolTagRegex;
    }

    public Regex CodeBlockStartRegex() {
        return this.CodeBlockStartRegex;
    }

    public Regex CodeBlockEndRegex() {
        return this.CodeBlockEndRegex;
    }
}

