/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import dotty.tools.dotc.core.Comments;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.Positions$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import java.net.URI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;

public final class DottyLanguageServer$ {
    public static final DottyLanguageServer$ MODULE$;

    static {
        new DottyLanguageServer$();
    }

    public DottyLanguageServer$() {
        MODULE$ = this;
    }

    public final String IDE_CONFIG_FILE() {
        return ".dotty-ide.json";
    }

    public SourcePosition sourcePosition(InteractiveDriver driver, URI uri, Position pos) {
        NoSourcePosition$ noSourcePosition$;
        SourceFile source = (SourceFile)driver.openedFiles().apply((Object)uri);
        if (source.exists()) {
            long p = Positions$.MODULE$.Position(source.lineToOffset(pos.getLine()) + pos.getCharacter());
            noSourcePosition$ = new SourcePosition(source, p, (SourcePosition)SourcePosition$.MODULE$.$lessinit$greater$default$3());
        } else {
            noSourcePosition$ = NoSourcePosition$.MODULE$;
        }
        return noSourcePosition$;
    }

    public Option<Range> range(SourcePosition p) {
        return p.exists() ? Some$.MODULE$.apply((Object)new Range(new Position(p.startLine(), p.startColumn()), new Position(p.endLine(), p.endColumn()))) : None$.MODULE$;
    }

    public Option<Location> location(SourcePosition p) {
        return this.range(p).map((Function1)((JFunction1)r -> new Location(InteractiveDriver$.MODULE$.toUri(p.source()).toString(), r)));
    }

    public Option<Diagnostic> diagnostic(MessageContainer mc) {
        None$ none$;
        if (!mc.pos().exists()) {
            none$ = None$.MODULE$;
        } else {
            String code = ((Object)BoxesRunTime.boxToInteger((int)mc.contained().errorId().errorNumber())).toString();
            none$ = this.range(mc.pos()).map((Function1)((JFunction1)r -> new Diagnostic(r, mc.message(), this.severity$1(mc.level()), "", code)));
        }
        return none$;
    }

    public CompletionItem completionItem(Symbols.Symbol sym, Contexts.Context ctx) {
        String label = sym.name(ctx).show(ctx);
        CompletionItem item = new CompletionItem(label);
        item.setDetail(Symbols$.MODULE$.toDenot(sym, ctx).info(ctx).widenTermRefExpr(ctx).show(ctx));
        item.setKind(this.completionItemKind$1(sym, ctx));
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public MarkupContent dotty$tools$languageserver$DottyLanguageServer$$$hoverContent(String typeInfo, Option<Comments.Comment> comment) {
        void var3_3;
        String string;
        MarkupContent markup = new MarkupContent();
        markup.setKind("markdown");
        Option option = comment.flatMap((Function1)((JFunction1)_$6 -> _$6.expandedBody()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String comment2 = (String)some.value();
            string = Predef$.MODULE$.augmentString("```scala\n             |" + typeInfo + "\n             |" + comment2 + "\n             |```");
        } else if (None$.MODULE$.equals(option)) {
            string = Predef$.MODULE$.augmentString("```scala\n             |" + typeInfo + "\n             |```");
        } else {
            throw new MatchError((Object)option);
        }
        markup.setValue(new StringOps(string).stripMargin());
        return var3_3;
    }

    public Option<SymbolInformation> symbolInfo(Symbols.Symbol sym, SourcePosition pos, Contexts.Context ctx) {
        String name = sym.name(ctx).show(ctx);
        String containerName = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx).owner(), ctx).exists() && !Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx).owner(), ctx).isEmptyPackage(ctx) ? Symbols$.MODULE$.toDenot(sym, ctx).owner().name(ctx).show(ctx) : null;
        return this.location(pos).map((Function1)((JFunction1)l -> new SymbolInformation(name, this.symbolKind$1(sym, ctx), l, containerName)));
    }

    private final DiagnosticSeverity severity$1(int level) {
        DiagnosticSeverity diagnosticSeverity;
        int n = level;
        switch (n) {
            case 0: {
                diagnosticSeverity = DiagnosticSeverity.Information;
                break;
            }
            case 1: {
                diagnosticSeverity = DiagnosticSeverity.Warning;
                break;
            }
            case 2: {
                diagnosticSeverity = DiagnosticSeverity.Error;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return diagnosticSeverity;
    }

    private final CompletionItemKind completionItemKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) ? CompletionItemKind.Module : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? CompletionItemKind.Constructor : (sym.isClass() ? CompletionItemKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? CompletionItemKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? CompletionItemKind.Method : CompletionItemKind.Field))));
    }

    private final SymbolKind symbolKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) ? SymbolKind.Package : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? SymbolKind.Constructor : (sym.isClass() ? SymbolKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? SymbolKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? SymbolKind.Method : SymbolKind.Field))));
    }
}

