/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import dotty.DottyPredef$;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.core.Comments;
import dotty.tools.dotc.core.Comments$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.interactive.Interactive;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.languageserver.DottyLanguageServer;
import dotty.tools.languageserver.DottyLanguageServer$;
import dotty.tools.languageserver.Memory$;
import dotty.tools.languageserver.config.ProjectConfig;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class DottyLanguageServer
implements LanguageServer,
LanguageClientAware,
TextDocumentService,
WorkspaceService {
    private String rootUri;
    private LanguageClient client;
    private scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> myDrivers;

    public static Option<SymbolInformation> symbolInfo(Symbols.Symbol symbol, SourcePosition sourcePosition, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.symbolInfo(symbol, sourcePosition, context);
    }

    public static String IDE_CONFIG_FILE() {
        return DottyLanguageServer$.MODULE$.IDE_CONFIG_FILE();
    }

    public static CompletionItem completionItem(Symbols.Symbol symbol, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.completionItem(symbol, context);
    }

    public static Option<Location> location(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.location(sourcePosition);
    }

    public static Option<Range> range(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.range(sourcePosition);
    }

    public static Option<Diagnostic> diagnostic(MessageContainer messageContainer) {
        return DottyLanguageServer$.MODULE$.diagnostic(messageContainer);
    }

    public static SourcePosition sourcePosition(InteractiveDriver interactiveDriver, URI uRI, Position position) {
        return DottyLanguageServer$.MODULE$.sourcePosition(interactiveDriver, uRI, position);
    }

    public Map<ProjectConfig, InteractiveDriver> drivers() {
        scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> map;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            if (this.myDrivers == null) {
                if (this.rootUri == null) {
                    DottyPredef$.MODULE$.assertFail(DottyLanguageServer::drivers$$anonfun$1);
                }
                File configFile = new File(new URI(this.rootUri + '/' + ".dotty-ide.json"));
                List configs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ObjectMapper().readValue(configFile, ProjectConfig[].class))).toList();
                List defaultFlags = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never"}));
                this.myDrivers = new HashMap();
                configs.foreach((Function1)((JProcedure1)config -> {
                    List settings = (List)((SeqLike)defaultFlags.$plus$plus((GenTraversableOnce)DottyLanguageServer.updateDeco$1(DottyLanguageServer.updateDeco$1(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.compilerArguments)).toList()).update("-classpath", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.dependencyClasspath)).$plus$colon((Object)config.classDirectory, ClassTag$.MODULE$.apply(File.class)))).mkString(File.pathSeparator))).update("-sourcepath", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories)).mkString(File.pathSeparator)), List$.MODULE$.canBuildFrom())).$colon$plus((Object)"-scansource", List$.MODULE$.canBuildFrom());
                    this.myDrivers.update(config, (Object)new InteractiveDriver(settings));
                }));
            }
            map = this.myDrivers;
        }
        return (Map)map;
    }

    private void restart() {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            BoxedUnit boxedUnit;
            Printers$.MODULE$.interactiv().println(DottyLanguageServer::restart$$anonfun$1);
            List driverConfigs = (List)this.myDrivers.toList().withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ProjectConfig config = (ProjectConfig)tuple2._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).map((Function1)((JFunction1)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ProjectConfig config = (ProjectConfig)tuple2._1();
                InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                return Tuple3$.MODULE$.apply((Object)config, (Object)new InteractiveDriver(driver.settings()), (Object)driver.openedFiles());
            }), List$.MODULE$.canBuildFrom());
            driverConfigs.withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    ProjectConfig config = (ProjectConfig)tuple3._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).foreach((Function1)((JProcedure1)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                ProjectConfig config = (ProjectConfig)tuple3._1();
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                this.myDrivers.update((Object)config, (Object)driver);
            }));
            System.gc();
            driverConfigs.withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    Map opened = (Map)tuple3._3();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).foreach((Function1)((JProcedure1)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                Map opened = (Map)tuple3._3();
                opened.withFilter((Function1)((JFunction1)x$1 -> {
                    boolean bl;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        URI uri = (URI)tuple2._1();
                        SourceFile source = (SourceFile)tuple2._2();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                })).foreach((Function1)((JFunction1)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    URI uri = (URI)tuple2._1();
                    SourceFile source = (SourceFile)tuple2._2();
                    return driver.run(uri, source);
                }));
            }));
            if (Memory$.MODULE$.isCritical()) {
                Predef$.MODULE$.println((Object)"WARNING: Insufficient memory to run Scala language server on these projects.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Object checkMemory() {
        return Memory$.MODULE$.isCritical() ? CompletableFutures.computeAsync(this::checkMemory$$anonfun$adapted$1) : BoxedUnit.UNIT;
    }

    public InteractiveDriver driverFor(URI uri) {
        InteractiveDriver interactiveDriver;
        Option matchingConfig = this.drivers().keys().find((Function1)((JFunction1)config -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories)).exists((Function1)((JFunction1)sourceDir -> new File(uri.getPath()).getCanonicalPath().startsWith(sourceDir.getCanonicalPath())))));
        Option option = matchingConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProjectConfig config2 = (ProjectConfig)some.value();
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config2);
        } else if (None$.MODULE$.equals(option)) {
            ProjectConfig config3 = (ProjectConfig)this.drivers().keys().head();
            Predef$.MODULE$.println((Object)("No configuration contains " + uri + " as a source file, arbitrarily choosing " + config3.id));
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config3);
        } else {
            throw new MatchError((Object)option);
        }
        return interactiveDriver;
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        System.exit(0);
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(new Object());
    }

    private <R> CompletableFuture<R> computeAsync(Function1<CancelChecker, R> fun) {
        return CompletableFutures.computeAsync(cancelToken -> {
            Object object;
            DottyLanguageServer dottyLanguageServer = this;
            synchronized (dottyLanguageServer) {
                cancelToken.checkCanceled();
                this.checkMemory();
                object = DottyLanguageServer.liftedTree1$1(fun, cancelToken);
            }
            return object;
        });
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            this.rootUri = params.getRootUri();
            if (this.rootUri == null) {
                DottyPredef$.MODULE$.assertFail();
            }
            ServerCapabilities c = new ServerCapabilities();
            c.setTextDocumentSync(TextDocumentSyncKind.Full);
            c.setDocumentHighlightProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(false), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"."}))).asJava()));
            CompletableFuture.supplyAsync(() -> this.drivers()).exceptionally(ex -> {
                ex.printStackTrace();
                return scala.sys.package$.MODULE$.exit(1);
            });
            return new InitializeResult(c);
        }));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            this.checkMemory();
            TextDocumentItem document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            String text = document.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)mc -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic((MessageContainer)mc))), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            this.checkMemory();
            VersionedTextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            TextDocumentContentChangeEvent change = (TextDocumentContentChangeEvent)params.getContentChanges().get(0);
            if (change.getRange() != null) {
                DottyPredef$.MODULE$.assertFail(DottyLanguageServer::didChange$$anonfun$1);
            }
            String text = change.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)mc -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic((MessageContainer)mc))), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            TextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            this.driverFor(uri).close(uri);
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            Nil$ nil$;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Option option = driver.compilationUnits().get((Object)uri);
            if (option instanceof Some) {
                Some some = (Some)option;
                CompilationUnit unit = (CompilationUnit)some.value();
                nil$ = (List)Interactive$.MODULE$.completions(pos, (Contexts.Context)ctx.fresh().setCompilationUnit(unit))._2();
            } else if (None$.MODULE$.equals(option)) {
                nil$ = package$.MODULE$.Nil();
            } else {
                throw new MatchError((Object)option);
            }
            Nil$ items = nil$;
            return Either.forRight((Object)new CompletionList(false, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)items.map((Function1)((JFunction1)sym -> DottyLanguageServer$.MODULE$.completionItem((Symbols.Symbol)sym, ctx)), List$.MODULE$.canBuildFrom())).asJava()));
        }));
    }

    public CompletableFuture<java.util.List<? extends Location>> definition(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.definition$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            java.util.List list;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
            } else {
                Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                List trees = driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(name).toString(), ctx);
                boolean includeDeclaration = params.getContext().isIncludeDeclaration();
                int includes = Interactive.Include$.MODULE$.references() | Interactive.Include$.MODULE$.overriding() | (includeDeclaration ? Interactive.Include$.MODULE$.definitions() : 0);
                List refs = Interactive$.MODULE$.findTreesMatching(trees, includes, sym, ctx);
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.flatMap((Function1)((JFunction1)ref -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.location(ref.namePos(ctx)))), List$.MODULE$.canBuildFrom())).asJava();
            }
            return list;
        }));
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            WorkspaceEdit workspaceEdit;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                workspaceEdit = new WorkspaceEdit();
            } else {
                Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                List trees = driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(name).toString(), ctx);
                String newName = params.getNewName();
                int includes = Interactive.Include$.MODULE$.references() | Interactive.Include$.MODULE$.definitions() | Interactive.Include$.MODULE$.linkedClass() | Interactive.Include$.MODULE$.overriding();
                List refs2 = Interactive$.MODULE$.findTreesMatching(trees, includes, sym, ctx);
                scala.collection.immutable.Map changes = refs2.groupBy((Function1)((JFunction1)ref -> InteractiveDriver$.MODULE$.toUri(ref.source()).toString())).mapValues((Function1)((JFunction1)refs -> (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.flatMap((Function1)((JFunction1)ref -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx)).map((Function1)((JFunction1)nameRange -> new TextEdit(nameRange, newName))))), List$.MODULE$.canBuildFrom())).asJava()));
                workspaceEdit = new WorkspaceEdit((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)changes).asJava());
            }
            return workspaceEdit;
        }));
    }

    public CompletableFuture<java.util.List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            java.util.List list;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol(uriTrees, pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
            } else {
                List refs = Interactive$.MODULE$.namedTrees(uriTrees, Interactive.Include$.MODULE$.references() | Interactive.Include$.MODULE$.overriding(), sym, ctx);
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.flatMap((Function1)((JFunction1)ref -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx)).map((Function1)((JFunction1)nameRange -> new DocumentHighlight(nameRange, DocumentHighlightKind.Read))))), List$.MODULE$.canBuildFrom())).asJava();
            }
            return list;
        }));
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            Hover hover;
            Types.Type tpw;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List trees = (List)driver.openedTrees().apply((Object)uri);
            Types.Type tp = Interactive$.MODULE$.enclosingType(trees, pos, ctx);
            Types.Type type = tpw = tp.widenTermRefExpr(ctx);
            Types.NoType$ noType$ = Types.NoType$.MODULE$;
            if (!(type != null ? !type.equals(noType$) : noType$ != null)) {
                hover = null;
            } else {
                Symbols.Symbol symbol = Interactive$.MODULE$.enclosingSourceSymbol(trees, pos, ctx);
                Option docComment = Comments.CommentsContext$.MODULE$.docCtx$extension(Comments$.MODULE$.CommentsContext(ctx)).flatMap((Function1)((JFunction1)_$4 -> _$4.docstring(symbol)));
                MarkupContent content = DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$hoverContent(tpw.show(ctx), (Option<Comments.Comment>)docComment);
                hover = new Hover(content, null);
            }
            return hover;
        }));
    }

    public CompletableFuture<java.util.List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            List defs = Interactive$.MODULE$.namedTrees(uriTrees, false, (Function1)((JFunction1)_$5 -> true), ctx);
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.flatMap((Function1)((JFunction1)d -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx), d.namePos(ctx), ctx).map((Function1)((JFunction1)info -> Either.forLeft((Object)info))))), List$.MODULE$.canBuildFrom())).asJava();
        }));
    }

    public CompletableFuture<java.util.List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            String query = params.getQuery();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.drivers().values().toList().flatMap((Function1)((JFunction1)driver -> {
                Contexts.Context ctx = driver.currentCtx();
                List trees = driver.allTrees(ctx);
                List defs = Interactive$.MODULE$.namedTrees(trees, false, query, ctx);
                return (GenTraversableOnce)defs.flatMap((Function1)((JFunction1)d -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx), d.namePos(ctx), ctx))), List$.MODULE$.canBuildFrom());
            }), List$.MODULE$.canBuildFrom())).asJava();
        }));
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return null;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens params) {
        return null;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem params) {
        return null;
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        return null;
    }

    private static final String drivers$$anonfun$1() {
        return "`drivers` cannot be called before `initialize`";
    }

    private static final updateDeco.1 updateDeco$1(List ss) {
        return new updateDeco.1(ss);
    }

    private static final String restart$$anonfun$1() {
        return "restarting presentation compiler";
    }

    private final /* synthetic */ void checkMemory$$anonfun$1(CancelChecker _$1) {
        this.restart();
    }

    private final Object checkMemory$$anonfun$adapted$1(CancelChecker _$1) {
        this.checkMemory$$anonfun$1(_$1);
        return BoxedUnit.UNIT;
    }

    private static final Object liftedTree1$1(Function1 fun$2, CancelChecker cancelToken$1) {
        Object object;
        try {
            object = fun$2.apply((Object)cancelToken$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                ex.printStackTrace();
                throw ex;
            }
            throw throwable;
        }
        return object;
    }

    private static final String didChange$$anonfun$1() {
        return "TextDocumentSyncKind.Incremental support is not implemented";
    }

    private static final /* synthetic */ Option $anonfun$7(Contexts.Context ctx$2, Names.Name name$1, Trees.Tree x$1) {
        Trees.Tree tree = x$1;
        if (!(tree instanceof Trees.DefDef)) {
            throw new MatchError((Object)tree);
        }
        Trees.DefDef defDef = (Trees.DefDef)tree;
        Trees.DefDef defDef2 = Trees.DefDef$.MODULE$.unapply(defDef);
        Names.TermName termName = defDef2._1();
        List list = defDef2._2();
        List list2 = defDef2._3();
        Trees.Tree tree2 = defDef2._4();
        Object object = defDef2._5();
        List paramss = list2;
        return ((LinearSeqOptimized)paramss.flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1)((JFunction1)_$2 -> {
            Names.TermName termName = _$2.name();
            Names.Name name = name$1;
            return !(termName != null ? !termName.equals(name) : name != null);
        })).map((Function1)((JFunction1)_$3 -> _$3.symbol(ctx$2)));
    }

    private static final Symbols.Symbol $anonfun$8(Contexts.Context ctx$4, Trees.Tree fn$1) {
        return fn$1.symbol(ctx$4);
    }

    private static final /* synthetic */ GenTraversableOnce definition$$anonfun$2$$anonfun$1(Contexts.Context ctx$5, SourceTree d) {
        return Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.location(d.namePos(ctx$5)));
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ java.util.List definition$$anonfun$1(TextDocumentPositionParams params$3, CancelChecker cancelToken) {
        block9: {
            block8: {
                uri = new URI(params$3.getTextDocument().getUri());
                driver = this.driverFor(uri);
                ctx = driver.currentCtx();
                pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$3.getPosition());
                path = Interactive$.MODULE$.pathTo((List)driver.openedTrees().apply((Object)uri), pos, ctx);
                enclTree = Interactive$.MODULE$.enclosingTree(path, ctx);
                var11_9 = path;
                if (!(var11_9 instanceof .colon.colon)) break block8;
                var12_10 = (.colon.colon)var11_9;
                var13_11 = (Trees.Tree)var12_10.head();
                var14_12 = var12_10.tl$access$1();
                if (!(var13_11 instanceof Trees.NamedArg)) break block8;
                var15_13 = (Trees.NamedArg)var13_11;
                var16_14 = Trees.NamedArg$.MODULE$.unapply(var15_13);
                var17_15 = var16_14._1();
                var18_16 = var16_14._2();
                name = var17_15;
                if (!(var14_12 instanceof .colon.colon)) break block8;
                var20_18 = (.colon.colon)var14_12;
                var21_19 = (Trees.Tree)var20_18.head();
                var22_20 = var20_18.tl$access$1();
                if (!(var21_19 instanceof Trees.Apply)) break block8;
                var23_21 = (Trees.Apply)var21_19;
                var24_22 = Trees.Apply$.MODULE$.unapply(var23_21);
                var25_23 = var24_22._1();
                var26_24 = var24_22._2();
                fn = var25_23;
                funSym = fn.symbol(ctx);
                v0 = funSym.name(ctx);
                var29_27 = StdNames$.MODULE$.nme().copy();
                if (v0 != null ? v0.equals(var29_27) == false : var29_27 != null) ** GOTO lbl-1000
                if (Symbols$.MODULE$.toDenot(funSym, ctx).is(Flags$.MODULE$.Synthetic(), ctx) && Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(funSym, ctx).owner(), ctx).is(Flags$.MODULE$.CaseClass(), ctx)) {
                    v1 = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(funSym, ctx).owner(), ctx).info(ctx).member(name, ctx).symbol();
                } else lbl-1000:
                // 2 sources

                {
                    classTree = Symbols$.MODULE$.toDenot(funSym, ctx).topLevelClass(ctx).asClass().rootTree(ctx);
                    v1 = (Symbols.Symbol)tpd$.MODULE$.defPath(funSym, classTree, ctx).lastOption().flatMap((Function1)(JFunction1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(dotty.tools.dotc.core.Contexts$Context dotty.tools.dotc.core.Names$Name dotty.tools.dotc.ast.Trees$Tree ), (Ldotty/tools/dotc/ast/Trees$Tree;)Lscala/Option;)((Contexts.Context)ctx, (Names.Name)name)).getOrElse((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(dotty.tools.dotc.core.Contexts$Context dotty.tools.dotc.ast.Trees$Tree ), ()Ldotty/tools/dotc/core/Symbols$Symbol;)((Contexts.Context)ctx, (Trees.Tree)fn));
                }
                break block9;
            }
            v1 = enclTree.symbol(ctx);
        }
        sym = v1;
        v2 = sym = Interactive$.MODULE$.sourceSymbol(sym, ctx);
        var31_31 = Symbols.NoSymbol$.MODULE$;
        if (!(v2 != null ? v2.equals(var31_31) == false : var31_31 != null)) {
            v3 = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
        } else {
            if (enclTree instanceof Trees.MemberDef) {
                var33_32 = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                v4 = Tuple2$.MODULE$.apply((Object)driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(var33_32).toString(), ctx), (Object)BoxesRunTime.boxToInteger((int)(Interactive.Include$.MODULE$.overriding() | Interactive.Include$.MODULE$.overridden())));
            } else {
                var34_33 = Symbols$.MODULE$.toDenot(sym, ctx).topLevelClass(ctx);
                if (var34_33 instanceof Symbols.ClassSymbol) {
                    cls = var35_34 = (Symbols.ClassSymbol)var34_33;
                    v4 = Tuple2$.MODULE$.apply((Object)SourceTree$.MODULE$.fromSymbol(cls, SourceTree$.MODULE$.fromSymbol$default$2(), ctx).toList(), (Object)BoxesRunTime.boxToInteger((int)Interactive.Include$.MODULE$.overriding()));
                } else {
                    v4 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)BoxesRunTime.boxToInteger((int)Interactive.Include$.MODULE$.overriding()));
                }
            }
            var32_36 = v4;
            trees = (List)var32_36._1();
            include = BoxesRunTime.unboxToInt((Object)var32_36._2());
            defs = Interactive$.MODULE$.namedTrees(trees, include, sym, ctx);
            v3 = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.flatMap((Function1)(JFunction1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, definition$$anonfun$2$$anonfun$1(dotty.tools.dotc.core.Contexts$Context dotty.tools.dotc.interactive.SourceTree ), (Ldotty/tools/dotc/interactive/SourceTree;)Lscala/collection/GenTraversableOnce;)((Contexts.Context)ctx), List$.MODULE$.canBuildFrom())).asJava();
        }
        return v3;
    }
}

