/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Annotations$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.interactive.Completion;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.messages;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.ParsedComment;
import dotty.tools.dotc.util.ParsedComment$;
import dotty.tools.dotc.util.Signatures;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans$;
import java.io.Serializable;
import java.net.URI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DottyLanguageServer$
implements Serializable {
    public static final DottyLanguageServer$ MODULE$;

    static {
        new DottyLanguageServer$();
    }

    private DottyLanguageServer$() {
        MODULE$ = this;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DottyLanguageServer$.class);
    }

    public SourcePosition sourcePosition(InteractiveDriver driver, URI uri, Position pos) {
        NoSourcePosition$ noSourcePosition$;
        Position actualPosition = this.dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(uri) ? this.toWrappedPosition(pos) : pos;
        SourceFile source = (SourceFile)driver.openedFiles().apply((Object)uri);
        if (source.exists()) {
            int offset;
            Option option = source.lineToOffsetOpt(actualPosition.getLine()).map((Function1)(JFunction1.mcII.sp & Serializable)_$17 -> _$17 + actualPosition.getCharacter());
            if (option instanceof Some && (offset = BoxesRunTime.unboxToInt((Object)((Some)option).value())) <= source.content().length) {
                long p = Spans$.MODULE$.Span(offset);
                noSourcePosition$ = new SourcePosition(source, p, (SourcePosition)SourcePosition$.MODULE$.$lessinit$greater$default$3());
            } else {
                noSourcePosition$ = NoSourcePosition$.MODULE$;
            }
        } else {
            noSourcePosition$ = NoSourcePosition$.MODULE$;
        }
        return noSourcePosition$;
    }

    public Option<Range> range(SourcePosition p) {
        None$ none$;
        if (p.exists()) {
            SourcePosition mappedPosition = (SourcePosition)this.positionMapperFor(p.source()).map((Function1)(JFunction1 & Serializable)_$18 -> (SourcePosition)_$18.apply((Object)p)).getOrElse(() -> this.$anonfun$2(p));
            none$ = Some$.MODULE$.apply((Object)new Range(new Position(mappedPosition.startLine(), mappedPosition.startColumn()), new Position(mappedPosition.endLine(), mappedPosition.endColumn())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Location> location(SourcePosition p) {
        return InteractiveDriver$.MODULE$.toUriOption(p.source()).flatMap((Function1)(JFunction1 & Serializable)uri -> this.range(p).map((Function1)(JFunction1 & Serializable)r -> new Location(uri.toString(), r)));
    }

    public Option<Diagnostic> diagnostic(dotty.tools.dotc.reporting.Diagnostic dia, Contexts.Context ctx) {
        None$ none$;
        if (!dia.pos().exists()) {
            none$ = None$.MODULE$;
        } else {
            Message message = dia.msg();
            if (this.displayMessage(message, dia.pos().source(), ctx)) {
                String code = BoxesRunTime.boxToInteger((int)message.errorId().errorNumber()).toString();
                none$ = this.range(dia.pos()).map((Function1)(JFunction1 & Serializable)r -> new Diagnostic(r, dia.message(), this.severity$1(dia.level()), "", code));
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private boolean displayMessage(Message message, SourceFile sourceFile, Contexts.Context ctx) {
        boolean bl;
        if (this.isWorksheet(sourceFile)) {
            Message message2 = message;
            if (message2 instanceof messages.PureExpressionInStatementPosition) {
                Symbols.Symbol ownerSym;
                messages.PureExpressionInStatementPosition msg = (messages.PureExpressionInStatementPosition)message2;
                Symbols.Symbol symbol = ownerSym = Symbols$.MODULE$.toDenot(msg.exprOwner(), ctx).isLocalDummy() ? Symbols$.MODULE$.toDenot(msg.exprOwner(), ctx).owner() : msg.exprOwner();
                bl = !this.isWorksheetWrapper(ownerSym, ctx);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(URI uri) {
        return uri.toString().endsWith(".sc");
    }

    private boolean isWorksheet(SourceFile sourcefile) {
        String string = sourcefile.file().extension();
        String string2 = "sc";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String dotty$tools$languageserver$DottyLanguageServer$$$wrapWorksheet(String source) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("object " + StdNames$.MODULE$.nme().WorksheetWrapper() + " {\n       |" + source + "\n       |}"));
    }

    private SourcePosition toUnwrappedPosition(SourcePosition position) {
        return new SourcePosition(position){
            private final SourcePosition position$1;
            {
                this.position$1 = position$1;
                super(position$1.source(), position$1.span(), position$1.outer());
            }

            public int startLine() {
                return this.position$1.startLine() - 1;
            }

            public int endLine() {
                return this.position$1.endLine() - 1;
            }
        };
    }

    private Position toWrappedPosition(Position position) {
        return new Position(position.getLine() + 1, position.getCharacter());
    }

    private Option<Function1<SourcePosition, SourcePosition>> positionMapperFor(SourceFile sourcefile) {
        return this.isWorksheet(sourcefile) ? Some$.MODULE$.apply((JFunction1 & Serializable)position -> this.toUnwrappedPosition((SourcePosition)position)) : None$.MODULE$;
    }

    public boolean isWorksheetWrapper(SourceTree sourceTree, Contexts.Context ctx) {
        return this.isWorksheet(sourceTree.source()) && this.isWorksheetWrapper(sourceTree.tree().symbol(ctx), ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWorksheetWrapper(Symbols.Symbol symbol, Contexts.Context ctx) {
        Names.Name name = symbol.name(ctx);
        Names.Name name2 = NameOps$.MODULE$.NameDecorator(StdNames$.MODULE$.nme().WorksheetWrapper());
        Names.TypeName typeName = NameOps.NameDecorator$.MODULE$.moduleClassName$extension(name2);
        if (name == null) {
            if (typeName != null) {
                return false;
            }
        } else if (!name.equals(typeName)) return false;
        Symbols.Symbol symbol2 = Symbols$.MODULE$.toDenot(symbol, ctx).owner();
        Symbols.ClassSymbol classSymbol = ctx.definitions().EmptyPackageClass();
        if (symbol2 == null) {
            if (classSymbol == null) return true;
            return false;
        } else {
            if (!symbol2.equals(classSymbol)) return false;
            return true;
        }
    }

    public boolean isTopLevelWrapper(SourceTree sourceTree, Contexts.Context ctx) {
        Symbols.Symbol symbol = sourceTree.tree().symbol(ctx);
        return Symbols$.MODULE$.toDenot(symbol, ctx).isPackageObject(ctx);
    }

    /*
     * WARNING - void declaration
     */
    public CompletionItem completionItem(Completion completion, Contexts.Context ctx) {
        void var3_3;
        CompletionItem item = new CompletionItem(completion.label());
        item.setDetail(completion.description());
        List documentation = completion.symbols().flatMap((Function1)(JFunction1 & Serializable)sym -> ParsedComment$.MODULE$.docOf(sym, ctx).map((Function1)(JFunction1 & Serializable)doc -> doc));
        if (documentation.nonEmpty()) {
            item.setDocumentation(this.dotty$tools$languageserver$DottyLanguageServer$$$hoverContent((Option<String>)None$.MODULE$, (List<ParsedComment>)documentation, ctx));
        }
        item.setDeprecated(Predef$.MODULE$.boolean2Boolean(completion.symbols().forall((Function1)(JFunction1 & Serializable)_$19 -> Annotations.AnnotInfo$.MODULE$.isDeprecated$extension(Annotations$.MODULE$.AnnotInfo(_$19), ctx))));
        completion.symbols().headOption().foreach((Function1)(JProcedure1 & Serializable)s -> item.setKind(this.completionItemKind$1((Symbols.Symbol)s, ctx)));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public MarkupContent markupContent(String content) {
        MarkupContent markupContent;
        if (content.isEmpty()) {
            markupContent = null;
        } else {
            void var2_2;
            MarkupContent markup = new MarkupContent();
            markup.setKind("markdown");
            markup.setValue(content.trim());
            markupContent = var2_2;
        }
        return markupContent;
    }

    public MarkupContent dotty$tools$languageserver$DottyLanguageServer$$$hoverContent(Option<String> typeInfo, List<ParsedComment> comments, Contexts.Context ctx) {
        StringBuilder buf = new StringBuilder();
        typeInfo.foreach((Function1)(JFunction1 & Serializable)info -> buf.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("```scala\n                    |" + info + "\n                    |```\n                    |"))));
        comments.foreach((Function1)(JFunction1 & Serializable)comment -> buf.append(comment.renderAsMarkdown(ctx)));
        return this.markupContent(buf.toString());
    }

    public Option<SymbolInformation> symbolInfo(Symbols.Symbol sym, SourcePosition pos, Contexts.Context ctx) {
        Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
        String name2 = NameOps.NameDecorator$.MODULE$.stripModuleClassSuffix$extension(name).show(ctx);
        return this.location(pos).map((Function1)(JFunction1 & Serializable)l -> new SymbolInformation(name2, this.symbolKind$1(sym, ctx), l, this.containerName$1(ctx, sym)));
    }

    public SignatureInformation signatureToSignatureInformation(Signatures.Signature signature) {
        List paramInfoss = signature.paramss().map((Function1)(JFunction1 & Serializable)_$20 -> _$20.map((Function1)(JFunction1 & Serializable)param -> this.paramToParameterInformation((Signatures.Param)param)));
        String paramLists = signature.paramss().map((Function1)(JFunction1 & Serializable)paramList -> {
            List labels = paramList.map((Function1)(JFunction1 & Serializable)_$21 -> _$21.show());
            String prefix = paramList.exists((Function1)(JFunction1 & Serializable)_$22 -> _$22.isImplicit()) ? "implicit " : "";
            return labels.mkString(prefix, ", ", "");
        }).mkString("(", ")(", ")");
        String tparamsLabel = signature.tparams().isEmpty() ? "" : signature.tparams().mkString("[", ", ", "]");
        String returnTypeLabel = (String)signature.returnType().map((Function1)(JFunction1 & Serializable)t -> ": " + t).getOrElse(this::$anonfun$7);
        String label = "" + signature.name() + tparamsLabel + paramLists + returnTypeLabel;
        Option documentation = signature.doc().map((Function1)(JFunction1 & Serializable)content -> this.markupContent((String)content));
        SignatureInformation sig = new SignatureInformation(label);
        sig.setParameters((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)paramInfoss.flatten(Predef$.MODULE$.$conforms())).asJava());
        documentation.foreach((Function1)(JProcedure1 & Serializable)_$23 -> sig.setDocumentation(_$23));
        return sig;
    }

    /*
     * WARNING - void declaration
     */
    private ParameterInformation paramToParameterInformation(Signatures.Param param) {
        void var3_3;
        Option documentation = param.doc().map((Function1)(JFunction1 & Serializable)content -> this.markupContent((String)content));
        ParameterInformation info = new ParameterInformation(param.show());
        documentation.foreach((Function1)(JProcedure1 & Serializable)_$24 -> info.setDocumentation(_$24));
        return var3_3;
    }

    private final SourcePosition $anonfun$2(SourcePosition p$2) {
        return p$2;
    }

    private final DiagnosticSeverity severity$1(int level) {
        DiagnosticSeverity diagnosticSeverity;
        int n = level;
        switch (n) {
            case 0: {
                diagnosticSeverity = DiagnosticSeverity.Information;
                break;
            }
            case 1: {
                diagnosticSeverity = DiagnosticSeverity.Warning;
                break;
            }
            case 2: {
                diagnosticSeverity = DiagnosticSeverity.Error;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return diagnosticSeverity;
    }

    private final CompletionItemKind completionItemKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Module(), ctx) ? CompletionItemKind.Module : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? CompletionItemKind.Constructor : (sym.isClass() ? CompletionItemKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? CompletionItemKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? CompletionItemKind.Method : CompletionItemKind.Field))));
    }

    private final SymbolKind symbolKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) ? SymbolKind.Package : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? SymbolKind.Constructor : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Module(), ctx) ? SymbolKind.Module : (Symbols$.MODULE$.toDenot(sym, ctx).isAllOf(Flags$.MODULE$.EnumCase(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAllOf(Flags$.MODULE$.EnumValue(), ctx) ? SymbolKind.EnumMember : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Enum(), ctx) ? SymbolKind.Enum : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Trait(), ctx) ? SymbolKind.Interface : (sym.isClass() ? SymbolKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? SymbolKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? SymbolKind.Method : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.TypeParam(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAbstractOrAliasType() ? SymbolKind.TypeParameter : SymbolKind.Field)))))))));
    }

    private final String containerName$1(Contexts.Context ctx$6, Symbols.Symbol sym) {
        String string;
        Symbols.Symbol owner;
        Symbols.Symbol symbol = owner = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$6).owner(), ctx$6).exists() && Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$6).owner(), ctx$6).isPackageObject(ctx$6) ? Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$6).owner(), ctx$6).owner() : Symbols$.MODULE$.toDenot(sym, ctx$6).owner();
        if (Symbols$.MODULE$.toDenot(owner, ctx$6).exists() && !Symbols$.MODULE$.toDenot(owner, ctx$6).isEmptyPackage(ctx$6)) {
            Names.Name name = NameOps$.MODULE$.NameDecorator(owner.name(ctx$6));
            string = NameOps.NameDecorator$.MODULE$.stripModuleClassSuffix$extension(name).show(ctx$6);
        } else {
            string = null;
        }
        return string;
    }

    private final String $anonfun$7() {
        return "";
    }
}

