/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.languageserver.DottyLanguageServer$;
import dotty.tools.languageserver.config.ProjectConfig;
import java.io.File;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public class DottyLanguageServer
implements LanguageServer,
LanguageClientAware,
TextDocumentService,
WorkspaceService {
    private String rootUri;
    private LanguageClient client;
    private scala.collection.mutable.Map myDrivers;

    public static CompletionItem completionItem(Symbols.Symbol symbol, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.completionItem(symbol, context);
    }

    public static Location location(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.location(sourcePosition);
    }

    public static SymbolInformation symbolInfo(Symbols.Symbol symbol, SourcePosition sourcePosition, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.symbolInfo(symbol, sourcePosition, context);
    }

    public static Option diagnostic(MessageContainer messageContainer) {
        return DottyLanguageServer$.MODULE$.diagnostic(messageContainer);
    }

    public static Range range(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.range(sourcePosition);
    }

    public static String IDE_CONFIG_FILE() {
        return DottyLanguageServer$.MODULE$.IDE_CONFIG_FILE();
    }

    public static SourcePosition sourcePosition(InteractiveDriver interactiveDriver, URI uRI, Position position) {
        return DottyLanguageServer$.MODULE$.sourcePosition(interactiveDriver, uRI, position);
    }

    public Map drivers() {
        scala.collection.mutable.Map map;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            if (this.myDrivers == null) {
                Predef$.MODULE$.assert(this.rootUri != null, DottyLanguageServer::drivers$$anonfun$1);
                File configFile = new File(new URI(new StringBuilder().append((Object)this.rootUri).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)".dotty-ide.json").toString()));
                List configs = Predef$.MODULE$.refArrayOps((Object[])new ObjectMapper().readValue(configFile, ProjectConfig[].class)).toList();
                List defaultFlags = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
                this.myDrivers = new HashMap();
                configs.foreach((Function1)((JFunction1)arg_0 -> this.drivers$$anonfun$2(defaultFlags, arg_0)));
            }
            map = this.myDrivers;
        }
        return (Map)map;
    }

    public InteractiveDriver driverFor(URI uri) {
        InteractiveDriver interactiveDriver;
        Option matchingConfig = this.drivers().keys().find((Function1)((JFunction1)arg_0 -> DottyLanguageServer.$anonfun$1(uri, arg_0)));
        Option option = matchingConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProjectConfig config = (ProjectConfig)some.x();
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config);
        } else if (None$.MODULE$.equals(option)) {
            ProjectConfig config = (ProjectConfig)this.drivers().keys().head();
            Predef$.MODULE$.println((Object)StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No configuration contains ", " as a source file, arbitrarily choosing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, config.id})));
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config);
        } else {
            throw new MatchError((Object)option);
        }
        return interactiveDriver;
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        System.exit(0);
    }

    public CompletableFuture shutdown() {
        return CompletableFuture.completedFuture(new Object());
    }

    private CompletableFuture computeAsync(Function1 fun) {
        return CompletableFutures.computeAsync(arg_0 -> this.computeAsync$$anonfun$1(fun, arg_0));
    }

    public CompletableFuture initialize(InitializeParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.initialize$$anonfun$1(params, arg_0)));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            TextDocumentItem document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            String text = document.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)DottyLanguageServer::didOpen$$anonfun$1), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            VersionedTextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            TextDocumentContentChangeEvent change = (TextDocumentContentChangeEvent)params.getContentChanges().get(0);
            Predef$.MODULE$.assert(change.getRange() == null, DottyLanguageServer::didChange$$anonfun$1);
            String text = change.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)DottyLanguageServer::didChange$$anonfun$2), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            TextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            this.driverFor(uri).close(uri);
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public CompletableFuture completion(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.completion$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture definition(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.definition$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture references(ReferenceParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.references$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture rename(RenameParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.rename$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture documentHighlight(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.documentHighlight$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture hover(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.hover$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture documentSymbol(DocumentSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.documentSymbol$$anonfun$1(params, arg_0)));
    }

    public CompletableFuture symbol(WorkspaceSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)arg_0 -> this.symbol$$anonfun$1(params, arg_0)));
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public CompletableFuture codeAction(CodeActionParams params) {
        return null;
    }

    public CompletableFuture codeLens(CodeLensParams params) {
        return null;
    }

    public CompletableFuture formatting(DocumentFormattingParams params) {
        return null;
    }

    public CompletableFuture rangeFormatting(DocumentRangeFormattingParams params) {
        return null;
    }

    public CompletableFuture onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return null;
    }

    public CompletableFuture resolveCodeLens(CodeLens params) {
        return null;
    }

    public CompletableFuture resolveCompletionItem(CompletionItem params) {
        return null;
    }

    public CompletableFuture signatureHelp(TextDocumentPositionParams params) {
        return null;
    }

    private static String drivers$$anonfun$1() {
        return "`drivers` cannot be called before `initialize`";
    }

    private Option drivers$$anonfun$2(List defaultFlags$1, ProjectConfig config) {
        Object[] objectArray = new String[2];
        objectArray[0] = "-classpath";
        File file = config.classDirectory;
        objectArray[1] = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])config.dependencyClasspath).$plus$colon((Object)file, ClassTag$.MODULE$.apply(File.class))).mkString(File.pathSeparator);
        List classpathFlags = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray));
        List settings = (List)((List)defaultFlags$1.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])config.compilerArguments).toList(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)classpathFlags, List$.MODULE$.canBuildFrom());
        return this.myDrivers.put((Object)config, (Object)new InteractiveDriver(settings));
    }

    public static boolean dotty$tools$languageserver$DottyLanguageServer$$anonfun$1$$$anonfun$1$$anonfun$1$1(URI uri$2, File sourceDir) {
        return new File(uri$2.getPath()).getCanonicalPath().startsWith(sourceDir.getCanonicalPath());
    }

    private static boolean $anonfun$1(URI uri$1, ProjectConfig config) {
        return Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories).exists((Function1)((JFunction1)arg_0 -> DottyLanguageServer.dotty$tools$languageserver$DottyLanguageServer$$anonfun$1$$$anonfun$1$$anonfun$1$1(uri$1, arg_0)));
    }

    private static Object liftedTree1$1(Function1 fun$2, CancelChecker cancelToken$1) {
        Object object;
        try {
            object = fun$2.apply((Object)cancelToken$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                ex.printStackTrace();
                throw ex;
            }
            throw throwable;
        }
        return object;
    }

    private Object computeAsync$$anonfun$1(Function1 fun$1, CancelChecker cancelToken) {
        Object object;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            cancelToken.checkCanceled();
            object = DottyLanguageServer.liftedTree1$1(fun$1, cancelToken);
        }
        return object;
    }

    private Map initialize$$anonfun$1$$anonfun$1() {
        return this.drivers();
    }

    private InitializeResult initialize$$anonfun$1(InitializeParams params$1, CancelChecker cancelToken) {
        this.rootUri = params$1.getRootUri();
        Predef$.MODULE$.assert(this.rootUri != null);
        ServerCapabilities c = new ServerCapabilities();
        c.setTextDocumentSync(TextDocumentSyncKind.Full);
        c.setDocumentHighlightProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
        c.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(false), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"."}))).asJava()));
        CompletableFuture.supplyAsync(this::initialize$$anonfun$1$$anonfun$1).exceptionally(new Function(){

            public Nothing$ apply(Throwable ex) {
                ex.printStackTrace();
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
        return new InitializeResult(c);
    }

    private static GenTraversableOnce didOpen$$anonfun$1(MessageContainer mc) {
        return Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic(mc));
    }

    private static String didChange$$anonfun$1() {
        return "TextDocumentSyncKind.Incremental support is not implemented";
    }

    private static GenTraversableOnce didChange$$anonfun$2(MessageContainer mc) {
        return Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic(mc));
    }

    private static CompletionItem completion$$anonfun$1$$anonfun$1(Contexts.Context ctx$1, Symbols.Symbol sym) {
        return DottyLanguageServer$.MODULE$.completionItem(sym, ctx$1);
    }

    private Either completion$$anonfun$1(TextDocumentPositionParams params$2, CancelChecker cancelToken) {
        URI uri = new URI(params$2.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$2.getPosition());
        List items = Interactive$.MODULE$.completions((List)driver.openedTrees().apply((Object)uri), pos, ctx);
        return Either.forRight((Object)new CompletionList(false, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)items.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.completion$$anonfun$1$$anonfun$1(ctx, arg_0)), List$.MODULE$.canBuildFrom())).asJava()));
    }

    private static Location definition$$anonfun$1$$anonfun$1(Contexts.Context ctx$2, SourceTree d) {
        return DottyLanguageServer$.MODULE$.location(d.namePos(ctx$2));
    }

    private java.util.List definition$$anonfun$1(TextDocumentPositionParams params$3, CancelChecker cancelToken) {
        java.util.List list;
        Symbols.Symbol sym;
        URI uri = new URI(params$3.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$3.getPosition());
        Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
        Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
        if (!(symbol == null ? noSymbol$ != null : !symbol.equals(noSymbol$))) {
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
        } else {
            List trees = SourceTree$.MODULE$.fromSymbol(Symbols$.MODULE$.toDenot(sym, ctx).topLevelClass(ctx).asClass(), ctx).toList();
            List defs = Interactive$.MODULE$.namedTrees(trees, false, true, sym, ctx);
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.definition$$anonfun$1$$anonfun$1(ctx, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    private static boolean $anonfun$2(Contexts.Context ctx$3, boolean includeDeclaration$1, Symbols.Symbol sym$1, Trees.NameTree tree) {
        return (includeDeclaration$1 || !Interactive$.MODULE$.isDefinition((Trees.Tree)tree)) && Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, sym$1, true, ctx$3);
    }

    private static Location references$$anonfun$1$$anonfun$1(Contexts.Context ctx$4, SourceTree ref) {
        return DottyLanguageServer$.MODULE$.location(ref.namePos(ctx$4));
    }

    private java.util.List references$$anonfun$1(ReferenceParams params$4, CancelChecker cancelToken) {
        java.util.List list;
        Symbols.Symbol sym;
        URI uri = new URI(params$4.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        boolean includeDeclaration = params$4.getContext().isIncludeDeclaration();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$4.getPosition());
        Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
        Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
        if (!(symbol == null ? noSymbol$ != null : !symbol.equals(noSymbol$))) {
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
        } else {
            List trees = driver.allTrees(ctx);
            List refs = Interactive$.MODULE$.namedTrees(trees, true, (Function1)((JFunction1)arg_0 -> DottyLanguageServer.$anonfun$2(ctx, includeDeclaration, sym, arg_0)), ctx);
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.references$$anonfun$1$$anonfun$1(ctx, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean $anonfun$3(Contexts.Context ctx$5, Symbols.Symbol sym$2, Symbols.Symbol linkedSym$1, Trees.NameTree tree) {
        if (Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, sym$2, true, ctx$5)) return true;
        Symbols.Symbol symbol = linkedSym$1;
        Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
        if (symbol == null) {
            if (noSymbol$ == null) return false;
        } else if (symbol.equals(noSymbol$)) return false;
        if (Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, linkedSym$1, true, ctx$5)) return true;
        return false;
    }

    private static String $anonfun$4(SourceTree ref) {
        return InteractiveDriver$.MODULE$.toUri(ref.source()).toString();
    }

    public static TextEdit dotty$tools$languageserver$DottyLanguageServer$$anonfun$5$$$anonfun$5$$anonfun$1$1(Contexts.Context ctx$7, String newName$2, SourceTree ref) {
        return new TextEdit(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx$7)), newName$2);
    }

    private static java.util.List $anonfun$5(Contexts.Context ctx$6, String newName$1, List _$1) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)_$1.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.dotty$tools$languageserver$DottyLanguageServer$$anonfun$5$$$anonfun$5$$anonfun$1$1(ctx$6, newName$1, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
    }

    private WorkspaceEdit rename$$anonfun$1(RenameParams params$5, CancelChecker cancelToken) {
        WorkspaceEdit workspaceEdit;
        Symbols.Symbol sym;
        URI uri = new URI(params$5.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$5.getPosition());
        Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
        Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
        if (!(symbol == null ? noSymbol$ != null : !symbol.equals(noSymbol$))) {
            workspaceEdit = new WorkspaceEdit();
        } else {
            List trees = driver.allTrees(ctx);
            Symbols.Symbol linkedSym = Symbols$.MODULE$.toDenot(sym, ctx).linkedClass(ctx);
            String newName = params$5.getNewName();
            List refs = Interactive$.MODULE$.namedTrees(trees, true, (Function1)((JFunction1)arg_0 -> DottyLanguageServer.$anonfun$3(ctx, sym, linkedSym, arg_0)), ctx);
            scala.collection.immutable.Map changes = refs.groupBy((Function1)((JFunction1)DottyLanguageServer::$anonfun$4)).mapValues((Function1)((JFunction1)arg_0 -> DottyLanguageServer.$anonfun$5(ctx, newName, arg_0)));
            workspaceEdit = new WorkspaceEdit((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)changes).asJava());
        }
        return workspaceEdit;
    }

    private static DocumentHighlight documentHighlight$$anonfun$1$$anonfun$1(Contexts.Context ctx$8, SourceTree ref) {
        return new DocumentHighlight(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx$8)), DocumentHighlightKind.Read);
    }

    private java.util.List documentHighlight$$anonfun$1(TextDocumentPositionParams params$6, CancelChecker cancelToken) {
        java.util.List list;
        Symbols.Symbol sym;
        URI uri = new URI(params$6.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$6.getPosition());
        List uriTrees = (List)driver.openedTrees().apply((Object)uri);
        Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol(uriTrees, pos, ctx);
        Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
        if (!(symbol == null ? noSymbol$ != null : !symbol.equals(noSymbol$))) {
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
        } else {
            List refs = Interactive$.MODULE$.namedTrees(uriTrees, true, true, sym, ctx);
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.documentHighlight$$anonfun$1$$anonfun$1(ctx, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    private Hover hover$$anonfun$1(TextDocumentPositionParams params$7, CancelChecker cancelToken) {
        Hover hover;
        Types.Type tpw;
        URI uri = new URI(params$7.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$7.getPosition());
        Types.Type tp = Interactive$.MODULE$.enclosingType((List)driver.openedTrees().apply((Object)uri), pos, ctx);
        Types.Type type = tpw = tp.widenTermRefExpr(ctx);
        Types.NoType$ noType$ = Types.NoType$.MODULE$;
        if (!(type == null ? noType$ != null : !type.equals(noType$))) {
            hover = new Hover();
        } else {
            String str = tpw.show(ctx).toString();
            hover = new Hover((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{Either.forLeft((Object)str)}))).asJava(), null);
        }
        return hover;
    }

    private static boolean $anonfun$6(Trees.NameTree _$2) {
        return true;
    }

    private static SymbolInformation documentSymbol$$anonfun$1$$anonfun$1(Contexts.Context ctx$9, SourceTree d) {
        return DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx$9), d.namePos(ctx$9), ctx$9);
    }

    private java.util.List documentSymbol$$anonfun$1(DocumentSymbolParams params$8, CancelChecker cancelToken) {
        URI uri = new URI(params$8.getTextDocument().getUri());
        InteractiveDriver driver = this.driverFor(uri);
        Contexts.Context ctx = driver.currentCtx();
        List uriTrees = (List)driver.openedTrees().apply((Object)uri);
        List defs = Interactive$.MODULE$.namedTrees(uriTrees, false, (Function1)((JFunction1)DottyLanguageServer::$anonfun$6), ctx);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.documentSymbol$$anonfun$1$$anonfun$1(ctx, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
    }

    public static SymbolInformation dotty$tools$languageserver$DottyLanguageServer$symbol$$anonfun$1$$anonfun$1$$symbol$$anonfun$1$$anonfun$1$$anonfun$1$1(Contexts.Context ctx$10, SourceTree d) {
        return DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx$10), d.namePos(ctx$10), ctx$10);
    }

    private static GenTraversableOnce symbol$$anonfun$1$$anonfun$1(String query$1, InteractiveDriver driver) {
        Contexts.Context ctx = driver.currentCtx();
        List trees = driver.allTrees(ctx);
        List defs = Interactive$.MODULE$.namedTrees(trees, false, query$1, ctx);
        return (GenTraversableOnce)defs.map((Function1)((JFunction1)arg_0 -> DottyLanguageServer.dotty$tools$languageserver$DottyLanguageServer$symbol$$anonfun$1$$anonfun$1$$symbol$$anonfun$1$$anonfun$1$$anonfun$1$1(ctx, arg_0)), List$.MODULE$.canBuildFrom());
    }

    private java.util.List symbol$$anonfun$1(WorkspaceSymbolParams params$9, CancelChecker cancelToken) {
        String query = params$9.getQuery();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.drivers().values().toList().flatMap((Function1)((JFunction1)arg_0 -> DottyLanguageServer.symbol$$anonfun$1$$anonfun$1(query, arg_0)), List$.MODULE$.canBuildFrom())).asJava();
    }
}

