/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.Positions$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import java.net.URI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public final class DottyLanguageServer$ {
    public static final DottyLanguageServer$ MODULE$;

    static {
        new DottyLanguageServer$();
    }

    public DottyLanguageServer$() {
        MODULE$ = this;
    }

    public final String IDE_CONFIG_FILE() {
        return ".dotty-ide.json";
    }

    public SourcePosition sourcePosition(InteractiveDriver driver, URI uri, Position pos) {
        NoSourcePosition$ noSourcePosition$;
        SourceFile source = (SourceFile)driver.openedFiles().apply((Object)uri);
        if (source.exists()) {
            long p = Positions$.MODULE$.Position(source.lineToOffset(pos.getLine()) + pos.getCharacter());
            noSourcePosition$ = new SourcePosition(source, p, (SourcePosition)SourcePosition$.MODULE$.$lessinit$greater$default$3());
        } else {
            noSourcePosition$ = NoSourcePosition$.MODULE$;
        }
        return noSourcePosition$;
    }

    public Range range(SourcePosition p) {
        return new Range(new Position(p.startLine(), p.startColumn()), new Position(p.endLine(), p.endColumn()));
    }

    public Location location(SourcePosition p) {
        return new Location(InteractiveDriver$.MODULE$.toUri(p.source()).toString(), this.range(p));
    }

    public Option<Diagnostic> diagnostic(MessageContainer mc) {
        None$ none$;
        if (!mc.pos().exists()) {
            none$ = None$.MODULE$;
        } else {
            String code = ((Object)BoxesRunTime.boxToInteger((int)mc.contained().errorId().errorNumber())).toString();
            none$ = Some$.MODULE$.apply((Object)new Diagnostic(this.range(mc.pos()), mc.message(), this.severity$1(mc.level()), "", code));
        }
        return none$;
    }

    public CompletionItem completionItem(Symbols.Symbol sym, Contexts.Context ctx) {
        String label = sym.name(ctx).show(ctx).toString();
        CompletionItem item = new CompletionItem(label);
        item.setDetail(Symbols$.MODULE$.toDenot(sym, ctx).info(ctx).widenTermRefExpr(ctx).show(ctx).toString());
        item.setKind(this.completionItemKind$1(sym, ctx));
        return item;
    }

    public SymbolInformation symbolInfo(Symbols.Symbol sym, SourcePosition pos, Contexts.Context ctx) {
        String name = sym.name(ctx).show(ctx).toString();
        String containerName = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx).owner(), ctx).exists() && !Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx).owner(), ctx).isEmptyPackage(ctx) ? Symbols$.MODULE$.toDenot(sym, ctx).owner().name(ctx).show(ctx).toString() : null;
        return new SymbolInformation(name, this.symbolKind$1(sym, ctx), this.location(pos), containerName);
    }

    private DiagnosticSeverity severity$1(int level) {
        DiagnosticSeverity diagnosticSeverity;
        int n = level;
        switch (n) {
            case 0: {
                diagnosticSeverity = DiagnosticSeverity.Information;
                break;
            }
            case 1: {
                diagnosticSeverity = DiagnosticSeverity.Warning;
                break;
            }
            case 2: {
                diagnosticSeverity = DiagnosticSeverity.Error;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return diagnosticSeverity;
    }

    private CompletionItemKind completionItemKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) ? CompletionItemKind.Module : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? CompletionItemKind.Constructor : (sym.isClass() ? CompletionItemKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? CompletionItemKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? CompletionItemKind.Method : CompletionItemKind.Field))));
    }

    private SymbolKind symbolKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        return Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) ? SymbolKind.Package : (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor() ? SymbolKind.Constructor : (sym.isClass() ? SymbolKind.Class : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx) ? SymbolKind.Variable : (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx) ? SymbolKind.Method : SymbolKind.Field))));
    }
}

