/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import dotty.DottyPredef$;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.config.Printers$;
import dotty.tools.dotc.core.Comments;
import dotty.tools.dotc.core.Comments$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.NameOps;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.interactive.Interactive;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.Positions;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.languageserver.DottyLanguageServer;
import dotty.tools.languageserver.DottyLanguageServer$;
import dotty.tools.languageserver.Memory$;
import dotty.tools.languageserver.config.ProjectConfig;
import java.io.File;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class DottyLanguageServer
implements LanguageServer,
LanguageClientAware,
TextDocumentService,
WorkspaceService {
    private String rootUri;
    private LanguageClient client;
    private scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> myDrivers;

    public static String IDE_CONFIG_FILE() {
        return DottyLanguageServer$.MODULE$.IDE_CONFIG_FILE();
    }

    public static SourcePosition sourcePosition(InteractiveDriver interactiveDriver, URI uRI, Position position) {
        return DottyLanguageServer$.MODULE$.sourcePosition(interactiveDriver, uRI, position);
    }

    public static CompletionItem completionItem(Symbols.Symbol symbol, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.completionItem(symbol, context);
    }

    public static Range range(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.range(sourcePosition);
    }

    public static Option<Diagnostic> diagnostic(MessageContainer messageContainer) {
        return DottyLanguageServer$.MODULE$.diagnostic(messageContainer);
    }

    public static Location location(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.location(sourcePosition);
    }

    public static SymbolInformation symbolInfo(Symbols.Symbol symbol, SourcePosition sourcePosition, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.symbolInfo(symbol, sourcePosition, context);
    }

    public Map<ProjectConfig, InteractiveDriver> drivers() {
        scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> map;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            if (this.myDrivers == null) {
                boolean assertion;
                boolean bl = assertion = this.rootUri != null;
                if (!assertion) {
                    DottyPredef$.MODULE$.assertFail(DottyLanguageServer::drivers$$anonfun$1);
                }
                File configFile = new File(new URI(this.rootUri + '/' + ".dotty-ide.json"));
                List configs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ObjectMapper().readValue(configFile, ProjectConfig[].class))).toList();
                List defaultFlags = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never"}));
                this.myDrivers = new HashMap();
                configs.foreach((Function1)((JProcedure1)config -> {
                    List settings = (List)((SeqLike)defaultFlags.$plus$plus((GenTraversableOnce)DottyLanguageServer.updateDeco$1(DottyLanguageServer.updateDeco$1(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.compilerArguments)).toList()).update("-classpath", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.dependencyClasspath)).$plus$colon((Object)config.classDirectory, ClassTag$.MODULE$.apply(File.class)))).mkString(File.pathSeparator))).update("-sourcepath", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories)).mkString(File.pathSeparator)), List$.MODULE$.canBuildFrom())).$colon$plus((Object)"-scansource", List$.MODULE$.canBuildFrom());
                    this.myDrivers.update(config, (Object)new InteractiveDriver(settings));
                }));
            }
            map = this.myDrivers;
        }
        return (Map)map;
    }

    private void restart() {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            BoxedUnit boxedUnit;
            Printers$.MODULE$.interactiv().println(DottyLanguageServer::restart$$anonfun$1);
            List driverConfigs = (List)this.myDrivers.toList().withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ProjectConfig config = (ProjectConfig)tuple2._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).map((Function1)((JFunction1)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ProjectConfig config = (ProjectConfig)tuple2._1();
                InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                return Tuple3$.MODULE$.apply((Object)config, (Object)new InteractiveDriver(driver.settings()), (Object)driver.openedFiles());
            }), List$.MODULE$.canBuildFrom());
            driverConfigs.withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    ProjectConfig config = (ProjectConfig)tuple3._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).foreach((Function1)((JProcedure1)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                ProjectConfig config = (ProjectConfig)tuple3._1();
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                this.myDrivers.update((Object)config, (Object)driver);
            }));
            System.gc();
            driverConfigs.withFilter((Function1)((JFunction1)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    Map opened = (Map)tuple3._3();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            })).foreach((Function1)((JProcedure1)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                Map opened = (Map)tuple3._3();
                opened.withFilter((Function1)((JFunction1)x$1 -> {
                    boolean bl;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        URI uri = (URI)tuple2._1();
                        SourceFile source = (SourceFile)tuple2._2();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                })).foreach((Function1)((JFunction1)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    URI uri = (URI)tuple2._1();
                    SourceFile source = (SourceFile)tuple2._2();
                    return driver.run(uri, source);
                }));
            }));
            if (Memory$.MODULE$.isCritical()) {
                StringContext $1$ = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: Insufficient memory to run Scala language server on these projects."}));
                Predef$.MODULE$.println((Object)$1$.s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Object checkMemory() {
        return Memory$.MODULE$.isCritical() ? CompletableFutures.computeAsync(this::checkMemory$$anonfun$adapted$1) : BoxedUnit.UNIT;
    }

    public InteractiveDriver driverFor(URI uri) {
        InteractiveDriver interactiveDriver;
        Option matchingConfig = this.drivers().keys().find((Function1)((JFunction1)config -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories)).exists((Function1)((JFunction1)sourceDir -> new File(uri.getPath()).getCanonicalPath().startsWith(sourceDir.getCanonicalPath())))));
        Option option = matchingConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProjectConfig config2 = (ProjectConfig)some.value();
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config2);
        } else if (None$.MODULE$.equals(option)) {
            ProjectConfig config3 = (ProjectConfig)this.drivers().keys().head();
            Predef$.MODULE$.println((Object)("No configuration contains " + uri + " as a source file, arbitrarily choosing " + config3.id));
            interactiveDriver = (InteractiveDriver)this.drivers().apply((Object)config3);
        } else {
            throw new MatchError((Object)option);
        }
        return interactiveDriver;
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        System.exit(0);
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(new Object());
    }

    private <R> CompletableFuture<R> computeAsync(Function1<CancelChecker, R> fun) {
        return CompletableFutures.computeAsync(cancelToken -> {
            Object object;
            DottyLanguageServer dottyLanguageServer = this;
            synchronized (dottyLanguageServer) {
                cancelToken.checkCanceled();
                this.checkMemory();
                object = DottyLanguageServer.liftedTree1$1(fun, cancelToken);
            }
            return object;
        });
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            boolean assertion;
            this.rootUri = params.getRootUri();
            boolean bl = assertion = this.rootUri != null;
            if (!assertion) {
                DottyPredef$.MODULE$.assertFail();
            }
            ServerCapabilities c = new ServerCapabilities();
            c.setTextDocumentSync(TextDocumentSyncKind.Full);
            c.setDocumentHighlightProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(false), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"."}))).asJava()));
            CompletableFuture.supplyAsync(() -> this.drivers()).exceptionally(ex -> {
                ex.printStackTrace();
                return scala.sys.package$.MODULE$.exit(1);
            });
            return new InitializeResult(c);
        }));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            this.checkMemory();
            TextDocumentItem document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            String text = document.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)mc -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic((MessageContainer)mc))), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            boolean assertion;
            this.checkMemory();
            VersionedTextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            TextDocumentContentChangeEvent change = (TextDocumentContentChangeEvent)params.getContentChanges().get(0);
            boolean bl = assertion = change.getRange() == null;
            if (!assertion) {
                DottyPredef$.MODULE$.assertFail(DottyLanguageServer::didChange$$anonfun$1);
            }
            String text = change.getText();
            List diags = driver.run(uri, text);
            this.client.publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1)((JFunction1)mc -> Option$.MODULE$.option2Iterable(DottyLanguageServer$.MODULE$.diagnostic((MessageContainer)mc))), List$.MODULE$.canBuildFrom())).asJava()));
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            TextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            this.driverFor(uri).close(uri);
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            Nil$ nil$;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Option option = driver.compilationUnits().get((Object)uri);
            if (option instanceof Some) {
                Some some = (Some)option;
                CompilationUnit unit = (CompilationUnit)some.value();
                nil$ = (List)Interactive$.MODULE$.completions(pos, (Contexts.Context)ctx.fresh().setCompilationUnit(unit))._2();
            } else if (None$.MODULE$.equals(option)) {
                nil$ = package$.MODULE$.Nil();
            } else {
                throw new MatchError((Object)option);
            }
            Nil$ items = nil$;
            return Either.forRight((Object)new CompletionList(false, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)items.map((Function1)((JFunction1)sym -> DottyLanguageServer$.MODULE$.completionItem((Symbols.Symbol)sym, ctx)), List$.MODULE$.canBuildFrom())).asJava()));
        }));
    }

    public CompletableFuture<java.util.List<? extends Location>> definition(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            java.util.List list;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Trees.Tree enclTree = Interactive$.MODULE$.enclosingTree((List)driver.openedTrees().apply((Object)uri), pos, ctx);
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.sourceSymbol(enclTree.symbol(ctx), ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
            } else {
                Tuple2 tuple2;
                if (enclTree instanceof Trees.MemberDef) {
                    Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                    tuple2 = Tuple2$.MODULE$.apply((Object)driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(name).toString(), ctx), (Object)BoxesRunTime.boxToInteger((int)(Interactive.Include$.MODULE$.overriding() | Interactive.Include$.MODULE$.overridden())));
                } else {
                    Symbols.Symbol symbol2 = Symbols$.MODULE$.toDenot(sym, ctx).topLevelClass(ctx);
                    if (symbol2 instanceof Symbols.ClassSymbol) {
                        Symbols.ClassSymbol classSymbol;
                        Symbols.ClassSymbol cls = classSymbol = (Symbols.ClassSymbol)symbol2;
                        tuple2 = Tuple2$.MODULE$.apply((Object)SourceTree$.MODULE$.fromSymbol(cls, SourceTree$.MODULE$.fromSymbol$default$2(), ctx).toList(), (Object)BoxesRunTime.boxToInteger((int)Interactive.Include$.MODULE$.overriding()));
                    } else {
                        tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)BoxesRunTime.boxToInteger((int)Interactive.Include$.MODULE$.overriding()));
                    }
                }
                Tuple2 tuple22 = tuple2;
                List trees = (List)tuple22._1();
                int include = BoxesRunTime.unboxToInt((Object)tuple22._2());
                List defs = Interactive$.MODULE$.namedTrees(trees, include, sym, ctx);
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.map((Function1)((JFunction1)d -> DottyLanguageServer$.MODULE$.location(d.namePos(ctx))), List$.MODULE$.canBuildFrom())).asJava();
            }
            return list;
        }));
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            java.util.List list;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            boolean includeDeclaration = params.getContext().isIncludeDeclaration();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
            } else {
                Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                List trees = driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(name).toString(), ctx);
                List refs = Interactive$.MODULE$.namedTrees(trees, true, (Function1)((JFunction1)tree -> (includeDeclaration || !Interactive$.MODULE$.isDefinition((Trees.Tree)tree)) && Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, sym, Interactive.Include$.MODULE$.overriding(), ctx)), ctx);
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.map((Function1)((JFunction1)ref -> DottyLanguageServer$.MODULE$.location(ref.namePos(ctx))), List$.MODULE$.canBuildFrom())).asJava();
            }
            return list;
        }));
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            WorkspaceEdit workspaceEdit;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol((List)driver.openedTrees().apply((Object)uri), pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                workspaceEdit = new WorkspaceEdit();
            } else {
                Names.Name name = NameOps$.MODULE$.NameDecorator(sym.name(ctx));
                List trees = driver.allTreesContaining(NameOps.NameDecorator$.MODULE$.sourceModuleName$extension(name).toString(), ctx);
                Symbols.Symbol linkedSym = Symbols$.MODULE$.toDenot(sym, ctx).linkedClass(ctx);
                String newName = params.getNewName();
                List refs = Interactive$.MODULE$.namedTrees(trees, true, (Function1)((JFunction1)tree -> {
                    if (!Positions.Position$.MODULE$.isSourceDerived$extension(tree.pos())) return false;
                    if (Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, sym, Interactive.Include$.MODULE$.overriding(), ctx)) return true;
                    Symbols.Symbol symbol = linkedSym;
                    Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
                    if (symbol == null) {
                        if (noSymbol$ == null) return false;
                    } else if (symbol.equals(noSymbol$)) return false;
                    if (!Interactive$.MODULE$.matchSymbol((Trees.Tree)tree, linkedSym, Interactive.Include$.MODULE$.overriding(), ctx)) return false;
                    return true;
                }), ctx);
                scala.collection.immutable.Map changes = refs.groupBy((Function1)((JFunction1)ref -> InteractiveDriver$.MODULE$.toUri(ref.source()).toString())).mapValues((Function1)((JFunction1)_$2 -> (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)_$2.map((Function1)((JFunction1)ref -> new TextEdit(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx)), newName)), List$.MODULE$.canBuildFrom())).asJava()));
                workspaceEdit = new WorkspaceEdit((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)changes).asJava());
            }
            return workspaceEdit;
        }));
    }

    public CompletableFuture<java.util.List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            java.util.List list;
            Symbols.Symbol sym;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            Symbols.Symbol symbol = sym = Interactive$.MODULE$.enclosingSourceSymbol(uriTrees, pos, ctx);
            Symbols.NoSymbol$ noSymbol$ = Symbols.NoSymbol$.MODULE$;
            if (!(symbol != null ? !symbol.equals(noSymbol$) : noSymbol$ != null)) {
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Nil()).asJava();
            } else {
                List refs = Interactive$.MODULE$.namedTrees(uriTrees, Interactive.Include$.MODULE$.references() | Interactive.Include$.MODULE$.overriding(), sym, ctx);
                list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.withFilter((Function1)((JFunction1)ref -> ref.namePos(ctx).exists())).map((Function1)((JFunction1)ref -> new DocumentHighlight(DottyLanguageServer$.MODULE$.range(ref.namePos(ctx)), DocumentHighlightKind.Read)), List$.MODULE$.canBuildFrom())).asJava();
            }
            return list;
        }));
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            Hover hover;
            Types.Type tpw;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List trees = (List)driver.openedTrees().apply((Object)uri);
            Types.Type tp = Interactive$.MODULE$.enclosingType(trees, pos, ctx);
            Types.Type type = tpw = tp.widenTermRefExpr(ctx);
            Types.NoType$ noType$ = Types.NoType$.MODULE$;
            if (!(type != null ? !type.equals(noType$) : noType$ != null)) {
                hover = new Hover();
            } else {
                Symbols.Symbol symbol = Interactive$.MODULE$.enclosingSourceSymbol(trees, pos, ctx);
                Option docComment = Comments.CommentsContext$.MODULE$.docCtx$extension(Comments$.MODULE$.CommentsContext(ctx)).flatMap((Function1)((JFunction1)_$3 -> _$3.docstring(symbol)));
                List<MarkedString> markedStrings = DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$docMarkedStrings((Option<Comments.Comment>)docComment, tpw.show(ctx).toString());
                hover = new Hover((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)markedStrings.map((Function1)((JFunction1)_$4 -> Either.forRight((Object)_$4)), List$.MODULE$.canBuildFrom())).asJava(), null);
            }
            return hover;
        }));
    }

    public CompletableFuture<java.util.List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            Contexts.Context ctx = driver.currentCtx();
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            List defs = Interactive$.MODULE$.namedTrees(uriTrees, false, (Function1)((JFunction1)_$5 -> true), ctx);
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.map((Function1)((JFunction1)d -> DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx), d.namePos(ctx), ctx)), List$.MODULE$.canBuildFrom())).asJava();
        }));
    }

    public CompletableFuture<java.util.List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return this.computeAsync((Function1)((JFunction1)cancelToken -> {
            String query = params.getQuery();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.drivers().values().toList().flatMap((Function1)((JFunction1)driver -> {
                Contexts.Context ctx = driver.currentCtx();
                List trees = driver.allTrees(ctx);
                List defs = Interactive$.MODULE$.namedTrees(trees, false, query, ctx);
                return (GenTraversableOnce)defs.map((Function1)((JFunction1)d -> DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(ctx), d.namePos(ctx), ctx)), List$.MODULE$.canBuildFrom());
            }), List$.MODULE$.canBuildFrom())).asJava();
        }));
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public CompletableFuture<java.util.List<? extends Command>> codeAction(CodeActionParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return null;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens params) {
        return null;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem params) {
        return null;
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        return null;
    }

    private static String drivers$$anonfun$1() {
        return "`drivers` cannot be called before `initialize`";
    }

    private static updateDeco.1 updateDeco$1(List ss) {
        return new updateDeco.1(ss);
    }

    private static String restart$$anonfun$1() {
        return "restarting presentation compiler";
    }

    private /* synthetic */ void checkMemory$$anonfun$1(CancelChecker _$1) {
        this.restart();
    }

    private Object checkMemory$$anonfun$adapted$1(CancelChecker _$1) {
        this.checkMemory$$anonfun$1(_$1);
        return BoxedUnit.UNIT;
    }

    private static Object liftedTree1$1(Function1 fun$2, CancelChecker cancelToken$1) {
        Object object;
        try {
            object = fun$2.apply((Object)cancelToken$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                ex.printStackTrace();
                throw ex;
            }
            throw throwable;
        }
        return object;
    }

    private static String didChange$$anonfun$1() {
        return "TextDocumentSyncKind.Incremental support is not implemented";
    }
}

