/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public final class ModuleSerializationProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> moduleClass;
    private static final ClassValue<Object> instances = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> clazz) {
            try {
                return AccessController.doPrivileged(() -> clazz.getField("MODULE$").get(null));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return ModuleSerializationProxy.rethrowRuntime(privilegedActionException.getCause());
            }
        }
    };

    private static Object rethrowRuntime(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw new RuntimeException(throwable2);
    }

    public ModuleSerializationProxy(Class<?> clazz) {
        this.moduleClass = clazz;
    }

    private Object readResolve() {
        return instances.get(this.moduleClass);
    }
}

