package scala.tasty.reflect

trait FlagsOps extends Core {

  given (self: Flags) {

    /** Is the given flag set a subset of this flag sets */
    def is(that: Flags): Boolean = internal.Flags_is(self)(that)

    /** Union of the two flag sets */
    def |(that: Flags): Flags = internal.Flags_or(self)(that)

    /** Intersection of the two flag sets */
    def &(that: Flags): Flags = internal.Flags_and(self)(that)

  }

  object Flags {

    /** The empty set of flags */
    def EmptyFlags = internal.Flags_EmptyFlags

    /** Is this symbol `private` */
    def Private: Flags = internal.Flags_Private

    /** Is this symbol `protected` */
    def Protected: Flags = internal.Flags_Protected

    /** Is this symbol `abstract` */
    def Abstract: Flags = internal.Flags_Abstract

    /** Is this symbol `final` */
    def Final: Flags = internal.Flags_Final

    /** Is this symbol `sealed` */
    def Sealed: Flags = internal.Flags_Sealed

    /** Is this symbol `case` */
    def Case: Flags = internal.Flags_Case

    /** Is this symbol `implicit` */
    def Implicit: Flags = internal.Flags_Implicit

    /** Is this symbol an inferable ("given") parameter */
    def Given: Flags = internal.Flags_Given

     /** Is this symbol `erased` */
    def Erased: Flags = internal.Flags_Erased

    /** Is this symbol `lazy` */
    def Lazy: Flags = internal.Flags_Lazy

    /** Is this symbol `override` */
    def Override: Flags = internal.Flags_Override

    /** Is this symbol `inline` */
    def Inline: Flags = internal.Flags_Inline

    /** Is this symbol markes as a macro. An inline method containing toplevel splices */
    def Macro: Flags = internal.Flags_Macro

    /** Is this symbol marked as static. Mapped to static Java member */
    def Static: Flags = internal.Flags_Static

    /** Is this symbol defined in a Java class */
    def JavaDefined: Flags = internal.Flags_JavaDefined

    /** Is this symbol an object or its class (used for a ValDef or a ClassDef extends Modifier respectively) */
    def Object: Flags = internal.Flags_Object

    /** Is this symbol a trait */
    def Trait: Flags = internal.Flags_Trait

    /** Is this symbol local? Used in conjunction with private/private[Type] to mean private[this] extends Modifier proctected[this] */
    def Local: Flags = internal.Flags_Local

    /** Was this symbol generated by Scala compiler */
    def Synthetic: Flags = internal.Flags_Synthetic

    /** Is this symbol to be tagged Java Synthetic */
    def Artifact: Flags = internal.Flags_Artifact

    /** Is this symbol a `var` (when used on a ValDef) */
    def Mutable: Flags = internal.Flags_Mutable

    /** Is this symbol a getter or a setter */
    def FieldAccessor: Flags = internal.Flags_FieldAccessor

    /** Is this symbol a getter for case class parameter */
    def CaseAcessor: Flags = internal.Flags_CaseAcessor

    /** Is this symbol a type parameter marked as covariant `+` */
    def Covariant: Flags = internal.Flags_Covariant

    /** Is this symbol a type parameter marked as contravariant `-` */
    def Contravariant: Flags = internal.Flags_Contravariant

    /** Was this symbol imported from Scala2.x */
    def Scala2X: Flags = internal.Flags_Scala2X

    /** Is this symbol a method with default parameters */
    def DefaultParameterized: Flags = internal.Flags_DefaultParameterized

    /** Is this symbol member that is assumed to be stable and realizable */
    def StableRealizable: Flags = internal.Flags_StableRealizable

    /** Is this symbol a parameter */
    def Param: Flags = internal.Flags_Param

    /** Is this symbol a parameter accessor */
    def ParamAccessor: Flags = internal.Flags_ParamAccessor

    /** Is this symbol an enum */
    def Enum: Flags = internal.Flags_Enum

    /** Is this symbol a module class */
    def ModuleClass: Flags = internal.Flags_ModuleClass

    /** Is this symbol labeled private[this] */
    def PrivateLocal: Flags = internal.Flags_PrivateLocal

    /** Is this symbol a package */
    def Package: Flags = internal.Flags_Package
  }

}
