/*
 * Decompiled with CFR 0.152.
 */
package dotty.runtime.vc;

import dotty.runtime.vc.VCArrayPrototype;
import dotty.runtime.vc.VCDoubleCompanion;
import dotty.runtime.vc.VCDoublePrototype;

public final class VCDoubleArray<T extends VCDoublePrototype>
extends VCArrayPrototype<T> {
    private final double[] arr;
    private final VCDoubleCompanion ct;

    private <T extends VCDoublePrototype> VCDoubleArray(double[] arr, VCDoubleCompanion<T> ct) {
        this.arr = arr;
        this.ct = ct;
    }

    public double[] arr() {
        return this.arr;
    }

    public VCDoubleCompanion<T> ct() {
        return this.ct;
    }

    public <T extends VCDoublePrototype> VCDoubleArray(VCDoubleCompanion<T> ct, int sz) {
        this(new double[sz], ct);
    }

    @Override
    public Object apply(int idx) {
        return this.ct().box(this.arr()[idx]);
    }

    @Override
    public void update(int idx, T elem) {
        this.arr()[idx] = this.ct().unbox(elem);
    }

    @Override
    public int length() {
        return this.arr().length;
    }

    @Override
    public VCDoubleArray<T> clone() {
        return new VCDoubleArray<T>((double[])this.arr().clone(), this.ct());
    }

    public String toString() {
        return "[" + this.ct().runtimeClass();
    }
}

