/*
 * Decompiled with CFR 0.152.
 */
package dotty.runtime.vc;

import dotty.runtime.vc.VCArrayPrototype;
import dotty.runtime.vc.VCByteCompanion;
import dotty.runtime.vc.VCBytePrototype;

public final class VCByteArray<T extends VCBytePrototype>
extends VCArrayPrototype<T> {
    private final byte[] arr;
    private final VCByteCompanion ct;

    private <T extends VCBytePrototype> VCByteArray(byte[] arr, VCByteCompanion<T> ct) {
        this.arr = arr;
        this.ct = ct;
    }

    public byte[] arr() {
        return this.arr;
    }

    public VCByteCompanion<T> ct() {
        return this.ct;
    }

    public <T extends VCBytePrototype> VCByteArray(VCByteCompanion<T> ct, int sz) {
        this(new byte[sz], ct);
    }

    @Override
    public Object apply(int idx) {
        return this.ct().box(this.arr()[idx]);
    }

    @Override
    public void update(int idx, T elem) {
        this.arr()[idx] = this.ct().unbox(elem);
    }

    @Override
    public int length() {
        return this.arr().length;
    }

    @Override
    public VCByteArray<T> clone() {
        return new VCByteArray<T>((byte[])this.arr().clone(), this.ct());
    }

    public String toString() {
        return "[" + this.ct().runtimeClass();
    }
}

