/*
 * Decompiled with CFR 0.152.
 */
package dotty.runtime.vc;

import dotty.runtime.vc.VCArrayPrototype;
import dotty.runtime.vc.VCFloatCompanion;
import dotty.runtime.vc.VCFloatPrototype;

public final class VCFloatArray<T extends VCFloatPrototype>
extends VCArrayPrototype<T> {
    private final float[] arr;
    private final VCFloatCompanion ct;

    private <T extends VCFloatPrototype> VCFloatArray(float[] arr, VCFloatCompanion<T> ct) {
        this.arr = arr;
        this.ct = ct;
    }

    public float[] arr() {
        return this.arr;
    }

    public VCFloatCompanion<T> ct() {
        return this.ct;
    }

    public <T extends VCFloatPrototype> VCFloatArray(VCFloatCompanion<T> ct, int sz) {
        this(new float[sz], ct);
    }

    @Override
    public Object apply(int idx) {
        return this.ct().box(this.arr()[idx]);
    }

    @Override
    public void update(int idx, T elem) {
        this.arr()[idx] = this.ct().unbox(elem);
    }

    @Override
    public int length() {
        return this.arr().length;
    }

    @Override
    public VCFloatArray<T> clone() {
        return new VCFloatArray<T>((float[])this.arr().clone(), this.ct());
    }

    public String toString() {
        return "[" + this.ct().runtimeClass();
    }
}

