/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.AbstractReporter;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import java.io.File;
import java.util.Optional;
import xsbt.Problem;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.Severity;

public final class DelegatingReporter
extends AbstractReporter {
    private final Reporter delegate;
    private static final Position noPosition = new Position(){

        public Optional<File> sourceFile() {
            return Optional.empty();
        }

        public Optional<String> sourcePath() {
            return Optional.empty();
        }

        public Optional<Integer> line() {
            return Optional.empty();
        }

        public String lineContent() {
            return "";
        }

        public Optional<Integer> offset() {
            return Optional.empty();
        }

        public Optional<Integer> pointer() {
            return Optional.empty();
        }

        public Optional<String> pointerSpace() {
            return Optional.empty();
        }
    };

    public DelegatingReporter(Reporter reporter) {
        this.delegate = reporter;
    }

    public void printSummary(Contexts.Context context) {
        this.delegate.printSummary();
    }

    public void doReport(MessageContainer messageContainer, Contexts.Context context) {
        Position position;
        Object object;
        SourcePosition sourcePosition;
        Severity severity;
        switch (messageContainer.level()) {
            case 2: {
                severity = Severity.Error;
                break;
            }
            case 1: {
                severity = Severity.Warn;
                break;
            }
            case 0: {
                severity = Severity.Info;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad diagnostic level: " + messageContainer.level());
            }
        }
        if (messageContainer.pos().exists()) {
            sourcePosition = messageContainer.pos();
            object = sourcePosition.source();
            position = new Position((SourceFile)object, sourcePosition){
                final /* synthetic */ SourceFile val$src;
                final /* synthetic */ SourcePosition val$pos;
                {
                    this.val$src = sourceFile;
                    this.val$pos = sourcePosition;
                }

                public Optional<File> sourceFile() {
                    if (!this.val$src.exists()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(this.val$src.file().file());
                }

                public Optional<String> sourcePath() {
                    if (!this.val$src.exists()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(this.val$src.file().path());
                }

                public Optional<Integer> line() {
                    int n = this.val$pos.line();
                    if (n == -1) {
                        return Optional.empty();
                    }
                    return Optional.of(n);
                }

                public String lineContent() {
                    String string = this.val$pos.lineContent();
                    if (string.endsWith("\r\n")) {
                        return string.substring(0, string.length() - 2);
                    }
                    if (string.endsWith("\n") || string.endsWith("\f")) {
                        return string.substring(0, string.length() - 1);
                    }
                    return string;
                }

                public Optional<Integer> offset() {
                    return Optional.of(this.val$pos.point());
                }

                public Optional<Integer> pointer() {
                    if (!this.val$src.exists()) {
                        return Optional.empty();
                    }
                    return Optional.of(this.val$pos.point() - this.val$src.startOfLine(this.val$pos.point()));
                }

                public Optional<String> pointerSpace() {
                    if (!this.val$src.exists()) {
                        return Optional.empty();
                    }
                    String string = this.lineContent();
                    int n = this.pointer().get();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append(string.charAt(i) == '\t' ? (char)'\t' : ' ');
                    }
                    return Optional.of(stringBuilder.toString());
                }
            };
        } else {
            position = noPosition;
        }
        sourcePosition = messageContainer.contained();
        object = new StringBuilder();
        ((StringBuilder)object).append(this.messageAndPos((Message)sourcePosition, messageContainer.pos(), this.diagnosticLevel(messageContainer), context));
        boolean bl = new MessageContainer.MessageContext(context).shouldExplain(messageContainer);
        if (bl && !sourcePosition.explanation().isEmpty()) {
            ((StringBuilder)object).append(this.explanation((Message)sourcePosition, context));
        }
        this.delegate.log((xsbti.Problem)new Problem(position, sourcePosition.msg(), severity, ((StringBuilder)object).toString()));
    }
}

