/*
 * Decompiled with CFR 0.152.
 */
package dotty.tastydoc.comment;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import dotty.runtime.function.JFunction1;
import dotty.tastydoc.comment.Body;
import dotty.tastydoc.comment.Bold;
import dotty.tastydoc.comment.Bold$;
import dotty.tastydoc.comment.Chain;
import dotty.tastydoc.comment.Chain$;
import dotty.tastydoc.comment.HtmlParsers$;
import dotty.tastydoc.comment.HtmlParsers$BodyToMarkdown$;
import dotty.tastydoc.comment.HtmlParsers$InlineToMarkdown$;
import dotty.tastydoc.comment.HtmlParsers$MarkdownToHtml$;
import dotty.tastydoc.comment.HtmlParsers$StringToMarkdown$;
import dotty.tastydoc.comment.HtmlParsers$StringToWiki$;
import dotty.tastydoc.comment.HtmlTag;
import dotty.tastydoc.comment.HtmlTag$;
import dotty.tastydoc.comment.Inline;
import dotty.tastydoc.comment.Italic;
import dotty.tastydoc.comment.Italic$;
import dotty.tastydoc.comment.Link;
import dotty.tastydoc.comment.Link$;
import dotty.tastydoc.comment.LinkTo;
import dotty.tastydoc.comment.LinkToExternal;
import dotty.tastydoc.comment.LinkToExternal$;
import dotty.tastydoc.comment.LinkToRepresentation;
import dotty.tastydoc.comment.LinkToRepresentation$;
import dotty.tastydoc.comment.Monospace;
import dotty.tastydoc.comment.Monospace$;
import dotty.tastydoc.comment.RepresentationLink;
import dotty.tastydoc.comment.RepresentationLink$;
import dotty.tastydoc.comment.Subscript;
import dotty.tastydoc.comment.Subscript$;
import dotty.tastydoc.comment.Summary;
import dotty.tastydoc.comment.Summary$;
import dotty.tastydoc.comment.Superscript;
import dotty.tastydoc.comment.Superscript$;
import dotty.tastydoc.comment.Text;
import dotty.tastydoc.comment.Text$;
import dotty.tastydoc.comment.Tooltip;
import dotty.tastydoc.comment.Tooltip$;
import dotty.tastydoc.comment.Underline;
import dotty.tastydoc.comment.Underline$;
import dotty.tastydoc.comment.util.traversing$;
import dotty.tastydoc.representations;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HtmlParsers {
    public static Body BodyToMarkdown(Body body) {
        return HtmlParsers$.MODULE$.BodyToMarkdown(body);
    }

    public static Node MarkdownToHtml(Node node) {
        return HtmlParsers$.MODULE$.MarkdownToHtml(node);
    }

    public static Formatter RENDERER() {
        return HtmlParsers$.MODULE$.RENDERER();
    }

    public static String StringToMarkdown(String string) {
        return HtmlParsers$.MODULE$.StringToMarkdown(string);
    }

    public static String StringToWiki(String string) {
        return HtmlParsers$.MODULE$.StringToWiki(string);
    }

    public static DataHolder markdownOptions() {
        return HtmlParsers$.MODULE$.markdownOptions();
    }

    public static final class BodyToMarkdown {
        private final Body body;

        public static boolean equals$extension(Body body, Object object) {
            return HtmlParsers$BodyToMarkdown$.MODULE$.equals$extension(body, object);
        }

        public static int hashCode$extension(Body body) {
            return HtmlParsers$BodyToMarkdown$.MODULE$.hashCode$extension(body);
        }

        public static String show$extension(Body body, representations.Representation representation) {
            return HtmlParsers$BodyToMarkdown$.MODULE$.show$extension(body, representation);
        }

        public BodyToMarkdown(Body body) {
            this.body = body;
        }

        public int hashCode() {
            return HtmlParsers$BodyToMarkdown$.MODULE$.hashCode$extension(this.body());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$BodyToMarkdown$.MODULE$.equals$extension(this.body(), x$0);
        }

        public Body body() {
            return this.body;
        }

        public String show(representations.Representation origin) {
            return HtmlParsers$BodyToMarkdown$.MODULE$.show$extension(this.body(), origin);
        }
    }

    public static class InlineToMarkdown
    implements Product,
    Serializable {
        private final representations.Representation origin;

        public static <A> Function1<representations.Representation, A> andThen(Function1<InlineToMarkdown, A> function1) {
            return HtmlParsers$InlineToMarkdown$.MODULE$.andThen(function1);
        }

        public static <A> Function1<A, InlineToMarkdown> compose(Function1<A, representations.Representation> function1) {
            return HtmlParsers$InlineToMarkdown$.MODULE$.compose(function1);
        }

        public static InlineToMarkdown fromProduct(Product product) {
            return HtmlParsers$InlineToMarkdown$.MODULE$.fromProduct(product);
        }

        public static InlineToMarkdown unapply(InlineToMarkdown inlineToMarkdown) {
            return HtmlParsers$InlineToMarkdown$.MODULE$.unapply(inlineToMarkdown);
        }

        public InlineToMarkdown(representations.Representation origin) {
            this.origin = origin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InlineToMarkdown)) return false;
            InlineToMarkdown inlineToMarkdown = (InlineToMarkdown)object;
            representations.Representation representation = this.origin();
            representations.Representation representation2 = inlineToMarkdown.origin();
            if (representation != null) {
                if (!representation.equals(representation2)) return false;
                return true;
            }
            if (representation2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InlineToMarkdown;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InlineToMarkdown";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "origin";
        }

        public representations.Representation origin() {
            return this.origin;
        }

        public String apply(Inline inl) {
            return this.toMarkdown(inl);
        }

        public String relativePath(representations.Representation target) {
            return traversing$.MODULE$.relativePath(this.origin(), target);
        }

        public String toMarkdown(Inline inl2) {
            Some<Tuple2<Inline, LinkTo>> some;
            String string;
            Inline inline = inl2;
            if (inline instanceof Chain) {
                Seq<Inline> seq;
                Chain chain = Chain$.MODULE$.unapply((Chain)inline);
                Seq<Inline> items = seq = chain._1();
                string = ((IterableOnceOps)items.map((Function1)(JFunction1 & Serializable)inl -> this.toMarkdown((Inline)inl))).mkString();
            } else if (inline instanceof Italic) {
                Inline inline2;
                Italic italic = Italic$.MODULE$.unapply((Italic)inline);
                Inline in = inline2 = italic._1();
                string = "*" + this.toMarkdown(in) + "*";
            } else if (inline instanceof Bold) {
                Inline inline3;
                Bold bold = Bold$.MODULE$.unapply((Bold)inline);
                Inline in = inline3 = bold._1();
                string = "**" + this.toMarkdown(in) + "**";
            } else if (inline instanceof Underline) {
                Inline inline4;
                Underline underline = Underline$.MODULE$.unapply((Underline)inline);
                Inline in = inline4 = underline._1();
                string = "__" + this.toMarkdown(in) + "__";
            } else if (inline instanceof Superscript) {
                Inline inline5;
                Superscript superscript = Superscript$.MODULE$.unapply((Superscript)inline);
                Inline in = inline5 = superscript._1();
                string = "<sup>" + this.toMarkdown(in) + "</sup>";
            } else if (inline instanceof Subscript) {
                Inline inline6;
                Subscript subscript = Subscript$.MODULE$.unapply((Subscript)inline);
                Inline in = inline6 = subscript._1();
                string = "<sub>" + this.toMarkdown(in) + "</sub>";
            } else if (inline instanceof Link) {
                Link link = Link$.MODULE$.unapply((Link)inline);
                String string2 = link._1();
                Inline inline7 = link._2();
                String raw = string2;
                Inline title = inline7;
                string = "[" + this.toMarkdown(title) + "](" + raw + ")";
            } else if (inline instanceof Monospace) {
                Inline inline8;
                Monospace monospace = Monospace$.MODULE$.unapply((Monospace)inline);
                Inline in = inline8 = monospace._1();
                string = "`" + this.toMarkdown(in) + "`";
            } else if (inline instanceof Text) {
                String string3;
                String text;
                Text text2 = Text$.MODULE$.unapply((Text)inline);
                string = text = (string3 = text2._1());
            } else if (inline instanceof Summary) {
                Inline inline9;
                Summary summary = Summary$.MODULE$.unapply((Summary)inline);
                Inline in = inline9 = summary._1();
                string = this.toMarkdown(in);
            } else if (inline instanceof HtmlTag) {
                String string4;
                String tag;
                HtmlTag htmlTag = HtmlTag$.MODULE$.unapply((HtmlTag)inline);
                string = tag = (string4 = htmlTag._1());
            } else if (inline instanceof RepresentationLink && !(some = RepresentationLink$.MODULE$.unapply((RepresentationLink)inline)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)some.get();
                Inline target = (Inline)tuple2._1();
                LinkTo link = (LinkTo)tuple2._2();
                string = this.enityLinktoMarkdown(target, link);
            } else {
                throw new MatchError((Object)inline);
            }
            return string;
        }

        public String enityLinktoMarkdown(Inline target, LinkTo link) {
            LinkToRepresentation linkToRepresentation;
            representations.Representation representation;
            String string;
            LinkTo linkTo = link;
            if (linkTo instanceof Tooltip) {
                Tooltip tooltip = Tooltip$.MODULE$.unapply((Tooltip)linkTo);
                String string2 = tooltip._1();
                string = this.toMarkdown(target);
            } else if (linkTo instanceof LinkToExternal) {
                LinkToExternal linkToExternal = LinkToExternal$.MODULE$.unapply((LinkToExternal)linkTo);
                String string3 = linkToExternal._1();
                String string4 = linkToExternal._2();
                String n = string3;
                String url = string4;
                string = "[" + n + "](" + url + ")";
            } else if (linkTo instanceof LinkToRepresentation && (representation = (linkToRepresentation = LinkToRepresentation$.MODULE$.unapply((LinkToRepresentation)linkTo))._1()) != null) {
                representations.Representation t = representation;
                representations.Representation representation2 = t;
                if (representation2 != null && representation2 instanceof representations.Members) {
                    representations.Representation e = representation2;
                    string = "[" + this.toMarkdown(target) + "](" + this.relativePath(t) + ".md)";
                } else {
                    representations.Representation x = representation2;
                    string = (String)x.parentRepresentation().fold(() -> this.enityLinktoMarkdown$$anonfun$1(target), (Function1)(JFunction1 & Serializable)xpar -> "[" + this.toMarkdown(target) + "](" + this.relativePath((representations.Representation)xpar) + ".md#" + x.name() + ")");
                }
            } else {
                throw new MatchError((Object)linkTo);
            }
            return string;
        }

        public InlineToMarkdown copy(representations.Representation origin) {
            return new InlineToMarkdown(origin);
        }

        public representations.Representation copy$default$1() {
            return this.origin();
        }

        public representations.Representation _1() {
            return this.origin();
        }

        private final String enityLinktoMarkdown$$anonfun$1(Inline target$1) {
            return this.toMarkdown(target$1);
        }
    }

    public static final class MarkdownToHtml {
        private final Node markdown;

        public static boolean equals$extension(Node node, Object object) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.equals$extension(node, object);
        }

        public static int hashCode$extension(Node node) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.hashCode$extension(node);
        }

        public static String shortenAndShow$extension(Node node) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.shortenAndShow$extension(node);
        }

        public static String show$extension(Node node) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.show$extension(node);
        }

        public MarkdownToHtml(Node markdown) {
            this.markdown = markdown;
        }

        public int hashCode() {
            return HtmlParsers$MarkdownToHtml$.MODULE$.hashCode$extension(this.markdown());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$MarkdownToHtml$.MODULE$.equals$extension(this.markdown(), x$0);
        }

        public Node markdown() {
            return this.markdown;
        }

        public String show() {
            return HtmlParsers$MarkdownToHtml$.MODULE$.show$extension(this.markdown());
        }

        public String shortenAndShow() {
            return HtmlParsers$MarkdownToHtml$.MODULE$.shortenAndShow$extension(this.markdown());
        }
    }

    public static final class StringToMarkdown {
        private final String text;

        public static boolean equals$extension(String string, Object object) {
            return HtmlParsers$StringToMarkdown$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return HtmlParsers$StringToMarkdown$.MODULE$.hashCode$extension(string);
        }

        public static Node toMarkdown$extension(String string, representations.Representation representation, Map map) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdown$extension(string, representation, (Map<String, representations.EmulatedPackageRepresentation>)map);
        }

        public static String toMarkdownString$extension(String string, representations.Representation representation, Map map) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdownString$extension(string, representation, (Map<String, representations.EmulatedPackageRepresentation>)map);
        }

        public StringToMarkdown(String text) {
            this.text = text;
        }

        public int hashCode() {
            return HtmlParsers$StringToMarkdown$.MODULE$.hashCode$extension(this.text());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$StringToMarkdown$.MODULE$.equals$extension(this.text(), x$0);
        }

        public String text() {
            return this.text;
        }

        public Node toMarkdown(representations.Representation origin, Map<String, representations.EmulatedPackageRepresentation> packages) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdown$extension(this.text(), origin, packages);
        }

        public String toMarkdownString(representations.Representation origin, Map<String, representations.EmulatedPackageRepresentation> packages) {
            return HtmlParsers$StringToMarkdown$.MODULE$.toMarkdownString$extension(this.text(), origin, packages);
        }
    }

    public static final class StringToWiki {
        private final String text;

        public static boolean equals$extension(String string, Object object) {
            return HtmlParsers$StringToWiki$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return HtmlParsers$StringToWiki$.MODULE$.hashCode$extension(string);
        }

        public static Body toWiki$extension(String string, representations.Representation representation, Map map) {
            return HtmlParsers$StringToWiki$.MODULE$.toWiki$extension(string, representation, (Map<String, representations.EmulatedPackageRepresentation>)map);
        }

        public StringToWiki(String text) {
            this.text = text;
        }

        public int hashCode() {
            return HtmlParsers$StringToWiki$.MODULE$.hashCode$extension(this.text());
        }

        public boolean equals(Object x$0) {
            return HtmlParsers$StringToWiki$.MODULE$.equals$extension(this.text(), x$0);
        }

        public String text() {
            return this.text;
        }

        public Body toWiki(representations.Representation origin, Map<String, representations.EmulatedPackageRepresentation> packages) {
            return HtmlParsers$StringToWiki$.MODULE$.toWiki$extension(this.text(), origin, packages);
        }
    }
}

