/*
 * Decompiled with CFR 0.152.
 */
package dotty.tastydoc;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.runtime.function.JProcedure1;
import dotty.tastydoc.Md$;
import dotty.tastydoc.comment.Comment;
import dotty.tastydoc.references;
import dotty.tastydoc.references$AndTypeReference$;
import dotty.tastydoc.references$BoundsReference$;
import dotty.tastydoc.references$ByNameReference$;
import dotty.tastydoc.references$CompanionReference$;
import dotty.tastydoc.references$ConstantReference$;
import dotty.tastydoc.references$EmptyReference$;
import dotty.tastydoc.references$FunctionReference$;
import dotty.tastydoc.references$NamedReference$;
import dotty.tastydoc.references$OrTypeReference$;
import dotty.tastydoc.references$RefinedReference$;
import dotty.tastydoc.references$TupleReference$;
import dotty.tastydoc.references$TypeReference$;
import dotty.tastydoc.representations;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.package$;

public class DocPrinter {
    private final String userDocSyntax;
    private final List<String> packagesToLink;
    private final Map packagesMap;
    private final String folderPrefix;

    public DocPrinter(HashMap<String, representations.EmulatedPackageRepresentation> mutablePackagesMap, String userDocSyntax, List<String> packagesToLink) {
        this.userDocSyntax = userDocSyntax;
        this.packagesToLink = packagesToLink;
        this.packagesMap = mutablePackagesMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.folderPrefix = "tastydoc/documentation/";
    }

    public Map<String, representations.EmulatedPackageRepresentation> packagesMap() {
        return this.packagesMap;
    }

    private String htmlPreCode(String content, String language) {
        String string = language;
        String string2 = "";
        return "<pre><code" + ((string == null ? string2 != null : !string.equals(string2)) ? " class=\"language-" + language + "\" " : "") + ">" + content + "</pre></code>";
    }

    private String htmlPreCode$default$2() {
        return "";
    }

    private String makeLink(String label, String link, boolean hasOwnFile, List<String> declarationPath) {
        String string;
        String labelName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(label), "$");
        String packageFormLink = link.replaceFirst("/", "").replaceAll("/", ".");
        if (this.packagesToLink.exists((Function1)(JFunction1 & Serializable)_$1 -> packageFormLink.matches((String)_$1))) {
            String relativeLink;
            String string2 = link;
            String string3 = "";
            String string4 = !(string2 != null ? !string2.equals(string3) : string3 != null) ? (hasOwnFile ? (declarationPath.isEmpty() ? "." : declarationPath.map((Function1)(JFunction1 & Serializable)_$3 -> "..").mkString("/")) : "") : (relativeLink = DocPrinter.ascendPath$1(declarationPath, (List)Predef$.MODULE$.wrapRefArray((Object[])link.split("/")).toList().tail()));
            if (hasOwnFile) {
                string = "<a href=\"" + relativeLink + "/" + label + ".md\">" + labelName + "</a>";
            } else {
                String string5 = relativeLink;
                String string6 = "";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    string = labelName;
                } else {
                    String string7 = relativeLink;
                    String string8 = ".";
                    string = !(string7 != null ? !string7.equals(string8) : string8 != null) ? "<a href=\"#" + label + "\">" + labelName + "</a>" : "<a href=\"" + relativeLink + ".md#" + label + "\">" + labelName + "</a>";
                }
            }
        } else {
            string = labelName;
        }
        return string;
    }

    private String formatReferences(references.Reference reference, List<String> declarationPath) {
        String string;
        references.Reference reference2 = reference;
        if (reference2 instanceof references.CompanionReference) {
            references.CompanionReference companionReference = references$CompanionReference$.MODULE$.unapply((references.CompanionReference)reference2);
            String string2 = companionReference._1();
            String string3 = companionReference._2();
            String string4 = companionReference._3();
            String label = string2;
            String link = string3;
            String kind = string4;
            string = this.makeLink(label, link, true, declarationPath);
        } else if (reference2 instanceof references.TypeReference) {
            references.TypeReference typeReference = references$TypeReference$.MODULE$.unapply((references.TypeReference)reference2);
            String string5 = typeReference._1();
            String string6 = typeReference._2();
            List<references.Reference> list = typeReference._3();
            boolean bl = typeReference._4();
            String label = string5;
            String link = string6;
            List<references.Reference> typeParams = list;
            boolean hasOwnFile = bl;
            string = typeParams.isEmpty() ? this.makeLink(label, link, hasOwnFile, declarationPath) : this.makeLink(label, link, hasOwnFile, declarationPath) + typeParams.map((Function1)(JFunction1 & Serializable)_$4 -> this.formatReferences((references.Reference)_$4, declarationPath)).mkString("[", ", ", "]");
        } else if (reference2 instanceof references.OrTypeReference) {
            references.OrTypeReference orTypeReference = references$OrTypeReference$.MODULE$.unapply((references.OrTypeReference)reference2);
            references.Reference reference3 = orTypeReference._1();
            references.Reference reference4 = orTypeReference._2();
            references.Reference left = reference3;
            references.Reference right = reference4;
            string = this.formatReferences(left, declarationPath) + " | " + this.formatReferences(right, declarationPath);
        } else if (reference2 instanceof references.AndTypeReference) {
            references.AndTypeReference andTypeReference = references$AndTypeReference$.MODULE$.unapply((references.AndTypeReference)reference2);
            references.Reference reference5 = andTypeReference._1();
            references.Reference reference6 = andTypeReference._2();
            references.Reference left = reference5;
            references.Reference right = reference6;
            string = this.formatReferences(left, declarationPath) + " & " + this.formatReferences(right, declarationPath);
        } else if (reference2 instanceof references.FunctionReference) {
            references.FunctionReference functionReference = references$FunctionReference$.MODULE$.unapply((references.FunctionReference)reference2);
            List<references.Reference> list = functionReference._1();
            references.Reference reference7 = functionReference._2();
            boolean bl = functionReference._3();
            List<references.Reference> args = list;
            references.Reference returnValue = reference7;
            boolean isImplicit = bl;
            string = args.map((Function1)(JFunction1 & Serializable)_$5 -> this.formatReferences((references.Reference)_$5, declarationPath)).mkString("(", ", ", ") => ") + this.formatReferences(returnValue, declarationPath);
        } else if (reference2 instanceof references.TupleReference) {
            List<references.Reference> list;
            references.TupleReference tupleReference = references$TupleReference$.MODULE$.unapply((references.TupleReference)reference2);
            List<references.Reference> args = list = tupleReference._1();
            string = args.map((Function1)(JFunction1 & Serializable)_$6 -> this.formatReferences((references.Reference)_$6, declarationPath)).mkString("(", ", ", ")");
        } else if (reference2 instanceof references.BoundsReference) {
            references.BoundsReference boundsReference = references$BoundsReference$.MODULE$.unapply((references.BoundsReference)reference2);
            references.Reference reference8 = boundsReference._1();
            references.Reference reference9 = boundsReference._2();
            references.Reference low = reference8;
            references.Reference high = reference9;
            string = this.formatReferences(low, declarationPath) + " <: " + this.formatReferences(high, declarationPath);
        } else if (reference2 instanceof references.ByNameReference) {
            references.Reference reference10;
            references.ByNameReference byNameReference = references$ByNameReference$.MODULE$.unapply((references.ByNameReference)reference2);
            references.Reference ref = reference10 = byNameReference._1();
            string = "=> " + this.formatReferences(ref, declarationPath);
        } else if (reference2 instanceof references.ConstantReference) {
            String string7;
            String label;
            references.ConstantReference constantReference = references$ConstantReference$.MODULE$.unapply((references.ConstantReference)reference2);
            string = label = (string7 = constantReference._1());
        } else if (reference2 instanceof references.NamedReference) {
            references.NamedReference namedReference = references$NamedReference$.MODULE$.unapply((references.NamedReference)reference2);
            String string8 = namedReference._1();
            references.Reference reference11 = namedReference._2();
            boolean bl = namedReference._3();
            String name = string8;
            references.Reference ref = reference11;
            boolean isRepeated = bl;
            string = name + ": " + this.formatReferences(ref, declarationPath) + (isRepeated ? "*" : "");
        } else if (reference2 instanceof references.RefinedReference) {
            references.RefinedReference refinedReference = references$RefinedReference$.MODULE$.unapply((references.RefinedReference)reference2);
            references.Reference reference12 = refinedReference._1();
            List<Tuple3<String, String, references.Reference>> list = refinedReference._2();
            references.Reference parent = reference12;
            List<Tuple3<String, String, references.Reference>> ls = list;
            string = this.formatReferences(parent, declarationPath) + ls.map((Function1)(JFunction1 & Serializable)x$1 -> DocPrinter.kind$1(x$1) + " " + DocPrinter.name$1(x$1) + ": " + this.formatReferences(DocPrinter.tpe$1(x$1), declarationPath)).mkString("{ ", "; ", " }");
        } else if (references$EmptyReference$.MODULE$.equals(reference2)) {
            string = "";
        } else {
            throw new MatchError((Object)reference2);
        }
        return string;
    }

    private String formatParamList(representations.ParamList paramList, List<String> declarationPath) {
        return paramList.list().map((Function1)(JFunction1 & Serializable)x -> this.formatReferences((references.Reference)x, declarationPath)).mkString("(" + (paramList.isImplicit() ? "implicit " : ""), ", ", ")");
    }

    private String formatModifiers(List<String> modifiers, Option<references.Reference> privateWithin, Option<references.Reference> protectedWithin, List<references.TypeReference> annotations, List<String> declarationPath) {
        String string;
        String string2;
        boolean hasInlineAnnot = annotations.contains((Object)references$TypeReference$.MODULE$.apply("forceInline", "/scala", (List<references.Reference>)package$.MODULE$.Nil(), true));
        List filteredModifiers = modifiers.filter((Function1)(JFunction1 & Serializable)x -> {
            String string = x;
            String string2 = "private";
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = x;
            String string4 = "protected";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (!hasInlineAnnot) return true;
            String string5 = x;
            String string6 = "inline";
            if (string5 == null) {
                if (string6 == null) return false;
                return true;
            } else if (string5.equals(string6)) return false;
            return true;
        });
        StringBuilder stringBuilder = new StringBuilder();
        Option<references.Reference> option = privateWithin;
        if (option instanceof Some) {
            references.Reference r = (references.Reference)((Some)option).value();
            string2 = StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(this.formatReferences(r, declarationPath)), "private[", "", "] ");
        } else if (None$.MODULE$.equals(option)) {
            string2 = modifiers.contains((Object)"private") ? "private " : "";
        } else {
            throw new MatchError(option);
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        Option<references.Reference> option2 = protectedWithin;
        if (option2 instanceof Some) {
            references.Reference r = (references.Reference)((Some)option2).value();
            string = StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(this.formatReferences(r, declarationPath)), "private[", "", "] ");
        } else if (None$.MODULE$.equals(option2)) {
            string = modifiers.contains((Object)"protected") ? "protected " : "";
        } else {
            throw new MatchError(option2);
        }
        return stringBuilder2.append(string).append(filteredModifiers.nonEmpty() ? filteredModifiers.mkString("", " ", " ") : "").toString();
    }

    private String formatComments(Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>> comment) {
        String string;
        Option option = (Option)comment.apply(this.packagesMap(), (Object)this.userDocSyntax);
        if (option instanceof Some) {
            Comment c = (Comment)((Some)option).value();
            string = DocPrinter.removeLineEnds$1(c.body()) + (c.authors().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("authors")) + " " + c.authors().mkString(", ") + "\n" : "") + (c.see().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("see")) + " " + c.see().mkString(", ") + "\n" : "") + (c.result().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("return")) + " " + c.result().get() + "\n" : "") + (c.throws().nonEmpty() ? ((IterableOnceOps)c.throws().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") : "") + (c.valueParams().nonEmpty() ? ((IterableOnceOps)c.valueParams().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") + "\n" : "") + (c.typeParams().nonEmpty() ? ((IterableOnceOps)c.typeParams().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") + "\n" : "") + (c.version().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("version")) + " " + c.version().get() + "\n" : "") + (c.since().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("since")) + " " + c.since().get() + "\n" : "") + (c.todo().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("TODO")) + " " + c.todo().mkString(", ") + "\n" : "") + (c.deprecated().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("deprecated")) + " " + c.deprecated().get() + "\n" : "") + (c.note().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("Note")) + " " + c.note().mkString("\n") + "\n" : "") + (c.example().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("Example")) + " " + c.example().mkString("\n") + "\n" : "") + (c.constructor().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("Constructor")) + " " + c.constructor().get() + "\n" : "") + (c.group().isDefined() ? Md$.MODULE$.bold(Md$.MODULE$.italics("Group")) + " " + c.group().get() + "\n" : "") + (c.groupDesc().nonEmpty() ? ((IterableOnceOps)c.groupDesc().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") : "") + (c.groupNames().nonEmpty() ? ((IterableOnceOps)c.groupNames().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") + "\n" : "") + (c.groupPrio().nonEmpty() ? ((IterableOnceOps)c.groupPrio().map((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                return Md$.MODULE$.bold(Md$.MODULE$.italics(x)) + " " + y;
            })).mkString("\n") + "\n" : "") + (c.hideImplicitConversions().nonEmpty() ? Md$.MODULE$.bold(Md$.MODULE$.italics("Hide Implicit Conversions")) + " " + c.hideImplicitConversions().mkString(", ") + "\n" : "");
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    private String formatAnnotations(List<references.TypeReference> annotations, List<String> declarationPath) {
        String str = annotations.map((Function1)(JFunction1 & Serializable)_$7 -> "@" + this.formatReferences((references.Reference)_$7, declarationPath)).mkString(" ");
        return str.isEmpty() ? str : str + " ";
    }

    private String formatSimplifiedClassRepresentation(representations.ClassRepresentation representation, List<String> declarationPath) {
        return this.formatSimplifiedSignature$1(representation, declarationPath) + this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> representation.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax));
    }

    private String formatClassRepresentation(representations.ClassRepresentation representation, List<String> declarationPath) {
        return representation.path().mkString(".") + "\n" + Md$.MODULE$.header1(representation.kind() + " " + (representation.isObject() ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(representation.name()), "$") : representation.name())) + "\n" + this.formatCompanion$1(representation, declarationPath) + this.formatSignature$1(representation) + this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> representation.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax)) + this.formatClassAnnotations$1(representation, declarationPath) + this.formatKnownSubclasses$1(representation, declarationPath) + this.formatConstructors$1(representation) + this.formatMembers$1(representation, declarationPath);
    }

    /*
     * WARNING - void declaration
     */
    private String formatDefRepresentation(representations.DefRepresentation representation, List<String> declarationPath) {
        void var3_3;
        String com;
        String string = com = this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> representation.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax));
        String string2 = "";
        return this.htmlPreCode(this.formatAnnotations(representation.annotations(), declarationPath) + this.formatModifiers(representation.modifiers(), representation.privateWithin(), representation.protectedWithin(), representation.annotations(), declarationPath) + "def " + representation.name() + (representation.typeParams().nonEmpty() ? representation.typeParams().mkString("[", ", ", "]") : "") + representation.paramLists().map((Function1)(JFunction1 & Serializable)_$24 -> this.formatParamList((representations.ParamList)_$24, declarationPath)).mkString("") + ": " + this.formatReferences(representation.returnValue(), declarationPath), "scala") + "\n" + (String)(!(string != null ? !string.equals(string2) : string2 != null) ? "\n" : var3_3);
    }

    private String formatValRepresentation(representations.ValRepresentation representation, List<String> declarationPath) {
        return this.htmlPreCode(this.formatAnnotations(representation.annotations(), declarationPath) + this.formatModifiers(representation.modifiers(), representation.privateWithin(), representation.protectedWithin(), representation.annotations(), declarationPath) + (representation.isVar() ? "var " : "val ") + representation.name() + ": " + this.formatReferences(representation.returnValue(), declarationPath), "scala") + "\n" + this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> representation.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax)) + "\n";
    }

    private String formatTypeRepresentation(representations.TypeRepresentation representation, List<String> declarationPath) {
        return this.htmlPreCode(this.formatAnnotations(representation.annotations(), declarationPath) + this.formatModifiers(representation.modifiers(), representation.privateWithin(), representation.protectedWithin(), representation.annotations(), declarationPath) + "type " + representation.name() + (representation.isAbstract() ? "" : ": " + this.formatReferences((references.Reference)representation.alias().get(), declarationPath)), "scala") + "\n" + this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> representation.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax)) + "\n";
    }

    public String formatRepresentationToMarkdown(representations.Representation representation, List<String> declarationPath, boolean useSimplifiedFormat) {
        String string;
        representations.Representation representation2 = representation;
        if (representation2 instanceof representations.EmulatedPackageRepresentation) {
            representations.EmulatedPackageRepresentation r = (representations.EmulatedPackageRepresentation)representation2;
            string = useSimplifiedFormat ? this.htmlPreCode("package " + this.makeLink(r.name(), ((IterableOnceOps)r.path().$colon$plus((Object)r.name())).mkString("/", "/", ""), true, declarationPath), "scala") : Md$.MODULE$.header1("Package " + r.name()) + Md$.MODULE$.header2("Members:") + r.members().foldLeft((Object)"", (Function2)(JFunction2 & Serializable)(acc, m) -> acc + this.formatRepresentationToMarkdown((representations.Representation)m, declarationPath, true));
        } else if (representation2 instanceof representations.PackageRepresentation) {
            representations.PackageRepresentation r = (representations.PackageRepresentation)representation2;
            string = this.htmlPreCode("package " + this.makeLink(r.name(), ((IterableOnceOps)r.path().$colon$plus((Object)r.name())).mkString("/", "/", ""), true, declarationPath), "scala");
        } else if (representation2 instanceof representations.ImportRepresentation) {
            representations.ImportRepresentation r = (representations.ImportRepresentation)representation2;
            string = "";
        } else if (representation2 instanceof representations.ClassRepresentation) {
            representations.ClassRepresentation r = (representations.ClassRepresentation)representation2;
            string = useSimplifiedFormat ? this.formatSimplifiedClassRepresentation(r, declarationPath) : this.formatClassRepresentation(r, declarationPath);
        } else if (representation2 instanceof representations.DefRepresentation) {
            representations.DefRepresentation r = (representations.DefRepresentation)representation2;
            string = this.formatDefRepresentation(r, declarationPath);
        } else if (representation2 instanceof representations.ValRepresentation) {
            representations.ValRepresentation r = (representations.ValRepresentation)representation2;
            string = this.formatValRepresentation(r, declarationPath);
        } else if (representation2 instanceof representations.TypeRepresentation) {
            representations.TypeRepresentation r = (representations.TypeRepresentation)representation2;
            string = this.formatTypeRepresentation(r, declarationPath);
        } else {
            throw new MatchError((Object)representation2);
        }
        return string;
    }

    public boolean formatRepresentationToMarkdown$default$3() {
        return false;
    }

    public String folderPrefix() {
        return this.folderPrefix;
    }

    public void traverseRepresentation(representations.Representation representation2) {
        block1: {
            representations.Representation representation3;
            block2: {
                block0: {
                    representation3 = representation2;
                    if (!(representation3 instanceof representations.EmulatedPackageRepresentation)) break block0;
                    representations.EmulatedPackageRepresentation r = (representations.EmulatedPackageRepresentation)representation3;
                    r.members().foreach((Function1)(JProcedure1 & Serializable)representation -> this.traverseRepresentation((representations.Representation)representation));
                    File file = new File("./" + this.folderPrefix() + ((IterableOnceOps)r.path().$colon$plus((Object)r.name())).mkString("/", "/", "/") + r.name() + ".md");
                    file.getParentFile().mkdirs();
                    PrintWriter pw = new PrintWriter(file);
                    pw.write(this.formatRepresentationToMarkdown(r, (List<String>)((List)r.path().$colon$plus((Object)r.name())), this.formatRepresentationToMarkdown$default$3()));
                    pw.close();
                    break block1;
                }
                if (!(representation3 instanceof representations.PackageRepresentation)) break block2;
                representations.PackageRepresentation r = (representations.PackageRepresentation)representation3;
                r.members().foreach((Function1)(JProcedure1 & Serializable)representation -> this.traverseRepresentation((representations.Representation)representation));
                break block1;
            }
            if (!(representation3 instanceof representations.ClassRepresentation)) break block1;
            representations.ClassRepresentation r = (representations.ClassRepresentation)representation3;
            File file = new File("./" + this.folderPrefix() + r.path().mkString("", "/", "/") + r.name() + ".md");
            file.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(file);
            pw.write(this.formatRepresentationToMarkdown(r, r.path(), this.formatRepresentationToMarkdown$default$3()));
            pw.close();
        }
    }

    private static final String ascendPath$1(List path, List link) {
        List list;
        List list2 = link;
        List list3 = path;
        while ((list = list3) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list4 = colon2.next$access$1();
            String x = (String)colon2.head();
            List xs = list4;
            if (!list2.nonEmpty()) break;
            Object object = list2.head();
            String string = x;
            if (object != null ? !object.equals(string) : string != null) break;
            List list5 = xs;
            List list6 = (List)list2.tail();
            list3 = list5;
            list2 = list6;
        }
        return (list3.isEmpty() ? "." : list3.map((Function1)(JFunction1 & Serializable)_$2 -> "..").mkString("/")) + (list2.isEmpty() ? "" : list2.mkString("/", "/", ""));
    }

    private static final String kind$1(Tuple3 x$1$1) {
        return (String)x$1$1._1();
    }

    private static final String name$1(Tuple3 x$1$2) {
        return (String)x$1$2._2();
    }

    private static final references.Reference tpe$1(Tuple3 x$1$3) {
        return (references.Reference)x$1$3._3();
    }

    private static final String removeLineEnds$1(String str) {
        String string;
        block2: {
            String string2 = str;
            while (true) {
                if (string2.isEmpty()) {
                    string = string2;
                    break block2;
                }
                char c = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(string2));
                if ('\n' != c) break;
                string2 = StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(string2));
            }
            string = string2 + "\n\n";
        }
        return string;
    }

    private final String formatSimplifiedSignature$1(representations.ClassRepresentation representation$1, List declarationPath$7) {
        return this.htmlPreCode(this.formatAnnotations(representation$1.annotations(), (List<String>)declarationPath$7) + this.formatModifiers(representation$1.modifiers(), representation$1.privateWithin(), representation$1.protectedWithin(), representation$1.annotations(), (List<String>)declarationPath$7) + representation$1.kind() + " " + this.makeLink(representation$1.name(), representation$1.path().mkString("/", "/", ""), true, (List<String>)declarationPath$7), "scala") + "\n";
    }

    private final String formatCompanion$1(representations.ClassRepresentation representation$3, List declarationPath$8) {
        String string;
        references.CompanionReference companionReference;
        Option<references.CompanionReference> option = representation$3.companion();
        if (option instanceof Some && (companionReference = (references.CompanionReference)((Some)option).value()) != null) {
            String string2;
            references.CompanionReference companionReference2 = references$CompanionReference$.MODULE$.unapply(companionReference);
            String string3 = companionReference2._1();
            String string4 = companionReference2._2();
            String kind = string2 = companionReference2._3();
            references.CompanionReference ref = companionReference;
            string = Md$.MODULE$.header2("Companion " + kind + " " + this.formatReferences(ref, (List<String>)declarationPath$8)) + "\n";
        } else {
            string = "";
        }
        return string;
    }

    private final String formatSignature$1(representations.ClassRepresentation representation$4) {
        return this.htmlPreCode(this.formatModifiers(representation$4.modifiers(), representation$4.privateWithin(), representation$4.protectedWithin(), representation$4.annotations(), representation$4.path()) + representation$4.kind() + " " + (representation$4.isObject() ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(representation$4.name()), "$") : representation$4.name()) + (representation$4.typeParams().nonEmpty() ? representation$4.typeParams().mkString("[", ", ", "]") : "") + (representation$4.parents().nonEmpty() ? " extends " + this.formatReferences((references.Reference)representation$4.parents().head(), representation$4.path()) + ((List)representation$4.parents().tail()).map((Function1)(JFunction1 & Serializable)_$8 -> " with " + this.formatReferences((references.Reference)_$8, representation$4.path())).mkString("") : ""), "scala") + "\n";
    }

    private final String formatClassAnnotations$1(representations.ClassRepresentation representation$6, List declarationPath$9) {
        return representation$6.annotations().isEmpty() ? "" : Md$.MODULE$.header2("Annotations:") + this.formatAnnotations(representation$6.annotations(), (List<String>)declarationPath$9) + "\n";
    }

    private final String formatKnownSubclasses$1(representations.ClassRepresentation representation$7, List declarationPath$10) {
        return representation$7.knownSubclasses().isEmpty() ? "" : Md$.MODULE$.header2("Known subclasses:") + representation$7.knownSubclasses().map((Function1)(JFunction1 & Serializable)_$9 -> this.formatReferences((references.Reference)_$9, (List<String>)declarationPath$10)).mkString(", ") + "\n";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String formatConstructors$1(representations.ClassRepresentation representation$8) {
        if (representation$8.constructors().isEmpty()) return "";
        if (representation$8.isObject()) return "";
        if (representation$8.constructors().size() == 1 && ((representations.DefRepresentation)representation$8.constructors().head()).paramLists().size() == 1) {
            List<references.NamedReference> list = ((representations.ParamList)((representations.DefRepresentation)representation$8.constructors().head()).paramLists().head()).list();
            Nil$ nil$ = package$.MODULE$.Nil();
            if (list == null) {
                if (nil$ == null) return "";
            } else if (list.equals((Object)nil$)) {
                return "";
            }
        }
        String string = Md$.MODULE$.header2("Constructors:") + representation$8.constructors().map((Function1)(JFunction1 & Serializable)ls -> this.htmlPreCode(representation$8.name() + ls.paramLists().map((Function1)(JFunction1 & Serializable)_$10 -> this.formatParamList((representations.ParamList)_$10, representation$8.path())).mkString(""), "scala") + "\n" + this.formatComments((Function2<Map<String, representations.EmulatedPackageRepresentation>, String, Option<Comment>>)(JFunction2 & Serializable)(packages, userDocSyntax) -> ls.comments((Map<String, representations.EmulatedPackageRepresentation>)packages, (String)userDocSyntax))).mkString("") + "\n";
        return string;
    }

    private final String formatMembers$1(representations.ClassRepresentation representation$11, List declarationPath$12) {
        List nonPrivateMembers = representation$11.members().filter((Function1)(JFunction1 & Serializable)_$11 -> !((representations.Modifiers)((Object)_$11)).isPrivate());
        List typeMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            None$ none$;
            representations.Representation representation = x$1;
            if (representation instanceof representations.TypeRepresentation) {
                representations.TypeRepresentation r = (representations.TypeRepresentation)representation;
                none$ = Some$.MODULE$.apply((Object)r);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        List objectMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            representations.ClassRepresentation r;
            representations.Representation representation = x$1;
            return representation instanceof representations.ClassRepresentation && (r = (representations.ClassRepresentation)representation).isObject() ? Some$.MODULE$.apply((Object)r) : None$.MODULE$;
        });
        List classMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            representations.ClassRepresentation r;
            representations.Representation representation = x$1;
            return representation instanceof representations.ClassRepresentation && !(r = (representations.ClassRepresentation)representation).isObject() && !r.isTrait() ? Some$.MODULE$.apply((Object)r) : None$.MODULE$;
        });
        List traitMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            representations.ClassRepresentation r;
            representations.Representation representation = x$1;
            return representation instanceof representations.ClassRepresentation && (r = (representations.ClassRepresentation)representation).isTrait() ? Some$.MODULE$.apply((Object)r) : None$.MODULE$;
        });
        List defMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            None$ none$;
            representations.Representation representation = x$1;
            if (representation instanceof representations.DefRepresentation) {
                representations.DefRepresentation r = (representations.DefRepresentation)representation;
                none$ = Some$.MODULE$.apply((Object)r);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        List valMembers = nonPrivateMembers.flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            None$ none$;
            representations.Representation representation = x$1;
            if (representation instanceof representations.ValRepresentation) {
                representations.ValRepresentation r = (representations.ValRepresentation)representation;
                none$ = Some$.MODULE$.apply((Object)r);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        String abstractTypeMembers = typeMembers.filter((Function1)(JFunction1 & Serializable)_$12 -> _$12.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("") + objectMembers.filter((Function1)(JFunction1 & Serializable)_$13 -> _$13.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x.name()), "$")) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("") + classMembers.filter((Function1)(JFunction1 & Serializable)_$14 -> _$14.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(x.name()) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("") + traitMembers.filter((Function1)(JFunction1 & Serializable)_$15 -> _$15.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(x.name()) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("");
        String concreteTypeMembers = typeMembers.filter((Function1)(JFunction1 & Serializable)_$16 -> !_$16.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("") + objectMembers.filter((Function1)(JFunction1 & Serializable)_$17 -> !_$17.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x.name()), "$")) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("") + classMembers.filter((Function1)(JFunction1 & Serializable)_$18 -> !_$18.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(x.name()) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("") + traitMembers.filter((Function1)(JFunction1 & Serializable)_$19 -> !_$19.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> {
            this.traverseRepresentation((representations.Representation)x);
            return Md$.MODULE$.header3(x.name()) + this.formatSimplifiedClassRepresentation((representations.ClassRepresentation)x, (List<String>)declarationPath$12);
        }).mkString("");
        String abstractValueMembers = defMembers.filter((Function1)(JFunction1 & Serializable)_$20 -> _$20.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("") + valMembers.filter((Function1)(JFunction1 & Serializable)_$21 -> _$21.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("");
        String concreteValueMembers = defMembers.filter((Function1)(JFunction1 & Serializable)_$22 -> !_$22.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("") + valMembers.filter((Function1)(JFunction1 & Serializable)_$23 -> !_$23.isAbstract()).map((Function1)(JFunction1 & Serializable)x -> Md$.MODULE$.header3(x.name()) + this.formatRepresentationToMarkdown((representations.Representation)x, (List<String>)declarationPath$12, this.formatRepresentationToMarkdown$default$3())).mkString("");
        return (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(abstractTypeMembers)) ? Md$.MODULE$.header2("Abstract Type Members:") + abstractTypeMembers : "") + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(concreteTypeMembers)) ? Md$.MODULE$.header2("Concrete Type Members:") + concreteTypeMembers : "") + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(abstractValueMembers)) ? Md$.MODULE$.header2("Abstract Value Members:") + abstractValueMembers : "") + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(concreteValueMembers)) ? Md$.MODULE$.header2("Concrete Value Members:") + concreteValueMembers : "");
    }
}

