/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.Settings$Setting$SettingDecorator$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$Context$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Decorators$StringInterpolators$;
import dotty.tools.dotc.printing.Highlighting;
import dotty.tools.dotc.reporting.MessageRendering;
import dotty.tools.dotc.reporting.diagnostic.Message;
import dotty.tools.dotc.reporting.diagnostic.MessageContainer;
import dotty.tools.dotc.reporting.diagnostic.messages;
import dotty.tools.dotc.util.SourcePosition;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.StringBuilder$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class MessageRendering$class {
    public static String stripColor(MessageRendering $this, String str) {
        return str.replaceAll("\u001b\\[[;\\d]*m", "");
    }

    public static List outer(MessageRendering $this, SourcePosition pos2, String prefix, Contexts.Context ctx) {
        Nil$ nil$;
        if (pos2.outer().exists()) {
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "| This location is in code that was inlined at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, pos2.outer()}));
            nil$ = $this.outer(pos2.outer(), prefix, ctx).$colon$colon((Object)string);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public static Tuple3 sourceLines(MessageRendering $this, SourcePosition pos2, Contexts.Context ctx) {
        IntRef maxLen2 = IntRef.create((int)Integer.MIN_VALUE);
        Tuple2<List<Object>, List<Object>> tuple2 = pos2.beforeAndAfterPoint();
        if (tuple2 != null) {
            Tuple2 tuple22;
            List before = (List)tuple2._1();
            List after = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)before, (Object)after);
            List before2 = (List)tuple23._1();
            List after2 = (List)tuple23._2();
            return new Tuple3((Object)MessageRendering$class.render$1($this, before2, maxLen2, pos2, ctx), (Object)MessageRendering$class.render$1($this, after2, maxLen2, pos2, ctx), (Object)BoxesRunTime.boxToInteger((int)maxLen2.elem));
        }
        throw new MatchError(tuple2);
    }

    public static String columnMarker(MessageRendering $this, SourcePosition pos2, int offset, Contexts.Context ctx) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset - 1);
        String whitespace = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(pos2.startColumn());
        Highlighting.Red carets = new Highlighting.Red(pos2.startLine() == pos2.endLine() ? new StringOps(Predef$.MODULE$.augmentString("^")).$times(package$.MODULE$.max(1, pos2.endColumn() - pos2.startColumn())) : "^");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "|", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, whitespace, carets.show(ctx)}));
    }

    public static String errorMsg(MessageRendering $this, SourcePosition pos2, String msg, int offset, Contexts.Context ctx) {
        int leastWhitespace = BoxesRunTime.unboxToInt((Object)new StringOps(Predef$.MODULE$.augmentString(msg)).lines().foldLeft((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), (Function2)new Serializable($this, pos2, offset, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageRendering $outer;
            private final SourcePosition pos$2;
            private final int offset$1;
            private final Contexts.Context ctx$2;

            public final int apply(int minPad, String line) {
                int lineLength = this.$outer.stripColor(line).length();
                int currPad = package$.MODULE$.min(package$.MODULE$.max(0, BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(this.ctx$2).settings().pageWidth()), this.ctx$2)) - this.offset$1 - lineLength), this.offset$1 + this.pos$2.startColumn());
                return package$.MODULE$.min(currPad, minPad);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pos$2 = pos$2;
                this.offset$1 = offset$1;
                this.ctx$2 = ctx$2;
            }
        }));
        return new StringOps(Predef$.MODULE$.augmentString(msg)).lines().map((Function1)new Serializable($this, leastWhitespace, offset){
            public static final long serialVersionUID = 0L;
            private final int leastWhitespace$1;
            private final int offset$1;

            public final String apply(String line) {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.offset$1 - 1)).append((Object)"|").append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.leastWhitespace$1 - this.offset$1)).append((Object)line).toString();
            }
            {
                this.leastWhitespace$1 = leastWhitespace$1;
                this.offset$1 = offset$1;
            }
        }).mkString((String)scala.sys.package$.MODULE$.props().apply((Object)"line.separator"));
    }

    public static String posStr(MessageRendering $this, SourcePosition pos2, String diagnosticLevel, Message message, Contexts.Context ctx) {
        String string;
        if (pos2.exists()) {
            String file = pos2.source().file().toString();
            String errId = message.errorId() != -1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[E", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("0")).$times(3 - ((Object)BoxesRunTime.boxToInteger((int)message.errorId())).toString().length())).append((Object)BoxesRunTime.boxToInteger((int)message.errorId())).toString()})) : "";
            String string2 = message.kind();
            String string3 = "";
            String kind = !(string2 != null ? !string2.equals(string3) : string3 != null) ? diagnosticLevel : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.kind(), diagnosticLevel}));
            String prefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-- ", "", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errId, kind, file}));
            string = new Highlighting.Blue(new StringBuilder().append((Object)prefix).append((Object)new StringOps(Predef$.MODULE$.augmentString("-")).$times(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)Settings$Setting$SettingDecorator$.MODULE$.value$extension(Settings$Setting$.MODULE$.SettingDecorator(Contexts$Context$.MODULE$.toBase(ctx).settings().pageWidth()), ctx)) - $this.stripColor(prefix).length(), 0))).toString()).show(ctx);
        } else {
            string = "";
        }
        return string;
    }

    public static String explanation(MessageRendering $this, Message m, Contexts.Context ctx) {
        StringBuilder sb = new StringBuilder(Decorators$StringInterpolators$.MODULE$.hl$extension(Decorators$.MODULE$.StringInterpolators(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n           |", "\n           |", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Highlighting.Blue("Explanation"), new Highlighting.Blue("===========")}), ctx));
        sb.append('\n').append(m.explanation());
        Option option = new StringOps(Predef$.MODULE$.augmentString(m.explanation())).lastOption();
        Some some = new Some((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        Object object = !(option != null ? !option.equals(some) : some != null) ? BoxedUnit.UNIT : sb.append('\n');
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String messageAndPos(MessageRendering $this, Message msg, SourcePosition pos2, String diagnosticLevel, Contexts.Context ctx) {
        StringBuilder stringBuilder;
        StringBuilder sb = StringBuilder$.MODULE$.newBuilder();
        sb.append($this.posStr(pos2, diagnosticLevel, msg, ctx)).append('\n');
        if (pos2.exists()) {
            Tuple3 tuple3;
            Tuple3<List<String>, List<String>, Object> tuple32 = $this.sourceLines(pos2, ctx);
            if (tuple32 == null) throw new MatchError(tuple32);
            List srcBefore = (List)tuple32._1();
            List srcAfter = (List)tuple32._2();
            int offset = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
            List srcBefore2 = (List)tuple33._1();
            List srcAfter2 = (List)tuple33._2();
            int offset2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            String marker = $this.columnMarker(pos2, offset2, ctx);
            String err2 = $this.errorMsg(pos2, msg.msg(), offset2, ctx);
            List list = srcBefore2;
            String string = marker;
            String string2 = err2;
            List<String> list2 = $this.outer(pos2, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(offset2 - 1), ctx);
            stringBuilder = sb.append(srcAfter2.$colon$colon$colon(list2).$colon$colon((Object)string2).$colon$colon((Object)string).$colon$colon$colon(list).mkString("\n"));
            return sb.toString();
        } else {
            stringBuilder = sb.append(msg.msg());
        }
        return sb.toString();
    }

    public static String diagnosticLevel(MessageRendering $this, MessageContainer cont) {
        MessageContainer messageContainer;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        messageContainer = cont;
                                        if (!(messageContainer instanceof messages.Error)) break block2;
                                        string = "Error";
                                        break block3;
                                    }
                                    if (!(messageContainer instanceof messages.FeatureWarning)) break block4;
                                    string = "Feature Warning";
                                    break block3;
                                }
                                if (!(messageContainer instanceof messages.DeprecationWarning)) break block5;
                                string = "Deprecation Warning";
                                break block3;
                            }
                            if (!(messageContainer instanceof messages.UncheckedWarning)) break block6;
                            string = "Unchecked Warning";
                            break block3;
                        }
                        if (!(messageContainer instanceof messages.MigrationWarning)) break block7;
                        string = "Migration Warning";
                        break block3;
                    }
                    if (!(messageContainer instanceof messages.Warning)) break block8;
                    string = "Warning";
                    break block3;
                }
                if (!(messageContainer instanceof messages.Info)) break block9;
                string = "Info";
            }
            return string;
        }
        throw new MatchError((Object)messageContainer);
    }

    private static final List render$1(MessageRendering $this, List xs, IntRef maxLen$1, SourcePosition pos$1, Contexts.Context ctx$1) {
        return (List)((List)((List)xs.map((Function1)new Serializable($this, pos$1){
            public static final long serialVersionUID = 0L;
            private final SourcePosition pos$1;

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int x$2) {
                return this.pos$1.source().offsetToLine(x$2);
            }
            {
                this.pos$1 = pos$1;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, maxLen$1, pos$1){
            public static final long serialVersionUID = 0L;
            private final IntRef maxLen$1;
            private final SourcePosition pos$1;

            public final Tuple2<String, String> apply(int lineNbr) {
                String prefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(lineNbr + 1))}));
                this.maxLen$1.elem = package$.MODULE$.max(this.maxLen$1.elem, prefix.length());
                return new Tuple2((Object)prefix, (Object)new StringOps(Predef$.MODULE$.augmentString(this.pos$1.lineContent(lineNbr))).stripLineEnd());
            }
            {
                this.maxLen$1 = maxLen$1;
                this.pos$1 = pos$1;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, maxLen$1, ctx$1){
            public static final long serialVersionUID = 0L;
            private final IntRef maxLen$1;
            private final Contexts.Context ctx$1;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String prefix = (String)tuple2._1();
                    String line = (String)tuple2._2();
                    Highlighting.Red lnum = new Highlighting.Red(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(0, this.maxLen$1.elem - prefix.length()))).append((Object)prefix).toString());
                    String string = Decorators$StringInterpolators$.MODULE$.hl$extension(Decorators$.MODULE$.StringInterpolators(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lnum, line}), this.ctx$1);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.maxLen$1 = maxLen$1;
                this.ctx$1 = ctx$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static void $init$(MessageRendering $this) {
    }
}

