/*
 * Decompiled with CFR 0.152.
 */
package PosixLikeIO;

import PosixLikeIO.File$;
import gears.async.Future;
import gears.async.Future$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class File {
    private final String path;
    private Option<AsynchronousFileChannel> channel;

    public static CompletionHandler<Integer, ByteBuffer> toCompletionHandler(Future.Resolver<Object> resolver) {
        return File$.MODULE$.toCompletionHandler(resolver);
    }

    public File(String path) {
        this.path = path;
        this.channel = None$.MODULE$;
    }

    public String path() {
        return this.path;
    }

    public boolean isOpened() {
        return this.channel.isDefined() && ((Channel)this.channel.get()).isOpen();
    }

    public File open(Seq<StandardOpenOption> options) {
        if (!this.channel.isEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        Seq options1 = options.isEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.READ})) : options;
        this.channel = Some$.MODULE$.apply((Object)AsynchronousFileChannel.open(Path.of(this.path(), new String[0]), (StandardOpenOption[])Arrays$.MODULE$.seqToArray(options1, StandardOpenOption.class)));
        return this;
    }

    public void close() {
        if (this.channel.isDefined()) {
            ((AsynchronousChannel)this.channel.get()).close();
            this.channel = None$.MODULE$;
            return;
        }
    }

    public Future<Object> read(ByteBuffer buffer) {
        if (!this.channel.isDefined()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return Future$.MODULE$.withResolver((JProcedure1 & Serializable)resolver -> ((AsynchronousFileChannel)this.channel.get()).read(buffer, 0L, buffer, File$.MODULE$.toCompletionHandler((Future.Resolver<Object>)resolver)));
    }

    public Future<String> readString(int size, Charset charset) {
        if (!this.channel.isDefined()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (size < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        return Future$.MODULE$.withResolver((JProcedure1 & Serializable)resolver -> ((AsynchronousFileChannel)this.channel.get()).read(buffer, 0L, buffer, new CompletionHandler<Integer, ByteBuffer>(resolver, charset){
            private final Future.Resolver resolver$1;
            private final Charset charset$2;
            {
                this.resolver$1 = resolver$5;
                this.charset$2 = charset$3;
            }

            public void completed(Integer result, ByteBuffer attachment) {
                this.resolver$1.resolve(this.charset$2.decode(attachment.slice(0, Predef$.MODULE$.Integer2int(result))).toString());
            }

            public void failed(Throwable e, ByteBuffer attachment) {
                this.resolver$1.reject(e);
            }
        }));
    }

    public Charset readString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public Future<Object> write(ByteBuffer buffer) {
        if (!this.channel.isDefined()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return Future$.MODULE$.withResolver((JProcedure1 & Serializable)resolver -> ((AsynchronousFileChannel)this.channel.get()).write(buffer, 0L, buffer, File$.MODULE$.toCompletionHandler((Future.Resolver<Object>)resolver)));
    }

    public Future<Object> writeString(String s, Charset charset) {
        return this.write(ByteBuffer.wrap(s.getBytes(charset)));
    }

    public Charset writeString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public void finalize() {
        super.finalize();
        if (this.channel.isDefined()) {
            ((AsynchronousChannel)this.channel.get()).close();
            return;
        }
    }
}

