/*
 * Decompiled with CFR 0.152.
 */
package gears.async;

import gears.async.Async;
import gears.async.Channel$;
import gears.async.Channel$Closed$;
import gears.async.Listener;
import gears.async.ReadableChannel;
import gears.async.SendableChannel;
import gears.async.listeners.locking$package$;
import java.io.Closeable;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface Channel<T>
extends SendableChannel<T>,
ReadableChannel<T>,
Closeable {

    public static abstract class Impl<T>
    implements Channel<T> {
        private boolean isClosed = false;
        private final CellBuf cells = new CellBuf();
        private final Async.Source readSource = new Async.Source<Either<Channel$Closed$, T>>(this){
            private final /* synthetic */ Impl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean poll(Listener k) {
                return this.$outer.pollRead(k);
            }

            public void onComplete(Listener k) {
                Impl impl = this.$outer;
                synchronized (impl) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.pollRead(k)) {
                        this.$outer.cells().addReader(k);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void dropListener(Listener k) {
                Impl impl = this.$outer;
                synchronized (impl) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.isClosed()) {
                        this.$outer.cells().dropReader(k);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        };

        public boolean isClosed() {
            return this.isClosed;
        }

        public void isClosed_$eq(boolean x$1) {
            this.isClosed = x$1;
        }

        public CellBuf cells() {
            return this.cells;
        }

        public abstract boolean pollRead(Listener<Either<Channel$Closed$, T>> var1);

        public abstract boolean pollSend(CanSend var1, Listener<Either<Channel$Closed$, BoxedUnit>> var2);

        public final <T> boolean checkClosed(Async.Source<Either<Channel$Closed$, T>> src, Listener<Either<Channel$Closed$, T>> l) {
            if (this.isClosed()) {
                l.completeNow((Either<Channel$Closed$, Either<Channel$Closed$, T>>)package$.MODULE$.Left().apply((Object)Channel$Closed$.MODULE$), (Async.Source<Either<Channel$Closed$, Either<Channel$Closed$, T>>>)src);
                return true;
            }
            return false;
        }

        @Override
        public Async.Source<Either<Channel$Closed$, T>> readSource() {
            return this.readSource;
        }

        @Override
        public final Async.Source<Either<Channel$Closed$, BoxedUnit>> sendSource(T x) {
            return new CanSend(this, x);
        }

        @Override
        public final void close() {
            Impl impl = this;
            synchronized (impl) {
                BoxedUnit boxedUnit;
                if (!this.isClosed()) {
                    this.isClosed_$eq(true);
                    this.cells().cancel();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }

        public final void complete(CanSend src, Listener<Either<Channel$Closed$, T>> reader, Listener<Either<Channel$Closed$, BoxedUnit>> sender) {
            reader.complete((Either<Channel$Closed$, Either<Channel$Closed$, T>>)package$.MODULE$.Right().apply(src.item()), (Async.Source<Either<Channel$Closed$, Either<Channel$Closed$, T>>>)this.readSource());
            sender.complete((Either<Channel$Closed$, BoxedUnit>)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), src);
        }

        public void gears$async$Channel$Impl$$inline$complete(CanSend src, Listener<Either<Channel$Closed$, T>> reader, Listener<Either<Channel$Closed$, BoxedUnit>> sender) {
            this.complete(src, reader, sender);
        }

        public final class CanSend
        implements Async.Source<Either<Channel$Closed$, BoxedUnit>> {
            private final Object item;
            private final /* synthetic */ Impl $outer;

            public CanSend(Impl $outer, T item) {
                this.item = item;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public T item() {
                return this.item;
            }

            @Override
            public boolean poll(Listener<Either<Channel$Closed$, BoxedUnit>> k) {
                return this.$outer.pollSend(this, k);
            }

            @Override
            public void onComplete(Listener<Either<Channel$Closed$, BoxedUnit>> k) {
                Impl impl = this.$outer;
                synchronized (impl) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.pollSend(this, k)) {
                        this.$outer.cells().addSender(this, k);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            @Override
            public void dropListener(Listener<Either<Channel$Closed$, BoxedUnit>> k) {
                Impl impl = this.$outer;
                synchronized (impl) {
                    BoxedUnit boxedUnit;
                    if (!this.$outer.isClosed()) {
                        this.$outer.cells().dropSender(this, k);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public final /* synthetic */ Impl gears$async$Channel$Impl$CanSend$$$outer() {
                return this.$outer;
            }
        }

        public class CellBuf {
            private int reader;
            private int sender;
            private final Queue<Object> pending;

            public CellBuf() {
                if (Impl.this == null) {
                    throw new NullPointerException();
                }
                this.reader = 0;
                this.sender = 0;
                this.pending = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0]));
            }

            public boolean hasReader() {
                return this.reader > 0;
            }

            public boolean hasSender() {
                return this.sender > 0;
            }

            public Listener<Either<Channel$Closed$, T>> nextReader() {
                Predef$.MODULE$.require(this.reader > 0);
                return (Listener)this.pending.head();
            }

            public Tuple2<CanSend, Listener<Either<Channel$Closed$, BoxedUnit>>> nextSender() {
                Predef$.MODULE$.require(this.sender > 0);
                return (Tuple2)this.pending.head();
            }

            public void dequeue() {
                this.pending.dequeue();
                if (this.reader > 0) {
                    --this.reader;
                    return;
                }
                --this.sender;
            }

            public CellBuf addReader(Listener<Either<Channel$Closed$, T>> r) {
                Predef$.MODULE$.require(this.sender == 0);
                ++this.reader;
                this.pending.enqueue(r);
                return this;
            }

            public CellBuf addSender(CanSend src, Listener<Either<Channel$Closed$, BoxedUnit>> s) {
                Predef$.MODULE$.require(this.reader == 0);
                ++this.sender;
                this.pending.enqueue((Object)Tuple2$.MODULE$.apply((Object)src, s));
                return this;
            }

            public CellBuf dropReader(Listener<Either<Channel$Closed$, T>> r) {
                if (this.reader > 0 && this.pending.removeFirst(arg_0 -> Channel$.gears$async$Channel$Impl$CellBuf$$_$dropReader$$anonfun$1(r, arg_0), this.pending.removeFirst$default$2()).isDefined()) {
                    --this.reader;
                }
                return this;
            }

            public CellBuf dropSender(CanSend src, Listener<Either<Channel$Closed$, BoxedUnit>> s) {
                if (this.sender > 0 && this.pending.removeFirst(arg_0 -> Channel$.gears$async$Channel$Impl$CellBuf$$_$dropSender$$anonfun$1(src, s, arg_0), this.pending.removeFirst$default$2()).isDefined()) {
                    --this.sender;
                }
                return this;
            }

            public boolean matchReader(Listener<Either<Channel$Closed$, T>> r) {
                while (this.hasSender()) {
                    Listener listener;
                    Listener listener2;
                    Tuple2<CanSend, Listener<Either<Channel$Closed$, BoxedUnit>>> tuple2 = this.nextSender();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    CanSend src = (CanSend)tuple2._1();
                    Listener s = (Listener)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)src, (Object)s);
                    CanSend src2 = (CanSend)tuple22._1();
                    Listener s2 = (Listener)tuple22._2();
                    Impl Impl_this = this.gears$async$Channel$Impl$CellBuf$$$outer();
                    Object object = locking$package$.MODULE$.lockBoth(r, s2);
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)object)) {
                        Impl_this.gears$async$Channel$Impl$$inline$complete(src2, r, s2);
                        this.dequeue();
                        listener2 = BoxedUnit.UNIT;
                    } else if (object == r || object == s2) {
                        Listener listener3;
                        listener2 = listener3 = (Listener)object;
                    } else {
                        throw new MatchError(object);
                    }
                    Listener listener4 = listener2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Listener listener5 = listener4;
                    if (!(boxedUnit != null ? !boxedUnit.equals(listener5) : listener5 != null)) {
                        return true;
                    }
                    Listener listener6 = listener = listener4;
                    Listener listener7 = r;
                    if (!(listener6 != null ? !listener6.equals(listener7) : listener7 != null)) {
                        return true;
                    }
                    this.dequeue();
                }
                return false;
            }

            public boolean matchSender(CanSend src, Listener<Either<Channel$Closed$, BoxedUnit>> s) {
                while (this.hasReader()) {
                    Listener listener;
                    Listener listener2;
                    Listener r = this.nextReader();
                    Impl Impl_this = this.gears$async$Channel$Impl$CellBuf$$$outer();
                    Object object = locking$package$.MODULE$.lockBoth(r, s);
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)object)) {
                        Impl_this.gears$async$Channel$Impl$$inline$complete(src, r, s);
                        this.dequeue();
                        listener2 = BoxedUnit.UNIT;
                    } else if (object == r || object == s) {
                        Listener listener3;
                        listener2 = listener3 = (Listener)object;
                    } else {
                        throw new MatchError(object);
                    }
                    Listener listener4 = listener2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Listener listener5 = listener4;
                    if (!(boxedUnit != null ? !boxedUnit.equals(listener5) : listener5 != null)) {
                        return true;
                    }
                    Listener listener6 = listener = listener4;
                    Listener<Either<Channel$Closed$, BoxedUnit>> listener7 = s;
                    if (!(listener6 != null ? !listener6.equals(listener7) : listener7 != null)) {
                        return true;
                    }
                    this.dequeue();
                }
                return false;
            }

            public void cancel() {
                this.pending.foreach((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    if (object instanceof Tuple2) {
                        Tuple2 tuple2 = (Tuple2)object;
                        CanSend src = (CanSend)tuple2._1();
                        Listener s = (Listener)tuple2._2();
                        return s.completeNow(package$.MODULE$.Left().apply((Object)Channel$Closed$.MODULE$), src);
                    }
                    if (object instanceof Listener) {
                        Listener r = (Listener)object;
                        return r.completeNow(package$.MODULE$.Left().apply((Object)Channel$Closed$.MODULE$), Impl.this.readSource());
                    }
                    throw new MatchError(object);
                });
                this.pending.clear();
                this.reader = 0;
                this.sender = 0;
            }

            public final /* synthetic */ Impl gears$async$Channel$Impl$CellBuf$$$outer() {
                return Impl.this;
            }
        }
    }
}

