/*
 * Decompiled with CFR 0.152.
 */
package gears.async.native;

import gears.async.Cancellable;
import gears.async.CompletionGroup;
import gears.async.Scheduler;
import gears.async.native.ExecutorWithSleepThread$Sleeper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public class ExecutorWithSleepThread
implements ExecutionContext,
Scheduler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExecutorWithSleepThread.class.getDeclaredField("given_Ordering_Sleeper$lzy1"));
    private final ExecutionContext exec;
    public final ExecutorWithSleepThread$Sleeper$ Sleeper$lzy1;
    private volatile Object given_Ordering_Sleeper$lzy1;
    private final PriorityQueue<Sleeper> sleepers;
    private Option<Deadline> sleepingUntil;
    private final Thread sleeperThread;

    public ExecutorWithSleepThread(ExecutionContext exec) {
        this.exec = exec;
        this.Sleeper$lzy1 = new ExecutorWithSleepThread$Sleeper$(this);
        ExecutionContext.$init$((ExecutionContext)this);
        this.sleepers = PriorityQueue$.MODULE$.empty(this.given_Ordering_Sleeper());
        this.sleepingUntil = None$.MODULE$;
        this.sleeperThread = new Thread(() -> this.sleepLoop());
        this.sleeperThread().setDaemon(true);
        this.sleeperThread().start();
    }

    public ExecutionContext exec() {
        return this.exec;
    }

    private final ExecutorWithSleepThread$Sleeper$ Sleeper() {
        return this.Sleeper$lzy1;
    }

    private final Ordering<Sleeper> given_Ordering_Sleeper() {
        Object object = this.given_Ordering_Sleeper$lzy1;
        if (object instanceof Ordering) {
            return (Ordering)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Ordering)this.given_Ordering_Sleeper$lzyINIT1();
    }

    private Object given_Ordering_Sleeper$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Ordering_Sleeper$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Ordering ordering = null;
                    try {
                        ordering = package$.MODULE$.Ordering().by((Function1 & Serializable)sleeper -> sleeper.wakeTime(), (Ordering)Deadline.DeadlineIsOrdered$.MODULE$).reverse();
                        object2 = ordering == null ? LazyVals.NullValue$.MODULE$ : ordering;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Ordering_Sleeper$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return ordering;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void execute(Runnable body) {
        this.exec().execute(body);
    }

    public void reportFailure(Throwable cause) {
        this.exec().reportFailure(cause);
    }

    @Override
    public Cancellable schedule(FiniteDuration delay, Runnable body) {
        Sleeper sleeper = this.Sleeper().apply(delay.fromNow(), body);
        ExecutorWithSleepThread executorWithSleepThread = this;
        synchronized (executorWithSleepThread) {
            BoxedUnit boxedUnit;
            this.sleepers.$plus$eq((Object)sleeper);
            boolean shouldWake = BoxesRunTime.unboxToBoolean((Object)this.sleepingUntil.map((Function1 & Serializable)_$1 -> sleeper.wakeTime().$less(_$1)).getOrElse(ExecutorWithSleepThread::$anonfun$4));
            if (shouldWake) {
                this.notifyAll();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new Cancellable(sleeper, this){
            private final Sleeper sleeper$3;
            private CompletionGroup gears$async$Cancellable$$group;
            {
                this.sleeper$3 = sleeper$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                Cancellable.$init$(this);
            }

            public CompletionGroup gears$async$Cancellable$$group() {
                return this.gears$async$Cancellable$$group;
            }

            public void gears$async$Cancellable$$group_$eq(CompletionGroup x$1) {
                this.gears$async$Cancellable$$group = x$1;
            }

            public final void cancel() {
                ExecutorWithSleepThread.gears$async$native$ExecutorWithSleepThread$$_$schedule$$anonfun$1(this.sleeper$3);
            }
        };
    }

    private void sleepLoop() {
        ExecutorWithSleepThread executorWithSleepThread = this;
        synchronized (executorWithSleepThread) {
            while (true) {
                Deadline deadline;
                this.sleepingUntil = this.sleepers.headOption().map((Function1 & Serializable)_$2 -> _$2.wakeTime());
                Option<Deadline> option = this.sleepingUntil;
                if (None$.MODULE$.equals(option)) {
                    this.wait();
                    deadline = Deadline$.MODULE$.now();
                } else if (option instanceof Some) {
                    Deadline current0;
                    Deadline value = (Deadline)((Some)option).value();
                    FiniteDuration timeLeft = value.$minus(current0 = Deadline$.MODULE$.now());
                    if (timeLeft.toNanos() > 0L) {
                        this.wait(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeLeft.toMillis()), 10L));
                        deadline = Deadline$.MODULE$.now();
                    } else {
                        deadline = current0;
                    }
                } else {
                    throw new MatchError(option);
                }
                Deadline current = deadline;
                while (this.sleepers.headOption().exists((Function1 & Serializable)_$3 -> _$3.wakeTime().$less$eq((Object)current))) {
                    Sleeper task = (Sleeper)this.sleepers.dequeue();
                    if (task.isCancelled()) continue;
                    this.execute(task.toRun());
                }
            }
        }
    }

    public Thread sleeperThread() {
        return this.sleeperThread;
    }

    private static final boolean $anonfun$4() {
        return true;
    }

    public static final /* synthetic */ void gears$async$native$ExecutorWithSleepThread$$_$schedule$$anonfun$1(Sleeper sleeper$2) {
        sleeper$2.isCancelled_$eq(true);
    }

    public class Sleeper
    implements Product,
    Serializable {
        private final Deadline wakeTime;
        private final Runnable toRun;
        private boolean isCancelled;
        private final /* synthetic */ ExecutorWithSleepThread $outer;

        public Sleeper(ExecutorWithSleepThread $outer, Deadline wakeTime, Runnable toRun) {
            this.wakeTime = wakeTime;
            this.toRun = toRun;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.isCancelled = false;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Sleeper)) return false;
            if (((Sleeper)object).gears$async$native$ExecutorWithSleepThread$Sleeper$$$outer() != this.$outer) return false;
            Sleeper sleeper = (Sleeper)object;
            Deadline deadline = this.wakeTime();
            Deadline deadline2 = sleeper.wakeTime();
            if (deadline == null) {
                if (deadline2 != null) {
                    return false;
                }
            } else if (!deadline.equals(deadline2)) return false;
            Runnable runnable = this.toRun();
            Runnable runnable2 = sleeper.toRun();
            if (runnable == null) {
                if (runnable2 != null) {
                    return false;
                }
            } else if (!runnable.equals(runnable2)) return false;
            if (!sleeper.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Sleeper;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Sleeper";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "wakeTime";
            }
            if (1 == n2) {
                return "toRun";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Deadline wakeTime() {
            return this.wakeTime;
        }

        public Runnable toRun() {
            return this.toRun;
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void isCancelled_$eq(boolean x$1) {
            this.isCancelled = x$1;
        }

        public Sleeper copy(Deadline wakeTime, Runnable toRun) {
            return new Sleeper(this.$outer, wakeTime, toRun);
        }

        public Deadline copy$default$1() {
            return this.wakeTime();
        }

        public Runnable copy$default$2() {
            return this.toRun();
        }

        public Deadline _1() {
            return this.wakeTime();
        }

        public Runnable _2() {
            return this.toRun();
        }

        public final /* synthetic */ ExecutorWithSleepThread gears$async$native$ExecutorWithSleepThread$Sleeper$$$outer() {
            return this.$outer;
        }
    }
}

