/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp;

import org.apache.commons.lang3.StringEscapeUtils;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class GradingFeedback$ {
    public static final GradingFeedback$ MODULE$;
    private final ListBuffer<String> feedbackSummary;
    private final ListBuffer<String> feedbackDetails;
    private double vTestScore;
    private double vStyleScore;
    private double vMaxTestScore;
    private double vMaxStyleScore;
    private String apiState;
    private boolean failed;
    private final String downloadUnpackFailedMessage;
    private final String compileFailedMessage;
    private final String testCompileFailedMessage;
    private final String testExecutionFailedMessage;

    static {
        new GradingFeedback$();
    }

    private ListBuffer<String> feedbackSummary() {
        return this.feedbackSummary;
    }

    private ListBuffer<String> feedbackDetails() {
        return this.feedbackDetails;
    }

    private void addSummary(String msg) {
        this.feedbackSummary().$plus$eq((Object)msg);
        this.feedbackSummary().$plus$eq((Object)"\n\n");
    }

    private void addDetails(String msg) {
        this.feedbackDetails().$plus$eq((Object)msg);
        this.feedbackDetails().$plus$eq((Object)"\n\n");
    }

    public String feedbackString(String uuid, boolean html) {
        String total = new StringBuilder().append((Object)this.totalGradeMessage(this.totalScore())).append((Object)"\n\n").toString();
        String s = new StringBuilder().append((Object)total).append((Object)this.feedbackSummary().mkString()).append((Object)this.feedbackDetails().mkString()).append((Object)this.uniqueGradeId(uuid)).append((Object)"\n\n").toString().trim();
        return html ? new StringBuilder().append((Object)"<pre>").append((Object)StringEscapeUtils.escapeHtml4((String)s)).append((Object)"</pre>").toString() : s;
    }

    public boolean feedbackString$default$2() {
        return true;
    }

    private double vTestScore() {
        return this.vTestScore;
    }

    private void vTestScore_$eq(double x$1) {
        this.vTestScore = x$1;
    }

    private double vStyleScore() {
        return this.vStyleScore;
    }

    private void vStyleScore_$eq(double x$1) {
        this.vStyleScore = x$1;
    }

    public double totalScore() {
        return this.vTestScore() + this.vStyleScore();
    }

    private double vMaxTestScore() {
        return this.vMaxTestScore;
    }

    private void vMaxTestScore_$eq(double x$1) {
        this.vMaxTestScore = x$1;
    }

    private double vMaxStyleScore() {
        return this.vMaxStyleScore;
    }

    private void vMaxStyleScore_$eq(double x$1) {
        this.vMaxStyleScore = x$1;
    }

    public double maxTestScore() {
        return this.vMaxTestScore();
    }

    public double maxStyleScore() {
        return this.vMaxStyleScore();
    }

    public String apiState() {
        return this.apiState;
    }

    public void apiState_$eq(String x$1) {
        this.apiState = x$1;
    }

    private boolean failed() {
        return this.failed;
    }

    private void failed_$eq(boolean x$1) {
        this.failed = x$1;
    }

    public boolean isFailed() {
        return this.failed();
    }

    public void initialize() {
        this.feedbackSummary().clear();
        this.feedbackDetails().clear();
        this.vTestScore_$eq(0.0);
        this.vStyleScore_$eq(0.0);
        this.apiState_$eq("");
        this.failed_$eq(false);
    }

    public void setMaxScore(double maxScore, double styleScoreRatio) {
        this.vMaxTestScore_$eq(maxScore * (1.0 - styleScoreRatio));
        this.vMaxStyleScore_$eq(maxScore * styleScoreRatio);
    }

    public void downloadUnpackFailed(String log) {
        this.failed_$eq(true);
        this.addSummary(this.downloadUnpackFailedMessage());
        this.addDetails("======== FAILURES WHILE DOWNLOADING OR EXTRACTING THE SUBMISSION ========");
        this.addDetails(log);
    }

    public void compileFailed(String log) {
        this.failed_$eq(true);
        this.addSummary(this.compileFailedMessage());
        this.addDetails("======== COMPILATION FAILURES ========");
        this.addDetails(log);
    }

    public void testCompileFailed(String log) {
        this.failed_$eq(true);
        this.addSummary(this.testCompileFailedMessage());
        this.addDetails("======== TEST COMPILATION FAILURES ========");
        this.addDetails(log);
    }

    public void allTestsPassed() {
        this.addSummary(this.allTestsPassedMessage());
        this.vTestScore_$eq(this.maxTestScore());
    }

    public void testsFailed(String log, double score) {
        this.addSummary(this.testsFailedMessage(score));
        this.vTestScore_$eq(score);
        this.addDetails("======== LOG OF FAILED TESTS ========");
        this.addDetails(log);
    }

    public void testExecutionFailed(String log) {
        this.failed_$eq(true);
        this.addSummary(this.testExecutionFailedMessage());
        this.addDetails("======== ERROR LOG OF TESTING TOOL ========");
        this.addDetails(log);
    }

    public void testExecutionDebugLog(String log) {
        this.addDetails("======== DEBUG OUTPUT OF TESTING TOOL ========");
        this.addDetails(log);
    }

    public void perfectStyle() {
        this.addSummary(this.perfectStyleMessage());
        this.vStyleScore_$eq(this.maxStyleScore());
    }

    public void styleProblems(String log, double score) {
        this.addSummary(this.styleProblemsMessage(score));
        this.vStyleScore_$eq(score);
        this.addDetails("======== CODING STYLE ISSUES ========");
        this.addDetails(log);
    }

    private String downloadUnpackFailedMessage() {
        return this.downloadUnpackFailedMessage;
    }

    private String compileFailedMessage() {
        return this.compileFailedMessage;
    }

    private String testCompileFailedMessage() {
        return this.testCompileFailedMessage;
    }

    private String testsFailedMessage(double score) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("The code you submitted did not pass all of our tests: your submission achieved a score of\n      |%.2f out of %.2f in our tests.\n      |\n      |In order to find bugs in your code, we advise to perform the following steps:\n      | - Take a close look at the test output that you can find below: it should point you to\n      |   the part of your code that has bugs.\n      | - Run the tests that we provide with the handout on your code.\n      | - The tests we provide do not test your code in depth: they are very incomplete. In order\n      |   to test more aspects of your code, write your own unit tests.\n      | - Take another very careful look at the assignment description. Try to find out if you\n      |   misunderstood parts of it. While reading through the assignment, write more tests.\n      |\n      |Below you can find a short feedback for every individual test that failed.")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)score), BoxesRunTime.boxToDouble((double)this.vMaxTestScore())}));
    }

    private String allTestsPassedMessage() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("Your solution passed all of our tests, congratulations! You obtained the maximal test\n      |score of %.2f.")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.vMaxTestScore())}));
    }

    private String testExecutionFailedMessage() {
        return this.testExecutionFailedMessage;
    }

    private String perfectStyleMessage() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("Our automated style checker tool could not find any issues with your code. You obtained the maximal\n      |style score of %.2f.")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.vMaxStyleScore())}));
    }

    private String styleProblemsMessage(double score) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("Our automated style checker tool found issues in your code with respect to coding style: it\n      |computed a style score of %.2f out of %.2f for your submission. See below for detailed feedback.")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)score), BoxesRunTime.boxToDouble((double)this.vMaxStyleScore())}));
    }

    private String totalGradeMessage(double score) {
        return new StringOps(Predef$.MODULE$.augmentString("Your overall score for this assignment is %.2f out of %.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)score), BoxesRunTime.boxToDouble((double)(this.vMaxTestScore() + this.vMaxStyleScore()))}));
    }

    private String uniqueGradeId(String s) {
        return new StringOps(Predef$.MODULE$.augmentString("Unique identifier of this grade is %s. This identifier will uniquely identify your assignment throughout the grading system.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private GradingFeedback$() {
        MODULE$ = this;
        this.feedbackSummary = new ListBuffer();
        this.feedbackDetails = new ListBuffer();
        this.vTestScore = 0.0;
        this.vStyleScore = 0.0;
        this.vMaxTestScore = 0.0;
        this.vMaxStyleScore = 0.0;
        this.apiState = "";
        this.failed = false;
        this.downloadUnpackFailedMessage = new StringOps(Predef$.MODULE$.augmentString("We were not able to download your submission from the coursera servers, or extracting the\n      |archive containing your source code failed.\n      |\n      |If you see this error message as your grade feedback, please contact one of the teaching\n      |assistants. See below for a detailed error log.")).stripMargin();
        this.compileFailedMessage = new StringOps(Predef$.MODULE$.augmentString("We were not able to compile the source code you submitted. This is not expected to happen,\n      |because the `submit` command in SBT can only be executed if your source code compiles.\n      |\n      |Please verify the following points:\n      | - You should use the `submit` command in SBT to upload your solution\n      | - You should not perform any changes to the SBT project definition files, i.e. the *.sbt\n      |   files, and the files in the `project/` directory\n      |\n      |Take a careful look at the compiler output below - maybe you can find out what the problem is.\n      |\n      |If you cannot find a solution, ask for help on the discussion forums on the course website.")).stripMargin();
        this.testCompileFailedMessage = new StringOps(Predef$.MODULE$.augmentString("We were not able to compile our tests, and therefore we could not correct your submission.\n      |\n      |The most likely reason for this problem is that your submitted code uses different names\n      |for methods, classes, objects or different types than expected.\n      |\n      |In principle, this can only arise if you changed some names or types in the code that we\n      |provide, for instance a method name or a parameter type.\n      |\n      |To diagnose your problem, perform the following steps:\n      | - Run the tests that we provide with our hand-out. These tests verify that all names and\n      |   types are correct. In case these tests pass, but you still see this message, please post\n      |   a report on the forums [1].\n      | - Take a careful look at the error messages from the Scala compiler below. They should give\n      |   you a hint where your code has an unexpected shape.\n      |\n      |If you cannot find a solution, ask for help on the discussion forums on the course website.")).stripMargin();
        this.testExecutionFailedMessage = new StringOps(Predef$.MODULE$.augmentString("An error occurred while running our tests on your submission.\n      |\n      |In order for us to help you, please contact one of the teaching assistants and send\n      |them the entire feedback message that you received.")).stripMargin();
    }
}

