/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.instragent;

import ch.epfl.lamp.instragent.ProfilerVisitor;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ASMTransformer
implements ClassFileTransformer {
    private final String[] shouldTransformPrefixes;

    public ASMTransformer() {
        String string = System.getProperty("ch.epfl.lamp.instragent.classprefixes", "");
        this.shouldTransformPrefixes = string.split(":");
    }

    private boolean shouldTransform(String string) {
        return this.shouldTransformPrefixExists(string) && !string.startsWith("ch/epfl/lamp/instragent/") && !string.startsWith("ch/epfl/lamp/grading/");
    }

    private boolean shouldTransformPrefixExists(String string) {
        for (String string2 : this.shouldTransformPrefixes) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] transform(final ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        if (this.shouldTransform(string)) {
            ClassWriter classWriter = new ClassWriter(3){

                protected String getCommonSuperClass(String string, String string2) {
                    Class<?> clazz;
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName(string.replace('/', '.'), false, classLoader);
                        clazz = Class.forName(string2.replace('/', '.'), false, classLoader);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                    if (clazz2.isAssignableFrom(clazz)) {
                        return string;
                    }
                    if (clazz.isAssignableFrom(clazz2)) {
                        return string2;
                    }
                    if (clazz2.isInterface() || clazz.isInterface()) {
                        return "java/lang/Object";
                    }
                    while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz)) {
                    }
                    return clazz2.getName().replace('.', '/');
                }
            };
            ProfilerVisitor profilerVisitor = new ProfilerVisitor((ClassVisitor)classWriter);
            ClassReader classReader = new ClassReader(byArray);
            classReader.accept((ClassVisitor)profilerVisitor, 0);
            return classWriter.toByteArray();
        }
        return byArray;
    }
}

