/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.grading.instrumented;

import java.util.HashMap;
import java.util.Map;

public class Profiler {
    private static boolean isProfiling = false;
    private static Map<MethodCallTrace, Integer> counts = new HashMap<MethodCallTrace, Integer>();

    public static void startProfiling() {
        isProfiling = true;
    }

    public static void stopProfiling() {
        isProfiling = false;
    }

    public static boolean isProfiling() {
        return isProfiling;
    }

    public static void resetProfiling() {
        counts = new HashMap<MethodCallTrace, Integer>();
    }

    public static void methodCalled(String string, String string2, String string3) {
        if (isProfiling) {
            MethodCallTrace methodCallTrace = new MethodCallTrace(string, string2, string3);
            Integer n = counts.get(methodCallTrace);
            if (n == null) {
                counts.put(methodCallTrace, 1);
            } else {
                counts.put(methodCallTrace, n + 1);
            }
        }
    }

    public static Map<MethodCallTrace, Integer> getStatistics() {
        return new HashMap<MethodCallTrace, Integer>(counts);
    }

    public static class MethodCallTrace {
        final String className;
        final String methodName;
        final String methodDescriptor;

        public MethodCallTrace(String string, String string2, String string3) {
            this.className = string;
            this.methodName = string2;
            this.methodDescriptor = string3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodCallTrace)) {
                return false;
            }
            MethodCallTrace methodCallTrace = (MethodCallTrace)object;
            return methodCallTrace.className.equals(this.className) && methodCallTrace.methodName.equals(this.methodName) && methodCallTrace.methodDescriptor.equals(this.methodDescriptor);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.methodName.hashCode() ^ this.methodDescriptor.hashCode();
        }
    }
}

