/*
 * Decompiled with CFR 0.152.
 */
package bloop.logging;

import bloop.logging.BloopLogger;
import com.google.common.collect.MapMaker;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;

public final class BloopLogger$ {
    public static BloopLogger$ MODULE$;
    private final String DefaultLayout;
    private final Map<BloopLogger, OutputStream> currentStreams;

    static {
        new BloopLogger$();
    }

    public BloopLogger apply(String name) {
        return new BloopLogger(name);
    }

    private String DefaultLayout() {
        return this.DefaultLayout;
    }

    private final String AppenderName() {
        return "BloopCommonOptionsAppender";
    }

    private void swapOut(BloopLogger logger, OutputStream out) {
        BloopLogger bloopLogger = logger;
        synchronized (bloopLogger) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withPattern(this.DefaultLayout()).build();
            String appenderName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BloopCommonOptionsAppender", logger.name()}));
            OutputStreamAppender appender = OutputStreamAppender.newBuilder().setName(appenderName).setLayout((Layout)layout).setTarget(out).setFollow(true).build();
            appender.start();
            LoggerConfig currentLoggerConfig = config.getLoggerConfig(logger.name());
            currentLoggerConfig.removeAppender("STDOUT");
            currentLoggerConfig.removeAppender(appenderName);
            currentLoggerConfig.addAppender((Appender)appender, null, null);
            ctx.updateLoggers();
        }
    }

    private Map<BloopLogger, OutputStream> currentStreams() {
        return this.currentStreams;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(BloopLogger logger, OutputStream out) {
        Option option = this.currentStreams().get((Object)logger);
        if (option instanceof Some) {
            OutputStream previousOut;
            Some some = (Some)option;
            OutputStream outputStream = previousOut = (OutputStream)some.value();
            OutputStream outputStream2 = out;
            if (!(outputStream != null ? !outputStream.equals(outputStream2) : outputStream2 != null)) {
                logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update of out (", ") in logger ", " is cached."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{out, logger.name()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.swapAndCache$1(logger, out);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void swapAndCache$1(BloopLogger logger$1, OutputStream out$1) {
        logger$1.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating logger ", " to use ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logger$1.name(), out$1})));
        this.swapOut(logger$1, out$1);
        this.currentStreams().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logger$1), (Object)out$1));
    }

    private BloopLogger$() {
        MODULE$ = this;
        this.DefaultLayout = "%highlight{%equals{[%-0.-1level] }{[I] }{}}{FATAL=white, ERROR=bright red, WARN=yellow, INFO=dim blue, DEBUG=green, TRACE=blue}%msg%n";
        this.currentStreams = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new MapMaker().weakKeys().makeMap()).asScala();
    }
}

