/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import io.github.soc.directories.ProjectDirectories;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Paths$ {
    public static Paths$ MODULE$;
    private final ProjectDirectories projectDirectories;
    private final Path bloopCacheDir;
    private final Path bloopDataDir;
    private final Path bloopLogsDir;
    private final Path bloopConfigDir;

    static {
        new Paths$();
    }

    private ProjectDirectories projectDirectories() {
        return this.projectDirectories;
    }

    private Path createDirFor(String filepath) {
        return AbsolutePath$.MODULE$.apply(Files.createDirectories(Paths.get(filepath, new String[0]), new FileAttribute[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public final Path bloopCacheDir() {
        return this.bloopCacheDir;
    }

    public final Path bloopDataDir() {
        return this.bloopDataDir;
    }

    public final Path bloopLogsDir() {
        return this.bloopLogsDir;
    }

    public final Path bloopConfigDir() {
        return this.bloopConfigDir;
    }

    /*
     * WARNING - void declaration
     */
    public Path getCacheDirectory(String dirName) {
        void var2_2;
        Path path;
        Path dir = AbsolutePath$.MODULE$.resolve$extension1(this.bloopCacheDir(), dirName);
        Path dirPath = dir;
        if (!Files.exists(dirPath, new LinkOption[0])) {
            path = Files.createDirectory(dirPath, new FileAttribute[0]);
        } else {
            Predef$.MODULE$.require(Files.isDirectory(dirPath, new LinkOption[0]), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("File '").append(AbsolutePath$.MODULE$.syntax$extension(dir)).append("' is not a directory.").toString());
            path = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public AbsolutePath[] getAllFiles(Path base, String pattern, int maxDepth) {
        ArrayBuffer out = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        FileVisitor<Path> visitor = new FileVisitor<Path>(out, matcher){
            private final ArrayBuffer out$1;
            private final PathMatcher matcher$1;

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$1.matches(file) ? this.out$1.$plus$eq((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()))) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.out$1 = out$1;
                this.matcher$1 = matcher$1;
            }
        };
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(base, opts, maxDepth, (FileVisitor<? super Path>)visitor);
        return (AbsolutePath[])out.toArray(ClassTag$.MODULE$.apply(AbsolutePath.class));
    }

    public int getAllFiles$default$3() {
        return Integer.MAX_VALUE;
    }

    public void delete(Path path) {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                try {
                    Files.delete(dir);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {}
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Paths$() {
        MODULE$ = this;
        this.projectDirectories = ProjectDirectories.from((String)"", (String)"", (String)"bloop");
        this.bloopCacheDir = this.createDirFor(this.projectDirectories().cacheDir);
        this.bloopDataDir = this.createDirFor(this.projectDirectories().dataDir);
        this.bloopLogsDir = this.createDirFor(AbsolutePath$.MODULE$.syntax$extension(AbsolutePath$.MODULE$.resolve$extension1(this.bloopDataDir(), "logs")));
        this.bloopConfigDir = this.createDirFor(this.projectDirectories().configDir);
    }
}

