/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.DependencyResolution$;
import bloop.ScalaInstance;
import bloop.internal.build.BloopScalaInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter$Compilation$;
import bloop.logging.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import jline.console.ConsoleReader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.Trees;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Main$;
import scala.util.control.NonFatal$;
import scala.xml.Node;

public final class ScalaInstance$ {
    public static ScalaInstance$ MODULE$;
    private final ConcurrentHashMap<Tuple3<String, String, String>, ScalaInstance> instancesById;
    private final ConcurrentHashMap<List<Path>, ScalaInstance> instancesByJar;
    private Option<ScalaInstance> cachedBloopScalaInstance;

    static {
        new ScalaInstance$();
    }

    public final String ScalacCompilerName() {
        return "scala-compiler";
    }

    public ScalaInstance apply(String scalaOrg, String scalaName, String scalaVersion, Seq<Path> allJars, Logger logger) {
        ScalaInstance scalaInstance;
        List jarsKey = ((TraversableOnce)((SeqLike)allJars.map((Function1 & Serializable & scala.Serializable)x$4 -> ((AbsolutePath)x$4).underlying(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> ((Object)x$5).toString(), (Ordering)Ordering.String$.MODULE$)).toList();
        if (allJars.nonEmpty()) {
            Seq nonExistingJars = (Seq)allJars.filter((Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$5(((AbsolutePath)j).underlying())));
            nonExistingJars.foreach((Function1 & Serializable & scala.Serializable)p -> {
                logger.warn(new StringBuilder(34).append("Scala instance jar ").append(AbsolutePath$.MODULE$.syntax$extension(((AbsolutePath)p).underlying())).append(" doesn't exist!").toString());
                return BoxedUnit.UNIT;
            });
            scalaInstance = this.instancesByJar().computeIfAbsent((List<Path>)jarsKey, x$7 -> ScalaInstance$.newInstance$1(scalaOrg, scalaName, scalaVersion, allJars, logger, jarsKey));
        } else {
            scalaInstance = this.resolve(scalaOrg, scalaName, scalaVersion, logger);
        }
        return scalaInstance;
    }

    private ConcurrentHashMap<Tuple3<String, String, String>, ScalaInstance> instancesById() {
        return this.instancesById;
    }

    private ConcurrentHashMap<List<Path>, ScalaInstance> instancesByJar() {
        return this.instancesByJar;
    }

    public ScalaInstance resolve(String scalaOrg, String scalaName, String scalaVersion, Logger logger) {
        Tuple3 instanceId = new Tuple3((Object)scalaOrg, (Object)scalaName, (Object)scalaVersion);
        return this.instancesById().computeIfAbsent((Tuple3<String, String, String>)instanceId, x$8 -> ScalaInstance$.resolveInstance$1(scalaOrg, scalaName, scalaVersion, logger));
    }

    /*
     * WARNING - void declaration
     */
    public Option<ScalaInstance> scalaInstanceFromBloop(Logger logger) {
        Option<ScalaInstance> option;
        if (this.cachedBloopScalaInstance != null) {
            option = this.cachedBloopScalaInstance;
        } else {
            void var2_2;
            Option instance;
            this.cachedBloopScalaInstance = instance = ScalaInstance$.findLocationForClazz$1(Predef$.MODULE$.getClass()).flatMap((Function1 & Serializable & scala.Serializable)scalaLibraryJar -> ScalaInstance$.findLocationForClazz$1(Trees.class).flatMap((Function1 & Serializable & scala.Serializable)scalaReflectJar -> ScalaInstance$.findLocationForClazz$1(Main$.MODULE$.getClass()).flatMap((Function1 & Serializable & scala.Serializable)scalaCompilerJar -> ScalaInstance$.findLocationForClazz$1(Node.class).flatMap((Function1 & Serializable & scala.Serializable)scalaXmlJar -> ScalaInstance$.findLocationForClazz$1(ConsoleReader.class).map((Function1 & Serializable & scala.Serializable)jlineJar -> {
                .colon.colon jars = new .colon.colon(scalaLibraryJar, (List)new .colon.colon(scalaReflectJar, (List)new .colon.colon(scalaCompilerJar, (List)new .colon.colon(scalaXmlJar, (List)new .colon.colon(jlineJar, (List)Nil$.MODULE$)))));
                return MODULE$.apply(BloopScalaInfo$.MODULE$.scalaOrganization(), "scala-compiler", BloopScalaInfo$.MODULE$.scalaVersion(), (Seq<Path>)((Seq)jars.map((Function1 & Serializable & scala.Serializable)x$9 -> new AbsolutePath(AbsolutePath$.MODULE$.apply(x$9, AbsolutePath$.MODULE$.workingDirectory())), List$.MODULE$.canBuildFrom())), logger);
            })))));
            option = var2_2;
        }
        return option;
    }

    public String getVersion(ClassLoader loader) {
        Option version = Option$.MODULE$.apply((Object)loader.getResource("compiler.properties")).flatMap((Function1 & Serializable & scala.Serializable)url -> {
            InputStream stream = url.openStream();
            Properties properties = new Properties();
            properties.load(stream);
            return Option$.MODULE$.apply((Object)((String)properties.get("version.number")));
        });
        return (String)version.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Loader ").append(loader).append(" doesn't have Scala in it!").toString());
    }

    private static final ScalaInstance newInstance$1(String scalaOrg$1, String scalaName$1, String scalaVersion$1, Seq allJars$1, Logger logger$1, List jarsKey$1) {
        logger$1.debug(new StringBuilder(33).append("Cache miss for scala instance ").append(scalaOrg$1).append(":").append(scalaName$1).append(":").append(scalaVersion$1).append(".").toString(), DebugFilter$Compilation$.MODULE$);
        jarsKey$1.foreach((Function1 & Serializable & scala.Serializable)p -> {
            logger$1.debug(new StringBuilder(5).append("  => ").append(p).toString(), DebugFilter$Compilation$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return new ScalaInstance(scalaOrg$1, scalaName$1, scalaVersion$1, (File[])((TraversableOnce)allJars$1.map((Function1 & Serializable & scala.Serializable)x$6 -> AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)x$6).underlying()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Path j) {
        return !Files.exists(j, new LinkOption[0]);
    }

    private static final ScalaInstance resolveInstance$1(String scalaOrg$2, String scalaName$2, String scalaVersion$2, Logger logger$2) {
        AbsolutePath[] allPaths = DependencyResolution$.MODULE$.resolve(scalaOrg$2, scalaName$2, scalaVersion$2, logger$2, DependencyResolution$.MODULE$.resolve$default$5());
        File[] allJars = (File[])Predef$.MODULE$.genericArrayOps((Object)allPaths).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = ((Object)A1).toString().endsWith(".jar") ? A1.toFile() : function1.apply((Object)new AbsolutePath(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = ((Object)path).toString().endsWith(".jar");
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ScalaInstance(scalaOrg$2, scalaName$2, scalaVersion$2, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allJars)).toArray(ClassTag$.MODULE$.apply(File.class)));
    }

    private static final Option findLocationForClazz$1(Class clazz) {
        Some some;
        try {
            some = new Some((Object)Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private ScalaInstance$() {
        MODULE$ = this;
        this.instancesById = new ConcurrentHashMap();
        this.instancesByJar = new ConcurrentHashMap();
        this.cachedBloopScalaInstance = null;
    }
}

