/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.CompileInputs;
import bloop.CompileMode;
import bloop.Compiler;
import bloop.ScalaInstance;
import bloop.internal.Ecosystem$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.reporter.ProblemPerPhase;
import bloop.reporter.Reporter;
import bloop.util.AnalysisUtils$;
import ch.epfl.scala.bsp.StatusCode;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.FreshCompilerCache;
import sbt.internal.inc.bloop.BloopZincCompiler$;
import sbt.internal.inc.bloop.internal.StopPipelining;
import sbt.util.InterfaceUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import xsbti.CompileCancelled;
import xsbti.CompileFailed;
import xsbti.Logger;
import xsbti.Problem;
import xsbti.T2;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOptions;
import xsbti.compile.CompileResult;
import xsbti.compile.Compilers;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.Inputs;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.Setup;
import xsbti.compile.TransactionalManagerType;

public final class Compiler$ {
    public static Compiler$ MODULE$;

    static {
        new Compiler$();
    }

    public Task<Compiler.Result> compile(CompileInputs compileInputs) {
        List<ProblemPerPhase> list;
        File classesDir = AbsolutePath$.MODULE$.toFile$extension(compileInputs.classesDir());
        File classesDirBak = AbsolutePath$.MODULE$.toFile$extension(AbsolutePath$.MODULE$.resolve$extension1(AbsolutePath$.MODULE$.getParent$extension(compileInputs.classesDir()), "classes.bak"));
        long start = System.nanoTime();
        ScalaInstance scalaInstance = compileInputs.scalaInstance();
        ClasspathOptions classpathOptions = compileInputs.classpathOptions();
        Compilers compilers = compileInputs.compilerCache().get(scalaInstance);
        Inputs inputs = Compiler$.getInputs$1(compilers, compileInputs, classesDir, classesDirBak);
        Reporter reporter = compileInputs.reporter();
        Option previousAnalysis = InterfaceUtil$.MODULE$.toOption(compileInputs.previousResult().analysis());
        Compiler.Result result = compileInputs.previousCompilerResult();
        if (result instanceof Compiler.Result.Failed) {
            Compiler.Result.Failed failed = (Compiler.Result.Failed)result;
            list = failed.problems();
        } else if (result instanceof Compiler.Result.Cancelled) {
            Compiler.Result.Cancelled cancelled = (Compiler.Result.Cancelled)result;
            list = cancelled.problems();
        } else {
            list = result instanceof Compiler.Result.Success ? AnalysisUtils$.MODULE$.problemsFrom((Option<CompileAnalysis>)previousAnalysis) : Nil$.MODULE$;
        }
        List<ProblemPerPhase> previousProblems = list;
        reporter.reportStartCompilation(previousProblems);
        return BloopZincCompiler$.MODULE$.compile(inputs, compileInputs.mode(), reporter).materialize().doOnCancel(Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Compiler$.cancel$1(compileInputs, reporter))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var7_21;
            void var6_14;
            boolean bl = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompileResult result = (CompileResult)success.value();
                reporter.reportEndCompilation((Option<CompileAnalysis>)previousAnalysis, (Option<CompileAnalysis>)new Some((Object)result.analysis()), (StatusCode)StatusCode.Ok$.MODULE$);
                PreviousResult res = PreviousResult.of(Optional.of(result.analysis()), Optional.of(result.setup()));
                Compiler.Result.Success success2 = new Compiler.Result.Success(compileInputs.reporter(), res, Compiler$.elapsed$1(start));
                return var6_14;
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                if (failure.exception() instanceof CompileCancelled) {
                    reporter.reportEndCompilation((Option<CompileAnalysis>)previousAnalysis, (Option<CompileAnalysis>)None$.MODULE$, (StatusCode)StatusCode.Cancelled$.MODULE$);
                    Compiler.Result.Cancelled cancelled = new Compiler.Result.Cancelled((List<ProblemPerPhase>)reporter.allProblemsPerPhase().toList(), Compiler$.elapsed$1(start));
                    return var6_14;
                }
            }
            if (!bl) throw new MatchError((Object)try_);
            Throwable cause = failure.exception();
            reporter.reportEndCompilation((Option<CompileAnalysis>)previousAnalysis, (Option<CompileAnalysis>)None$.MODULE$, (StatusCode)StatusCode.Error$.MODULE$);
            Throwable throwable = cause;
            if (throwable instanceof StopPipelining) {
                StopPipelining stopPipelining = (StopPipelining)throwable;
                Compiler.Result.Blocked blocked = new Compiler.Result.Blocked(stopPipelining.failedProjectNames());
            } else if (throwable instanceof CompileFailed) {
                CompileFailed compileFailed = (CompileFailed)throwable;
                List reportedProblems = reporter.allProblemsPerPhase().toList();
                Set rawProblemsFromReporter = reportedProblems.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.problem()).toSet();
                List newProblems = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compileFailed.problems())).flatMap((Function1 & Serializable & scala.Serializable)p -> rawProblemsFromReporter.contains(p) ? Nil$.MODULE$ : new .colon.colon((Object)new ProblemPerPhase((Problem)p, (Option<String>)None$.MODULE$), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ProblemPerPhase.class))))).toList();
                List failedProblems = (List)reportedProblems.$plus$plus((GenTraversableOnce)newProblems, List$.MODULE$.canBuildFrom());
                Compiler.Result.Failed failed = new Compiler.Result.Failed((List<ProblemPerPhase>)failedProblems, (Option<Throwable>)None$.MODULE$, Compiler$.elapsed$1(start));
            } else {
                if (throwable == null) throw new MatchError((Object)throwable);
                Throwable throwable2 = throwable;
                throwable2.printStackTrace();
                Compiler.Result.Failed failed = new Compiler.Result.Failed((List<ProblemPerPhase>)Nil$.MODULE$, (Option<Throwable>)new Some((Object)throwable2), Compiler$.elapsed$1(start));
            }
            void var6_13 = var7_21;
            return var6_14;
        });
    }

    private static final Inputs getInputs$1(Compilers compilers, CompileInputs compileInputs$1, File classesDir$1, File classesDirBak$1) {
        CompileOptions options = Compiler$.getCompilationOptions$1(compileInputs$1);
        Setup setup = Compiler$.getSetup$1(compileInputs$1, classesDir$1, classesDirBak$1);
        return Inputs.of((Compilers)compilers, (CompileOptions)options, (Setup)setup, (PreviousResult)compileInputs$1.previousResult());
    }

    private static final CompileOptions getCompilationOptions$1(CompileInputs inputs) {
        AbsolutePath[] sources = inputs.sources();
        File classesDir = AbsolutePath$.MODULE$.toFile$extension(inputs.classesDir());
        File[] classpath = (File[])Predef$.MODULE$.genericArrayOps((Object)inputs.classpath()).map((Function1 & Serializable & scala.Serializable)x$2 -> AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)x$2).underlying()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return CompileOptions.create().withClassesDirectory(classesDir).withSources((File[])Predef$.MODULE$.genericArrayOps((Object)sources).map((Function1 & Serializable & scala.Serializable)x$3 -> AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)x$3).underlying()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).withClasspath(classpath).withStore(inputs.store()).withScalacOptions(inputs.scalacOptions()).withJavacOptions(inputs.javacOptions()).withClasspathOptions(inputs.classpathOptions()).withOrder(inputs.compileOrder());
    }

    private static final IncOptions withTransactional$1(IncOptions opts, File classesDirBak$1, Reporter reporter$1) {
        return opts.withClassfileManagerType(Optional.of(TransactionalManagerType.of((File)classesDirBak$1, (Logger)reporter$1.logger())));
    }

    private static final Setup getSetup$1(CompileInputs compileInputs, File classesDir$1, File classesDirBak$1) {
        Setup setup;
        boolean skip = false;
        T2[] empty = (T2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(T2.class));
        Map results = compileInputs.dependentResults().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)classesDir$1), (Object)compileInputs.previousResult()));
        Compiler.ZincClasspathEntryLookup lookup = new Compiler.ZincClasspathEntryLookup((Map<File, PreviousResult>)results);
        Reporter reporter = compileInputs.reporter();
        FreshCompilerCache compilerCache = new FreshCompilerCache();
        File cacheFile = AbsolutePath$.MODULE$.toFile$extension(AbsolutePath$.MODULE$.resolve$extension1(compileInputs.baseDirectory(), "cache"));
        boolean disableIncremental = Boolean.getBoolean("bloop.zinc.disabled");
        IncOptions opts = Compiler$.withTransactional$1(IncOptions.create().withEnabled(!disableIncremental), classesDirBak$1, reporter);
        IncOptions incOptions = !compileInputs.scalaInstance().isDotty() ? opts : Ecosystem$.MODULE$.supportDotty(opts);
        Optional<Compiler.BloopProgress> progress = Optional.of(new Compiler.BloopProgress(reporter, compileInputs.cancelPromise()));
        Setup setup2 = Setup.create((PerClasspathEntryLookup)lookup, (boolean)skip, (File)cacheFile, (GlobalsCache)compilerCache, (IncOptions)incOptions, (xsbti.Reporter)reporter, progress, (T2[])empty);
        CompileMode compileMode = compileInputs.mode();
        if (compileMode instanceof CompileMode.Pipelined) {
            CompileMode.Pipelined pipelined = (CompileMode.Pipelined)compileMode;
            setup = setup2.withIrPromise(pipelined.irs());
        } else if (compileMode instanceof CompileMode.ParallelAndPipelined) {
            CompileMode.ParallelAndPipelined parallelAndPipelined = (CompileMode.ParallelAndPipelined)compileMode;
            setup = setup2.withIrPromise(parallelAndPipelined.irs());
        } else {
            setup = setup2;
        }
        return setup;
    }

    private static final long elapsed$1(long start$1) {
        return (long)((double)(System.nanoTime() - start$1) / 1000000.0);
    }

    private static final void cancel$1(CompileInputs compileInputs$1, Reporter reporter$2) {
        Object object = !compileInputs$1.cancelPromise().isCompleted() ? compileInputs$1.cancelPromise().success((Object)BoxedUnit.UNIT) : BoxedUnit.UNIT;
        reporter$2.reportCancelledCompilation();
    }

    private Compiler$() {
        MODULE$ = this;
    }
}

