/*
 * Decompiled with CFR 0.152.
 */
package bloop.util;

import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.util.JavaRuntime;
import bloop.util.JavaRuntime$JDK$;
import bloop.util.JavaRuntime$JRE$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class JavaRuntime$ {
    public static JavaRuntime$ MODULE$;
    private Try<BoxedUnit> loadJavaDebugInterface;
    private final Path home;
    private final String version;
    private final Option<Path> javac;
    private final Option<JavaCompiler> javaCompiler;
    private volatile boolean bitmap$0;

    static {
        new JavaRuntime$();
    }

    public Path home() {
        return this.home;
    }

    public String version() {
        return this.version;
    }

    public Option<Path> javac() {
        return this.javac;
    }

    public Option<JavaCompiler> javaCompiler() {
        return this.javaCompiler;
    }

    public JavaRuntime current() {
        Product product;
        Option<JavaCompiler> option = this.javaCompiler();
        if (option instanceof Some) {
            product = JavaRuntime$JDK$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            product = JavaRuntime$JRE$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return product;
    }

    public Option<Path> javacBinaryFromJavaHome(Path home) {
        return !AbsolutePath$.MODULE$.exists$extension(home) ? None$.MODULE$ : Option$.MODULE$.apply((Object)new AbsolutePath(JavaRuntime$.toJavaBinary$1(home))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbsolutePath$.MODULE$.exists$extension(((AbsolutePath)x$1).underlying()))).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)new AbsolutePath(JavaRuntime$.toJavaBinary$1(AbsolutePath$.MODULE$.getParent$extension(home))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbsolutePath$.MODULE$.exists$extension(((AbsolutePath)x$2).underlying())));
    }

    private Try<BoxedUnit> loadJavaDebugInterface$lzycompute() {
        JavaRuntime$ javaRuntime$ = this;
        synchronized (javaRuntime$) {
            if (!this.bitmap$0) {
                this.loadJavaDebugInterface = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JavaRuntime$.initializeJDI$1()).orElse((Function0 & Serializable & scala.Serializable)() -> JavaRuntime$.loadTools$1()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                    JavaRuntime$.$anonfun$loadJavaDebugInterface$5(x$4);
                    return BoxedUnit.UNIT;
                });
                this.bitmap$0 = true;
            }
        }
        return this.loadJavaDebugInterface;
    }

    public Try<BoxedUnit> loadJavaDebugInterface() {
        return !this.bitmap$0 ? this.loadJavaDebugInterface$lzycompute() : this.loadJavaDebugInterface;
    }

    private static final Path toJavaBinary$1(Path home) {
        return AbsolutePath$.MODULE$.resolve$extension1(AbsolutePath$.MODULE$.resolve$extension1(home, "bin"), "javac");
    }

    private static final void initializeJDI$1() {
        Class.forName("com.sun.jdi.Value");
    }

    private static final Try loadTools$1() {
        Failure failure;
        Option urls = Option$.MODULE$.apply((Object)ToolProvider.getSystemToolClassLoader()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ClassLoader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                URL[] uRLArray;
                A1 A1 = x1;
                if (A1 instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)A1;
                    uRLArray = uRLClassLoader.getURLs();
                } else {
                    uRLArray = function1.apply(x1);
                }
                return (B1)uRLArray;
            }

            public final boolean isDefinedAt(ClassLoader x1) {
                ClassLoader classLoader = x1;
                boolean bl = classLoader instanceof URLClassLoader;
                return bl;
            }
        });
        Option option = urls;
        if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new Exception("JDI implementation is not provided by the vendor"));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            URL[] urls2 = (URL[])some.value();
            Try hotLoadTools = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls2)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> method.invoke((Object)MODULE$.getClass().getClassLoader(), x$3));
                JavaRuntime$.initializeJDI$1();
            });
            failure = hotLoadTools.recoverWith((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof ClassNotFoundException) {
                        ClassNotFoundException classNotFoundException = (ClassNotFoundException)A1;
                        object = new Failure((Throwable)new Exception("JDI implementation is not on the classpath", classNotFoundException));
                    } else if (A1 instanceof ReflectiveOperationException) {
                        ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)A1;
                        object = new Failure((Throwable)new Exception(new StringBuilder(29).append("Could not load tools due to: ").append(reflectiveOperationException.getMessage()).toString(), reflectiveOperationException));
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof ClassNotFoundException ? true : throwable instanceof ReflectiveOperationException;
                    return bl;
                }
            });
        } else {
            throw new MatchError((Object)option);
        }
        return failure;
    }

    public static final /* synthetic */ void $anonfun$loadJavaDebugInterface$5(BoxedUnit x$4) {
    }

    private JavaRuntime$() {
        MODULE$ = this;
        this.home = AbsolutePath$.MODULE$.apply((String)package$.MODULE$.props().apply((Object)"java.home"), AbsolutePath$.MODULE$.workingDirectory());
        this.version = (String)package$.MODULE$.props().apply((Object)"java.version");
        this.javac = this.javacBinaryFromJavaHome(this.home());
        this.javaCompiler = Option$.MODULE$.apply((Object)ToolProvider.getSystemJavaCompiler());
    }
}

