/*
 * Decompiled with CFR 0.152.
 */
package bloop.tracing;

import bloop.tracing.BraveTracer;
import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.Random$;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class BraveTracer$ {
    public static BraveTracer$ MODULE$;
    private final String zipkinServerUrl;
    private final boolean debugTrace;
    private final URLConnectionSender sender;
    private final SpanBytesEncoder jsonVersion;
    private final AsyncReporter<zipkin2.Span> spanReporter;

    static {
        new BraveTracer$();
    }

    public String zipkinServerUrl() {
        return this.zipkinServerUrl;
    }

    public boolean debugTrace() {
        return this.debugTrace;
    }

    public URLConnectionSender sender() {
        return this.sender;
    }

    public SpanBytesEncoder jsonVersion() {
        return this.jsonVersion;
    }

    public AsyncReporter<zipkin2.Span> spanReporter() {
        return this.spanReporter;
    }

    public BraveTracer apply(String name, Seq<Tuple2<String, String>> tags) {
        return this.apply(name, (Option<TraceContext>)None$.MODULE$, tags);
    }

    public BraveTracer apply(String name, Option<TraceContext> ctx, Seq<Tuple2<String, String>> tags) {
        Tracing tracing = Tracing.newBuilder().localServiceName("bloop").spanReporter(this.spanReporter()).build();
        Tracer tracer = tracing.tracer();
        Span newParentTrace = (Span)ctx.map((Function1 & Serializable & scala.Serializable)c -> tracer.newChild(c)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Span span;
            if (MODULE$.debugTrace()) {
                TraceContext c = TraceContext.newBuilder().traceId(Random$.MODULE$.nextLong()).spanId(Random$.MODULE$.nextLong()).debug(true).build();
                span = tracer.newChild(c);
            } else {
                span = tracer.newTrace();
            }
            return span;
        });
        Span rootSpan = (Span)tags.foldLeft((Object)newParentTrace.name(name), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Span span;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    span = (Span)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String tagKey = (String)tuple2._1();
            String tagValue = (String)tuple2._2();
            Span span2 = span.tag(tagKey, tagValue);
            return span2;
        });
        rootSpan.start();
        JFunction0.mcV.sp & Serializable & scala.Serializable closeEverything = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            rootSpan.finish();
            tracing.close();
            MODULE$.spanReporter().flush();
        };
        return new BraveTracer(tracer, rootSpan, (Function0<BoxedUnit>)closeEverything);
    }

    private BraveTracer$() {
        MODULE$ = this;
        this.zipkinServerUrl = (String)Option$.MODULE$.apply((Object)System.getProperty("zipkin.server.url")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "http://127.0.0.1:9411/api/v2/spans");
        this.debugTrace = Properties$.MODULE$.propOrFalse("zipkin.trace.debug");
        this.sender = URLConnectionSender.create((String)this.zipkinServerUrl());
        this.jsonVersion = this.zipkinServerUrl().contains("/api/v1") ? SpanBytesEncoder.JSON_V1 : SpanBytesEncoder.JSON_V2;
        this.spanReporter = AsyncReporter.builder((Sender)this.sender()).build((BytesEncoder)this.jsonVersion());
    }
}

