/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.bloop.internal;

import bloop.logging.ObservedLogger;
import bloop.reporter.ZincReporter;
import bloop.tracing.BraveTracer;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.PlainVirtualFileConverter$;
import sbt.internal.inc.bloop.internal.BloopHighLevelCompiler$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.io.IO$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.control.NonFatal$;
import xsbt.InterfaceCompileCancelled;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Problem;
import xsbti.VirtualFile;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompileOrder;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IncToolOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\t\u0013\u0005qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bM\u0003A\u0011\u0001+\t\r\u0005\u0004\u0001\u0015!\u0004c\u0011\u0019Q\u0007\u0001)A\u0007W\"11\u0010\u0001Q\u0001\u000eqD\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0003\u0005\u0007K\u0002!\t!a\t\b\u000f\u0005U$\u0003#\u0001\u0002x\u00191\u0011C\u0005E\u0001\u0003sBaa\u0015\b\u0005\u0002\u0005m\u0004bBA?\u001d\u0011\u0005\u0011q\u0010\u0002\u0017\u00052|w\u000e\u001d%jO\"dUM^3m\u0007>l\u0007/\u001b7fe*\u00111\u0003F\u0001\tS:$XM\u001d8bY*\u0011QCF\u0001\u0006E2|w\u000e\u001d\u0006\u0003/a\t1!\u001b8d\u0015\t\u0019\u0012DC\u0001\u001b\u0003\r\u0019(\r^\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007g\u000e\fG.Y2\u0011\u0005\u00152S\"\u0001\f\n\u0005\u001d2\"!E!oC2L(0\u001b8h\u0007>l\u0007/\u001b7fe\u0006)!.\u0019<bGB\u0011!\u0006L\u0007\u0002W)\u0011\u0001FF\u0005\u0003[-\u0012Q#\u00118bYfT\u0018N\\4KCZ\f7i\\7qS2,'/\u0001\u0004d_:4\u0017n\u001a\t\u0003KAJ!!\r\f\u0003)\r{W\u000e]5mK\u000e{gNZ5hkJ\fG/[8o\u0003!\u0011X\r]8si\u0016\u0014\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001a7\u0015\u0005)\u0012B\u0001\u001d6\u00051Q\u0016N\\2SKB|'\u000f^3s\u0003\u0019awnZ4feB\u00121h\u0011\t\u0004y}\nU\"A\u001f\u000b\u0005y2\u0014a\u00027pO\u001eLgnZ\u0005\u0003\u0001v\u0012ab\u00142tKJ4X\r\u001a'pO\u001e,'\u000f\u0005\u0002C\u00072\u0001A!\u0003#\u0006\u0003\u0003\u0005\tQ!\u0001F\u0005\ryF%M\t\u0003\r&\u0003\"AH$\n\u0005!{\"a\u0002(pi\"Lgn\u001a\t\u0003=)K!aS\u0010\u0003\u0007\u0005s\u00170\u0001\u0004ue\u0006\u001cWM\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!Z\nq\u0001\u001e:bG&tw-\u0003\u0002S\u001f\nY!I]1wKR\u0013\u0018mY3s\u0003\u0019a\u0014N\\5u}Q9Qk\u0016-Z5n\u0003\u0007C\u0001,\u0001\u001b\u0005\u0011\u0002\"B\u0012\b\u0001\u0004!\u0003\"\u0002\u0015\b\u0001\u0004I\u0003\"\u0002\u0018\b\u0001\u0004y\u0003\"\u0002\u001a\b\u0001\u0004\u0019\u0004\"B\u001d\b\u0001\u0004a\u0006GA/`!\ratH\u0018\t\u0003\u0005~#\u0011\u0002R.\u0002\u0002\u0003\u0005)\u0011A#\t\u000b1;\u0001\u0019A'\u0002\u000bM,G/\u001e9\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017aB2p[BLG.\u001a\u0006\u0002O\u0006)\u0001p\u001d2uS&\u0011\u0011\u000e\u001a\u0002\n\u001b&t\u0017nU3ukB\f\u0011b\u00197bgN\u0004\u0018\r\u001e5\u0011\u00071$xO\u0004\u0002ne:\u0011a.]\u0007\u0002_*\u0011\u0001oG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!a]\u0010\u0002\u000fA\f7m[1hK&\u0011QO\u001e\u0002\u0004'\u0016\f(BA: !\tA\u00180D\u0001g\u0013\tQhMA\u0006WSJ$X/\u00197GS2,\u0017\u0001D2mCN\u001c\b/\u0019;i\u001d&|\u0007c\u00017u{B\u0019a0a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!a-\u001b7f\u0015\u0011\t)!a\u0002\u0002\u00079LwN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\r\tia \u0002\u0005!\u0006$\b.A\u0007KCZ\f7i\\7qY\u0016$X\r\u001a\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!bAA\f?\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0011Q\u0003\u0002\b!J|W.[:f!\rq\u0012qD\u0005\u0004\u0003Cy\"\u0001B+oSR$b\"!\n\u00026\u0005%\u00131KA/\u0003O\nY\u0007\u0005\u0004\u0002(\u0005E\u0012QD\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005!QM^1m\u0015\t\ty#A\u0003n_:L\u00070\u0003\u0003\u00024\u0005%\"\u0001\u0002+bg.Dq!a\u000e\r\u0001\u0004\tI$\u0001\tt_V\u00148-Z:U_\u000e{W\u000e]5mKB)\u00111HA\"o:!\u0011QHA !\tqw$C\u0002\u0002B}\ta\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u00121aU3u\u0015\r\t\te\b\u0005\b\u0003\u0017b\u0001\u0019AA'\u0003\u001d\u0019\u0007.\u00198hKN\u00042aYA(\u0013\r\t\t\u0006\u001a\u0002\u0012\t\u0016\u0004XM\u001c3f]\u000eL8\t[1oO\u0016\u001c\bbBA+\u0019\u0001\u0007\u0011qK\u0001\tG\u0006dGNY1dWB\u0019\u00010!\u0017\n\u0007\u0005mcM\u0001\tB]\u0006d\u0017p]5t\u0007\u0006dGNY1dW\"9\u0011q\f\u0007A\u0002\u0005\u0005\u0014\u0001E2mCN\u001ch-\u001b7f\u001b\u0006t\u0017mZ3s!\r\u0019\u00171M\u0005\u0004\u0003K\"'\u0001E\"mCN\u001ch)\u001b7f\u001b\u0006t\u0017mZ3s\u0011\u001d\tI\u0007\u0004a\u0001\u0003#\tQbY1oG\u0016d\u0007K]8nSN,\u0007bBA7\u0019\u0001\u0007\u0011qN\u0001\u0011G2\f7o\u001d9bi\"|\u0005\u000f^5p]N\u00042aYA9\u0013\r\t\u0019\b\u001a\u0002\u0011\u00072\f7o\u001d9bi\"|\u0005\u000f^5p]N\faC\u00117p_BD\u0015n\u001a5MKZ,GnQ8na&dWM\u001d\t\u0003-:\u0019\"AD\u000f\u0015\u0005\u0005]\u0014!B1qa2LHcC+\u0002\u0002\u0006\r\u0015QQAI\u0003'CQA\f\tA\u0002=BQA\r\tA\u0002MBa!\u000f\tA\u0002\u0005\u001d\u0005\u0007BAE\u0003\u001b\u0003B\u0001P \u0002\fB\u0019!)!$\u0005\u0017\u0005=\u0015QQA\u0001\u0002\u0003\u0015\t!\u0012\u0002\u0004?\u0012\u0012\u0004\"\u0002'\u0011\u0001\u0004i\u0005bBA7!\u0001\u0007\u0011q\u000e")
public final class BloopHighLevelCompiler {
    private final AnalyzingCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final ZincReporter reporter;
    private final ObservedLogger<?> logger;
    private final BraveTracer tracer;
    private final MiniSetup setup;
    private final Seq<VirtualFile> classpath;
    private final Seq<Path> classpathNio;
    private final Promise<BoxedUnit> JavaCompleted;

    public static BloopHighLevelCompiler apply(CompileConfiguration compileConfiguration, ZincReporter zincReporter, ObservedLogger<?> observedLogger, BraveTracer braveTracer, ClasspathOptions classpathOptions) {
        return BloopHighLevelCompiler$.MODULE$.apply(compileConfiguration, zincReporter, observedLogger, braveTracer, classpathOptions);
    }

    public Task<BoxedUnit> compile(Set<VirtualFile> sourcesToCompile, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager, Promise<BoxedUnit> cancelPromise, ClasspathOptions classpathOptions) {
        Task task;
        boolean existsCompilation;
        .colon.colon colon2;
        Output output = this.setup.output();
        if (output instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output;
            colon2 = new .colon.colon((Object)singleOutput.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        } else if (output instanceof MultipleOutput) {
            MultipleOutput multipleOutput = (MultipleOutput)output;
            colon2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multipleOutput.getOutputGroups())).iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getOutputDirectoryAsPath()).toList();
        } else {
            throw new MatchError((Object)output);
        }
        .colon.colon outputDirs = colon2;
        outputDirs.foreach((Function1 & Serializable & scala.Serializable)d -> {
            BloopHighLevelCompiler.$anonfun$compile$3(d);
            return BoxedUnit.UNIT;
        });
        Seq includedSources = (Seq)this.config.sources().filter(sourcesToCompile);
        Tuple2 tuple2 = includedSources.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BloopHighLevelCompiler.$anonfun$compile$4(x$3)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSources = (Seq)tuple2._1();
        Seq scalaSources = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)javaSources, (Object)scalaSources);
        Tuple2 tuple23 = tuple22;
        Seq javaSources2 = (Seq)tuple23._1();
        Seq scalaSources2 = (Seq)tuple23._2();
        boolean bl = existsCompilation = javaSources2.size() + scalaSources2.size() > 0;
        if (existsCompilation) {
            this.reporter.reportStartIncrementalCycle((Seq<VirtualFile>)includedSources, (Seq<File>)((Seq)outputDirs.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toFile(), List$.MODULE$.canBuildFrom())));
        }
        Object object = javaSources2.isEmpty() && !this.JavaCompleted.isCompleted() ? BoxesRunTime.boxToBoolean((boolean)this.JavaCompleted.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
        if (scalaSources2.isEmpty()) {
            task = Task$.MODULE$.now((Object)BoxedUnit.UNIT);
        } else {
            CompileOrder compileOrder = this.setup.order();
            CompileOrder compileOrder2 = CompileOrder.Mixed;
            Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? includedSources : scalaSources2;
            task = this.compileSequentially$1(sources, callback, classpathOptions, changes, cancelPromise);
        }
        Task compileScala = task;
        Task compileJava = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timed$1("javac", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager), (boolean)$this.config.incOptions().useCustomizedFileManager());
            String[] javaOptions = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.setup.options().javacOptions())).toArray(ClassTag$.MODULE$.apply(String.class));
            try {
                $this.javac.compile(javaSources2, (Seq)Nil$.MODULE$, (FileConverter)PlainVirtualFileConverter$.MODULE$.converter(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])javaOptions), $this.setup.output(), (Option)None$.MODULE$, callback, incToolOptions, $this.config.reporter(), $this.logger, $this.config.progress());
                $this.JavaCompleted.trySuccess((Object)BoxedUnit.UNIT);
            }
            catch (xsbti.CompileFailed f) {
                $this.config.reporter().printSummary();
                $this.JavaCompleted.tryFailure((Throwable)f);
                throw f;
            }
        }));
        CompileOrder compileOrder = this.setup.order();
        CompileOrder compileOrder3 = CompileOrder.JavaThenScala;
        Task combinedTasks = !(compileOrder != null ? !compileOrder.equals(compileOrder3) : compileOrder3 != null) ? compileJava.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> compileScala) : compileScala.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> compileJava);
        return Task$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.nanoTime()).flatMap((Function1 & Serializable & scala.Serializable)nanoStart -> BloopHighLevelCompiler.$anonfun$compile$13(this, combinedTasks, existsCompilation, BoxesRunTime.unboxToLong((Object)nanoStart))).dematerialize(Predef$.MODULE$.$conforms());
    }

    private final Object timed$1(String label, Function0 t) {
        return this.tracer.trace(label, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$1 -> t.apply());
    }

    public static final /* synthetic */ void $anonfun$compile$3(Path d) {
        block0: {
            if (d.endsWith(".jar") || Files.exists(d, new LinkOption[0])) break block0;
            IO$.MODULE$.createDirectory(d.toFile());
        }
    }

    public static final /* synthetic */ boolean $anonfun$compile$4(VirtualFile x$3) {
        return x$3.name().endsWith(".java");
    }

    private final CompilerArguments compilerArgs$1(ClasspathOptions classpathOptions$1) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().compilerJars())).isEmpty()) {
            throw new CompileFailed(new String[0], new StringBuilder(57).append("Expected Scala compiler jar in Scala instance containing ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().allJars())).mkString(", ")).toString(), new Problem[0]);
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().libraryJars())).isEmpty()) {
            throw new CompileFailed(new String[0], new StringBuilder(56).append("Expected Scala library jar in Scala instance containing ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scalac.scalaInstance().allJars())).mkString(", ")).toString(), new Problem[0]);
        }
        return new CompilerArguments(this.scalac.scalaInstance(), classpathOptions$1);
    }

    private final void compileSources$1(Seq sources, String[] scalacOptions, AnalysisCallback callback, DependencyChanges changes$1, Promise cancelPromise$1, ClasspathOptions classpathOptions$1) {
        try {
            Seq args = this.compilerArgs$1(classpathOptions$1).makeArguments((Seq)Nil$.MODULE$, this.classpathNio, (Seq)Predef$.MODULE$.wrapRefArray((Object[])scalacOptions));
            this.scalac.compile((VirtualFile[])sources.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])this.classpath.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (FileConverter)PlainVirtualFileConverter$.MODULE$.converter(), changes$1, (String[])args.toArray(ClassTag$.MODULE$.apply(String.class)), this.setup.output(), callback, this.config.reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption(this.config.progress()).toOptional(), this.logger);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.JavaCompleted.tryFailure(t);
                Throwable throwable3 = t;
                if (throwable3 instanceof NullPointerException && cancelPromise$1.isCompleted()) {
                    throw new InterfaceCompileCancelled((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Caught NPE when compilation was cancelled!");
                }
                throw throwable3;
            }
            throw throwable;
        }
    }

    private final Task compileSequentially$1(Seq sources$1, AnalysisCallback callback$1, ClasspathOptions classpathOptions$1, DependencyChanges changes$1, Promise cancelPromise$1) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] scalacOptions = $this.setup.options().scalacOptions();
            Seq args = this.compilerArgs$1(classpathOptions$1).makeArguments((Seq)Nil$.MODULE$, $this.classpathNio, (Seq)Predef$.MODULE$.wrapRefArray((Object[])scalacOptions));
            this.timed$1("scalac", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.compileSources$1(sources$1, scalacOptions, callback$1, changes$1, cancelPromise$1, classpathOptions$1));
        });
    }

    public static final /* synthetic */ Task $anonfun$compile$13(BloopHighLevelCompiler $this, Task combinedTasks$1, boolean existsCompilation$1, long nanoStart) {
        return combinedTasks$1.materialize().map((Function1 & Serializable & scala.Serializable)r -> {
            block0: {
                if (!existsCompilation$1) break block0;
                long elapsedMs = (System.nanoTime() - nanoStart) / 1000000L;
                $this.reporter.reportEndIncrementalCycle(elapsedMs, (Try<BoxedUnit>)r);
            }
            return r;
        });
    }

    public BloopHighLevelCompiler(AnalyzingCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, ZincReporter reporter, ObservedLogger<?> logger, BraveTracer tracer) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.reporter = reporter;
        this.logger = logger;
        this.tracer = tracer;
        this.setup = config.currentSetup();
        this.classpath = config.classpath();
        this.classpathNio = (Seq)this.classpath.map((Function1 & Serializable & scala.Serializable)ref -> PlainVirtualFileConverter$.MODULE$.converter().toPath(ref), Seq$.MODULE$.canBuildFrom());
        this.JavaCompleted = Promise$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }
}

