/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.io.ParallelOps;
import bloop.io.ParallelOps$CopyMode$NoReplace$;
import bloop.io.ParallelOps$CopyMode$ReplaceExisting$;
import bloop.io.ParallelOps$CopyMode$ReplaceIfMetadataMismatch$;
import bloop.logging.Logger;
import bloop.task.Task;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.cancelables.AssignableCancelable;
import monix.execution.cancelables.AssignableCancelable$;
import monix.execution.cancelables.CompositeCancelable;
import monix.execution.cancelables.CompositeCancelable$;
import monix.reactive.Consumer;
import monix.reactive.Consumer$;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class ParallelOps$ {
    public static ParallelOps$ MODULE$;
    private final ConcurrentHashMap<Path, Promise<BoxedUnit>> takenByOtherCopyProcess;

    static {
        new ParallelOps$();
    }

    public Task<ParallelOps.FileWalk> copyDirectories(ParallelOps.CopyConfiguration configuration, Path origin, Path target, Scheduler scheduler, boolean enableCancellation, Logger logger) {
        return bloop.task.Task$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            AtomicBoolean isCancelled = AtomicBoolean$.MODULE$.apply(false);
            ListBuffer visitedPaths = new ListBuffer();
            ListBuffer targetPaths = new ListBuffer();
            Tuple2 tuple2 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.publish(), scheduler);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Observer.Sync observer = (Observer.Sync)tuple2._1();
            Observable observable = (Observable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)observer, (Object)observable);
            Observer.Sync observer2 = (Observer.Sync)tuple22._1();
            Observable observable2 = (Observable)tuple22._2();
            FileVisitor<Path> discovery = new FileVisitor<Path>(target, isCancelled, configuration, visitedPaths, targetPaths, observer2){
                private boolean firstVisit;
                private Path currentTargetDirectory;
                private final AtomicBoolean isCancelled$1;
                private final ParallelOps.CopyConfiguration configuration$1;
                private final ListBuffer visitedPaths$1;
                private final ListBuffer targetPaths$1;
                private final Observer.Sync observer$1;

                public boolean firstVisit() {
                    return this.firstVisit;
                }

                public void firstVisit_$eq(boolean x$1) {
                    this.firstVisit = x$1;
                }

                public Path currentTargetDirectory() {
                    return this.currentTargetDirectory;
                }

                public void currentTargetDirectory_$eq(Path x$1) {
                    this.currentTargetDirectory = x$1;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    BoxedUnit boxedUnit;
                    if (this.isCancelled$1.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (attributes.isDirectory() || this.configuration$1.denylist().contains((Object)file)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Path rebasedFile = this.currentTargetDirectory().resolve(file.getFileName());
                        if (this.configuration$1.denylist().contains((Object)rebasedFile)) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.visitedPaths$1.$plus$eq((Object)file);
                            this.targetPaths$1.$plus$eq((Object)rebasedFile);
                            boxedUnit = this.observer$1.onNext((Object)new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)attributes), (Object)rebasedFile));
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path t, IOException e) {
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                    if (this.isCancelled$1.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (this.firstVisit()) {
                        this.firstVisit_$eq(false);
                    } else {
                        this.currentTargetDirectory_$eq(this.currentTargetDirectory().resolve(directory.getFileName()));
                    }
                    Files.createDirectories(this.currentTargetDirectory(), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                    this.currentTargetDirectory_$eq(this.currentTargetDirectory().getParent());
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.isCancelled$1 = isCancelled$1;
                    this.configuration$1 = configuration$1;
                    this.visitedPaths$1 = visitedPaths$1;
                    this.targetPaths$1 = targetPaths$1;
                    this.observer$1 = observer$1;
                    this.firstVisit = true;
                    this.currentTargetDirectory = target$1;
                }
            };
            Task discoverFileTree = bloop.task.Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                if (!Files.exists(origin, new LinkOption[0])) {
                    return new ParallelOps.FileWalk((List<Path>)Nil$.MODULE$, (List<Path>)Nil$.MODULE$);
                }
                Files.walkFileTree(origin, discovery);
                return new ParallelOps.FileWalk((List<Path>)visitedPaths.toList(), (List<Path>)targetPaths.toList());
            }).doOnFinish((Function1<Option<Throwable>, Task<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Throwable t = (Throwable)some.value();
                    return bloop.task.Task$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onError(t));
                }
                if (None$.MODULE$.equals(option)) {
                    return bloop.task.Task$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> observer2.onComplete());
                }
                throw new MatchError((Object)option);
            });
            Promise subscribed = Promise$.MODULE$.apply();
            ObjectRef completeSubscribers = ObjectRef.create((Object)Cancelable$.MODULE$.empty());
            ListBuffer cancelables = new ListBuffer();
            AssignableCancelable cancelable = AssignableCancelable$.MODULE$.multi((Cancelable & Serializable)() -> {
                List list;
                ListBuffer listBuffer = cancelables;
                synchronized (listBuffer) {
                    list = cancelables.toList();
                }
                List tasksToCancel = list;
                Cancelable cancelable = (Cancelable)completeSubscribers$1.elem;
                Cancelable$.MODULE$.cancelAll((Iterable)tasksToCancel.$colon$colon((Object)cancelable));
            });
            Consumer copyFileSequentially = Consumer$.MODULE$.foreachTask((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Path targetFile = (Path)tuple2._2();
                    if (tuple22 != null) {
                        BasicFileAttributes originAttrs;
                        Path originFile = (Path)tuple22._1();
                        Either either = (Either)new Task.DeprecatedExtensions(Task$.MODULE$.DeprecatedExtensions(ParallelOps$.acquireFile$1(originFile, isCancelled, configuration, targetFile, originAttrs = (BasicFileAttributes)tuple22._2(), logger))).coeval(scheduler).value();
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            BoxedUnit boxedUnit = (BoxedUnit)right.value();
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            BoxedUnit boxedUnit3 = boxedUnit;
                            if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) {
                                return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                            }
                        }
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            CancelableFuture cancelable = (CancelableFuture)left.value();
                            ListBuffer listBuffer = cancelables;
                            synchronized (listBuffer) {
                                cancelables.$plus$eq((Object)cancelable);
                            }
                            return Task$.MODULE$.fromFuture((Future)cancelable).doOnFinish((Function1 & Serializable & scala.Serializable)x$4 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                ListBuffer listBuffer = cancelables;
                                synchronized (listBuffer) {
                                    cancelables.$minus$eq((Object)cancelable);
                                }
                            }));
                        }
                        throw new MatchError((Object)either);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            Task copyFilesInParallel = bloop.task.Task$.MODULE$.create((Function2 & Serializable & scala.Serializable)(scheduler, cb) -> {
                CompositeCancelable cancelable;
                block3: {
                    if (isCancelled.get()) {
                        cb.onSuccess((Object)Nil$.MODULE$);
                        subscribed.success((Object)BoxedUnit.UNIT);
                        return Cancelable$.MODULE$.empty();
                    }
                    Consumer parallelConsumer = Consumer$.MODULE$.loadBalance(configuration.parallelUnits(), copyFileSequentially);
                    Tuple2 tuple2 = parallelConsumer.createSubscriber(cb, scheduler);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Subscriber out = (Subscriber)tuple2._1();
                    AssignableCancelable consumerSubscription = (AssignableCancelable)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)out, (Object)consumerSubscription);
                    Subscriber out2 = (Subscriber)tuple22._1();
                    AssignableCancelable consumerSubscription2 = (AssignableCancelable)tuple22._2();
                    Cancelable cancelOut = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out2.onComplete());
                    completeSubscribers$1.elem = CompositeCancelable$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cancelable[]{cancelOut}));
                    Cancelable sourceSubscription = observable2.subscribe(out2);
                    subscribed.success((Object)BoxedUnit.UNIT);
                    cancelable = CompositeCancelable$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cancelable[]{sourceSubscription, consumerSubscription2}));
                    if (!enableCancellation) {
                        return Cancelable$.MODULE$.empty();
                    }
                    if (!isCancelled.get()) break block3;
                    cancelable.cancel();
                }
                return cancelable;
            });
            Task orderlyDiscovery = bloop.task.Task$.MODULE$.fromFuture(subscribed.future()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> discoverFileTree);
            Task qual$1 = bloop.task.Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> bloop.task.Task$.MODULE$.mapBoth(orderlyDiscovery, copyFilesInParallel, (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
                if (tuple2 != null) {
                    ParallelOps.FileWalk fileWalk = (ParallelOps.FileWalk)tuple2._1();
                    return fileWalk;
                }
                throw new MatchError((Object)tuple2);
            })).flatten(Predef$.MODULE$.$conforms());
            Scheduler x$1 = scheduler;
            boolean x$2 = qual$1.executeOn$default$2();
            Task aggregatedCopyTask = qual$1.executeOn(x$1, x$2);
            return aggregatedCopyTask.doOnCancel((Function0<Task<BoxedUnit>>)(Function0 & Serializable & scala.Serializable)() -> bloop.task.Task$.MODULE$.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (enableCancellation) {
                    isCancelled.compareAndSet(false, true);
                    observer2.onComplete();
                    cancelable.cancel();
                    return;
                }
            }));
        });
    }

    private static final void copy$1(boolean replaceExisting, Path originFile$1, Path targetFile$1, Logger logger$1) {
        try {
            Path path = replaceExisting ? Files.copy(originFile$1, targetFile$1, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING) : Files.copy(originFile$1, targetFile$1, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger$1.report(new StringBuilder(79).append("Unexpected error when copying ").append(originFile$1).append(" to ").append(targetFile$1).append(", you might need to restart the build server.").toString(), t);
            }
            throw throwable;
        }
    }

    private static final monix.eval.Task triggerCopy$1(Promise p, AtomicBoolean isCancelled$1, ParallelOps.CopyConfiguration configuration$1, Path targetFile$1, BasicFileAttributes originAttrs$1, Path originFile$1, Logger logger$1) {
        return Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block15: {
                try {
                    if (isCancelled$1.get()) {
                        break block15;
                    }
                    ParallelOps.CopyMode copyMode = configuration$1.mode();
                    if (ParallelOps$CopyMode$ReplaceExisting$.MODULE$.equals(copyMode)) {
                        ParallelOps$.copy$1(true, originFile$1, targetFile$1, logger$1);
                        break block15;
                    }
                    if (ParallelOps$CopyMode$ReplaceIfMetadataMismatch$.MODULE$.equals(copyMode)) {
                        boolean bl = false;
                        Failure failure = null;
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.readAttributes(targetFile$1, BasicFileAttributes.class, new LinkOption[0]));
                        if (try_ instanceof Success) {
                            boolean changedMetadata;
                            Success success = (Success)try_;
                            BasicFileAttributes targetAttrs = (BasicFileAttributes)success.value();
                            boolean bl2 = changedMetadata = originAttrs$1.lastModifiedTime().compareTo(targetAttrs.lastModifiedTime()) != 0 || originAttrs$1.size() != targetAttrs.size();
                            if (!changedMetadata) {
                            } else {
                                ParallelOps$.copy$1(true, originFile$1, targetFile$1, logger$1);
                            }
                            break block15;
                        }
                        if (try_ instanceof Failure) {
                            bl = true;
                            failure = (Failure)try_;
                            if (failure.exception() instanceof IOException) {
                                ParallelOps$.copy$1(true, originFile$1, targetFile$1, logger$1);
                                break block15;
                            }
                        }
                        if (bl) {
                            Throwable t = failure.exception();
                            throw t;
                        }
                        throw new MatchError((Object)try_);
                    }
                    if (ParallelOps$CopyMode$NoReplace$.MODULE$.equals(copyMode)) {
                        if (Files.exists(targetFile$1, new LinkOption[0])) {
                        } else {
                            ParallelOps$.copy$1(false, originFile$1, targetFile$1, logger$1);
                        }
                        break block15;
                    }
                    throw new MatchError((Object)copyMode);
                }
                finally {
                    ParallelOps$.MODULE$.takenByOtherCopyProcess.remove(originFile$1);
                    p.success((Object)BoxedUnit.UNIT);
                }
            }
        });
    }

    private static final monix.eval.Task acquireFile$1(Path originFile$1, AtomicBoolean isCancelled$1, ParallelOps.CopyConfiguration configuration$1, Path targetFile$1, BasicFileAttributes originAttrs$1, Logger logger$1) {
        Promise currentPromise = Promise$.MODULE$.apply();
        Promise<BoxedUnit> promiseInMap = ParallelOps$.MODULE$.takenByOtherCopyProcess.putIfAbsent(originFile$1, (Promise<BoxedUnit>)currentPromise);
        if (promiseInMap == null) {
            return ParallelOps$.triggerCopy$1(currentPromise, isCancelled$1, configuration$1, targetFile$1, originAttrs$1, originFile$1, logger$1);
        }
        return Task$.MODULE$.fromFuture(promiseInMap.future()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ParallelOps$.acquireFile$1(originFile$1, isCancelled$1, configuration$1, targetFile$1, originAttrs$1, logger$1));
    }

    private ParallelOps$() {
        MODULE$ = this;
        this.takenByOtherCopyProcess = new ConcurrentHashMap();
    }
}

