/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import bloop.ScalaInstance;
import bloop.logging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import sbt.internal.inc.BloopComponentCompiler;
import sbt.internal.inc.BloopComponentManager;
import sbt.internal.inc.BloopComponentManager$;
import sbt.librarymanagement.Configurations$;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.ModuleID$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import xsbti.ComponentProvider;
import xsbti.compile.CompilerBridgeProvider;

public final class BloopComponentCompiler$ {
    public static BloopComponentCompiler$ MODULE$;
    private String latestVersion;
    private final String javaClassVersion;
    private final Some<String> CompileConf;
    private volatile boolean bitmap$0;

    static {
        new BloopComponentCompiler$();
    }

    public final String binSeparator() {
        return "-bin_";
    }

    public final String javaClassVersion() {
        return this.javaClassVersion;
    }

    private String latestVersion$lzycompute() {
        BloopComponentCompiler$ bloopComponentCompiler$ = this;
        synchronized (bloopComponentCompiler$) {
            if (!this.bitmap$0) {
                this.latestVersion = BloopComponentManager$.MODULE$.version();
                this.bitmap$0 = true;
            }
        }
        return this.latestVersion;
    }

    public final String latestVersion() {
        if (!this.bitmap$0) {
            return this.latestVersion$lzycompute();
        }
        return this.latestVersion;
    }

    public ComponentProvider getComponentProvider(Path componentsDir) {
        Path componentsPath = componentsDir;
        Object object = !Files.exists(componentsPath, new LinkOption[0]) ? Files.createDirectory(componentsPath, new FileAttribute[0]) : BoxedUnit.UNIT;
        return this.getDefaultComponentProvider(componentsPath.toFile());
    }

    private Some<String> CompileConf() {
        return this.CompileConf;
    }

    public ModuleID getModuleForBridgeSources(xsbti.compile.ScalaInstance scalaInstance) {
        ScalaInstance scalaInstance2;
        Tuple3 tuple3;
        boolean bl;
        try {
            String[] stringArray = scalaInstance.version().split("\\.");
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String patch = (String)((SeqLike)option.get()).apply(2);
            String patch2 = patch;
            int patchTrimmed = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(patch2)).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1))))))).toInt();
            bl = scalaInstance.version().startsWith("2.13.") && patchTrimmed >= 12;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        boolean isAfter2_13_11 = bl;
        xsbti.compile.ScalaInstance scalaInstance3 = scalaInstance;
        Tuple3 tuple32 = tuple3 = scalaInstance3 instanceof ScalaInstance && ((scalaInstance2 = (ScalaInstance)scalaInstance3).isDotty() || isAfter2_13_11) ? new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)scalaInstance2.organization(), (Object)scalaInstance2.version()) : new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"org.scala-sbt", (Object)this.latestVersion());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        boolean isDotty = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        String organization = (String)tuple3._2();
        String version = (String)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)isDotty), (Object)organization, (Object)version);
        boolean isDotty2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
        String organization2 = (String)tuple33._2();
        String version2 = (String)tuple33._3();
        String bridgeId = BloopComponentCompiler$.compilerBridgeId$1(scalaInstance.version(), isAfter2_13_11);
        ModuleID module = ModuleID$.MODULE$.apply(organization2, bridgeId, version2).withConfigurations(this.CompileConf());
        if (isDotty2) {
            return module;
        }
        return module.sources();
    }

    public String getBridgeComponentId(ModuleID sources, xsbti.compile.ScalaInstance scalaInstance) {
        String id = new StringBuilder(2).append(sources.organization()).append("-").append(sources.name()).append("-").append(sources.revision()).toString();
        String scalaVersion = scalaInstance.actualVersion();
        return new StringBuilder(7).append(id).append("-bin_").append(scalaVersion).append("__").append(this.javaClassVersion()).toString();
    }

    public CompilerBridgeProvider interfaceProvider(ModuleID compilerBridgeSource, BloopComponentManager manager, Logger logger) {
        Some bridgeSources = new Some((Object)compilerBridgeSource);
        return new BloopComponentCompiler.BloopCompilerBridgeProvider((Option<ModuleID>)bridgeSources, manager, logger);
    }

    public ComponentProvider getDefaultComponentProvider(File targetDir) {
        Predef$.MODULE$.require(targetDir.isDirectory());
        return new BloopComponentCompiler.DefaultComponentProvider(targetDir);
    }

    private static final String compilerBridgeId$1(String scalaVersion, boolean isAfter2_13_11$1) {
        String string = scalaVersion;
        if (string.startsWith("0.")) {
            return "dotty-sbt-bridge";
        }
        if (string.startsWith("3.")) {
            return "scala3-sbt-bridge";
        }
        if (isAfter2_13_11$1) {
            return "scala2-sbt-bridge";
        }
        if (string.startsWith("2.10.")) {
            return "compiler-bridge_2.10";
        }
        if (string.startsWith("2.11.")) {
            return "compiler-bridge_2.11";
        }
        if (string.startsWith("2.12.")) {
            return "compiler-bridge_2.12";
        }
        return "compiler-bridge_2.13";
    }

    private BloopComponentCompiler$() {
        MODULE$ = this;
        this.javaClassVersion = System.getProperty("java.class.version");
        this.CompileConf = new Some((Object)Configurations$.MODULE$.Compile().name());
    }
}

