/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.DependencyResolution;
import bloop.DependencyResolution$;
import bloop.ScalaInstance;
import bloop.ScalaInstanceTopLoader;
import bloop.internal.build.BloopScalaInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import jline.console.ConsoleReader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.Trees;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.tools.nsc.Main$;
import scala.util.Properties$;
import scala.util.control.NonFatal$;
import scala.xml.Node;

public final class ScalaInstance$ {
    public static ScalaInstance$ MODULE$;
    private final ClassLoader bootClassLoader;
    private final ClassLoader topClassLoader;
    private final ConcurrentHashMap<Tuple3<String, String, String>, ScalaInstance> instancesById;
    private final ConcurrentHashMap<List<Path>, ScalaInstance> instancesByJar;
    private ReentrantLock cachedBloopLock;
    private Option<ScalaInstance> cachedBloopScalaInstance;

    static {
        new ScalaInstance$();
    }

    public ClassLoader bootClassLoader() {
        return this.bootClassLoader;
    }

    public ClassLoader topClassLoader() {
        return this.topClassLoader;
    }

    public final String ScalacCompilerName() {
        return "scala-compiler";
    }

    public ScalaInstance apply(String scalaOrg, String scalaName, String scalaVersion, Seq<AbsolutePath> allJars, Logger logger) {
        ScalaInstance scalaInstance;
        List jarsKey = ((TraversableOnce)((SeqLike)allJars.map((Function1 & Serializable & scala.Serializable)x$5 -> ((AbsolutePath)x$5).underlying(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> ((Object)x$6).toString(), (Ordering)Ordering.String$.MODULE$)).toList();
        if (allJars.nonEmpty()) {
            Seq nonExistingJars = (Seq)allJars.filter((Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$5(((AbsolutePath)j).underlying())));
            nonExistingJars.foreach((Function1 & Serializable & scala.Serializable)p -> {
                logger.warn(new StringBuilder(34).append("Scala instance jar ").append(AbsolutePath$.MODULE$.syntax$extension(((AbsolutePath)p).underlying())).append(" doesn't exist!").toString());
                return BoxedUnit.UNIT;
            });
            scalaInstance = this.instancesByJar().computeIfAbsent((List<Path>)jarsKey, x$8 -> ScalaInstance$.newInstance$1(logger, scalaOrg, scalaName, scalaVersion, jarsKey, allJars));
        } else {
            scalaInstance = this.resolve(scalaOrg, scalaName, scalaVersion, logger);
        }
        return scalaInstance;
    }

    private ConcurrentHashMap<Tuple3<String, String, String>, ScalaInstance> instancesById() {
        return this.instancesById;
    }

    private ConcurrentHashMap<List<Path>, ScalaInstance> instancesByJar() {
        return this.instancesByJar;
    }

    public ScalaInstance resolve(String scalaOrg, String scalaName, String scalaVersion, Logger logger) {
        Tuple3 instanceId = new Tuple3((Object)scalaOrg, (Object)scalaName, (Object)scalaVersion);
        return this.instancesById().computeIfAbsent((Tuple3<String, String, String>)instanceId, x$9 -> ScalaInstance$.resolveInstance$1(scalaOrg, scalaName, scalaVersion, logger));
    }

    public Option<ScalaInstance> scalaInstanceForJavaProjects(Logger logger) {
        Option option;
        LazyRef tempDirectory$lzy = new LazyRef();
        DebugFilter.Compilation$ filter = DebugFilter.Compilation$.MODULE$;
        if (this.cachedBloopScalaInstance != null) {
            option = this.cachedBloopScalaInstance;
        } else {
            this.cachedBloopLock.lock();
            try {
                Option instance;
                logger.debug("Creating a scala instance from Bloop's classloader...", (DebugFilter)filter);
                this.cachedBloopScalaInstance = instance = ScalaInstance$.findLocationForClazz$1(Predef$.MODULE$.getClass(), "scala-library.jar", logger, filter, tempDirectory$lzy).map((Function1 & Serializable & scala.Serializable)libraryJar -> {
                    Class<Trees> treesClazz = Trees.class;
                    return new Tuple2(libraryJar, treesClazz);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
                    Tuple2 tuple2 = x$11;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Path libraryJar = (Path)tuple2._1();
                    Class treesClazz = (Class)tuple2._2();
                    Option option = ScalaInstance$.findLocationForClazz$1(treesClazz, "scala-reflect.jar", logger, filter, tempDirectory$lzy).flatMap((Function1 & Serializable & scala.Serializable)reflectJar -> ScalaInstance$.findLocationForClazz$1(Main$.MODULE$.getClass(), "scala-compiler.jar", logger, filter, tempDirectory$lzy).flatMap((Function1 & Serializable & scala.Serializable)compilerJar -> ScalaInstance$.findLocationForClazz$1(Node.class, "scala-xml.jar", logger, filter, tempDirectory$lzy).flatMap((Function1 & Serializable & scala.Serializable)xmlJar -> ScalaInstance$.findLocationForClazz$1(ConsoleReader.class, "jline.jar", logger, filter, tempDirectory$lzy).map((Function1 & Serializable & scala.Serializable)jlineJar -> {
                        logger.debug(new StringBuilder(33).append("Created Bloop scala instance for ").append(BloopScalaInfo$.MODULE$.scalaVersion()).toString(), (DebugFilter)filter);
                        .colon.colon jars = new .colon.colon((Object)libraryJar, (List)new .colon.colon(reflectJar, (List)new .colon.colon(compilerJar, (List)new .colon.colon(xmlJar, (List)new .colon.colon(jlineJar, (List)Nil$.MODULE$)))));
                        return MODULE$.apply(BloopScalaInfo$.MODULE$.scalaOrganization(), "scala-compiler", BloopScalaInfo$.MODULE$.scalaVersion(), (Seq<AbsolutePath>)((Seq)jars.map((Function1 & Serializable & scala.Serializable)x$10 -> new AbsolutePath(AbsolutePath$.MODULE$.apply(x$10, AbsolutePath$.MODULE$.workingDirectory())), List$.MODULE$.canBuildFrom())), logger);
                    }))));
                    return option;
                });
                option = instance;
            }
            finally {
                this.cachedBloopLock.unlock();
            }
        }
        return option;
    }

    public String getVersion(ClassLoader loader) {
        Option version = Option$.MODULE$.apply((Object)loader.getResource("compiler.properties")).flatMap((Function1 & Serializable & scala.Serializable)url -> {
            InputStream stream = url.openStream();
            Properties properties = new Properties();
            properties.load(stream);
            return Option$.MODULE$.apply((Object)((String)properties.get("version.number")));
        });
        return (String)version.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Loader ").append(loader).append(" doesn't have Scala in it!").toString());
    }

    private static final /* synthetic */ ClassLoader liftedTree1$1() {
        ClassLoader classLoader;
        try {
            classLoader = MethodHandles.lookup().findStatic(ClassLoader.class, "getPlatformClassLoader", MethodType.methodType(ClassLoader.class)).invoke();
        }
        catch (Throwable throwable) {
            classLoader = null;
        }
        return classLoader;
    }

    private static final ScalaInstance newInstance$1(Logger logger$1, String scalaOrg$1, String scalaName$1, String scalaVersion$1, List jarsKey$1, Seq allJars$1) {
        logger$1.debug(new StringBuilder(33).append("Cache miss for scala instance ").append(scalaOrg$1).append(":").append(scalaName$1).append(":").append(scalaVersion$1).append(".").toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$);
        jarsKey$1.foreach((Function1 & Serializable & scala.Serializable)p -> {
            logger$1.debug(new StringBuilder(5).append("  => ").append(p).toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return new ScalaInstance(scalaOrg$1, scalaName$1, scalaVersion$1, (File[])((TraversableOnce)allJars$1.map((Function1 & Serializable & scala.Serializable)x$7 -> AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)x$7).underlying()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Path j) {
        return !Files.exists(j, new LinkOption[0]);
    }

    private static final ScalaInstance resolveInstance$1(String scalaOrg$2, String scalaName$2, String scalaVersion$2, Logger logger$2) {
        AbsolutePath[] allPaths = DependencyResolution$.MODULE$.resolve((List)new .colon.colon((Object)new DependencyResolution.Artifact(scalaOrg$2, scalaName$2, scalaVersion$2), (List)Nil$.MODULE$), logger$2, DependencyResolution$.MODULE$.resolve$default$3(), DependencyResolution$.MODULE$.resolve$default$4());
        File[] allJars = (File[])Predef$.MODULE$.genericArrayOps((Object)allPaths).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AbsolutePath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.toString().endsWith(".jar") ? A1.toFile() : function1.apply((Object)new AbsolutePath(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = ((Object)path).toString().endsWith(".jar");
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ScalaInstance(scalaOrg$2, scalaName$2, scalaVersion$2, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allJars)).toArray(ClassTag$.MODULE$.apply(File.class)));
    }

    private static final /* synthetic */ Path tempDirectory$lzycompute$1(LazyRef tempDirectory$lzy$1) {
        Path path;
        LazyRef lazyRef = tempDirectory$lzy$1;
        synchronized (lazyRef) {
            path = tempDirectory$lzy$1.initialized() ? (Path)tempDirectory$lzy$1.value() : (Path)tempDirectory$lzy$1.initialize((Object)Files.createTempDirectory("bloop-scala-instance", new FileAttribute[0]));
        }
        return path;
    }

    private static final Path tempDirectory$1(LazyRef tempDirectory$lzy$1) {
        return tempDirectory$lzy$1.initialized() ? (Path)tempDirectory$lzy$1.value() : ScalaInstance$.tempDirectory$lzycompute$1(tempDirectory$lzy$1);
    }

    private static final Option findLocationForClazz$1(Class clazz, String jarName, Logger logger$3, DebugFilter.Compilation$ filter$1, LazyRef tempDirectory$lzy$1) {
        Some some;
        block6: {
            try {
                URI expectedPath = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
                logger$3.debug(new StringBuilder(13).append(clazz).append(" detected in ").append(expectedPath).toString(), (DebugFilter)filter$1);
                try {
                    some = new Some((Object)Paths.get(expectedPath));
                }
                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                    logger$3.debug(new StringBuilder(68).append("Load jar from resource because scheme '").append(expectedPath.getScheme()).append("' has no file system provider").toString(), (DebugFilter)filter$1);
                    InputStream fromResourceStream = clazz.getResourceAsStream(new StringBuilder(1).append("/").append(expectedPath.getSchemeSpecificPart()).toString());
                    if (fromResourceStream == null) {
                        String scalaJarResourceError = new StringOps(Predef$.MODULE$.augmentString("Unexpected error when creating Bloop's default Scala instance!\n                  |  -> The resources where Bloop Scala jars are hosted cannot be accessed\n                  |This error can happen when making an standalone bootstrap of bloop via coursier which is currently not supported\n                ")).stripMargin();
                        logger$3.error(scalaJarResourceError);
                        some = None$.MODULE$;
                        break block6;
                    }
                    Path outPath = ScalaInstance$.tempDirectory$1(tempDirectory$lzy$1).resolve(jarName);
                    logger$3.debug(new StringBuilder(37).append(clazz).append(" detected in resource, dumping to ").append(outPath).append("...").toString(), (DebugFilter)filter$1);
                    Files.copy(fromResourceStream, outPath, new CopyOption[0]);
                    some = new Some((Object)outPath);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                logger$3.debug("Unexpected error when creating Bloop's classloader", (DebugFilter)filter$1);
                logger$3.trace(t);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
        }
        return some;
    }

    private ScalaInstance$() {
        MODULE$ = this;
        this.bootClassLoader = !Properties$.MODULE$.isJavaAtLeast("9") ? null : ScalaInstance$.liftedTree1$1();
        ClassLoader bloopClassLoader = this.getClass().getClassLoader();
        this.topClassLoader = new ScalaInstanceTopLoader(bloopClassLoader, this.bootClassLoader());
        this.instancesById = new ConcurrentHashMap();
        this.instancesByJar = new ConcurrentHashMap();
        this.cachedBloopLock = new ReentrantLock();
        this.cachedBloopScalaInstance = null;
    }
}

